/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.business.mq.consumer.taxinfo;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.taxc.bdtaxr.common.enums.TaxationSysEnum;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.common.json.JsonUtil;
import kd.taxc.common.util.DateUtils;
import kd.taxc.common.util.EmptyCheckUtils;
import kd.taxc.tctb.business.enums.YHSDeclareTypeEnum;
import kd.taxc.tctb.business.enums.szyh.CompareMethodEnums;
import kd.taxc.tctb.business.enums.szyh.FjsfPlaceMappingenum;
import kd.taxc.tctb.business.enums.szyh.TaxTypeAsZspmEnums;
import kd.taxc.tctb.business.enums.szyh.VerificationDiffEnums;
import kd.taxc.tctb.business.enums.szyh.VerificationTaxTypeEnums;
import org.apache.commons.lang3.StringUtils;

public class TaxtypeCardCompareConsumer
implements MessageConsumer {
    public static final Log logger = LogFactory.getLog(TaxtypeCardCompareConsumer.class);
    private static final String TAX_MAIN = "tctb_tax_main";
    private static final String NODATA = "nodata";
    private static final String WITHOUT = "without";
    private static final String COMPARESTATUS = "comparestatus";
    private static final String UPDATESTATUS = "updatestatus";
    private static final String DIFF = "diff";
    private static final String UNDO = "undo";
    private static final String SAME = "same";
    private static final String FAIL = "fail";

    public void onMessage(Object message, String messageId, boolean resend, MessageAcker acker) {
        String data = (String)message;
        logger.info("TaxtypeCardCompareConsumer message:" + data);
        Map dataMap = (Map)JsonUtil.fromJson((String)data, Map.class);
        if (dataMap.containsKey("orgId") && dataMap.containsKey("pkIds")) {
            String orgId = (String)dataMap.get("orgId");
            Map<String, List<DynamicObject>> taxTypeCardMap = TaxtypeCardCompareConsumer.getTaxTypeCard(Long.valueOf(orgId));
            List ids = (List)dataMap.get("pkIds");
            DynamicObject[] verifyObjs = BusinessDataServiceHelper.load((String)"tctb_taxtype_verify", (String)MetadataUtil.getAllSubFieldString((String)"tctb_taxtype_verify"), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids).and("infotype", "=", (Object)"0").and("levytype", "=", (Object)"zxsb").and("expirydate", ">=", (Object)new Date())});
            if (taxTypeCardMap == null) {
                logger.info(String.format("\u6570\u636e\u6bd4\u5bf9\u5f02\u5e38\uff0c\u672a\u67e5\u8be2\u5230\u7a0e\u79cd\u5361\u7247\u4fe1\u606fID\uff1a%s", data));
                if (verifyObjs != null && verifyObjs.length > 0) {
                    Arrays.stream(verifyObjs).forEach(o -> {
                        o.set(COMPARESTATUS, (Object)NODATA);
                        o.set(UPDATESTATUS, (Object)WITHOUT);
                    });
                }
                return;
            }
            boolean fail = false;
            try (TXHandle handle = TX.required();){
                try {
                    List convertIdS;
                    if (verifyObjs != null && verifyObjs.length > 0) {
                        Map<String, List<DynamicObject>> collect = Arrays.stream(verifyObjs).collect(Collectors.groupingBy(a -> a.getDynamicObject("zsxm").getString("number")));
                        for (Map.Entry<String, List<DynamicObject>> map : collect.entrySet()) {
                            if (taxTypeCardMap.containsKey(VerificationTaxTypeEnums.getTypeByNumber(map.getKey()))) {
                                Method method = this.getClass().getDeclaredMethod(CompareMethodEnums.getMethodNameByKey(VerificationTaxTypeEnums.getTypeByNumber(map.getKey())), List.class, DynamicObject.class, String.class);
                                List<DynamicObject> cards = taxTypeCardMap.get(VerificationTaxTypeEnums.getTypeByNumber(map.getKey()));
                                method.invoke((Object)this, map.getValue(), cards.get(0), orgId);
                                continue;
                            }
                            map.getValue().forEach(o -> {
                                o.set(COMPARESTATUS, (Object)NODATA);
                                o.set(UPDATESTATUS, (Object)WITHOUT);
                            });
                        }
                    }
                    SaveServiceHelper.save((DynamicObject[])verifyObjs);
                    if (dataMap.containsKey("isAuto") && StringUtils.equals((CharSequence)"1", (CharSequence)String.valueOf(dataMap.get("isAuto"))) && CollectionUtils.isNotEmpty(convertIdS = Arrays.stream(verifyObjs).filter(o -> StringUtils.equals((CharSequence)DIFF, (CharSequence)o.getString(COMPARESTATUS))).map(o -> o.getLong("id")).collect(Collectors.toList()))) {
                        DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"TaxtypeCardService", (String)"convert", (Object[])new Object[]{SerializationUtils.toJsonString(convertIdS)});
                    }
                    acker.ack(messageId);
                }
                catch (Throwable throwable) {
                    fail = true;
                    handle.markRollback();
                    logger.error("TaxtypeCardCompareConsumer execute error", throwable);
                    acker.discard(messageId);
                }
            }
            if (fail && verifyObjs != null && verifyObjs.length > 0) {
                Arrays.stream(verifyObjs).forEach(o -> {
                    o.set(COMPARESTATUS, (Object)FAIL);
                    o.set(UPDATESTATUS, (Object)UNDO);
                });
                SaveServiceHelper.save((DynamicObject[])verifyObjs);
            }
        }
    }

    public void compareDataForZzs(List<DynamicObject> data, DynamicObject card, String orgId) {
        if ("0".equals(card.getString("enable"))) {
            for (DynamicObject obj : data) {
                obj.set(COMPARESTATUS, (Object)DIFF);
                obj.set(UPDATESTATUS, (Object)UNDO);
            }
        } else {
            for (DynamicObject obj : data) {
                obj.set(COMPARESTATUS, (Object)SAME);
                obj.set(UPDATESTATUS, (Object)WITHOUT);
            }
        }
    }

    public void compareDataForQysds(List<DynamicObject> data, DynamicObject card, String orgId) {
        if ("0".equals(card.getString("enable"))) {
            for (DynamicObject obj : data) {
                obj.set(COMPARESTATUS, (Object)DIFF);
                obj.set(UPDATESTATUS, (Object)UNDO);
            }
        } else {
            String taxlimit = TaxtypeCardCompareConsumer.getTaxLimit(card.getString("deadline"));
            for (DynamicObject obj : data) {
                if (StringUtils.equals((CharSequence)taxlimit, (CharSequence)obj.getString("taxlimit"))) {
                    obj.set(COMPARESTATUS, (Object)SAME);
                    obj.set(UPDATESTATUS, (Object)WITHOUT);
                    continue;
                }
                obj.set(COMPARESTATUS, (Object)DIFF);
                obj.set(UPDATESTATUS, (Object)UNDO);
            }
        }
    }

    public void compareDataForFjsf(List<DynamicObject> data, DynamicObject card, String orgId) {
        if ("0".equals(card.getString("enable"))) {
            for (DynamicObject obj : data) {
                obj.set(COMPARESTATUS, (Object)DIFF);
                obj.set(UPDATESTATUS, (Object)UNDO);
            }
        } else {
            for (DynamicObject obj : data) {
                String zsxm = obj.getDynamicObject("zsxm").getString("number");
                if ("006".equals(obj.getDynamicObject("zsxm").getString("number"))) {
                    String zspm;
                    if ("4".equals(card.getString("cswhjssenable"))) {
                        obj.set(COMPARESTATUS, (Object)DIFF);
                        obj.set(UPDATESTATUS, (Object)UNDO);
                        continue;
                    }
                    String orgplace = card.getString("orgplace");
                    if (StringUtils.equals((CharSequence)orgplace, (CharSequence)FjsfPlaceMappingenum.getOrgplaceByzspm(zspm = obj.getDynamicObject("zspm").getString("number")))) {
                        obj.set(COMPARESTATUS, (Object)SAME);
                        obj.set(UPDATESTATUS, (Object)WITHOUT);
                        continue;
                    }
                    obj.set(COMPARESTATUS, (Object)DIFF);
                    obj.set(UPDATESTATUS, (Object)UNDO);
                    continue;
                }
                if ("019".equals(zsxm)) {
                    if ("5".equals(card.getString("jyffjenable"))) {
                        obj.set(COMPARESTATUS, (Object)DIFF);
                        obj.set(UPDATESTATUS, (Object)UNDO);
                        continue;
                    }
                    obj.set(COMPARESTATUS, (Object)SAME);
                    obj.set(UPDATESTATUS, (Object)WITHOUT);
                    continue;
                }
                if (!"020".equals(zsxm)) continue;
                if ("6".equals(card.getString("dfjyffjenable"))) {
                    obj.set(COMPARESTATUS, (Object)DIFF);
                    obj.set(UPDATESTATUS, (Object)UNDO);
                    continue;
                }
                obj.set(COMPARESTATUS, (Object)SAME);
                obj.set(UPDATESTATUS, (Object)WITHOUT);
            }
        }
    }

    public void compareDataForYhs(List<DynamicObject> verifyData, DynamicObject taxMainCard, String orgId) {
        if ("0".equals(taxMainCard.getString("enable"))) {
            for (DynamicObject obj : verifyData) {
                this.setYHSVerifyDataDiffStatus(obj);
            }
        } else {
            DynamicObjectCollection yhsCardEntity = TaxtypeCardCompareConsumer.getTaxTypeEntity(Long.valueOf(orgId), "yhsentity");
            if (yhsCardEntity != null && !yhsCardEntity.isEmpty()) {
                Map<String, List<DynamicObject>> taxMainYhsZspmCollect = yhsCardEntity.stream().filter(o -> EmptyCheckUtils.isNotEmpty((Object)o.getDynamicObject("taxrate"))).collect(Collectors.groupingBy(a -> a.getDynamicObject("taxrate").getString("name")));
                Map<String, List<DynamicObject>> verifyZspmCollect = verifyData.stream().collect(Collectors.groupingBy(a -> a.getDynamicObject("zspm").getString("name")));
                Map<String, List<DynamicObject>> taxMainyhsCombineKeyMap = yhsCardEntity.stream().filter(o -> EmptyCheckUtils.isNotEmpty((Object)o.getDynamicObject("taxrate"))).collect(Collectors.groupingBy(a -> String.format("%1$s_%2$s_%3$s_%4$s_%5$s", a.getDynamicObject("taxrate").getString("name"), a.getString("period"), DateUtils.format((Date)a.getDate("effectivedate"), (String)"yyyy-MM-dd"), DateUtils.format((Date)a.getDate("expirydate"), (String)"yyyy-MM-dd"), a.getString("declaretype"))));
                for (Map.Entry<String, List<DynamicObject>> verifyZspmMap : verifyZspmCollect.entrySet()) {
                    String zspmKey = verifyZspmMap.getKey();
                    if (taxMainYhsZspmCollect.containsKey(zspmKey)) {
                        if (taxMainYhsZspmCollect.get(zspmKey).size() != 1 || verifyZspmMap.getValue().size() != 1) {
                            for (DynamicObject dynamicObject : verifyZspmMap.getValue()) {
                                this.setYHSVerifyDataDiffStatus(dynamicObject);
                            }
                            continue;
                        }
                        Map<String, List<DynamicObject>> verifyZspmCombineKeyMap = verifyZspmMap.getValue().stream().collect(Collectors.groupingBy(a -> String.format("%1$s_%2$s_%3$s_%4$s_%5$s", a.getDynamicObject("zspm").getString("name"), a.getString("taxlimit"), DateUtils.format((Date)a.getDate("effectivedate"), (String)"yyyy-MM-dd"), DateUtils.format((Date)a.getDate("expirydate"), (String)"yyyy-MM-dd"), YHSDeclareTypeEnum.getYHSDelaretype(a.getString("taxlimit")))));
                        for (Map.Entry<String, List<DynamicObject>> verifyZspmCombineKeyMapEntry : verifyZspmCombineKeyMap.entrySet()) {
                            String key = verifyZspmCombineKeyMapEntry.getKey();
                            if (taxMainyhsCombineKeyMap.containsKey(key)) {
                                verifyZspmCombineKeyMapEntry.getValue().stream().forEach(o -> {
                                    o.set(COMPARESTATUS, (Object)SAME);
                                    o.set(UPDATESTATUS, (Object)WITHOUT);
                                });
                                continue;
                            }
                            verifyZspmCombineKeyMapEntry.getValue().stream().forEach(o -> this.setYHSVerifyDataDiffStatus((DynamicObject)o));
                        }
                        continue;
                    }
                    DynamicObject[] tcsdTaxrates = BusinessDataServiceHelper.load((String)"tpo_tcsd_taxrate", (String)"id,entryentity,entryentity.subname,startdate,enddate", (QFilter[])new QFilter[]{new QFilter("startdate", "<=", (Object)new Date()).and(new QFilter("enddate", ">=", (Object)new Date())).or(QFilter.isNull((String)"enddate"))});
                    HashMap<String, DynamicObject> hashMap = new HashMap<String, DynamicObject>();
                    for (DynamicObject tcsdTaxrate : tcsdTaxrates) {
                        DynamicObjectCollection entryentity = tcsdTaxrate.getDynamicObjectCollection("entryentity");
                        if (!CollectionUtils.isNotEmpty((Collection)entryentity)) continue;
                        for (DynamicObject obj : entryentity) {
                            hashMap.put(obj.getString("subname"), obj);
                        }
                    }
                    if (!hashMap.containsKey(zspmKey)) {
                        for (DynamicObject obj : verifyZspmMap.getValue()) {
                            obj.set(COMPARESTATUS, (Object)NODATA);
                            obj.set(UPDATESTATUS, (Object)WITHOUT);
                        }
                        continue;
                    }
                    for (DynamicObject obj : verifyZspmMap.getValue()) {
                        this.setYHSVerifyDataDiffStatus(obj);
                    }
                }
            } else {
                for (DynamicObject obj : verifyData) {
                    this.setYHSVerifyDataDiffStatus(obj);
                }
            }
        }
    }

    protected void setYHSVerifyDataDiffStatus(DynamicObject yhsVerifyData) {
        if ("acsb".equals(YHSDeclareTypeEnum.getYHSDelaretype(yhsVerifyData.getString("taxlimit")))) {
            yhsVerifyData.set(COMPARESTATUS, (Object)NODATA);
            yhsVerifyData.set(UPDATESTATUS, (Object)WITHOUT);
        } else {
            yhsVerifyData.set(COMPARESTATUS, (Object)DIFF);
            yhsVerifyData.set(UPDATESTATUS, (Object)UNDO);
        }
    }

    public void compareDataForQtsf(List<DynamicObject> data, DynamicObject card, String orgId) {
        if ("0".equals(card.getString("enable"))) {
            for (DynamicObject obj : data) {
                obj.set(COMPARESTATUS, (Object)DIFF);
                obj.set(UPDATESTATUS, (Object)UNDO);
            }
        } else {
            for (DynamicObject obj : data) {
                if (obj.getDynamicObject("zspm") != null) continue;
                obj.set(COMPARESTATUS, (Object)NODATA);
                obj.set(UPDATESTATUS, (Object)WITHOUT);
            }
            DynamicObjectCollection qtsfEntity = TaxtypeCardCompareConsumer.getTaxTypeEntity(Long.valueOf(orgId), "qtsfentity");
            if (qtsfEntity != null && qtsfEntity.size() > 0) {
                Map<String, List<DynamicObject>> qtsfZspmCollect = qtsfEntity.stream().filter(o -> EmptyCheckUtils.isNotEmpty((Object)o.getDynamicObject("collectrate"))).collect(Collectors.groupingBy(a -> a.getDynamicObject("collectrate").getString("id")));
                Map<String, List<DynamicObject>> sjZsxmcollect = data.stream().filter(o -> EmptyCheckUtils.isNotEmpty((Object)o.getDynamicObject("zspm"))).collect(Collectors.groupingBy(a -> TaxTypeAsZspmEnums.getZspmIdByDynamicObject(a)));
                Map<String, List<DynamicObject>> qtsfCollect = qtsfEntity.stream().filter(o -> EmptyCheckUtils.isNotEmpty((Object)o.getDynamicObject("collectrate"))).collect(Collectors.groupingBy(a -> a.getDynamicObject("collectrate").getString("id") + "_" + a.getString("taxperiod") + "_" + a.getString("amountrate") + "_" + DateUtils.format((Date)a.getDate("effectivestart"), (String)"yyyy-MM-dd") + "_" + DateUtils.format((Date)a.getDate("effectiveend"), (String)"yyyy-MM-dd")));
                for (Map.Entry<String, List<DynamicObject>> sjMap : sjZsxmcollect.entrySet()) {
                    String zspmKey = sjMap.getKey();
                    if (qtsfZspmCollect.containsKey(zspmKey)) {
                        if (qtsfZspmCollect.get(zspmKey).size() != 1 || sjMap.getValue().size() != 1) {
                            for (DynamicObject dynamicObject : sjMap.getValue()) {
                                dynamicObject.set(COMPARESTATUS, (Object)DIFF);
                                dynamicObject.set(UPDATESTATUS, (Object)UNDO);
                            }
                            continue;
                        }
                        Map<String, List<DynamicObject>> collect = sjMap.getValue().stream().collect(Collectors.groupingBy(a -> TaxTypeAsZspmEnums.getZspmIdByDynamicObject(a) + "_" + VerificationDiffEnums.getTaxMainValueByZlValue(a.getString("taxlimit")) + "_" + a.getString("taxrate") + "_" + DateUtils.format((Date)a.getDate("effectivedate"), (String)"yyyy-MM-dd") + "_" + DateUtils.format((Date)a.getDate("expirydate"), (String)"yyyy-MM-dd")));
                        for (Map.Entry<String, List<DynamicObject>> sjTaxMap : collect.entrySet()) {
                            String key = sjTaxMap.getKey();
                            if (qtsfCollect.containsKey(key)) {
                                sjTaxMap.getValue().stream().forEach(o -> {
                                    o.set(COMPARESTATUS, (Object)SAME);
                                    o.set(UPDATESTATUS, (Object)WITHOUT);
                                });
                                continue;
                            }
                            sjTaxMap.getValue().stream().forEach(o -> {
                                o.set(COMPARESTATUS, (Object)DIFF);
                                o.set(UPDATESTATUS, (Object)UNDO);
                            });
                        }
                        continue;
                    }
                    for (DynamicObject dynamicObject : sjMap.getValue()) {
                        dynamicObject.set(COMPARESTATUS, (Object)DIFF);
                        dynamicObject.set(UPDATESTATUS, (Object)UNDO);
                    }
                }
            } else {
                for (DynamicObject obj : data) {
                    obj.set(COMPARESTATUS, (Object)DIFF);
                    obj.set(UPDATESTATUS, (Object)UNDO);
                }
            }
        }
    }

    private static Map<String, List<DynamicObject>> getTaxTypeCard(Long orgid) {
        QFilter qilter = new QFilter("orgid", "=", (Object)orgid).and(new QFilter("taxationsys", "=", (Object)TaxationSysEnum.CHAIN_MAINLAND.getId()));
        DynamicObject taxOrgMain = BusinessDataServiceHelper.loadSingle((String)TAX_MAIN, (String)"id", (QFilter[])new QFilter[]{qilter});
        if (taxOrgMain != null) {
            DynamicObject taxMain = BusinessDataServiceHelper.loadSingle((Object)taxOrgMain.getLong("id"), (String)TAX_MAIN);
            DynamicObjectCollection categoryentryentity = taxMain.getDynamicObjectCollection("categoryentryentity");
            if (CollectionUtils.isNotEmpty((Collection)categoryentryentity)) {
                Map<String, List<DynamicObject>> cardMap = categoryentryentity.stream().collect(Collectors.groupingBy(a -> a.getString("taxtype")));
                return cardMap;
            }
            return null;
        }
        return null;
    }

    private static DynamicObjectCollection getTaxTypeEntity(Long orgid, String entityName) {
        QFilter qilter = new QFilter("orgid", "=", (Object)orgid).and(new QFilter("taxationsys", "=", (Object)TaxationSysEnum.CHAIN_MAINLAND.getId()));
        DynamicObject taxOrgMain = BusinessDataServiceHelper.loadSingle((String)TAX_MAIN, (String)"id", (QFilter[])new QFilter[]{qilter});
        if (taxOrgMain != null) {
            DynamicObject taxMain = BusinessDataServiceHelper.loadSingle((Object)taxOrgMain.getLong("id"), (String)TAX_MAIN);
            return taxMain.getDynamicObjectCollection(entityName);
        }
        return null;
    }

    public static String getTaxLimit(String deadline) {
        if ("aysb".equals(deadline)) {
            return "month";
        }
        if ("ajsb".equals(deadline)) {
            return "season";
        }
        if ("acsb".equals(deadline)) {
            return "single";
        }
        return "";
    }
}

