/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.business.mq.consumer.taxinfo;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.taxc.bdtaxr.common.enums.TaxationSysEnum;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.common.json.JsonUtil;
import kd.taxc.common.util.EmptyCheckUtils;
import kd.taxc.tctb.business.enums.YHSDeclareTypeEnum;
import kd.taxc.tctb.business.enums.szyh.CovertMethodEnums;
import kd.taxc.tctb.business.enums.szyh.FjsfPlaceMappingenum;
import kd.taxc.tctb.business.enums.szyh.TaxTypeAsZspmEnums;
import kd.taxc.tctb.business.enums.szyh.VerificationDiffEnums;
import kd.taxc.tctb.business.enums.szyh.VerificationTaxTypeEnums;
import kd.taxc.tctb.business.taxmain.util.TaxVersionUtil;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class TaxtypeCardConvertConsumer
implements MessageConsumer {
    public static final Log logger = LogFactory.getLog(TaxtypeCardConvertConsumer.class);
    private static final String TAX_MAIN = "tctb_tax_main";
    private static final String UPDATESTATUS = "updatestatus";
    private static final String FAIL = "fail";
    private static final String DIFF = "diff";
    private static final String UPDATED = "updated";
    private static final String NODATA = "nodata";
    private static final String WITHOUT = "without";
    private static final String COMPARESTATUS = "comparestatus";

    public void onMessage(Object message, String messageId, boolean resend, MessageAcker acker) {
        String orgId;
        QFilter qfilter;
        DynamicObject taxOrgMain;
        String data = (String)message;
        logger.info("TaxtypeCardConvertConsumer message:" + data);
        Map dataMap = (Map)JsonUtil.fromJson((String)data, Map.class);
        if (dataMap.containsKey("orgId") && (taxOrgMain = BusinessDataServiceHelper.loadSingle((String)TAX_MAIN, (String)"id", (QFilter[])new QFilter[]{qfilter = new QFilter("orgid", "=", (Object)Long.valueOf(orgId = (String)dataMap.get("orgId"))).and(new QFilter("taxationsys", "=", (Object)TaxationSysEnum.CHAIN_MAINLAND.getId()))})) != null) {
            DynamicObject taxMain = BusinessDataServiceHelper.loadSingle((Object)taxOrgMain.getLong("id"), (String)TAX_MAIN);
            Map<String, List<DynamicObject>> taxTypeCardMap = TaxtypeCardConvertConsumer.getTaxTypeCard(taxMain);
            List ids = (List)dataMap.get("pkIds");
            DynamicObject[] verifyObjs = BusinessDataServiceHelper.load((String)"tctb_taxtype_verify", (String)MetadataUtil.getAllSubFieldString((String)"tctb_taxtype_verify"), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids).and("infotype", "=", (Object)"0").and("levytype", "=", (Object)"zxsb").and("expirydate", ">=", (Object)new Date())});
            if (taxTypeCardMap == null) {
                logger.info(String.format("\u6570\u636e\u6bd4\u5bf9\u5f02\u5e38\uff0c\u672a\u67e5\u8be2\u5230\u7a0e\u79cd\u5361\u7247\u4fe1\u606fID\uff1a%s", data));
                if (verifyObjs != null && verifyObjs.length > 0) {
                    Arrays.stream(verifyObjs).forEach(o -> o.set(UPDATESTATUS, (Object)WITHOUT));
                }
                SaveServiceHelper.save((DynamicObject[])verifyObjs);
                return;
            }
            boolean fail = false;
            try (TXHandle handle = TX.required();){
                try {
                    StringBuilder taxtypeChange = new StringBuilder();
                    if (verifyObjs != null && verifyObjs.length > 0) {
                        Map<String, List<DynamicObject>> collect = Arrays.stream(verifyObjs).collect(Collectors.groupingBy(a -> a.getDynamicObject("zsxm").getString("number")));
                        for (Map.Entry<String, List<DynamicObject>> map : collect.entrySet()) {
                            if (!taxTypeCardMap.containsKey(VerificationTaxTypeEnums.getTypeByNumber(map.getKey()))) continue;
                            if (EmptyCheckUtils.isEmpty((Object)taxtypeChange)) {
                                taxtypeChange.append(VerificationTaxTypeEnums.getTypeByNumber(map.getKey()));
                            } else if (taxtypeChange.toString().indexOf(VerificationTaxTypeEnums.getTypeByNumber(map.getKey())) < 0) {
                                taxtypeChange.append(',').append(VerificationTaxTypeEnums.getTypeByNumber(map.getKey()));
                            }
                            Method method = this.getClass().getDeclaredMethod(CovertMethodEnums.getMethodNameByKey(VerificationTaxTypeEnums.getTypeByNumber(map.getKey())), List.class, DynamicObject.class, String.class, String.class);
                            method.invoke((Object)this, map.getValue(), taxMain, orgId, map.getKey());
                        }
                    }
                    SaveServiceHelper.save((DynamicObject[])verifyObjs);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taxMain});
                    TaxVersionUtil.saveTsateTaxLastVersion(taxtypeChange.toString(), taxMain.getLong("id"));
                    acker.ack(messageId);
                }
                catch (Throwable throwable) {
                    handle.markRollback();
                    fail = true;
                    logger.error("TaxtypeCardCompareConsumer execute error", throwable);
                    acker.discard(messageId);
                }
            }
            if (fail && verifyObjs != null && verifyObjs.length > 0) {
                Arrays.stream(verifyObjs).forEach(o -> o.set(UPDATESTATUS, (Object)FAIL));
                SaveServiceHelper.save((DynamicObject[])verifyObjs);
            }
        }
    }

    public void convertDataForZzs(List<DynamicObject> data, DynamicObject taxMain, String orgId, String key) {
        Map<String, List<DynamicObject>> cardMap;
        List<DynamicObject> cards;
        DynamicObjectCollection categoryentryentity = taxMain.getDynamicObjectCollection("categoryentryentity");
        if (CollectionUtils.isNotEmpty((Collection)categoryentryentity) && CollectionUtils.isNotEmpty(cards = (cardMap = categoryentryentity.stream().collect(Collectors.groupingBy(a -> a.getString("taxtype")))).get(VerificationTaxTypeEnums.getTypeByNumber(key)))) {
            DynamicObject card = cards.get(0);
            if ("0".equals(card.getString("enable"))) {
                card.set("enable", (Object)"1");
            }
            for (DynamicObject obj : data) {
                if (!DIFF.equals(obj.getString(COMPARESTATUS))) continue;
                obj.set(UPDATESTATUS, (Object)UPDATED);
            }
        }
    }

    public void convertDataForQysds(List<DynamicObject> data, DynamicObject taxMain, String orgId, String key) {
        Map<String, List<DynamicObject>> cardMap;
        List<DynamicObject> cards;
        DynamicObjectCollection categoryentryentity = taxMain.getDynamicObjectCollection("categoryentryentity");
        if (CollectionUtils.isNotEmpty((Collection)categoryentryentity) && CollectionUtils.isNotEmpty(cards = (cardMap = categoryentryentity.stream().collect(Collectors.groupingBy(a -> a.getString("taxtype")))).get(VerificationTaxTypeEnums.getTypeByNumber(key)))) {
            DynamicObject obj;
            String deadline;
            DynamicObject card = cards.get(0);
            if ("0".equals(card.getString("enable"))) {
                card.set("enable", (Object)"1");
            }
            if (!StringUtils.equals((CharSequence)(deadline = card.getString("deadline")), (CharSequence)TaxtypeCardConvertConsumer.getDeadline((obj = data.get(0)).getString("taxlimit")))) {
                card.set("deadline", (Object)TaxtypeCardConvertConsumer.getDeadline(obj.getString("taxlimit")));
            }
            for (DynamicObject o : data) {
                if (!DIFF.equals(obj.getString(COMPARESTATUS))) continue;
                obj.set(UPDATESTATUS, (Object)UPDATED);
            }
        }
    }

    public void convertDataForFjsf(List<DynamicObject> data, DynamicObject taxMain, String orgId, String key) {
        Map<String, List<DynamicObject>> cardMap;
        List<DynamicObject> cards;
        DynamicObjectCollection categoryentryentity = taxMain.getDynamicObjectCollection("categoryentryentity");
        if (CollectionUtils.isNotEmpty((Collection)categoryentryentity) && CollectionUtils.isNotEmpty(cards = (cardMap = categoryentryentity.stream().collect(Collectors.groupingBy(a -> a.getString("taxtype")))).get(VerificationTaxTypeEnums.getTypeByNumber(key)))) {
            DynamicObject card = cards.get(0);
            if ("0".equals(card.getString("enable"))) {
                card.set("enable", (Object)"1");
            }
            for (DynamicObject obj : data) {
                String zsxm = obj.getDynamicObject("zsxm").getString("number");
                if ("006".equals(obj.getDynamicObject("zsxm").getString("number"))) {
                    if ("4".equals(card.getString("cswhjssenable"))) {
                        card.set("cswhjssenable", (Object)"1");
                    }
                    String zspm = obj.getDynamicObject("zspm").getString("number");
                    String orgplace = card.getString("orgplace");
                    if (!StringUtils.equals((CharSequence)orgplace, (CharSequence)FjsfPlaceMappingenum.getOrgplaceByzspm(zspm))) {
                        card.set("orgplace", (Object)FjsfPlaceMappingenum.getOrgplaceByzspm(zspm));
                    }
                    if (!DIFF.equals(obj.getString(COMPARESTATUS))) continue;
                    obj.set(UPDATESTATUS, (Object)UPDATED);
                    continue;
                }
                if ("019".equals(zsxm)) {
                    if ("5".equals(card.getString("jyffjenable"))) {
                        card.set("jyffjenable", (Object)"2");
                    }
                    if (!DIFF.equals(obj.getString(COMPARESTATUS))) continue;
                    obj.set(UPDATESTATUS, (Object)UPDATED);
                    continue;
                }
                if (!"020".equals(zsxm)) continue;
                if ("6".equals(card.getString("dfjyffjenable"))) {
                    card.set("dfjyffjenable", (Object)"3");
                }
                if (!DIFF.equals(obj.getString(COMPARESTATUS))) continue;
                obj.set(UPDATESTATUS, (Object)UPDATED);
            }
        }
    }

    public void convertDataForYhs(List<DynamicObject> verifyData, DynamicObject taxMain, String orgId, String key) {
        Map<String, List<DynamicObject>> cardMap;
        List<DynamicObject> cards;
        DynamicObjectCollection categoryentryentity = taxMain.getDynamicObjectCollection("categoryentryentity");
        if (CollectionUtils.isNotEmpty((Collection)categoryentryentity) && CollectionUtils.isNotEmpty(cards = (cardMap = categoryentryentity.stream().collect(Collectors.groupingBy(a -> a.getString("taxtype")))).get(VerificationTaxTypeEnums.getTypeByNumber(key)))) {
            DynamicObject card = cards.get(0);
            if ("0".equals(card.getString("enable"))) {
                card.set("enable", (Object)"1");
            }
            DynamicObjectCollection taxMainYhsEntity = TaxtypeCardConvertConsumer.getTaxTypeEntity(taxMain, "yhsentity");
            DynamicObject[] tcsdTaxrates = BusinessDataServiceHelper.load((String)"tpo_tcsd_taxrate", (String)"id,entryentity,entryentity.subname,startdate,enddate", (QFilter[])new QFilter[]{new QFilter("startdate", "<=", (Object)new Date()).and(new QFilter("enddate", ">=", (Object)new Date())).or(QFilter.isNull((String)"enddate"))});
            HashMap<String, DynamicObject> taxCategoryNameObjMap = new HashMap<String, DynamicObject>();
            for (DynamicObject dynamicObject : tcsdTaxrates) {
                DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entryentity");
                if (!CollectionUtils.isNotEmpty((Collection)dynamicObjectCollection)) continue;
                for (Object obj : dynamicObjectCollection) {
                    taxCategoryNameObjMap.put(obj.getString("subname"), (DynamicObject)obj);
                }
            }
            Map<String, List<DynamicObject>> verifyZspmCollect = verifyData.stream().collect(Collectors.groupingBy(a -> a.getDynamicObject("zspm").getString("name")));
            HashMap<String, List<DynamicObject>> oldDataMap = new HashMap<String, List<DynamicObject>>();
            this.dealYhsMerageData(verifyZspmCollect, oldDataMap);
            if (taxMainYhsEntity != null && !taxMainYhsEntity.isEmpty()) {
                Map<String, List<DynamicObject>> taxMainYhsZspmCollect = taxMainYhsEntity.stream().filter(o -> EmptyCheckUtils.isNotEmpty((Object)o.getDynamicObject("taxrate"))).collect(Collectors.groupingBy(a -> a.getDynamicObject("taxrate").getString("name")));
                for (Map.Entry<String, List<DynamicObject>> entry : verifyZspmCollect.entrySet()) {
                    String zspmKey = entry.getKey();
                    if (taxMainYhsZspmCollect.containsKey(zspmKey)) {
                        if (taxMainYhsZspmCollect.get(zspmKey).size() != 1 || entry.getValue().size() != 1) {
                            for (DynamicObject obj : entry.getValue()) {
                                obj.set(UPDATESTATUS, (Object)FAIL);
                            }
                            continue;
                        }
                        DynamicObject verifyZsmpData = entry.getValue().get(0);
                        DynamicObject taxMainYhsObj = taxMainYhsZspmCollect.get(zspmKey).get(0);
                        taxMainYhsObj.set("period", (Object)verifyZsmpData.getString("taxlimit"));
                        taxMainYhsObj.set("taxrate", taxCategoryNameObjMap.get(zspmKey));
                        taxMainYhsObj.set("effectivedate", (Object)verifyZsmpData.getDate("effectivedate"));
                        taxMainYhsObj.set("expirydate", (Object)verifyZsmpData.getDate("expirydate"));
                        taxMainYhsObj.set("declaretype", (Object)YHSDeclareTypeEnum.getYHSDelaretype(verifyZsmpData.getString("taxlimit")));
                        verifyZsmpData.set(UPDATESTATUS, (Object)UPDATED);
                        continue;
                    }
                    List<DynamicObject> sjObjs = entry.getValue();
                    for (DynamicObject sjObj : sjObjs) {
                        if (!taxCategoryNameObjMap.containsKey(zspmKey)) {
                            sjObj.set(UPDATESTATUS, (Object)WITHOUT);
                            sjObj.set(COMPARESTATUS, (Object)NODATA);
                            continue;
                        }
                        DynamicObject entryObject = taxMainYhsEntity.addNew();
                        entryObject.set("taxrate", taxCategoryNameObjMap.get(zspmKey));
                        entryObject.set("period", sjObj.get("taxlimit"));
                        entryObject.set("effectivedate", (Object)sjObj.getDate("effectivedate"));
                        entryObject.set("expirydate", (Object)sjObj.getDate("expirydate"));
                        entryObject.set("declaretype", (Object)YHSDeclareTypeEnum.getYHSDelaretype(sjObj.getString("taxlimit")));
                        entryObject.set("isverify", (Object)Boolean.FALSE);
                        sjObj.set(UPDATESTATUS, (Object)UPDATED);
                    }
                }
            } else {
                for (DynamicObject dynamicObject : verifyData) {
                    String string = dynamicObject.getDynamicObject("zspm").getString("name");
                    if (!taxCategoryNameObjMap.containsKey(string)) {
                        dynamicObject.set(UPDATESTATUS, (Object)WITHOUT);
                        dynamicObject.set(COMPARESTATUS, (Object)NODATA);
                        continue;
                    }
                    if (taxMainYhsEntity == null) continue;
                    DynamicObject entryObject = taxMainYhsEntity.addNew();
                    entryObject.set("taxrate", taxCategoryNameObjMap.get(string));
                    entryObject.set("period", dynamicObject.get("taxlimit"));
                    entryObject.set("effectivedate", (Object)dynamicObject.getDate("effectivedate"));
                    entryObject.set("expirydate", (Object)dynamicObject.getDate("expirydate"));
                    entryObject.set("isverify", (Object)Boolean.FALSE);
                    entryObject.set("declaretype", (Object)YHSDeclareTypeEnum.getYHSDelaretype(dynamicObject.getString("taxlimit")));
                    dynamicObject.set(UPDATESTATUS, (Object)UPDATED);
                }
            }
            for (Map.Entry entry : verifyZspmCollect.entrySet()) {
                if (!oldDataMap.containsKey(entry.getKey())) continue;
                List list = (List)oldDataMap.get(entry.getKey());
                DynamicObject mergeData = (DynamicObject)((List)entry.getValue()).get(0);
                for (DynamicObject oldDatum : list) {
                    oldDatum.set(UPDATESTATUS, mergeData.get(UPDATESTATUS));
                    oldDatum.set(COMPARESTATUS, mergeData.get(COMPARESTATUS));
                }
            }
        }
    }

    private void dealYhsMerageData(Map<String, List<DynamicObject>> sjZspmcollect, Map<String, List<DynamicObject>> oldDataMap) {
        for (Map.Entry<String, List<DynamicObject>> sjZspmEntry : sjZspmcollect.entrySet()) {
            List<DynamicObject> sjZspmList = sjZspmEntry.getValue();
            if (CollectionUtils.isEmpty(sjZspmList) || sjZspmList.size() == 1) continue;
            oldDataMap.put(sjZspmEntry.getKey(), sjZspmEntry.getValue());
            Date mergeEffectiveDate = null;
            Date mergeExpiryDate = null;
            DynamicObject mergeObject = BusinessDataServiceHelper.newDynamicObject((String)"tsate_taxtype_verify");
            boolean notCopy = true;
            for (DynamicObject sjZspm : sjZspmList) {
                Date effectiveDate = sjZspm.getDate("effectivedate");
                Date expiryDate = sjZspm.getDate("expiryDate");
                if (mergeEffectiveDate == null || effectiveDate.before(mergeEffectiveDate)) {
                    mergeEffectiveDate = effectiveDate;
                }
                if (mergeExpiryDate == null || !expiryDate.before(mergeExpiryDate)) {
                    mergeExpiryDate = expiryDate;
                }
                if (!notCopy) continue;
                mergeObject = TaxtypeCardConvertConsumer.copyData(sjZspm);
                notCopy = false;
            }
            mergeObject.set("effectivedate", mergeEffectiveDate);
            mergeObject.set("expiryDate", mergeExpiryDate);
            sjZspmcollect.put(sjZspmEntry.getKey(), Collections.singletonList(mergeObject));
        }
    }

    public void convertDataForQtsf(List<DynamicObject> data, DynamicObject taxMain, String orgId, String key) {
        block13: {
            Map<String, List<DynamicObject>> cardMap;
            List<DynamicObject> cards;
            DynamicObjectCollection categoryentryentity = taxMain.getDynamicObjectCollection("categoryentryentity");
            if (!CollectionUtils.isNotEmpty((Collection)categoryentryentity) || !CollectionUtils.isNotEmpty(cards = (cardMap = categoryentryentity.stream().collect(Collectors.groupingBy(a -> a.getString("taxtype")))).get(VerificationTaxTypeEnums.getTypeByNumber(key)))) break block13;
            DynamicObject card = cards.get(0);
            if ("0".equals(card.getString("enable"))) {
                card.set("enable", (Object)"1");
            }
            DynamicObjectCollection qtsfEntity = TaxtypeCardConvertConsumer.getTaxTypeEntity(taxMain, "qtsfentity");
            Map zspmMap = BusinessDataServiceHelper.loadFromCache((String)"tpo_zspm", (String)"id,name,number", null);
            HashMap map = new HashMap();
            if (ObjectUtils.isNotEmpty((Object)zspmMap)) {
                for (Map.Entry entry : zspmMap.entrySet()) {
                    map.put(((DynamicObject)entry.getValue()).getString("id"), entry.getValue());
                }
            }
            Map<String, List<DynamicObject>> sjZsxmcollect = data.stream().collect(Collectors.groupingBy(a -> TaxTypeAsZspmEnums.getZspmIdByDynamicObject(a)));
            if (CollectionUtils.isNotEmpty((Collection)qtsfEntity)) {
                Map<String, List<DynamicObject>> qtsfZspmCollect = qtsfEntity.stream().filter(o -> EmptyCheckUtils.isNotEmpty((Object)o.getDynamicObject("collectrate"))).collect(Collectors.groupingBy(a -> a.getDynamicObject("collectrate").getString("id")));
                for (Map.Entry<String, List<DynamicObject>> sjMap : sjZsxmcollect.entrySet()) {
                    String zspmKey = sjMap.getKey();
                    if (qtsfZspmCollect.containsKey(zspmKey)) {
                        if (qtsfZspmCollect.get(zspmKey).size() != 1 || sjMap.getValue().size() != 1) {
                            for (DynamicObject obj : sjMap.getValue()) {
                                obj.set(UPDATESTATUS, (Object)FAIL);
                            }
                            continue;
                        }
                        DynamicObject sjObj = sjMap.getValue().get(0);
                        DynamicObject qtsfObj = qtsfZspmCollect.get(zspmKey).get(0);
                        qtsfObj.set("taxperiod", (Object)VerificationDiffEnums.getTaxMainValueByZlValue(sjObj.getString("taxlimit")));
                        qtsfObj.set("amountrate", (Object)sjObj.getString("taxrate"));
                        qtsfObj.set("effectivestart", (Object)sjObj.getDate("effectivedate"));
                        qtsfObj.set("effectiveend", (Object)sjObj.getDate("expirydate"));
                        sjObj.set(UPDATESTATUS, (Object)UPDATED);
                        continue;
                    }
                    List<DynamicObject> sjObjs = sjMap.getValue();
                    for (DynamicObject sjObj : sjObjs) {
                        String zspmId = TaxTypeAsZspmEnums.getZspmIdByDynamicObject(sjObj);
                        if (!map.containsKey(zspmId)) {
                            sjObj.set(UPDATESTATUS, (Object)WITHOUT);
                            sjObj.set(COMPARESTATUS, (Object)NODATA);
                            continue;
                        }
                        DynamicObject entryObject = qtsfEntity.addNew();
                        entryObject.set("collectrate", map.get(zspmId));
                        entryObject.set("taxperiod", (Object)VerificationDiffEnums.getTaxMainValueByZlValue(sjObj.getString("taxlimit")));
                        entryObject.set("amountrate", (Object)sjObj.getString("taxrate"));
                        entryObject.set("effectivestart", (Object)sjObj.getDate("effectivedate"));
                        entryObject.set("effectiveend", (Object)sjObj.getDate("expirydate"));
                        sjObj.set(UPDATESTATUS, (Object)UPDATED);
                    }
                }
            } else {
                for (DynamicObject sjObj : data) {
                    String zspmKey = TaxTypeAsZspmEnums.getZspmIdByDynamicObject(sjObj);
                    if (!map.containsKey(zspmKey)) {
                        sjObj.set(UPDATESTATUS, (Object)WITHOUT);
                        sjObj.set(COMPARESTATUS, (Object)NODATA);
                        continue;
                    }
                    DynamicObject entryObject = qtsfEntity.addNew();
                    entryObject.set("collectrate", map.get(zspmKey));
                    entryObject.set("taxperiod", (Object)VerificationDiffEnums.getTaxMainValueByZlValue(sjObj.getString("taxlimit")));
                    entryObject.set("amountrate", (Object)sjObj.getString("taxrate"));
                    entryObject.set("effectivestart", (Object)sjObj.getDate("effectivedate"));
                    entryObject.set("effectiveend", (Object)sjObj.getDate("expirydate"));
                    sjObj.set(UPDATESTATUS, (Object)UPDATED);
                }
            }
        }
    }

    private static Map<String, List<DynamicObject>> getTaxTypeCard(DynamicObject taxMain) {
        if (taxMain != null) {
            DynamicObjectCollection categoryentryentity = taxMain.getDynamicObjectCollection("categoryentryentity");
            if (CollectionUtils.isNotEmpty((Collection)categoryentryentity)) {
                Map<String, List<DynamicObject>> cardMap = categoryentryentity.stream().collect(Collectors.groupingBy(a -> a.getString("taxtype")));
                return cardMap;
            }
            return null;
        }
        return null;
    }

    private static DynamicObjectCollection getTaxTypeEntity(DynamicObject taxMain, String entityName) {
        if (taxMain != null) {
            return taxMain.getDynamicObjectCollection(entityName);
        }
        return null;
    }

    private static String getDeadline(String taxlimit) {
        if ("month".equals(taxlimit)) {
            return "aysb";
        }
        if ("season".equals(taxlimit)) {
            return "ajsb";
        }
        if ("single".equals(taxlimit)) {
            return "acsb";
        }
        return "";
    }

    public static DynamicObject copyData(DynamicObject declare) {
        if (declare == null) {
            return null;
        }
        CloneUtils cloneUtils = new CloneUtils(false, false);
        return (DynamicObject)cloneUtils.clone((IDataEntityBase)declare);
    }
}

