/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.business.org;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class OrgService {
    public DynamicObject loadTaxMain(Long orgId) {
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgId);
        DynamicObject taxMain = Optional.ofNullable(QueryServiceHelper.queryOne((String)"tctb_tax_main", (String)"id", (QFilter[])new QFilter[]{orgFilter})).map(s -> BusinessDataServiceHelper.loadSingle((Object)s.getLong("id"), (String)"tctb_tax_main")).orElseGet(() -> null);
        return taxMain;
    }

    public List<String> getPersonNames(Long orgId, String position) {
        ArrayList<String> persons = new ArrayList<String>();
        DynamicObject dynamicObject = this.loadTaxMain(orgId);
        if (dynamicObject == null || CollectionUtils.isEmpty((Collection)dynamicObject.getDynamicObjectCollection("personalinformation"))) {
            return persons;
        }
        DynamicObjectCollection personalinformation = dynamicObject.getDynamicObjectCollection("personalinformation");
        List<String> names = personalinformation.stream().filter(s -> s.getString("position").equals(position)).map(s -> s.getString("fullname")).collect(Collectors.toList());
        return names;
    }

    public List<Long> longOrgIdByTagId(List<Long> tagIds) {
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"tctb_tax_main", (String)"orgid.id as orgId", (QFilter[])new QFilter[]{new QFilter("orgattr.fbasedataid", "in", tagIds)});
        if (dynamicObjects != null && dynamicObjects.size() > 0) {
            return dynamicObjects.stream().map(s -> s.getLong("orgId")).collect(Collectors.toList());
        }
        return new ArrayList<Long>();
    }
}

