/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.business.org;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.TaxationsysMappingEnum;
import kd.taxc.bdtaxr.common.helper.bastax.taxcorg.TaxcOrgDataServiceHelper;
import kd.taxc.common.constant.LicenseCheckConstant;
import kd.taxc.common.util.DBUtils;
import kd.taxc.tctb.business.taxclicense.TaxcLicensePurchaseService;
import kd.taxc.tctb.business.taxclicense.TaxcLicenseService;

public class TaxcOrgSaveBusiness {
    private static Log logger = LogFactory.getLog(TaxcOrgSaveBusiness.class);

    public static void syncTaxLicenseWithLock(List<Long> ids) {
        DLock lock = null;
        try {
            lock = DLock.create((String)"taxc/license/syncData");
            boolean getLock = lock.tryLock();
            if (getLock) {
                TaxcOrgSaveBusiness.syncTaxLicense(ids);
            } else {
                logger.info("TaxcOrgSaveBusiness.syncTaxLicenseWithLock\u6ca1\u6709\u62ff\u5230\u9501\uff01");
            }
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    private static Object syncTaxLicense(List<Long> ids) {
        if (!CollectionUtils.isEmpty(ids)) {
            ArrayList<DynamicObject> saveObjs = new ArrayList<DynamicObject>(ids.size());
            TaxResult listTaxResult = TaxcOrgDataServiceHelper.queryTaxcOrgByIds(ids, (Long)TaxationsysMappingEnum.CHN.getId());
            if (listTaxResult != null && !CollectionUtils.isEmpty((Collection)((Collection)listTaxResult.getData()))) {
                List<Long> orgIds = ((List)listTaxResult.getData()).stream().map(o -> o.getLong("org.id")).collect(Collectors.toList());
                Map<Long, DynamicObject> orgMap = ((List)listTaxResult.getData()).stream().collect(Collectors.toMap(o -> o.getLong("org.id"), o -> o));
                if (!CollectionUtils.isEmpty(orgIds)) {
                    DynamicObject[] licenseObjs = TaxcLicenseService.queryTaxcLicenseByOrgIds(orgIds);
                    if (licenseObjs != null && licenseObjs.length > 0) {
                        TaxcOrgSaveBusiness.dealExsitData(orgIds, orgMap, saveObjs, licenseObjs);
                    } else {
                        TaxcOrgSaveBusiness.dealNoData(orgIds, orgMap, saveObjs);
                    }
                    if (!CollectionUtils.isEmpty(saveObjs)) {
                        OperationServiceHelper.executeOperate((String)"save", (String)"tctb_license_from", (DynamicObject[])saveObjs.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
                    }
                }
            } else {
                DynamicObject[] licenseObjs = TaxcLicenseService.queryTaxcLicenseByOrgIds(ids);
                if (licenseObjs != null && licenseObjs.length > 0) {
                    DynamicObject licenseObj2 = null;
                    for (DynamicObject licenseObj2 : licenseObjs) {
                        if ("B".equals(licenseObj2.getString("licensestatus"))) continue;
                        licenseObj2.set("unifiedsocialcode", null);
                        saveObjs.add(licenseObj2);
                    }
                    if (!CollectionUtils.isEmpty(saveObjs)) {
                        OperationServiceHelper.executeOperate((String)"save", (String)"tctb_license_from", (DynamicObject[])saveObjs.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
                    }
                }
            }
            return ids.size();
        }
        return null;
    }

    private static void dealNoData(List<Long> orgIds, Map<Long, DynamicObject> orgMap, List<DynamicObject> saveObjs) {
        orgIds.stream().forEach(o -> {
            String unifiedsocialcode = null;
            Optional<DynamicObject> first = ((DynamicObject)orgMap.get(o)).getDynamicObjectCollection("entryentity").stream().filter(f -> f.getLong("entry_taxationsys.id") == TaxationsysMappingEnum.CHN.getId().longValue()).findFirst();
            if (first.isPresent()) {
                unifiedsocialcode = first.get().getString("entry_unifiedsocialcode");
            }
            TaxcOrgSaveBusiness.newLicenseDynamicObject(saveObjs, o, unifiedsocialcode);
        });
    }

    private static void dealExsitData(List<Long> orgIds, Map<Long, DynamicObject> orgMap, List<DynamicObject> saveObjs, DynamicObject[] licenseObjs) {
        Map<Long, List<DynamicObject>> collect = Arrays.stream(licenseObjs).collect(Collectors.groupingBy(s -> s.getLong("orgid.id")));
        orgIds.stream().forEach(o -> {
            String unifiedsocialcode = null;
            Optional<DynamicObject> first = ((DynamicObject)orgMap.get(o)).getDynamicObjectCollection("entryentity").stream().filter(f -> f.getLong("entry_taxationsys.id") == TaxationsysMappingEnum.CHN.getId().longValue()).findFirst();
            if (first.isPresent()) {
                unifiedsocialcode = first.get().getString("entry_unifiedsocialcode");
            }
            if (collect.containsKey(o)) {
                String finalUnifiedsocialcode = unifiedsocialcode;
                ((List)collect.get(o)).stream().forEach(s -> {
                    if (!"B".equals(s.getString("licensestatus"))) {
                        s.set("unifiedsocialcode", (Object)finalUnifiedsocialcode);
                    }
                });
                String version = TaxcLicensePurchaseService.getVersion();
                Optional<DynamicObject> licenseFirst = ((List)collect.get(o)).stream().filter(s -> version.equals(s.getString("ver"))).findFirst();
                if (!licenseFirst.isPresent()) {
                    TaxcOrgSaveBusiness.newLicenseDynamicObject(saveObjs, o, unifiedsocialcode);
                }
                saveObjs.addAll((Collection)collect.get(o));
            } else {
                TaxcOrgSaveBusiness.newLicenseDynamicObject(saveObjs, o, unifiedsocialcode);
            }
        });
    }

    private static void newLicenseDynamicObject(List<DynamicObject> saveObjs, Long o, String unifiedsocialcode) {
        String version = TaxcLicensePurchaseService.getVersion();
        for (LicenseCheckConstant.LicenseEnum lisenseVesionEnum : LicenseCheckConstant.LicenseEnum.values()) {
            if (!lisenseVesionEnum.getVersion().equals(version)) continue;
            DynamicObject d = BusinessDataServiceHelper.newDynamicObject((String)"tctb_license_from");
            d.set("id", (Object)DBUtils.getLongId((String)"tctb_license_from"));
            d.set("orgid", (Object)o);
            d.set("group", (Object)Long.valueOf(lisenseVesionEnum.getGroup()));
            d.set("unifiedsocialcode", (Object)unifiedsocialcode);
            d.set("licensestatus", (Object)"A");
            d.set("ver", (Object)lisenseVesionEnum.getVersion());
            d.set("password", (Object)"");
            saveObjs.add(d);
        }
    }
}

