/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.business.org;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.taxc.common.util.DBUtils;
import kd.taxc.common.util.DateUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class YhsEntityUpgradeBusisess {
    private static List<String> ID_REPLACE = new ArrayList<String>();
    private static List<String> EXPIRE_ADD = new ArrayList<String>();
    private static List<String> EXPIRE = new ArrayList<String>();
    private static LinkedHashMap<String, String> YHS_MAP = new LinkedHashMap();
    private static final String SEASON = "season";
    private static final String HALFYEAR = "halfyear";
    private static final String YEAR = "year";

    public static void sqlUpdate() {
        Long newTpoTcsdTaxDyo = YhsEntityUpgradeBusisess.checkDataAndGetNewTaxRates();
        Object[] params = new Object[]{newTpoTcsdTaxDyo};
        List newTaxEntryList = DBUtils.query((String)" SELECT a.FID FID,a.FENTRYID FENTRYID,a.FNUMBER FNUMBER,b.FNAME FNAME FROM t_tpo_tcsd_taxrateentry a,t_tpo_tcsd_taxrateentry_l b WHERE  a.FENTRYID = b.FENTRYID and b.FLOCALEID = 'zh_CN'  and  a.FID  = ? and a.FISLEAF = '1' ;", (Object[])params);
        List newTaxEntryIds = newTaxEntryList.stream().map(m -> (Long)m.get("FENTRYID")).collect(Collectors.toList());
        Date lastDay = DateUtils.stringToDate((String)"20220630", (String)"yyyyMMdd");
        List yhsentityList = DBUtils.query((String)" SELECT a.FID FID ,a.FENTRYID FENTRYID,a.FSEQ FSEQ,a.FPERIOD FPERIOD,a.FHDRATE FHDRATE,a.FTAXRATEID FTAXRATEID,a.FEFFECTIVEDATE FEFFECTIVEDATE,a.FEXPIRYDATE FEXPIRYDATE,a.FISVERIFY FISVERIFY,b.FNAME FNAME from  t_tctb_yhs_entry a, t_tpo_tcsd_taxrateentry_l b WHERE  a.FTAXRATEID = b.FENTRYID and b.FLOCALEID ='zh_CN';");
        HashMap<Long, Integer> idSeqMap = new HashMap<Long, Integer>();
        HashSet<Long> fidSet = new HashSet<Long>();
        boolean isUpdate = false;
        for (Map yhsentity : yhsentityList) {
            boolean setExpiry;
            Long fid = (Long)yhsentity.get("FID");
            Long fentryid = (Long)yhsentity.get("FENTRYID");
            List yhsentityListByFentryId = DBUtils.query((String)String.format("  SELECT TOP 1,0 a.FID FID ,a.FENTRYID FENTRYID,a.FSEQ FSEQ,a.FPERIOD FPERIOD,a.FHDRATE FHDRATE,a.FTAXRATEID FTAXRATEID,a.FEFFECTIVEDATE FEFFECTIVEDATE,a.FEXPIRYDATE FEXPIRYDATE,a.FISVERIFY FISVERIFY,b.FNAME FNAME from  t_tctb_yhs_entry a, t_tpo_tcsd_taxrateentry_l b WHERE  a.FTAXRATEID = b.FENTRYID and b.FLOCALEID ='zh_CN' and a.FENTRYID = %S; ", fentryid));
            if (CollectionUtils.isEmpty((Collection)yhsentityListByFentryId)) continue;
            yhsentity = (Map)yhsentityListByFentryId.get(0);
            String period = (String)yhsentity.get("FPERIOD");
            Object fhdrate = yhsentity.get("FHDRATE");
            Long ftaxrateid = (Long)yhsentity.get("FTAXRATEID");
            Date effectivedate = (Date)yhsentity.get("FEFFECTIVEDATE");
            Date expirydate = (Date)yhsentity.get("FEXPIRYDATE");
            Object fisverify = yhsentity.get("FISVERIFY");
            String taxRateName = (String)yhsentity.get("FNAME");
            if (!idSeqMap.containsKey(fid)) {
                List collect = yhsentityList.stream().filter(m -> fid.compareTo((Long)m.get("FID")) == 0).collect(Collectors.toList());
                idSeqMap.put(fid, collect.size());
            }
            if (newTaxEntryIds.contains(ftaxrateid) || YhsEntityUpgradeBusisess.isExpiry(expirydate, lastDay)) continue;
            if (ftaxrateid == null || effectivedate == null || expirydate == null || effectivedate.compareTo(expirydate) >= 0) {
                String format = String.format("DELETE FROM  t_tctb_yhs_entry WHERE FENTRYID = %S ;", fentryid);
                DBUtils.execute((String)format);
                isUpdate = true;
                fidSet.add(fid);
                continue;
            }
            if ("month".equalsIgnoreCase(period) || HALFYEAR.equalsIgnoreCase(period)) {
                isUpdate = YhsEntityUpgradeBusisess.setExpiry(yhsentity, lastDay);
                if (!isUpdate) continue;
                fidSet.add(fid);
                continue;
            }
            if (ID_REPLACE.contains(taxRateName)) {
                List newTaxRate = newTaxEntryList.stream().filter(m -> taxRateName.equalsIgnoreCase((String)m.get("FNAME"))).collect(Collectors.toList());
                if (newTaxRate.size() != 1) {
                    throw new KDBizException(ResManager.loadKDString((String)"id\u66ff\u6362\uff0c\u65b0\u7684\u7a0e\u76ee\u8868\u4e0d\u552f\u4e00", (String)"YhsEntityUpgradeBusisess_20", (String)"taxc-tctb-business", (Object[])new Object[0]));
                }
                DBUtils.execute((String)String.format("UPDATE t_tctb_yhs_entry SET FTAXRATEID =  %S WHERE FENTRYID = %S ;", ((Map)newTaxRate.get(0)).get("FENTRYID"), fentryid));
                isUpdate = true;
            } else if (EXPIRE.contains(taxRateName)) {
                isUpdate = YhsEntityUpgradeBusisess.setExpiry(yhsentity, lastDay);
            } else if (EXPIRE_ADD.contains(taxRateName) && (setExpiry = YhsEntityUpgradeBusisess.setExpiry(yhsentity, lastDay))) {
                isUpdate = true;
                List name = newTaxEntryList.stream().filter(m -> YHS_MAP.get(taxRateName).equalsIgnoreCase((String)m.get("FNAME"))).collect(Collectors.toList());
                if (name.size() != 1) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u65b0\u589e\u65b0\u7a0e\u76ee\uff0c\u65b0\u7684\u7a0e\u76ee\u8868\u4e0d\u552f\u4e00", (String)"YhsEntityUpgradeBusisess_21", (String)"taxc-tctb-business", (Object[])new Object[0]));
                }
                Long newTaxrateid = (Long)((Map)name.get(0)).get("FENTRYID");
                String newTaxRateName = (String)((Map)name.get(0)).get("FNAME");
                ImmutablePair<List<Map<String, Object>>, Boolean> updateSamePeriodTaxRate = YhsEntityUpgradeBusisess.getAndUpdateSamePeriodTaxRate(fid, newTaxrateid, expirydate, newTaxRateName, isUpdate, fisverify);
                List collect = (List)updateSamePeriodTaxRate.left;
                isUpdate = (Boolean)updateSamePeriodTaxRate.right;
                if (CollectionUtils.isEmpty((Collection)collect)) {
                    String insertSql = " INSERT INTO t_tctb_yhs_entry(FID,FENTRYID,FSEQ,FPERIOD,FHDRATE,FTAXRATEID,FEFFECTIVEDATE,FEXPIRYDATE,FISVERIFY) values (?,?,?,?,?,?,?,?,?) ;";
                    if (SEASON.equalsIgnoreCase(period)) {
                        effectivedate = DateUtils.stringToDate((String)"20220701", (String)"yyyyMMdd");
                    } else if (YEAR.equalsIgnoreCase(period)) {
                        effectivedate = DateUtils.stringToDate((String)"20220101", (String)"yyyyMMdd");
                    }
                    Integer nextSeq = (Integer)idSeqMap.get(fid) + 1;
                    idSeqMap.put(fid, nextSeq);
                    ArrayList<Object[]> parmList = new ArrayList<Object[]>(1);
                    Object[] param = new Object[]{fid, DBUtils.getLongId((String)"t_tctb_yhs_entry"), nextSeq, period, fhdrate, newTaxrateid, effectivedate, expirydate, fisverify};
                    parmList.add(param);
                    DBUtils.executeBatch((String)insertSql, parmList);
                }
            }
            if (!isUpdate) continue;
            fidSet.add(fid);
        }
        YhsEntityUpgradeBusisess.recordYhsVersion(fidSet);
    }

    private static Long checkDataAndGetNewTaxRates() {
        Object[] params = new Object[]{DateUtils.stringToDate((String)"20220701", (String)"yyyyMMdd")};
        List tcsdTaxrates = DBUtils.query((String)" SELECT FID FROM t_tpo_tcsd_taxrate WHERE  FENDDATE < ? ;", (Object[])params);
        if (tcsdTaxrates == null || tcsdTaxrates.size() != 1) {
            throw new KDBizException(ResManager.loadKDString((String)"2022\u5e746\u670830\u53f7\u8fc7\u671f\u7684\u5370\u82b1\u7a0e\u7a0e\u76ee\u6570\u636e\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u552f\u4e00", (String)"YhsEntityUpgradeBusisess_22", (String)"taxc-tctb-business", (Object[])new Object[0]));
        }
        Long fid = (Long)((Map)tcsdTaxrates.get(0)).get("FID");
        String oldTaxEntrySql = String.format(" SELECT b.FNAME FNAME,a.FISLEAF FISLEAF FROM t_tpo_tcsd_taxrateentry a, t_tpo_tcsd_taxrateentry_l b WHERE a.FENTRYID = b.FENTRYID and  a.FID = %S and a.FISLEAF = '1'  and b.FLOCALEID = 'zh_CN' ; ", fid);
        List oldTaxEntry = DBUtils.query((String)oldTaxEntrySql);
        List oldNameList = oldTaxEntry.stream().map(m -> (String)m.get("FNAME")).distinct().collect(Collectors.toList());
        if (!oldNameList.containsAll(ID_REPLACE)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9700\u8981id\u66ff\u6362\u7684\u65e7\u7a0e\u76ee\u4e0d\u5b58\u5728", (String)"YhsEntityUpgradeBusisess_23", (String)"taxc-tctb-business", (Object[])new Object[0]));
        }
        if (!oldNameList.containsAll(EXPIRE_ADD)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9700\u8981\u5931\u6548\u5e76\u65b0\u589e\u7684\u65e7\u7a0e\u76ee\u4e0d\u5b58\u5728", (String)"YhsEntityUpgradeBusisess_24", (String)"taxc-tctb-business", (Object[])new Object[0]));
        }
        if (!oldNameList.containsAll(EXPIRE)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9700\u8981\u5931\u6548\u7684\u65e7\u7a0e\u76ee\u4e0d\u5b58\u5728", (String)"YhsEntityUpgradeBusisess_25", (String)"taxc-tctb-business", (Object[])new Object[0]));
        }
        params = new Object[]{DateUtils.stringToDate((String)"20220701", (String)"yyyyMMdd")};
        List newTpoTcsdTaxrates = DBUtils.query((String)" SELECT FID FROM t_tpo_tcsd_taxrate WHERE  FENDDATE > ? or FENDDATE is  null ;", (Object[])params);
        if (newTpoTcsdTaxrates == null || newTpoTcsdTaxrates.size() != 1) {
            throw new KDBizException(ResManager.loadKDString((String)"2022\u5e746\u670830\u53f7\u4e4b\u540e\u7684\u5370\u82b1\u7a0e\u7a0e\u76ee\u6570\u636e\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u552f\u4e00", (String)"YhsEntityUpgradeBusisess_26", (String)"taxc-tctb-business", (Object[])new Object[0]));
        }
        return (Long)((Map)newTpoTcsdTaxrates.get(0)).get("FID");
    }

    private static boolean setExpiry(Map<String, Object> yhsentity, Date lastDay) {
        Long fid = (Long)yhsentity.get("FID");
        Long fentryid = (Long)yhsentity.get("FENTRYID");
        String period = (String)yhsentity.get("FPERIOD");
        Long ftaxrateid = (Long)yhsentity.get("FTAXRATEID");
        Date effectivedate = (Date)yhsentity.get("FEFFECTIVEDATE");
        Date expirydate = (Date)yhsentity.get("FEXPIRYDATE");
        Object fisverify = yhsentity.get("FISVERIFY");
        boolean isNeedUpdate = expirydate.compareTo(lastDay) > 0;
        boolean matchPeriod = true;
        Date newEffectivedate = effectivedate;
        Date newExpirydate = expirydate;
        if (isNeedUpdate) {
            if (!YEAR.equalsIgnoreCase(period)) {
                newExpirydate = DateUtils.getLastDateOfDay((Date)DateUtils.stringToDate((String)"20220630", (String)"yyyyMMdd"));
                matchPeriod = effectivedate.compareTo(DateUtils.stringToDate((String)"20220630", (String)"yyyyMMdd")) < 0;
            } else {
                newExpirydate = DateUtils.getLastDateOfDay((Date)DateUtils.stringToDate((String)"20211231", (String)"yyyyMMdd"));
                boolean bl = matchPeriod = effectivedate.compareTo(DateUtils.stringToDate((String)"20211231", (String)"yyyyMMdd")) < 0;
            }
        }
        if (isNeedUpdate && !matchPeriod) {
            if (HALFYEAR.equalsIgnoreCase(period)) {
                newEffectivedate = DateUtils.stringToDate((String)"20220101", (String)"yyyyMMdd");
            } else if (SEASON.equalsIgnoreCase(period)) {
                newEffectivedate = DateUtils.stringToDate((String)"20220401", (String)"yyyyMMdd");
            } else if (YEAR.equalsIgnoreCase(period)) {
                newEffectivedate = DateUtils.stringToDate((String)"20210101", (String)"yyyyMMdd");
            } else if ("month".equalsIgnoreCase(period)) {
                newEffectivedate = DateUtils.stringToDate((String)"20220601", (String)"yyyyMMdd");
            }
        }
        if (isNeedUpdate) {
            Object[] param = new Object[]{newEffectivedate, newExpirydate, fentryid};
            Object[] queryParam = new Object[]{ftaxrateid, fisverify, fid, fentryid};
            List sameTaxEntryList = DBUtils.query((String)" SELECT FENTRYID,FEFFECTIVEDATE,FEXPIRYDATE FROM t_tctb_yhs_entry WHERE  FTAXRATEID = ?  AND FISVERIFY = ? AND FID = ? AND FENTRYID   <>  ?;", (Object[])queryParam);
            boolean hasCross = false;
            if (CollectionUtils.isNotEmpty((Collection)sameTaxEntryList)) {
                for (Map objectMap : sameTaxEntryList) {
                    Date targetEffectiveDate = (Date)objectMap.get("FEFFECTIVEDATE");
                    Date targetExpiryDate = (Date)objectMap.get("FEXPIRYDATE");
                    if (newEffectivedate.after(targetExpiryDate) || newExpirydate.before(targetEffectiveDate)) continue;
                    hasCross = true;
                }
            }
            if (!hasCross) {
                ArrayList<Object[]> parmList = new ArrayList<Object[]>(1);
                parmList.add(param);
                DBUtils.executeBatch((String)"UPDATE t_tctb_yhs_entry SET FEFFECTIVEDATE = ? , FEXPIRYDATE = ? WHERE FENTRYID = ? ; ", parmList);
                return true;
            }
            String format = String.format("DELETE FROM  t_tctb_yhs_entry WHERE FENTRYID = %S ;", fentryid);
            DBUtils.execute((String)format);
            return true;
        }
        return false;
    }

    private static ImmutablePair<List<Map<String, Object>>, Boolean> getAndUpdateSamePeriodTaxRate(Long fid, Long newTaxRateId, Date expiryDate, String newTaxRateName, Boolean isUpdate, Object fisverify) {
        Date localExpiryDate;
        List yhsentityListByFid = DBUtils.query((String)String.format(" SELECT a.FID FID ,a.FENTRYID FENTRYID,a.FSEQ FSEQ,a.FPERIOD FPERIOD,a.FHDRATE FHDRATE,a.FTAXRATEID FTAXRATEID,a.FEFFECTIVEDATE FEFFECTIVEDATE,a.FEXPIRYDATE FEXPIRYDATE,a.FISVERIFY FISVERIFY,b.FNAME FNAME from  t_tctb_yhs_entry a, t_tpo_tcsd_taxrateentry_l b WHERE  a.FTAXRATEID = b.FENTRYID and b.FLOCALEID ='zh_CN' and a.FID = %S; ", fid));
        List collect = yhsentityListByFid.stream().filter(m -> {
            Long loaclTaxrateid = (Long)m.get("FTAXRATEID");
            Object localIsverify = m.get("FISVERIFY");
            return newTaxRateId.compareTo(loaclTaxrateid) == 0 && localIsverify.toString().equals(fisverify.toString());
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            return ImmutablePair.of(collect, (Object)false);
        }
        if (collect.size() > 1) {
            List maps = collect.subList(1, collect.size());
            List fids = maps.stream().map(m -> (Long)m.get("FENTRYID")).collect(Collectors.toList());
            String entryIdsStr = StringUtils.join((Object[])fids.toArray(), (String)",");
            String format = String.format(" DELETE FROM  t_tctb_yhs_entry WHERE FENTRYID IN ( %S ) ;", entryIdsStr);
            DBUtils.execute((String)format);
            isUpdate = true;
        }
        if (newTaxRateName.equalsIgnoreCase(ResManager.loadKDString((String)"\u5efa\u8bbe\u5de5\u7a0b\u5408\u540c", (String)"YhsEntityUpgradeBusisess_16", (String)"taxc-tctb-business", (Object[])new Object[0])) && (localExpiryDate = (Date)((Map)collect.get(0)).get("FEXPIRYDATE")).compareTo(expiryDate) < 0) {
            Object[] param = new Object[]{expiryDate, ((Map)collect.get(0)).get("FENTRYID")};
            ArrayList<Object[]> parmList = new ArrayList<Object[]>(1);
            parmList.add(param);
            DBUtils.executeBatch((String)"UPDATE t_tctb_yhs_entry SET FEXPIRYDATE = ? WHERE FENTRYID = ? ; ", parmList);
            isUpdate = true;
        }
        return ImmutablePair.of(collect, (Object)isUpdate);
    }

    private static void recordYhsVersion(HashSet<Long> fidSet) {
        String insertYhsSql = " INSERT INTO t_tctb_tax_ver_yhs(FID,FMODIFYDATE,FORG,FTAXTYPE,FMODIFIER,FVER) values (?,?,?,?,?,?) ;";
        String insertYhsEntitySql = " INSERT INTO t_tctb_tax_ver_yhs_e(FID,FENTRYID,FSEQ,FTAXRATEID,FPERIOD,FISVERIFY,FHDRATE,FEFFECTIVEDATE,FEXPIRYDATE,FENDDATE,FSTARTDATE) values (?,?,?,?,?,?,?,?,?,?,?) ;";
        for (Long fid : fidSet) {
            List taxMains = DBUtils.query((String)String.format(" SELECT FID ,FORGID from  t_tctb_tax_main  WHERE  FID = %S ;", fid));
            if (taxMains.size() != 1) continue;
            Long orgId = (Long)((Map)taxMains.get(0)).get("FORGID");
            List yhsVer = DBUtils.query((String)String.format(" SELECT TOP 1,0 FORG ,FVER from  t_tctb_tax_ver_yhs  WHERE  FORG = %S  ORDER BY FVER DESC;", orgId));
            Long ver = (Long)((Map)yhsVer.get(0)).get("FVER") + 1L;
            ArrayList<Object[]> parmList = new ArrayList<Object[]>(1);
            long taxVerYhsId = DBUtils.getLongId((String)"t_tctb_tax_ver_yhs");
            Object[] param = new Object[]{taxVerYhsId, new Date(), orgId, "yhs", 1L, ver};
            parmList.add(param);
            DBUtils.executeBatch((String)insertYhsSql, parmList);
            List yhsentityListByFid = DBUtils.query((String)String.format(" SELECT  FID , FENTRYID, FSEQ, FPERIOD, FHDRATE, FTAXRATEID, FEFFECTIVEDATE, FEXPIRYDATE, FISVERIFY from  t_tctb_yhs_entry  WHERE FID =  %S ORDER BY  FSEQ DESC ;", fid));
            ArrayList<Object[]> entityParmList = new ArrayList<Object[]>(2);
            for (Map yhsentity : yhsentityListByFid) {
                Object[] entityParam = new Object[]{taxVerYhsId, DBUtils.getLongId((String)"t_tctb_tax_ver_yhs_e"), yhsentity.get("FSEQ"), yhsentity.get("FTAXRATEID"), yhsentity.get("FPERIOD"), yhsentity.get("FISVERIFY"), yhsentity.get("FHDRATE"), yhsentity.get("FEFFECTIVEDATE"), yhsentity.get("FEXPIRYDATE"), yhsentity.get("FENDDATE"), yhsentity.get("FSTARTDATE")};
                entityParmList.add(entityParam);
            }
            if (yhsentityListByFid.isEmpty()) continue;
            DBUtils.executeBatch((String)insertYhsEntitySql, entityParmList);
        }
    }

    private static boolean isExpiry(Date expirydate, Date lastDay) {
        return expirydate != null && DateUtils.getDayFirst((Date)expirydate).compareTo(lastDay) <= 0;
    }

    static {
        ID_REPLACE.add(ResManager.loadKDString((String)"\u501f\u6b3e\u5408\u540c", (String)"YhsEntityUpgradeBusisess_0", (String)"taxc-tctb-business", (Object[])new Object[0]));
        ID_REPLACE.add(ResManager.loadKDString((String)"\u6280\u672f\u5408\u540c", (String)"YhsEntityUpgradeBusisess_1", (String)"taxc-tctb-business", (Object[])new Object[0]));
        ID_REPLACE.add(ResManager.loadKDString((String)"\u8d22\u4ea7\u4fdd\u9669\u5408\u540c", (String)"YhsEntityUpgradeBusisess_2", (String)"taxc-tctb-business", (Object[])new Object[0]));
        EXPIRE.add(ResManager.loadKDString((String)"\u4ed3\u50a8\u4fdd\u7ba1\u5408\u540c", (String)"YhsEntityUpgradeBusisess_3", (String)"taxc-tctb-business", (Object[])new Object[0]));
        EXPIRE.add(ResManager.loadKDString((String)"\u4ea7\u6743\u8f6c\u79fb\u4e66\u636e", (String)"YhsEntityUpgradeBusisess_4", (String)"taxc-tctb-business", (Object[])new Object[0]));
        EXPIRE.add(ResManager.loadKDString((String)"\u8425\u4e1a\u8d26\u7c3f\uff08\u5176\u4ed6\u8d26\u7c3f\uff09", (String)"YhsEntityUpgradeBusisess_5", (String)"taxc-tctb-business", (Object[])new Object[0]));
        EXPIRE.add(ResManager.loadKDString((String)"\u6743\u5229\u3001\u8bb8\u53ef\u8bc1\u7167", (String)"YhsEntityUpgradeBusisess_6", (String)"taxc-tctb-business", (Object[])new Object[0]));
        EXPIRE_ADD.add(ResManager.loadKDString((String)"\u8d2d\u9500\u5408\u540c", (String)"YhsEntityUpgradeBusisess_7", (String)"taxc-tctb-business", (Object[])new Object[0]));
        EXPIRE_ADD.add(ResManager.loadKDString((String)"\u52a0\u5de5\u627f\u63fd\u5408\u540c", (String)"YhsEntityUpgradeBusisess_8", (String)"taxc-tctb-business", (Object[])new Object[0]));
        EXPIRE_ADD.add(ResManager.loadKDString((String)"\u5efa\u8bbe\u5de5\u7a0b\u52d8\u5bdf\u8bbe\u8ba1\u5408\u540c", (String)"YhsEntityUpgradeBusisess_9", (String)"taxc-tctb-business", (Object[])new Object[0]));
        EXPIRE_ADD.add(ResManager.loadKDString((String)"\u5efa\u7b51\u5b89\u88c5\u5de5\u7a0b\u627f\u5305\u5408\u540c", (String)"YhsEntityUpgradeBusisess_10", (String)"taxc-tctb-business", (Object[])new Object[0]));
        EXPIRE_ADD.add(ResManager.loadKDString((String)"\u8d27\u7269\u8fd0\u8f93\u5408\u540c", (String)"YhsEntityUpgradeBusisess_11", (String)"taxc-tctb-business", (Object[])new Object[0]));
        EXPIRE_ADD.add(ResManager.loadKDString((String)"\u8d22\u4ea7\u79df\u8d41\u5408\u540c", (String)"YhsEntityUpgradeBusisess_12", (String)"taxc-tctb-business", (Object[])new Object[0]));
        EXPIRE_ADD.add(ResManager.loadKDString((String)"\u8425\u4e1a\u8d26\u7c3f\uff08\u8bb0\u8f7d\u8d44\u91d1\u7684\u8d26\u7c3f\uff09", (String)"YhsEntityUpgradeBusisess_13", (String)"taxc-tctb-business", (Object[])new Object[0]));
        YHS_MAP.put(ResManager.loadKDString((String)"\u8d2d\u9500\u5408\u540c", (String)"YhsEntityUpgradeBusisess_7", (String)"taxc-tctb-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e70\u5356\u5408\u540c", (String)"YhsEntityUpgradeBusisess_7", (String)"taxc-tctb-business", (Object[])new Object[0]));
        YHS_MAP.put(ResManager.loadKDString((String)"\u52a0\u5de5\u627f\u63fd\u5408\u540c", (String)"YhsEntityUpgradeBusisess_8", (String)"taxc-tctb-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u627f\u63fd\u5408\u540c", (String)"YhsEntityUpgradeBusisess_8", (String)"taxc-tctb-business", (Object[])new Object[0]));
        YHS_MAP.put(ResManager.loadKDString((String)"\u5efa\u8bbe\u5de5\u7a0b\u52d8\u5bdf\u8bbe\u8ba1\u5408\u540c", (String)"YhsEntityUpgradeBusisess_9", (String)"taxc-tctb-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5efa\u8bbe\u5de5\u7a0b\u5408\u540c", (String)"YhsEntityUpgradeBusisess_9", (String)"taxc-tctb-business", (Object[])new Object[0]));
        YHS_MAP.put(ResManager.loadKDString((String)"\u5efa\u7b51\u5b89\u88c5\u5de5\u7a0b\u627f\u5305\u5408\u540c", (String)"YhsEntityUpgradeBusisess_10", (String)"taxc-tctb-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5efa\u8bbe\u5de5\u7a0b\u5408\u540c", (String)"YhsEntityUpgradeBusisess_10", (String)"taxc-tctb-business", (Object[])new Object[0]));
        YHS_MAP.put(ResManager.loadKDString((String)"\u8d27\u7269\u8fd0\u8f93\u5408\u540c", (String)"YhsEntityUpgradeBusisess_11", (String)"taxc-tctb-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8fd0\u8f93\u5408\u540c", (String)"YhsEntityUpgradeBusisess_11", (String)"taxc-tctb-business", (Object[])new Object[0]));
        YHS_MAP.put(ResManager.loadKDString((String)"\u8d22\u4ea7\u79df\u8d41\u5408\u540c", (String)"YhsEntityUpgradeBusisess_12", (String)"taxc-tctb-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u79df\u8d41\u5408\u540c", (String)"YhsEntityUpgradeBusisess_12", (String)"taxc-tctb-business", (Object[])new Object[0]));
        YHS_MAP.put(ResManager.loadKDString((String)"\u8425\u4e1a\u8d26\u7c3f\uff08\u8bb0\u8f7d\u8d44\u91d1\u7684\u8d26\u7c3f\uff09", (String)"YhsEntityUpgradeBusisess_13", (String)"taxc-tctb-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8425\u4e1a\u8d26\u7c3f", (String)"YhsEntityUpgradeBusisess_13", (String)"taxc-tctb-business", (Object[])new Object[0]));
    }
}

