/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.business.orggroup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import org.apache.commons.collections.CollectionUtils;

public class TaxcOrgGroupService {
    public static DynamicObjectCollection filterByTaxtypeAndSummaryway(DynamicObjectCollection docs, String taxType, String summaryway, Date effectdate, Date invaliddate) {
        DynamicObjectCollection objs = new DynamicObjectCollection();
        if (CollectionUtils.isNotEmpty((Collection)docs)) {
            for (DynamicObject doc : docs) {
                if (!TaxcOrgGroupService.isCurrentTaxType(doc, taxType).booleanValue() || !TaxcOrgGroupService.isCurrentSummaryway(doc, summaryway).booleanValue() || !TaxcOrgGroupService.isBetweenValidDate(doc, effectdate, invaliddate).booleanValue()) continue;
                objs.add((Object)doc);
            }
        }
        return objs;
    }

    public static DynamicObjectCollection filterBySummaryway(DynamicObjectCollection docs, String summaryway, Date effectdate, Date invaliddate) {
        DynamicObjectCollection objs = new DynamicObjectCollection();
        if (CollectionUtils.isNotEmpty((Collection)docs)) {
            for (DynamicObject doc : docs) {
                if (!TaxcOrgGroupService.isCurrentSummaryway(doc, summaryway).booleanValue() || !TaxcOrgGroupService.isBetweenValidDate(doc, effectdate, invaliddate).booleanValue()) continue;
                objs.add((Object)doc);
            }
        }
        return objs;
    }

    public static DynamicObjectCollection filterByTaxtypeAndDeclaration(DynamicObjectCollection docs, String taxType, String declaration, Date effectdate, Date invaliddate) {
        DynamicObjectCollection objs = new DynamicObjectCollection();
        if (CollectionUtils.isNotEmpty((Collection)docs)) {
            for (DynamicObject doc : docs) {
                if (!TaxcOrgGroupService.isCurrentTaxType(doc, taxType).booleanValue() || !TaxcOrgGroupService.isCurrentDeclaration(doc, declaration).booleanValue() || !TaxcOrgGroupService.isBetweenValidDate(doc, effectdate, invaliddate).booleanValue()) continue;
                objs.add((Object)doc);
            }
        }
        return objs;
    }

    public static DynamicObjectCollection filterByTaxtypeAndDeclaration(DynamicObjectCollection docs, String taxType, String declaration) {
        DynamicObjectCollection objs = new DynamicObjectCollection();
        if (CollectionUtils.isNotEmpty((Collection)docs)) {
            for (DynamicObject doc : docs) {
                if (!TaxcOrgGroupService.isCurrentTaxType(doc, taxType).booleanValue() || !TaxcOrgGroupService.isCurrentDeclaration(doc, declaration).booleanValue()) continue;
                objs.add((Object)doc);
            }
        }
        return objs;
    }

    public static DynamicObjectCollection filterByDeclaration(DynamicObjectCollection docs, String declaration) {
        DynamicObjectCollection objs = new DynamicObjectCollection();
        if (CollectionUtils.isNotEmpty((Collection)docs)) {
            for (DynamicObject doc : docs) {
                if (!TaxcOrgGroupService.isCurrentDeclaration(doc, declaration).booleanValue()) continue;
                objs.add((Object)doc);
            }
        }
        return objs;
    }

    public static DynamicObjectCollection filterByTaxtype(DynamicObjectCollection docs, String taxType) {
        DynamicObjectCollection objs = new DynamicObjectCollection();
        for (DynamicObject doc : docs) {
            if (!TaxcOrgGroupService.isCurrentTaxType(doc, taxType).booleanValue()) continue;
            objs.add((Object)doc);
        }
        return objs;
    }

    public static DynamicObjectCollection filterByTaxtype(DynamicObjectCollection docs, String taxType, Date effectdate, Date invaliddate) {
        DynamicObjectCollection objs = new DynamicObjectCollection();
        for (DynamicObject doc : docs) {
            if (!TaxcOrgGroupService.isCurrentTaxType(doc, taxType).booleanValue() || !TaxcOrgGroupService.isBetweenValidDate(doc, effectdate, invaliddate).booleanValue()) continue;
            objs.add((Object)doc);
        }
        return objs;
    }

    public static DynamicObjectCollection filterByTaxtypeAndTime(DynamicObjectCollection docs, String taxType, Date effectdate, Date invaliddate) {
        DynamicObjectCollection objs = new DynamicObjectCollection();
        for (DynamicObject doc : docs) {
            if (!TaxcOrgGroupService.isCurrentTaxType(doc, taxType).booleanValue() || !TaxcOrgGroupService.isBetweenValidDateByDay(doc, effectdate, invaliddate).booleanValue()) continue;
            objs.add((Object)doc);
        }
        return objs;
    }

    public static DynamicObjectCollection filterByValidDate(DynamicObjectCollection docs, Date effectdate, Date invaliddate) {
        DynamicObjectCollection objs = new DynamicObjectCollection();
        if (CollectionUtils.isNotEmpty((Collection)docs)) {
            for (DynamicObject doc : docs) {
                if (!TaxcOrgGroupService.isBetweenValidDate(doc, effectdate, invaliddate).booleanValue()) continue;
                objs.add((Object)doc);
            }
        }
        return objs;
    }

    public static DynamicObject[] filterByValidDate(DynamicObject[] docs, Date date) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        if (docs != null && docs.length > 0) {
            for (DynamicObject doc : docs) {
                if (!TaxcOrgGroupService.isBetweenValidDate(doc, date).booleanValue()) continue;
                list.add(doc);
            }
        }
        return list.toArray(new DynamicObject[0]);
    }

    public static DynamicObjectCollection filterBySummaryorgtype(DynamicObjectCollection docs, String summaryorgtype, Date effectdate, Date invaliddate) {
        DynamicObjectCollection objs = new DynamicObjectCollection();
        if (CollectionUtils.isNotEmpty((Collection)docs)) {
            for (DynamicObject doc : docs) {
                if (!TaxcOrgGroupService.isCurrentSummaryorgtype(doc, summaryorgtype).booleanValue() || !TaxcOrgGroupService.isBetweenValidDate(doc, effectdate, invaliddate).booleanValue()) continue;
                objs.add((Object)doc);
            }
        }
        return objs;
    }

    private static Boolean isCurrentTaxType(DynamicObject doc, String taxtype) {
        return StringUtils.equals((CharSequence)taxtype, (CharSequence)doc.getString("taxtype"));
    }

    private static Boolean isCurrentDeclaration(DynamicObject doc, String declaration) {
        return StringUtils.equals((CharSequence)declaration, (CharSequence)doc.getString("orgrow.declaration"));
    }

    private static Boolean isCurrentSummaryway(DynamicObject doc, String summaryway) {
        return StringUtils.equals((CharSequence)summaryway, (CharSequence)doc.getString("summaryway"));
    }

    private static Boolean isCurrentSummaryorgtype(DynamicObject doc, String summaryorgtype) {
        return StringUtils.equals((CharSequence)summaryorgtype, (CharSequence)doc.getString("summaryorgtype"));
    }

    private static Boolean isBetweenValidDateByDay(DynamicObject doc, Date effectdate, Date invaliddate) {
        effectdate = DateUtils.getDayFirst((Date)effectdate);
        invaliddate = DateUtils.getDayFirst((Date)invaliddate);
        if (doc != null) {
            if (doc.getDate("invaliddate") != null) {
                return !effectdate.before(doc.getDate("effectdate")) && !invaliddate.after(doc.getDate("invaliddate"));
            }
            return !effectdate.before(doc.getDate("effectdate"));
        }
        return Boolean.FALSE;
    }

    private static Boolean isBetweenValidDate(DynamicObject doc, Date effectdate, Date invaliddate) {
        if (doc != null) {
            if (doc.getDate("invaliddate") != null) {
                return effectdate.after(doc.getDate("effectdate")) && invaliddate.before(doc.getDate("invaliddate"));
            }
            return effectdate.after(doc.getDate("effectdate"));
        }
        return Boolean.FALSE;
    }

    private static Boolean isBetweenValidDate(DynamicObject doc, Date date) {
        if (doc != null) {
            if (doc.getDate("invaliddate") != null) {
                return date.after(doc.getDate("effectdate")) && date.before(doc.getDate("invaliddate"));
            }
            return date.after(doc.getDate("effectdate"));
        }
        return Boolean.FALSE;
    }
}

