/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.business.orgmap;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bd.taxcategory.TaxCategoryDataServiceHelper;
import kd.taxc.tctb.business.orgmap.OrgMapRelationDao;
import kd.taxc.tctb.business.orgmap.OrgMapRelationService;

public class OrgMapRelationBusiness {
    public static DynamicObject[] queryOrgMapRelationByGroupId(Long groupId) {
        return OrgMapRelationDao.queryOrgMapRelationByGroupId(groupId, "id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,group,group.mapobject.id,group.mapobject.number,group.mapobject.name,useorg,entryentity,entryentity.seq,entryentity.businessnumber,entryentity.businessname,entryentity.businessid,entryentity.startdate,entryentity.enddate,entryentity.taxcategory");
    }

    public static DynamicObject[] queryOrgMapRelationByGroupIds(List<Long> groupIds) {
        return OrgMapRelationDao.queryOrgMapRelationByGroupIds(groupIds, "id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,group,group.mapobject.id,group.mapobject.number,group.mapobject.name,useorg,entryentity,entryentity.seq,entryentity.businessnumber,entryentity.businessname,entryentity.businessid,entryentity.startdate,entryentity.enddate,entryentity.taxcategory");
    }

    public static DynamicObject[] queryOrgMapRelations(Long groupId, List<Long> taxorgs, Date startDate, Date endDate) {
        DynamicObject[] objs = OrgMapRelationDao.queryOrgMapRelations(groupId, taxorgs, "id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,group,group.mapobject.id,group.mapobject.number,group.mapobject.name,useorg,entryentity,entryentity.seq,entryentity.businessnumber,entryentity.businessname,entryentity.businessid,entryentity.startdate,entryentity.enddate,entryentity.taxcategory");
        objs = OrgMapRelationService.filterBillStatusAndStatus(objs);
        return OrgMapRelationService.filterEffective(objs, startDate, endDate);
    }

    public static DynamicObjectCollection queryOrgMapRelations(Long orgId, Long categoryId, Date startDate, Date endDate) {
        DynamicObjectCollection objs = OrgMapRelationDao.queryOrgMapRelations(orgId, "id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,group,group.mapobject.id,group.mapobject.number,group.mapobject.name,useorg,entryentity,entryentity.seq,entryentity.businessnumber,entryentity.businessname,entryentity.businessid,entryentity.startdate,entryentity.enddate,entryentity.taxcategory");
        objs = OrgMapRelationService.filterBillStatusAndStatus(objs);
        objs = OrgMapRelationService.filtercategory(objs, categoryId);
        return OrgMapRelationService.filterEffective(objs, startDate, endDate);
    }

    public static DynamicObjectCollection queryOrgMapRelations(Long orgId, Long categoryId, Long groupId, Date startDate, Date endDate) {
        DynamicObjectCollection objs = OrgMapRelationDao.queryOrgMapRelations(orgId, groupId, "id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,group,group.mapobject.id,group.mapobject.number,group.mapobject.name,useorg,entryentity,entryentity.seq,entryentity.businessnumber,entryentity.businessname,entryentity.businessid,entryentity.startdate,entryentity.enddate,entryentity.taxcategory");
        objs = OrgMapRelationService.filterBillStatusAndStatus(objs);
        objs = OrgMapRelationService.filtercategory(objs, categoryId);
        return OrgMapRelationService.filterEffective(objs, startDate, endDate);
    }

    public static DynamicObject[] queryOrgMappingByOrgIds(List<Long> orgIds) {
        return OrgMapRelationDao.queryOrgMappingByOrgIds(orgIds, "id,number,name,mapobject");
    }

    public static DynamicObjectCollection queryBusinessObject(String entityName, String selectFields, QFilter[] filters) {
        return OrgMapRelationDao.queryBusinessObject(entityName, selectFields, filters);
    }

    public static Map<String, DynamicObject> getTaxCategoryMap(String key, boolean isIncludeDisable) {
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>();
        TaxResult result = TaxCategoryDataServiceHelper.queryTaxCategoryByIds(null, (boolean)isIncludeDisable);
        if (result != null && result.isSuccess()) {
            List taxTypes = (List)result.getData();
            if (taxTypes == null) {
                return map;
            }
            taxTypes.stream().forEach(v -> map.put(String.valueOf(v.get(key)), (DynamicObject)v));
        }
        return map;
    }
}

