/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.business.orgmap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.taxc.common.util.DateUtils;
import org.apache.commons.lang3.StringUtils;

public class OrgMapRelationService {
    public static DynamicObject[] filterEffective(DynamicObject[] docs, Date startDate, Date endDate) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(10);
        DynamicObjectCollection entryColl = null;
        for (DynamicObject doc : docs) {
            entryColl = new DynamicObjectCollection();
            for (DynamicObject entry : doc.getDynamicObjectCollection("entryentity")) {
                if (!OrgMapRelationService.isEffective(entry, startDate, endDate)) continue;
                entryColl.add((Object)entry);
            }
            if (entryColl.size() <= 0) continue;
            doc.set("entryentity", (Object)entryColl);
            list.add(doc);
        }
        return list.toArray(new DynamicObject[0]);
    }

    public static DynamicObjectCollection filterEffective(DynamicObjectCollection docs, Date startDate, Date endDate) {
        DynamicObjectCollection objs = new DynamicObjectCollection();
        for (DynamicObject doc : docs) {
            if (!OrgMapRelationService.isEffectiveForCollection(doc, startDate, endDate)) continue;
            objs.add((Object)doc);
        }
        return objs;
    }

    public static DynamicObjectCollection filtercategory(DynamicObjectCollection docs, Long categoryId) {
        DynamicObjectCollection objs = new DynamicObjectCollection();
        for (DynamicObject doc : docs) {
            String taxcategoryId = doc.getString("entryentity.taxcategory");
            if (StringUtils.isNotBlank((CharSequence)taxcategoryId)) {
                List<String> taxcategoryIds = Arrays.asList(taxcategoryId.split(","));
                if (!taxcategoryIds.contains(String.valueOf(categoryId))) continue;
                objs.add((Object)doc);
                continue;
            }
            objs.add((Object)doc);
        }
        return objs;
    }

    public static DynamicObject[] filterBillStatusAndStatus(DynamicObject[] docs) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(10);
        for (DynamicObject doc : docs) {
            if (!"C".equals(doc.getString("status")) || !doc.getBoolean("enable")) continue;
            list.add(doc);
        }
        return list.toArray(new DynamicObject[0]);
    }

    public static DynamicObjectCollection filterBillStatusAndStatus(DynamicObjectCollection docs) {
        DynamicObjectCollection list = new DynamicObjectCollection();
        for (DynamicObject doc : docs) {
            if (!"C".equals(doc.getString("status")) || !doc.getBoolean("enable")) continue;
            list.add((Object)doc);
        }
        return list;
    }

    public static boolean isEffective(DynamicObject entry, Date startDate, Date endDate) {
        Date endTime;
        Date beginTime = DateUtils.trunc((Date)entry.getDate("startdate"), (String)"yyyy-MM-dd");
        Date[] date = DateUtils.getIntersectionDate((Date)beginTime, (Date)(endTime = DateUtils.trunc((Date)entry.getDate("enddate"), (String)"yyyy-MM-dd")), (Date)startDate, (Date)endDate);
        return date != null && date.length > 0;
    }

    public static boolean isEffectiveForCollection(DynamicObject entry, Date startDate, Date endDate) {
        Date endTime;
        Date beginTime = DateUtils.trunc((Date)entry.getDate("entryentity.startdate"), (String)"yyyy-MM-dd");
        Date[] date = DateUtils.getIntersectionDate((Date)beginTime, (Date)(endTime = DateUtils.trunc((Date)entry.getDate("entryentity.enddate"), (String)"yyyy-MM-dd")), (Date)startDate, (Date)endDate);
        return date != null && date.length > 0;
    }

    public static boolean validateIsEffective(DynamicObject entry, Date startDate, Date endDate) {
        Date endTime;
        Date beginTime = DateUtils.trunc((Date)entry.getDate("entryentity.startdate"), (String)"yyyy-MM-dd");
        Date[] date = DateUtils.getIntersectionDate((Date)beginTime, (Date)(endTime = DateUtils.trunc((Date)entry.getDate("entryentity.enddate"), (String)"yyyy-MM-dd")), (Date)startDate, (Date)endDate);
        return date != null && date.length > 0;
    }
}

