/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.business.orgmap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.taxc.bdtaxr.business.changemodel.service.impl.BillLogService;
import kd.taxc.common.util.StringUtil;
import kd.taxc.tctb.business.orgmap.OrgMapRelationBusiness;
import org.apache.commons.lang3.ObjectUtils;

public class OrgMapXBillLogService
extends BillLogService {
    private Map<String, Object> cacheMap = new HashMap<String, Object>(100);

    public OrgMapXBillLogService() {
        this.init();
    }

    private void init() {
        Map<String, DynamicObject> taxcategoryMap = OrgMapRelationBusiness.getTaxCategoryMap("id", true);
        this.cacheMap.put("taxcategoryMap", taxcategoryMap);
    }

    public String displayFieldValue(DynamicObject obj, String field, Object value, DynamicProperty property) {
        String displayFieldValue = super.displayFieldValue(obj, field, value, property);
        if ("taxcategory".equals(field)) {
            Map taxcategoryMap = (Map)this.cacheMap.get("taxcategoryMap");
            if (ObjectUtils.isNotEmpty((Object)value) && taxcategoryMap != null) {
                String[] ids = value.toString().split(",");
                ArrayList numberList = new ArrayList(10);
                ArrayList nameList = new ArrayList(10);
                Arrays.stream(ids).filter(id -> !ObjectUtils.isEmpty(taxcategoryMap.get(id))).forEach(id -> {
                    numberList.add(((DynamicObject)taxcategoryMap.get(id)).getString("number"));
                    nameList.add(((DynamicObject)taxcategoryMap.get(id)).getString("name"));
                });
                displayFieldValue = StringUtil.join(nameList, (String)",");
            }
        }
        return displayFieldValue;
    }

    protected String displayFieldAlias(DynamicObject obj, String entryName, String field) {
        String displayFieldAlias = super.displayFieldAlias(obj, entryName, field);
        if ("taxcategory".equals(field)) {
            displayFieldAlias = ResManager.loadKDString((String)"\u9002\u7528\u7a0e\u79cd", (String)"OrgMapXBillLogService_0", (String)"taxc-tctb-business", (Object[])new Object[0]);
        }
        return displayFieldAlias;
    }
}

