/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.business.packaudit;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class PackAuditTaskDao {
    public static DynamicObject[] queryPackAuditTaskByOrgIds(List<Long> orgIds) {
        QFilter qfilter = null;
        qfilter = orgIds != null && orgIds.size() > 0 ? new QFilter("org.id", "in", orgIds) : QFilter.of((String)"1 = 1", (Object[])new Object[0]);
        return PackAuditTaskDao.loadPackAuditTaskByQfilter("id,org", qfilter, null);
    }

    public static void createPackAuditTask(List<Long> orgIds) {
        DynamicObject[] objects = PackAuditTaskDao.queryPackAuditTaskByOrgIds(orgIds);
        List existTaskOrgIds = Stream.of(objects).map(v -> v.getLong("org.id")).collect(Collectors.toList());
        List newOrgIds = orgIds.stream().distinct().filter(v -> !existTaskOrgIds.contains(v)).collect(Collectors.toList());
        DynamicObject[] saveObjects = new DynamicObject[newOrgIds.size()];
        DynamicObject dynamicObject = null;
        int size = newOrgIds.size();
        for (int i = 0; i < size; ++i) {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"tctb_packaudittask");
            dynamicObject.set("org", (Object)orgIds.get(i));
            saveObjects[i] = dynamicObject;
        }
        if (saveObjects.length > 0) {
            SaveServiceHelper.save((DynamicObject[])saveObjects);
        }
    }

    public static void deletePackAuditTask(List<Long> orgIds) {
        QFilter qfilter = new QFilter("org.id", "in", orgIds);
        DeleteServiceHelper.delete((String)"tctb_packaudittask", (QFilter[])new QFilter[]{qfilter});
    }

    private static DynamicObject[] loadPackAuditTaskByQfilter(String selectFields, QFilter qfilter, String orderBy) {
        return BusinessDataServiceHelper.load((String)"tctb_packaudittask", (String)selectFields, (QFilter[])new QFilter[]{qfilter}, (String)orderBy);
    }
}

