/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.business.provision;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.taxc.bdtaxr.business.tctb.provision.ProvisionSharePlanService;
import kd.taxc.bdtaxr.common.utils.DynamicObjectUtils;
import kd.taxc.common.util.DateUtils;
import kd.taxc.tctb.business.enums.provision.TaxPlanCfgEnum;
import kd.taxc.tctb.business.provision.ProvisionPlanDao;
import kd.taxc.tctb.business.shareplan.ProvisionSharePlanBusiness;
import kd.taxc.tctb.business.shareplan.ProvisionSharePlanDao;

public class ProvisionPlanBusiness {
    public static final String[] multiSelectKey = new String[]{"planuse", "provisiondimension", "booktype"};
    public static final String[] checkKey = new String[]{"taxsystem", "taxtype", "taxarea", "cycle", "isdimprovision", "businessdimension"};
    public static final String[] checkShareKey = new String[]{"taxsystem", "taxtype", "taxarea"};

    public static DynamicObject queryOneProvisionPlan(Long taxationsysId, Long categoryId, Long taxareaId) {
        DynamicObject[] dyns = ProvisionPlanDao.loadPlanByTaxInfo(taxationsysId, categoryId, taxareaId);
        DynamicObject[] jdDyns = ProvisionPlanBusiness.filterPlanuse(dyns, true, null);
        return jdDyns.length > 0 ? jdDyns[0] : null;
    }

    public static DynamicObject queryOneTaxPlan(Long taxationsysId, Long categoryId, Long taxareaId) {
        DynamicObject[] dyns = ProvisionPlanDao.loadPlanByTaxInfo(taxationsysId, categoryId, taxareaId);
        DynamicObject[] jdDyns = ProvisionPlanBusiness.filterPlanuse(dyns, null, true);
        return jdDyns.length > 0 ? jdDyns[0] : null;
    }

    public static DynamicObject[] queryProvisionPlan(Long taxationsysId, Long categoryId, Long taxareaId) {
        DynamicObject[] dyns = ProvisionPlanDao.loadPlanByTaxInfo(taxationsysId, categoryId, taxareaId);
        return ProvisionPlanBusiness.filterPlanuse(dyns, true, null);
    }

    public static DynamicObject[] queryTaxPlan(Long taxationsysId, Long categoryId, Long taxareaId) {
        DynamicObject[] dyns = ProvisionPlanDao.loadPlanByTaxInfo(taxationsysId, categoryId, taxareaId);
        return ProvisionPlanBusiness.filterPlanuse(dyns, null, true);
    }

    public static DynamicObject[] queryPlanByIds(List<Long> ids) {
        DynamicObject[] dyns = ProvisionPlanDao.queryPlanByIds(ids, "id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,taxsystem,taxtype,systemset,cycle,method,taxarea,booktype,isdimprovision,provisiondimension,businessdimension,startdate,enddate,planuse");
        return dyns;
    }

    public static DynamicObject[] queryProvisionPlanByIds(List<Long> ids) {
        DynamicObject[] dyns = ProvisionPlanDao.queryPlanByIds(ids, "id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,taxsystem,taxtype,systemset,cycle,method,taxarea,booktype,isdimprovision,provisiondimension,businessdimension,startdate,enddate,planuse");
        return ProvisionPlanBusiness.filterPlanuse(dyns, true, null);
    }

    public static DynamicObject[] queryTaxPlanByIds(List<Long> ids) {
        DynamicObject[] dyns = ProvisionPlanDao.queryPlanByIds(ids, "id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,taxsystem,taxtype,systemset,cycle,method,taxarea,booktype,isdimprovision,provisiondimension,businessdimension,startdate,enddate,planuse");
        return ProvisionPlanBusiness.filterPlanuse(dyns, null, true);
    }

    public static boolean hasDateDuplicate(DynamicObject o1, DynamicObject o2) {
        Date endDate;
        Date startDate;
        Date endTime;
        Date beginTime = o1.getDate("startdate");
        Date[] date = DateUtils.getIntersectionDate((Date)beginTime, (Date)(endTime = o1.getDate("enddate")), (Date)(startDate = o2.getDate("startdate")), (Date)(endDate = o2.getDate("enddate")));
        return date != null && date.length > 0;
    }

    public static DynamicObject[] queryProvisionPlanByDims(Set<Long> taxsystemIds, Set<Long> taxtypeIds, Set<Long> taxareaIds) {
        DynamicObject[] dyns = ProvisionPlanDao.queryPlanByDims(taxsystemIds, taxtypeIds, taxareaIds, "id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,taxsystem,taxtype,systemset,cycle,method,taxarea,booktype,isdimprovision,provisiondimension,businessdimension,startdate,enddate,planuse");
        return ProvisionPlanBusiness.filterPlanuse(dyns, true, null);
    }

    public static DynamicObject[] queryTaxPlanByDims(Set<Long> taxsystemIds, Set<Long> taxtypeIds, Set<Long> taxareaIds) {
        DynamicObject[] dyns = ProvisionPlanDao.queryPlanByDims(taxsystemIds, taxtypeIds, taxareaIds, "id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,taxsystem,taxtype,systemset,cycle,method,taxarea,booktype,isdimprovision,provisiondimension,businessdimension,startdate,enddate,planuse");
        return ProvisionPlanBusiness.filterPlanuse(dyns, null, true);
    }

    public static OperationResult specifiedSharing(List<Long> sharePlanIds, List<Long> planIds) {
        DynamicObject[] shardingPlans = ProvisionSharePlanBusiness.querySharePlanByIds(sharePlanIds);
        DynamicObject[] plans = ProvisionPlanBusiness.queryPlanByIds(planIds);
        Stream.of(shardingPlans).forEach(shardingPlan -> {
            DynamicObjectCollection ruleCollection = shardingPlan.getDynamicObjectCollection("ruleentity");
            Stream.of(plans).forEach(o -> {
                DynamicObject dynamicObject = ruleCollection.addNew();
                dynamicObject.set("seq", (Object)(ruleCollection.size() - 1));
                dynamicObject.set("rule", o);
            });
        });
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"tctb_jtfa_shareplan", (DynamicObject[])shardingPlans, (OperateOption)OperateOption.create());
        return operationResult;
    }

    public static Collection<String> getUsabaleTaxsys(String planuseCode) {
        List<TaxPlanCfgEnum> list = TaxPlanCfgEnum.getByPlanuse(planuseCode);
        HashSet<String> taxsysCodes = new HashSet<String>(8);
        list.forEach(item -> taxsysCodes.add(item.getTaxsysCode()));
        return taxsysCodes;
    }

    public static Collection<String> getUsabaleTaxtype(String planuseCode, String taxsysCode) {
        List<TaxPlanCfgEnum> list = TaxPlanCfgEnum.getByPlanuseAndTaxsys(planuseCode, taxsysCode);
        HashSet<String> taxsysTypes = new HashSet<String>(8);
        list.forEach(item -> taxsysTypes.add(item.getTaxtypeCode()));
        return taxsysTypes;
    }

    public static boolean matchDimensionShare(DynamicObject dyn1, DynamicObject dyn2) {
        if (!DynamicObjectUtils.coverMultiSelectFiled((DynamicObject)dyn1, (DynamicObject)dyn2, (String)"planuse")) {
            return false;
        }
        for (String k : checkShareKey) {
            if (DynamicObjectUtils.matchFiled((DynamicObject)dyn1, (DynamicObject)dyn2, (String)k)) continue;
            return false;
        }
        return ProvisionPlanBusiness.matchTimeCover(dyn1, dyn2);
    }

    public static boolean matchDimension(DynamicObject dyn1, DynamicObject dyn2) {
        for (String k : multiSelectKey) {
            if (DynamicObjectUtils.matchMultiSelectFiled((DynamicObject)dyn1, (DynamicObject)dyn2, (String)k)) continue;
            return false;
        }
        for (String k : checkKey) {
            if (DynamicObjectUtils.matchFiled((DynamicObject)dyn1, (DynamicObject)dyn2, (String)k)) continue;
            return false;
        }
        return ProvisionPlanBusiness.matchTimeCover(dyn1, dyn2);
    }

    private static boolean matchTimeCover(DynamicObject dyn1, DynamicObject dyn2) {
        Date s1 = dyn1.getDate("startdate");
        Date e1 = dyn1.getDate("enddate");
        s1 = DateUtils.getDayFirst((Date)s1);
        if (e1 != null) {
            e1 = DateUtils.getDayLast((Date)e1);
        }
        Date s2 = dyn2.getDate("startdate");
        Date e2 = dyn2.getDate("enddate");
        s2 = DateUtils.getDayFirst((Date)s2);
        if (e2 != null) {
            e2 = DateUtils.getDayLast((Date)e2);
        }
        return kd.taxc.bdtaxr.common.utils.date.DateUtils.getIntersectionDate((Date)s1, (Date)e1, (Date)s2, (Date)e2) != null;
    }

    public static boolean checkPlanUseMulti(DynamicObject dyn, Boolean jt, Boolean js) {
        return ProvisionSharePlanService.checkPlanUseMulti((DynamicObject)dyn, (Boolean)jt, (Boolean)js);
    }

    private static DynamicObject[] filterPlanuse(DynamicObject[] dyns, Boolean jt, Boolean js) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(dyns.length);
        for (DynamicObject dyn : dyns) {
            if (!ProvisionPlanBusiness.checkPlanUseMulti(dyn, jt, js)) continue;
            list.add(dyn);
        }
        return list.toArray(new DynamicObject[0]);
    }

    private static DynamicObject[] filterTaxCategory(DynamicObject[] dyns, List<Long> taxTypeIds) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(dyns.length);
        for (DynamicObject dyn : dyns) {
            Long taxType = dyn.getLong("taxtype");
            if (!taxTypeIds.contains(taxType)) continue;
            list.add(dyn);
        }
        return list.toArray(new DynamicObject[0]);
    }

    private static DynamicObject[] filterTaxDimension(DynamicObject[] dyns, Boolean orgDim, Boolean businessDim) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(dyns.length);
        boolean b1 = true;
        boolean b2 = true;
        for (DynamicObject dyn : dyns) {
            String dim = dyn.getString("provisiondimension");
            if (dim != null) {
                if (orgDim != null) {
                    boolean bl = orgDim != false ? dim.contains("accountorg") : (b1 = !dim.contains("accountorg"));
                }
                if (businessDim != null) {
                    boolean bl = businessDim != false ? dim.contains("businessdimension") : (b2 = !dim.contains("businessdimension"));
                }
            }
            if (!b1 || !b2) continue;
            list.add(dyn);
        }
        return list.toArray(new DynamicObject[0]);
    }

    public static List<DynamicObject> queryTaxPlanByOrgIdAndTaxcategorys(Long orgId, List<Long> taxCategoryIds) {
        ArrayList<Long> orgIds = new ArrayList<Long>(2);
        orgIds.add(orgId);
        DynamicObject[] shares = ProvisionSharePlanDao.querySharePlanByOrgIds(orgIds, "id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,ruleentity,orgentity,ruleentity.seq,ruleentity.rule,ruleentity.rule.taxsystem,ruleentity.rule.taxtype,ruleentity.rule.number,ruleentity.rule.cycle,ruleentity.rule.taxarea,ruleentity.rule.booktype,ruleentity.rule.isdimprovision,ruleentity.rule.enable,ruleentity.rule.provisiondimension,ruleentity.rule.businessdimension,ruleentity.rule.businessdimension.fbasedataid.id,ruleentity.rule.startdate,ruleentity.rule.enddate,ruleentity.rule.planuse,orgentity.seq,orgentity.org");
        Set<Long> planIds = ProvisionPlanBusiness.getPlanIdsFromShare(shares);
        DynamicObject[] plans = ProvisionPlanDao.queryPlanByIds(planIds, "id,billno,billstatus,creator,modifier,auditor,auditdate,modifytime,createtime,entryentity,taxorg,accountorg,taxsystem,taxtype,provistonitem,startdate,enddate,entrydate,coins,total,isvoucher,entitytype,entitynumber,voucherno,accountsettype,sourcedrafttype,extend,entryentity.seq,taxarea");
        DynamicObject[] jsPlans = ProvisionPlanBusiness.filterPlanuse(plans, null, true);
        jsPlans = ProvisionPlanBusiness.filterTaxCategory(jsPlans, taxCategoryIds);
        return Arrays.asList(jsPlans);
    }

    public static List<DynamicObject> queryTaxPlanByOrgIdAndTaxcategory(Long orgId, Long taxCategoryId) {
        ArrayList<Long> taxTypes = new ArrayList<Long>(2);
        taxTypes.add(taxCategoryId);
        return ProvisionPlanBusiness.queryTaxPlanByOrgIdAndTaxcategorys(orgId, taxTypes);
    }

    public static Boolean ifOrgHasOrgDimensionTaxPlan(Long orgId, Long taxCategoryId) {
        List<DynamicObject> plans = ProvisionPlanBusiness.queryTaxPlanByOrgIdAndTaxcategory(orgId, taxCategoryId);
        return ProvisionPlanBusiness.filterTaxDimension(plans.toArray(new DynamicObject[0]), true, null).length > 0;
    }

    public static List<DynamicObject> queryTaxPlanByOrgIdsAndTaxcategory(List<Long> orgIds, Long taxCategoryId) {
        DynamicObject[] shares = ProvisionSharePlanDao.querySharePlanByOrgIds(orgIds, "id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,ruleentity,orgentity,ruleentity.seq,ruleentity.rule,ruleentity.rule.taxsystem,ruleentity.rule.taxtype,ruleentity.rule.number,ruleentity.rule.cycle,ruleentity.rule.taxarea,ruleentity.rule.booktype,ruleentity.rule.isdimprovision,ruleentity.rule.enable,ruleentity.rule.provisiondimension,ruleentity.rule.businessdimension,ruleentity.rule.businessdimension.fbasedataid.id,ruleentity.rule.startdate,ruleentity.rule.enddate,ruleentity.rule.planuse,orgentity.seq,orgentity.org");
        Set<Long> planIds = ProvisionPlanBusiness.getPlanIdsFromShare(shares);
        DynamicObject[] plans = ProvisionPlanDao.queryPlanByIds(planIds, "id,billno,billstatus,creator,modifier,auditor,auditdate,modifytime,createtime,entryentity,taxorg,accountorg,taxsystem,taxtype,provistonitem,startdate,enddate,entrydate,coins,total,isvoucher,entitytype,entitynumber,voucherno,accountsettype,sourcedrafttype,extend,entryentity.seq,taxarea");
        DynamicObject[] jsPlans = ProvisionPlanBusiness.filterPlanuse(plans, null, true);
        ArrayList<Long> taxCategoryIds = new ArrayList<Long>(2);
        taxCategoryIds.add(taxCategoryId);
        jsPlans = ProvisionPlanBusiness.filterTaxCategory(jsPlans, taxCategoryIds);
        return Arrays.asList(jsPlans);
    }

    private static Set<Long> getPlanIdsFromShare(DynamicObject share) {
        return share.getDynamicObjectCollection("ruleentity").stream().map(dyn -> dyn.getDynamicObject("rule").getLong("id")).collect(Collectors.toSet());
    }

    private static Set<Long> getPlanIdsFromShare(DynamicObject[] shares) {
        HashSet<Long> s = new HashSet<Long>(8);
        for (DynamicObject share : shares) {
            s.addAll(ProvisionPlanBusiness.getPlanIdsFromShare(share));
        }
        return s;
    }

    public static boolean[] isdimprovisionCfg(TaxPlanCfgEnum cfgEnum) {
        if (cfgEnum == null) {
            return new boolean[]{false, false, false};
        }
        TaxPlanCfgEnum[] showEditClose = new TaxPlanCfgEnum[]{TaxPlanCfgEnum.JT_001_001, TaxPlanCfgEnum.JT_001_008, TaxPlanCfgEnum.JT_001_007, TaxPlanCfgEnum.JT_001_009, TaxPlanCfgEnum.JT_001_018};
        if (Arrays.asList(showEditClose).contains((Object)cfgEnum)) {
            return new boolean[]{true, true, false};
        }
        TaxPlanCfgEnum[] showNoEditOpen = new TaxPlanCfgEnum[]{TaxPlanCfgEnum.JS_001_001, TaxPlanCfgEnum.JS_001_007, TaxPlanCfgEnum.JS_001_009, TaxPlanCfgEnum.JS_001_011, TaxPlanCfgEnum.JTJS_001_001};
        if (Arrays.asList(showNoEditOpen).contains((Object)cfgEnum)) {
            return new boolean[]{true, false, true};
        }
        return new boolean[]{false, false, false};
    }

    public static boolean[] cycleCfg(TaxPlanCfgEnum cfgEnum) {
        if (cfgEnum == null) {
            return new boolean[]{false, false, false};
        }
        TaxPlanCfgEnum[] showEditClose = new TaxPlanCfgEnum[]{TaxPlanCfgEnum.JS_001_007, TaxPlanCfgEnum.JS_001_009, TaxPlanCfgEnum.JS_001_011};
        if (Arrays.asList(showEditClose).contains((Object)cfgEnum)) {
            return new boolean[]{false, false, false};
        }
        return new boolean[]{true, true, true};
    }
}

