/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.business.provision;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.taxc.bdtaxr.common.dto.ProvisionRuleAmountDto;
import kd.taxc.bdtaxr.common.dto.ProvisionRuleFetchDto;
import kd.taxc.bdtaxr.common.dto.ProvisionRuleQueryDto;
import kd.taxc.bdtaxr.common.dto.ProvisionRuleResultDto;
import kd.taxc.tctb.business.provision.ProvisionRuleDao;
import kd.taxc.tctb.business.provision.fetchdata.service.ProvisionRuleFetchService;
import kd.taxc.tctb.business.provision.fetchdata.service.ProvisionRuleServiceFactory;
import kd.taxc.tctb.business.shareplan.jtgz.ProvisionRuleSharePlanBusiness;

public class ProvisionRuleBusiness {
    private static final Log logger = LogFactory.getLog(ProvisionRuleBusiness.class);

    public static List<ProvisionRuleResultDto> getProvisionRules(List<ProvisionRuleQueryDto> queryDtos) {
        HashSet<Long> orgIds = new HashSet<Long>(10);
        HashSet<Long> taxtypes = new HashSet<Long>(10);
        HashSet<String> templateTypes = new HashSet<String>(10);
        HashSet<Long> taxationsysIds = new HashSet<Long>(10);
        for (ProvisionRuleQueryDto queryDto : queryDtos) {
            orgIds.add(queryDto.getOrgId());
            taxtypes.add(queryDto.getTaxtype());
            templateTypes.add(queryDto.getTemplateType());
            taxationsysIds.add(queryDto.getTaxationsysId());
        }
        DataSet sharePlanDataSet = ProvisionRuleSharePlanBusiness.queryProvisionRuleSharePlanByDims(orgIds, taxtypes, templateTypes, taxationsysIds);
        ArrayList<ProvisionRuleResultDto> result = new ArrayList<ProvisionRuleResultDto>(10);
        ProvisionRuleResultDto resultDto = null;
        for (ProvisionRuleQueryDto queryDto : queryDtos) {
            resultDto = new ProvisionRuleResultDto(queryDto);
            result.add(resultDto);
            DataSet dataSetCopy = sharePlanDataSet.copy();
            Throwable throwable = null;
            try {
                DataSet dataSet = dataSetCopy.filter(ProvisionRuleBusiness.getSharePlanFilter(queryDto).toString());
                Row row = null;
                while (dataSet.hasNext()) {
                    row = dataSet.next();
                    resultDto.getRuleIds().add(row.getLong("ruleentity.rule.id"));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dataSetCopy == null) continue;
                if (throwable != null) {
                    try {
                        dataSetCopy.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dataSetCopy.close();
            }
        }
        return result;
    }

    private static QFilter getSharePlanFilter(ProvisionRuleQueryDto queryDto) {
        QFilter qfilter = new QFilter("orgentity.org.id", "=", (Object)queryDto.getOrgId());
        qfilter.and(new QFilter("ruleentity.rule.provistonitem.taxtype.id", "=", (Object)queryDto.getTaxtype()));
        qfilter.and(new QFilter("ruleentity.rule.reporttype.fbasedataid.id", "=", (Object)queryDto.getTemplateType()));
        qfilter.and(new QFilter("ruleentity.rule.provistonitem.taxsystem.id", "=", (Object)queryDto.getTaxationsysId()));
        return qfilter;
    }

    public static List<ProvisionRuleAmountDto> getProvisionRuleAmount(List<ProvisionRuleFetchDto> fetchDtos) {
        ProvisionRuleFetchService service = ProvisionRuleServiceFactory.getFetchService();
        return service.doProcess(fetchDtos);
    }

    public static DynamicObject[] queryProvisionRuleByIds(List<Long> ids) {
        return ProvisionRuleDao.queryProvisionRuleByIds(ids, "id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,org,entryentity,ruletype,rulepurpose,issystem,provistonitem,datasource,generatecondition,remark,filterjson,filterjson_tag,taxtype,entryentity.seq,entryentity.bizname,entryentity.table,entryentity.absolute,entryentity.datatype,entryentity.datadirection,entryentity.filtercondition,entryentity.advancedconf,entryentity.conditionjson,entryentity.advancedconfjson,entryentity.vatrate,entryentity.basedatatype,entryentity.amountfield,entryentity.datasourcetext,entryentity.composite,entryentity.compositejson,entryentity.compositejson_tag,provistonitem.taxtype");
    }

    public static OperationResult specifiedSharing(List<Long> sharePlanIds, List<Long> ids) {
        DynamicObject[] shardingPlans = ProvisionRuleSharePlanBusiness.queryProvisionRuleSharePlanByIds(sharePlanIds);
        DynamicObject[] plans = ProvisionRuleBusiness.queryProvisionRuleByIds(ids);
        Stream.of(shardingPlans).forEach(shardingPlan -> {
            DynamicObjectCollection ruleCollection = shardingPlan.getDynamicObjectCollection("ruleentity");
            Stream.of(plans).forEach(o -> {
                DynamicObject dynamicObject = ruleCollection.addNew();
                dynamicObject.set("seq", (Object)(ruleCollection.size() - 1));
                dynamicObject.set("rule", o);
            });
        });
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"tctb_jtgz_shareplan", (DynamicObject[])shardingPlans, (OperateOption)OperateOption.create());
        return operationResult;
    }

    public static String getDimKey(DynamicObject rule) {
        return rule.getString("provistonitem.id");
    }
}

