/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.business.provision.fetchdata.service.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.taxc.bdtaxr.business.customsource.CustomSourceFactory;
import kd.taxc.bdtaxr.business.rule.impl.AbstractAccessConfigIdentify;
import kd.taxc.bdtaxr.common.dto.ProvisionRuleFetchDto;
import kd.taxc.bdtaxr.common.enums.DataType;
import kd.taxc.bdtaxr.common.rule.dto.RuleAccessDetailDto;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.utils.DynamicObjectUtils;
import kd.taxc.tctb.business.provision.fetchdata.model.ProvisionRuleDetailModel;
import kd.taxc.tctb.business.provision.fetchdata.model.ProvisionRuleSubDetailModel;
import kd.taxc.tctb.business.provision.fetchdata.service.ProvisionRuleCalculateService;
import org.apache.commons.lang3.ObjectUtils;

public class ProvisionRuleCalculateServiceImpl
extends AbstractAccessConfigIdentify
implements ProvisionRuleCalculateService {
    public ProvisionRuleCalculateServiceImpl() {
        this.accessConfigEntityName = "tctb_jtgz_rules";
    }

    @Override
    public BigDecimal calculate(ProvisionRuleFetchDto fetchDto, DynamicObject rule) {
        List<ProvisionRuleDetailModel> detailDtos = this.buildProvisionRuleDetailDtos(fetchDto, rule);
        BigDecimal total = BigDecimal.ZERO;
        for (ProvisionRuleDetailModel detailDto : detailDtos) {
            if (detailDto.getComposite()) {
                for (ProvisionRuleSubDetailModel subDetailDto : detailDto.getSubDetailDtos()) {
                    this.calculateDataSourceAmount(fetchDto, rule, subDetailDto.getAccessDetailDto());
                }
            } else {
                this.calculateDataSourceAmount(fetchDto, rule, detailDto.getAccessDetailDto());
            }
            total = total.add(detailDto.getFetchAmount());
        }
        return total;
    }

    protected List<ProvisionRuleDetailModel> buildProvisionRuleDetailDtos(ProvisionRuleFetchDto fetchDto, DynamicObject accessConfig) {
        DynamicObjectCollection collection = accessConfig.getDynamicObjectCollection(this.entryentity);
        IDataEntityProperty vatRateProperty = MetadataServiceHelper.getDataEntityType((String)this.accessConfigEntityName).findProperty(this.vatrate);
        IDataEntityProperty baseDataTypeProperty = MetadataServiceHelper.getDataEntityType((String)this.accessConfigEntityName).findProperty("basedatatype");
        boolean isContainBasedatatype = false;
        if (null != baseDataTypeProperty) {
            isContainBasedatatype = true;
        }
        ArrayList<ProvisionRuleDetailModel> detailDtos = new ArrayList<ProvisionRuleDetailModel>(10);
        ProvisionRuleDetailModel detailDto = null;
        RuleAccessDetailDto ruleAccessDetailDto = null;
        boolean composite = false;
        for (DynamicObject row : collection) {
            composite = row.getBoolean("composite");
            detailDto = new ProvisionRuleDetailModel();
            detailDto.setComposite(composite);
            if (composite) {
                Object entryData = row.get("compositejson_tag");
                if (EmptyCheckUtils.isNotEmpty((Object)entryData)) {
                    DynamicObject object = DynamicObjectUtils.deSerializerFromString((String)((String)entryData), (String)"tctb_jtgz_datasource_form");
                    String expression = object.getString("expression");
                    detailDto.setExpression(expression);
                    DynamicObjectCollection entries = object.getDynamicObjectCollection(this.entryentity);
                    ProvisionRuleSubDetailModel subDetailDto = null;
                    for (DynamicObject entry : entries) {
                        ruleAccessDetailDto = this.buildRuleAccessDetailDto(entry, fetchDto, accessConfig, isContainBasedatatype, vatRateProperty);
                        subDetailDto = new ProvisionRuleSubDetailModel(entry.getLong("id"), ruleAccessDetailDto);
                        detailDto.getSubDetailDtos().add(subDetailDto);
                    }
                }
            } else {
                ruleAccessDetailDto = this.buildRuleAccessDetailDto(row, fetchDto, accessConfig, isContainBasedatatype, vatRateProperty);
                detailDto.setAccessDetailDto(ruleAccessDetailDto);
            }
            detailDtos.add(detailDto);
        }
        return detailDtos;
    }

    private RuleAccessDetailDto buildRuleAccessDetailDto(DynamicObject row, ProvisionRuleFetchDto fetchDto, DynamicObject accessConfig, boolean isContainBasedatatype, IDataEntityProperty vatRateProperty) {
        String bizName = row.getString(this.bizname);
        String amountFieldEntity = "";
        String amountFieldNum = "";
        String baseDataType = "tctb_datasource_entry";
        if (isContainBasedatatype) {
            if (StringUtil.equalsIgnoreCase((CharSequence)row.getString("basedatatype"), (CharSequence)"tctb_datasource_entry")) {
                DynamicObject amountObject = BusinessDataServiceHelper.loadSingleFromCache((Object)row.getDynamicObject(this.amountfield).get("id"), (String)"tctb_datasource_entry", (String)"fieldsubname,fieldname");
                amountFieldEntity = amountObject.getString("fieldsubname");
                amountFieldNum = amountObject.getString("fieldname");
            } else {
                amountFieldEntity = row.getString("basedatatype");
                amountFieldNum = row.getDynamicObject(this.amountfield).getString("id");
                baseDataType = row.getString("basedatatype");
            }
        } else {
            amountFieldEntity = row.getDynamicObject(this.amountfield).getString("fieldsubname");
            amountFieldNum = row.getDynamicObject(this.amountfield).getString("fieldname");
        }
        Long amountFieldId = row.getDynamicObject(this.amountfield).getLong("id");
        String dataDirection = row.getString(this.datadirection);
        String absoluteB = row.getString(this.absolute);
        String filterCondition = row.getString(this.filtercondition);
        String dataType = row.getString(this.datatype);
        Long dataSourceId = row.getDynamicObject(this.ftable).getLong("id");
        String advancedConf = row.getString(this.advancedconf);
        String conditionJsonS = row.getString(this.conditionjson);
        String advancedConfJson = row.getString(this.advancedconfjson);
        BigDecimal vatRate = null != vatRateProperty ? row.getBigDecimal(this.vatrate) : null;
        RuleAccessDetailDto detailDto = new RuleAccessDetailDto(accessConfig, fetchDto.getOrgId(), fetchDto.getStartDate(), fetchDto.getEndDate(), bizName, dataSourceId, amountFieldId, dataDirection, absoluteB, filterCondition, dataType, advancedConf, conditionJsonS, advancedConfJson, amountFieldEntity, amountFieldNum, vatRate, baseDataType);
        return detailDto;
    }

    private RuleAccessDetailDto calculateDataSourceAmount(ProvisionRuleFetchDto fetchDto, DynamicObject rule, RuleAccessDetailDto detailRowDto) {
        Long taxType = rule.getLong("provistonitem.taxtype.id");
        Long dataSourceId = detailRowDto.getDataSource();
        BigDecimal originAmount = CustomSourceFactory.getInstance().queryBizDataRetSum(detailRowDto.getOrgId(), detailRowDto.getSkssqq(), detailRowDto.getSkssqz(), dataSourceId, detailRowDto.getAmountFieldNum(), detailRowDto.getAmountFieldEntity(), detailRowDto.getConditionJson(), detailRowDto.getAdvancedConfJson(), taxType);
        if (ObjectUtils.isEmpty((Object)originAmount)) {
            return null;
        }
        BigDecimal fetchAmount = this.convertFetchAmount(originAmount, detailRowDto);
        detailRowDto.setOriginAmount(originAmount);
        detailRowDto.setFetchAmount(fetchAmount);
        return detailRowDto;
    }

    protected BigDecimal convertFetchAmount(BigDecimal originAmount, RuleAccessDetailDto detailRowDto) {
        BigDecimal resultAmount = BigDecimal.ZERO;
        String absolute = detailRowDto.getAbsolute();
        BigDecimal numAfterPositive = StringUtil.equalsIgnoreCase((CharSequence)absolute, (CharSequence)"true") ? originAmount.abs() : originAmount;
        String dataDirection = detailRowDto.getFetchDirection();
        BigDecimal reverse = new BigDecimal(-1);
        resultAmount = StringUtil.equalsIgnoreCase((CharSequence)"positive", (CharSequence)dataDirection) ? numAfterPositive : numAfterPositive.multiply(reverse);
        String datatypeS = detailRowDto.getFetchType();
        BigDecimal vatRate = detailRowDto.getVatRate();
        if (StringUtil.isNotEmpty((CharSequence)datatypeS) && null != vatRate) {
            if (DataType.JSFLQS.getCode().equals(datatypeS)) {
                resultAmount = resultAmount.divide(BigDecimal.ONE.add(vatRate), 2, RoundingMode.HALF_UP);
            } else if (DataType.CYSLDSQS.getCode().equals(datatypeS)) {
                if (vatRate.compareTo(BigDecimal.ZERO) != 0) {
                    resultAmount = resultAmount.divide(vatRate, 2, RoundingMode.HALF_UP);
                }
            } else if (DataType.SEHSHSJ.getCode().equals(datatypeS)) {
                if (vatRate.compareTo(BigDecimal.ZERO) != 0) {
                    resultAmount = resultAmount.divide(vatRate, 2, RoundingMode.HALF_UP).multiply(BigDecimal.ONE.add(vatRate));
                }
            } else if (DataType.HSJHSSE.getCode().equals(datatypeS)) {
                if (vatRate.compareTo(BigDecimal.ZERO) != 0) {
                    BigDecimal numerator = resultAmount.multiply(vatRate);
                    BigDecimal denominator = vatRate.add(new BigDecimal(1));
                    resultAmount = numerator.divide(denominator, 2, RoundingMode.HALF_UP);
                }
            } else if (DataType.BHSJHSSE.getCode().equals(datatypeS) && vatRate.compareTo(BigDecimal.ZERO) != 0) {
                resultAmount = resultAmount.multiply(vatRate).setScale(2, RoundingMode.HALF_UP);
            }
        }
        return resultAmount;
    }
}

