/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.business.provision.fetchdata.task;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.dto.ProvisionRuleAmountDto;
import kd.taxc.bdtaxr.common.dto.ProvisionRuleFetchDto;
import kd.taxc.common.threadpools.Task;
import kd.taxc.tctb.business.provision.ProvisionRuleBusiness;
import kd.taxc.tctb.business.provision.fetchdata.service.ProvisionRuleServiceFactory;
import org.apache.commons.lang3.ObjectUtils;

public class ProvisionRuleFetchTask
extends Task {
    private static Log logger = LogFactory.getLog(ProvisionRuleFetchTask.class);
    private int batchSize = 8;
    private List<ProvisionRuleFetchDto> paramDtos;

    public ProvisionRuleFetchTask(List<ProvisionRuleFetchDto> paramDtos) {
        this.paramDtos = paramDtos;
    }

    public List<List<ProvisionRuleFetchDto>> getValue() {
        return Lists.partition(this.paramDtos, (int)this.batchSize);
    }

    public Object executor(Object resolveObj) {
        ArrayList<ProvisionRuleAmountDto> calculateResult = new ArrayList<ProvisionRuleAmountDto>(10);
        if (resolveObj instanceof List) {
            List fetchList = (List)resolveObj;
            Long startDate = System.currentTimeMillis();
            logger.info("{}\u6267\u884c\u8ba1\u63d0\u89c4\u5219\u53d6\u6570\u7684\u6761\u6570:{}", (Object)((Object)((Object)this)).getClass().getName(), (Object)fetchList.size());
            logger.info("{}\u6267\u884c\u8ba1\u63d0\u89c4\u5219\u53d6\u6570\u7684\u5f00\u59cb\u65f6\u95f4:{}", (Object)((Object)((Object)this)).getClass().getName(), (Object)System.currentTimeMillis());
            List<Long> ruleIds = fetchList.stream().filter(v -> ObjectUtils.isNotEmpty((Object)v.getRuleId())).map(ProvisionRuleFetchDto::getRuleId).collect(Collectors.toList());
            DynamicObject[] ruleColl = ProvisionRuleBusiness.queryProvisionRuleByIds(ruleIds);
            Map<Long, DynamicObject> ruleMap = Stream.of(ruleColl).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
            DynamicObject rule = null;
            ProvisionRuleAmountDto amountDto = null;
            for (ProvisionRuleFetchDto fetchDto : fetchList) {
                amountDto = new ProvisionRuleAmountDto(fetchDto);
                calculateResult.add(amountDto);
                rule = ruleMap.get(fetchDto.getRuleId());
                if (rule == null) continue;
                BigDecimal result = ProvisionRuleServiceFactory.getCalculateService().calculate(fetchDto, rule);
                amountDto.setFetchAmount(result);
            }
            logger.info("{}\u6267\u884c\u8ba1\u63d0\u89c4\u5219\u53d6\u6570\u7684\u7ed3\u675f\u65f6\u95f4:{}", (Object)((Object)((Object)this)).getClass().getName(), (Object)System.currentTimeMillis());
            logger.info("{}\u6267\u884c\u8ba1\u63d0\u89c4\u5219\u53d6\u6570\u7684\u603b\u8017\u65f6:{}ms,\u603b\u6761\u6570{}", new Object[]{((Object)((Object)this)).getClass().getName(), System.currentTimeMillis() - startDate, fetchList.size()});
        }
        return calculateResult;
    }
}

