/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.business.shareplan;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;

public class JtjsShareDynamiciWrapper {
    private DynamicObject shareDyn;
    private List<DynamicObject> planDyns;
    private List<DynamicObject> orgDyns;

    public DynamicObject getShareDyn() {
        return this.shareDyn;
    }

    public List<DynamicObject> getPlanDyns() {
        return this.planDyns;
    }

    public List<DynamicObject> getOrgDyns() {
        return this.orgDyns;
    }

    public JtjsShareDynamiciWrapper(DynamicObject shareDyn) {
        this.shareDyn = shareDyn;
        List<List<DynamicObject>> entrys = this.getShareEntry(shareDyn);
        this.planDyns = entrys.get(1);
        this.orgDyns = entrys.get(0);
    }

    public String getNumber() {
        return this.shareDyn.getString("number");
    }

    public List<Long> getPlanIds() {
        return this.planDyns.stream().map(dyn -> this.getLongId((DynamicObject)dyn)).collect(Collectors.toList());
    }

    public List<Long> getOrgIds() {
        return this.orgDyns.stream().map(dyn -> this.getLongId((DynamicObject)dyn)).collect(Collectors.toList());
    }

    public boolean existMultiPlan(Long planId) {
        int n = 0;
        for (DynamicObject dyn : this.planDyns) {
            Long id = this.getLongId(dyn);
            if (id.compareTo(planId) != 0) continue;
            ++n;
        }
        return n > 1;
    }

    public boolean existMultiOrg(Long orgId) {
        int n = 0;
        for (DynamicObject dyn : this.orgDyns) {
            Long id = this.getLongId(dyn);
            if (id.compareTo(orgId) != 0) continue;
            ++n;
        }
        return n > 1;
    }

    public DynamicObject getOrg(Long orgId) {
        for (DynamicObject dyn : this.orgDyns) {
            Long id = this.getLongId(dyn);
            if (id.compareTo(orgId) != 0) continue;
            return dyn;
        }
        return null;
    }

    public DynamicObject getPlan(Long planId) {
        for (DynamicObject dyn : this.planDyns) {
            Long id = this.getLongId(dyn);
            if (id.compareTo(planId) != 0) continue;
            return dyn;
        }
        return null;
    }

    public boolean existOrg(Long orgId) {
        return this.getOrg(orgId) != null;
    }

    public boolean existPlan(Long planId) {
        return this.getPlan(planId) != null;
    }

    private List<List<DynamicObject>> getShareEntry(DynamicObject share) {
        ArrayList<List<DynamicObject>> list = new ArrayList<List<DynamicObject>>(4);
        DynamicObjectCollection orgEntrys = share.getDynamicObjectCollection("orgentity");
        List orgDyns = orgEntrys.stream().map(item -> item.getDynamicObject("org")).collect(Collectors.toList());
        DynamicObjectCollection planEntitys = share.getDynamicObjectCollection("ruleentity");
        List planDyns = planEntitys.stream().map(item -> item.getDynamicObject("rule")).collect(Collectors.toList());
        list.add(orgDyns);
        list.add(planDyns);
        return list;
    }

    private Long getLongId(DynamicObject dyn) {
        return dyn.getLong("id");
    }

    public boolean isSameId(JtjsShareDynamiciWrapper other) {
        Long thisShareId = this.getLongId(this.shareDyn);
        Long otherShareId = this.getLongId(other.getShareDyn());
        if (thisShareId == null || otherShareId == null) {
            return false;
        }
        if (thisShareId == 0L || otherShareId == 0L) {
            return false;
        }
        return thisShareId.compareTo(otherShareId) == 0;
    }

    public boolean isSameObj(JtjsShareDynamiciWrapper other) {
        return this.shareDyn == other.getShareDyn();
    }
}

