/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.business.shareplan;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.taxc.bdtaxr.business.tctb.provision.ProvisionSharePlanService;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bastax.taxcorg.TaxcOrgDataServiceHelper;
import kd.taxc.tctb.business.shareplan.ProvisionSharePlanDao;

public class ProvisionSharePlanBusiness {
    public static DynamicObject[] querySharePlanByIds(List<Long> ids) {
        return ProvisionSharePlanDao.querySharePlanByIds(ids, "id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,ruleentity,orgentity,ruleentity.seq,ruleentity.rule,ruleentity.rule.taxsystem,ruleentity.rule.taxtype,ruleentity.rule.number,ruleentity.rule.cycle,ruleentity.rule.taxarea,ruleentity.rule.booktype,ruleentity.rule.isdimprovision,ruleentity.rule.enable,ruleentity.rule.provisiondimension,ruleentity.rule.businessdimension,ruleentity.rule.businessdimension.fbasedataid.id,ruleentity.rule.startdate,ruleentity.rule.enddate,ruleentity.rule.planuse,orgentity.seq,orgentity.org");
    }

    public static DynamicObject[] queryProvisionSharePlanByIds(List<Long> ids) {
        DynamicObject[] dyns = ProvisionSharePlanDao.querySharePlanByIds(ids, "id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,ruleentity,orgentity,ruleentity.seq,ruleentity.rule,ruleentity.rule.taxsystem,ruleentity.rule.taxtype,ruleentity.rule.number,ruleentity.rule.cycle,ruleentity.rule.taxarea,ruleentity.rule.booktype,ruleentity.rule.isdimprovision,ruleentity.rule.enable,ruleentity.rule.provisiondimension,ruleentity.rule.businessdimension,ruleentity.rule.businessdimension.fbasedataid.id,ruleentity.rule.startdate,ruleentity.rule.enddate,ruleentity.rule.planuse,orgentity.seq,orgentity.org");
        return ProvisionSharePlanBusiness.filter(dyns, (Boolean)true, null);
    }

    public static DynamicObject querySharePlanById(Long id) {
        return ProvisionSharePlanDao.querySharePlanById(id, "id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,ruleentity,orgentity,ruleentity.seq,ruleentity.rule,ruleentity.rule.taxsystem,ruleentity.rule.taxtype,ruleentity.rule.number,ruleentity.rule.cycle,ruleentity.rule.taxarea,ruleentity.rule.booktype,ruleentity.rule.isdimprovision,ruleentity.rule.enable,ruleentity.rule.provisiondimension,ruleentity.rule.businessdimension,ruleentity.rule.businessdimension.fbasedataid.id,ruleentity.rule.startdate,ruleentity.rule.enddate,ruleentity.rule.planuse,orgentity.seq,orgentity.org");
    }

    public static DynamicObject queryProvisionSharePlanById(Long id) {
        DynamicObject dyn = ProvisionSharePlanDao.querySharePlanById(id, "id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,ruleentity,orgentity,ruleentity.seq,ruleentity.rule,ruleentity.rule.taxsystem,ruleentity.rule.taxtype,ruleentity.rule.number,ruleentity.rule.cycle,ruleentity.rule.taxarea,ruleentity.rule.booktype,ruleentity.rule.isdimprovision,ruleentity.rule.enable,ruleentity.rule.provisiondimension,ruleentity.rule.businessdimension,ruleentity.rule.businessdimension.fbasedataid.id,ruleentity.rule.startdate,ruleentity.rule.enddate,ruleentity.rule.planuse,orgentity.seq,orgentity.org");
        return ProvisionSharePlanBusiness.filter(dyn, (Boolean)true, null);
    }

    public static DynamicObject[] queryProvisionSharePlanByRuleIds(List<Long> ruleIds) {
        DynamicObject[] dyns = ProvisionSharePlanDao.querySharePlanByRuleIds(ruleIds, "id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,ruleentity,orgentity,ruleentity.seq,ruleentity.rule,ruleentity.rule.taxsystem,ruleentity.rule.taxtype,ruleentity.rule.number,ruleentity.rule.cycle,ruleentity.rule.taxarea,ruleentity.rule.booktype,ruleentity.rule.isdimprovision,ruleentity.rule.enable,ruleentity.rule.provisiondimension,ruleentity.rule.businessdimension,ruleentity.rule.businessdimension.fbasedataid.id,ruleentity.rule.startdate,ruleentity.rule.enddate,ruleentity.rule.planuse,orgentity.seq,orgentity.org");
        return ProvisionSharePlanBusiness.filter(dyns, (Boolean)true, null);
    }

    public static DynamicObject[] queryProvisionSharePlanByOrgIds(List<Long> orgIds) {
        DynamicObject[] dyns = ProvisionSharePlanBusiness.querySharePlanByOrgIds(orgIds);
        return ProvisionSharePlanBusiness.filter(dyns, (Boolean)true, null);
    }

    public static DynamicObject[] querySharePlanByOrgIds(List<Long> orgIds) {
        return ProvisionSharePlanDao.querySharePlanByOrgIds(orgIds, "id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,ruleentity,orgentity,ruleentity.seq,ruleentity.rule,ruleentity.rule.taxsystem,ruleentity.rule.taxtype,ruleentity.rule.number,ruleentity.rule.cycle,ruleentity.rule.taxarea,ruleentity.rule.booktype,ruleentity.rule.isdimprovision,ruleentity.rule.enable,ruleentity.rule.provisiondimension,ruleentity.rule.businessdimension,ruleentity.rule.businessdimension.fbasedataid.id,ruleentity.rule.startdate,ruleentity.rule.enddate,ruleentity.rule.planuse,orgentity.seq,orgentity.org");
    }

    public static DynamicObjectCollection queryProvisionSharePlanByOrgIdsAndCategoryId(List<Long> orgIds, Long categoryId, Long taxationsysId) {
        DynamicObjectCollection dyns = ProvisionSharePlanBusiness.querySharePlanByOrgIdsAndCategoryId(orgIds, categoryId, taxationsysId);
        ProvisionSharePlanBusiness.filterCollection((Collection<DynamicObject>)dyns, true, null);
        return dyns;
    }

    public static DynamicObjectCollection querySharePlanByOrgIdsAndCategoryId(List<Long> orgIds, Long categoryId, Long taxationsysId) {
        DynamicObjectCollection dyns = ProvisionSharePlanDao.querySharePlanByOrgIdsAndCategoryId(orgIds, categoryId, taxationsysId, "id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,ruleentity,orgentity,ruleentity.seq,ruleentity.rule,ruleentity.rule.taxsystem,ruleentity.rule.taxtype,ruleentity.rule.number,ruleentity.rule.cycle,ruleentity.rule.taxarea,ruleentity.rule.booktype,ruleentity.rule.isdimprovision,ruleentity.rule.enable,ruleentity.rule.provisiondimension,ruleentity.rule.businessdimension,ruleentity.rule.businessdimension.fbasedataid.id,ruleentity.rule.startdate,ruleentity.rule.enddate,ruleentity.rule.planuse,orgentity.seq,orgentity.org");
        ProvisionSharePlanService.filterEnableCollectionByQuery((DynamicObjectCollection)dyns, (Boolean)true);
        return dyns;
    }

    public static DynamicObject[] loadProvisionSharePlanByOrgIdsAndCategoryId(List<Long> orgIds, Long categoryId, Long taxationsysId) {
        DynamicObject[] dyns = ProvisionSharePlanBusiness.loadSharePlanByOrgIdsAndCategoryId(orgIds, categoryId, taxationsysId);
        return ProvisionSharePlanBusiness.filter(dyns, (Boolean)true, null);
    }

    public static DynamicObject[] loadTaxSharePlanByOrgIdsAndCategoryId(List<Long> orgIds, Long categoryId, Long taxationsysId) {
        DynamicObject[] dyns = ProvisionSharePlanBusiness.loadSharePlanByOrgIdsAndCategoryId(orgIds, categoryId, taxationsysId);
        return ProvisionSharePlanBusiness.filter(dyns, null, (Boolean)true);
    }

    public static DynamicObject[] loadSharePlanByOrgIdsAndCategoryId(List<Long> orgIds, Long categoryId, Long taxationsysId) {
        DynamicObject[] dyns = ProvisionSharePlanDao.loadSharePlanByOrgIdsAndCategoryId(orgIds, categoryId, taxationsysId, "id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,ruleentity,orgentity,ruleentity.seq,ruleentity.rule,ruleentity.rule.taxsystem,ruleentity.rule.taxtype,ruleentity.rule.number,ruleentity.rule.cycle,ruleentity.rule.taxarea,ruleentity.rule.booktype,ruleentity.rule.isdimprovision,ruleentity.rule.enable,ruleentity.rule.provisiondimension,ruleentity.rule.businessdimension,ruleentity.rule.businessdimension.fbasedataid.id,ruleentity.rule.startdate,ruleentity.rule.enddate,ruleentity.rule.planuse,orgentity.seq,orgentity.org");
        ProvisionSharePlanService.filterEnableCollectionByLoad(Arrays.asList(dyns), (Boolean)true);
        return dyns;
    }

    public static List<DynamicObject> queryTaxcOrgByOrgIdAndIsTaxpayer(List<Long> orgIds) {
        TaxResult result = TaxcOrgDataServiceHelper.queryTaxcOrgByOrgIdsAndIsTaxpayer(orgIds, null);
        if (result != null && result.isSuccess()) {
            return (List)result.getData();
        }
        return Collections.emptyList();
    }

    private static DynamicObject filter(DynamicObject shareDyn, Boolean jt, Boolean js) {
        return ProvisionSharePlanService.filterPlanUse((DynamicObject)shareDyn, (Boolean)jt, (Boolean)js);
    }

    private static DynamicObject[] filter(DynamicObject[] shareDyns, Boolean jt, Boolean js) {
        return ProvisionSharePlanService.filterPlanUse((DynamicObject[])shareDyns, (Boolean)jt, (Boolean)js);
    }

    private static void filterCollection(Collection<DynamicObject> shareDyns, Boolean jt, Boolean js) {
        ProvisionSharePlanService.filterPlanUseCollection(shareDyns, (Boolean)jt, (Boolean)js);
    }

    public static DynamicObjectCollection queryProvisionSharePlanByOrgIdsAndCategoryIdAndDataRange(List<Long> orgIds, Long categoryId, Long taxationsysId, Date startDate, Date endDate) {
        DynamicObject[] colls = ProvisionSharePlanBusiness.loadProvisionSharePlanByOrgIdsAndCategoryId(orgIds, categoryId, taxationsysId);
        List objs = Stream.of(colls).collect(Collectors.toList());
        return ProvisionSharePlanService.filter(objs, orgIds, (Long)categoryId, (Long)taxationsysId, (Date)startDate, (Date)endDate);
    }

    public static DynamicObjectCollection querySharePlanByOrgIdsAndCategoryIdAndDataRange(List<Long> orgIds, Long categoryId, Long taxationsysId, Date startDate, Date endDate) {
        DynamicObject[] colls = ProvisionSharePlanBusiness.loadSharePlanByOrgIdsAndCategoryId(orgIds, categoryId, taxationsysId);
        List objs = Stream.of(colls).collect(Collectors.toList());
        return ProvisionSharePlanService.filter(objs, orgIds, (Long)categoryId, (Long)taxationsysId, (Date)startDate, (Date)endDate);
    }
}

