/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.business.shareplan;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.taxc.common.util.DateUtils;
import org.apache.commons.lang3.ObjectUtils;

public class ProvisionSharePlanService {
    public static DynamicObjectCollection filterEffective(DynamicObject[] docs, Date startDate, Date endDate) {
        DynamicObjectCollection objs = new DynamicObjectCollection();
        DynamicObject rule = null;
        DynamicObjectCollection entries = null;
        for (DynamicObject doc : docs) {
            entries = new DynamicObjectCollection();
            for (DynamicObject ruleEntry : doc.getDynamicObjectCollection("ruleentity")) {
                rule = ruleEntry.getDynamicObject("rule");
                if (!ObjectUtils.isNotEmpty((Object)rule) || !ProvisionSharePlanService.isEffectiveForCollection(rule, startDate, endDate)) continue;
                entries.add((Object)ruleEntry);
            }
            if (entries.size() <= 0) continue;
            doc.set("ruleentity", (Object)entries);
            objs.add((Object)doc);
        }
        return objs;
    }

    public static boolean isEffectiveForCollection(DynamicObject entry, Date startDate, Date endDate) {
        Date endTime;
        Date beginTime = DateUtils.trunc((Date)entry.getDate("startdate"), (String)"yyyy-MM-dd");
        Date[] date = DateUtils.getIntersectionDate((Date)beginTime, (Date)(endTime = DateUtils.trunc((Date)entry.getDate("enddate"), (String)"yyyy-MM-dd")), (Date)startDate, (Date)endDate);
        return date != null && date.length > 0;
    }
}

