/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.business.supplier;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tctb.business.supplier.TaxSupplierDao;

public class TaxSupplierBusiness {
    public static DynamicObject[] queryTaxSupplierByIds(List<Long> ids) {
        return TaxSupplierDao.queryTaxSupplierByIds(ids, "id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,supplier,entry_treaty,entry_treaty.seq,entry_treaty.treatyname,entry_treaty.treatyagreement,entry_treaty.startdate,entry_treaty.enddate");
    }

    public static DynamicObject[] queryTaxSupplierBySupplierIds(List<Long> supplierIds) {
        return TaxSupplierDao.queryTaxSupplierBySupplierIds(supplierIds, "id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,supplier,entry_treaty,entry_treaty.seq,entry_treaty.treatyname,entry_treaty.treatyagreement,entry_treaty.startdate,entry_treaty.enddate");
    }

    public static DynamicObject queryTaxSupplierBySupplierId(Long supplierId) {
        return TaxSupplierDao.queryTaxSupplierBySupplierId(supplierId, "id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,supplier,entry_treaty,entry_treaty.seq,entry_treaty.treatyname,entry_treaty.treatyagreement,entry_treaty.startdate,entry_treaty.enddate");
    }

    public static boolean existTaxSupplier(Long id) {
        return QueryServiceHelper.exists((String)"tctb_supplier", (Object)id);
    }

    public static List<Long> getSupplierIdsByIds(List<Long> ids) {
        DynamicObject[] coll = TaxSupplierDao.queryTaxSupplierByIds(ids, "supplier");
        List<Long> supplierIds = Stream.of(coll).filter(v -> v.getDynamicObject("supplier") != null).map(v -> v.getDynamicObject("supplier").getLong("id")).collect(Collectors.toList());
        return supplierIds;
    }

    public static String getEntryDimKey(DynamicObject object) {
        String keyFormat = "%1$1s_%2$s";
        return String.format(keyFormat, object.getString("treatyname"), object.getString("treatyagreement"));
    }
}

