/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.business.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.common.util.BigDecimalUtil;
import kd.taxc.common.util.DBUtils;
import kd.taxc.common.util.DateUtils;
import kd.taxc.common.util.EmptyCheckUtils;
import kd.taxc.tctb.common.util.DevprotalBizAppUtil;

public class SchduleCalculateTask
extends AbstractTask {
    private static final int LIMIT_SIZE = 500;
    private static final String TCTB_TASK_CALCULATE = "tctb_task_calculate";
    private static final String TCTB_TASK_DETAIL = "tctb_task_monitor_detail";
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("SchduleCalculateTask", new DistributeCacheHAPolicy(true, true));

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        boolean flag = QueryServiceHelper.exists((String)TCTB_TASK_CALCULATE, (QFilter[])new QFilter[0]);
        if (!flag) {
            QFilter statusFilter = new QFilter("status", "=", (Object)"COMPLETED");
            DynamicObject[] detailList = BusinessDataServiceHelper.load((String)TCTB_TASK_DETAIL, (String)"appid,status,starttime,endtime", (QFilter[])new QFilter[]{statusFilter});
            this.branchHandleData(detailList);
        } else {
            Date date = DateUtils.addDay((Date)new Date(), (int)-1);
            Date dayFirst = DateUtils.getDayFirst((Date)date);
            Date dayLast = DateUtils.getDayLast((Date)date);
            QFilter q1 = new QFilter("starttime", ">=", (Object)dayFirst);
            QFilter q2 = new QFilter("starttime", "<=", (Object)dayLast);
            QFilter q3 = new QFilter("status", "=", (Object)"COMPLETED");
            DynamicObject[] detailList = BusinessDataServiceHelper.load((String)TCTB_TASK_DETAIL, (String)"appid,status,starttime,endtime", (QFilter[])new QFilter[]{q1, q2, q3});
            this.branchHandleData(detailList);
        }
    }

    private void branchHandleData(DynamicObject[] detailList) {
        if (EmptyCheckUtils.isEmpty((Object)detailList)) {
            return;
        }
        int count = detailList.length;
        if (count > 500) {
            int round = count / 500 + 1;
            for (int i = 0; i < round; ++i) {
                int start = 500 * i;
                int end = 500 * (i + 1);
                if (500 * (i + 1) >= count) {
                    end = count;
                }
                List<DynamicObject> subList = Arrays.asList(detailList).subList(start, end);
                this.calculate(subList);
            }
        } else {
            this.calculate(Arrays.asList(detailList));
        }
        DynamicObject[] calculateList = BusinessDataServiceHelper.load((String)TCTB_TASK_CALCULATE, (String)"id,appid,number,avgcosttime,taxtypecount", (QFilter[])new QFilter[0]);
        if (EmptyCheckUtils.isNotEmpty((Object)calculateList)) {
            HashMap<String, Object> cacheMap = new HashMap<String, Object>(16);
            for (DynamicObject calResult : calculateList) {
                cacheMap.put(calResult.getString("appid.id"), calResult.get("avgcosttime"));
            }
            cache.put("task_calculate_result", (Object)SerializationUtils.toJsonString(cacheMap));
        }
    }

    private void calculate(List<DynamicObject> details) {
        Map<String, List<DynamicObject>> detailMap = details.stream().filter(x -> Objects.nonNull(x.getString("appid"))).collect(Collectors.groupingBy(x -> x.getString("appid.id")));
        ArrayList<DynamicObject> resultList = new ArrayList<DynamicObject>(detailMap.size());
        DynamicObject[] calculateList = BusinessDataServiceHelper.load((String)TCTB_TASK_CALCULATE, (String)"id,appid,number,avgcosttime,taxtypecount", (QFilter[])new QFilter[0]);
        for (Map.Entry<String, List<DynamicObject>> entry : detailMap.entrySet()) {
            String appid = entry.getKey();
            List<DynamicObject> objects = entry.getValue();
            long totalCost = 0L;
            for (DynamicObject detail : objects) {
                Date starttime = detail.getDate("starttime");
                Date endtime = detail.getDate("endtime");
                if (!Objects.nonNull(starttime)) continue;
                long endTime = Objects.isNull(endtime) ? starttime.getTime() : endtime.getTime();
                long cost = endTime - starttime.getTime();
                totalCost += cost;
            }
            long avgCostTime = BigDecimalUtil.divideObject((Object)totalCost, (Object)objects.size(), (int)2).longValue();
            long preAvgCost = 0L;
            long preCount = 0L;
            List appidList = Arrays.stream(calculateList).map(x -> x.get("appid.id")).collect(Collectors.toList());
            if (EmptyCheckUtils.isNotEmpty((Object)calculateList)) {
                for (DynamicObject cal : calculateList) {
                    if (!appidList.contains(appid)) {
                        DynamicObject calculate = this.getCalculateObject(appid, objects, avgCostTime);
                        resultList.add(calculate);
                        continue;
                    }
                    if (!Objects.equals(appid, cal.getString("appid.id")) || !appidList.contains(appid)) continue;
                    preAvgCost = cal.getLong("avgcosttime");
                    preCount = cal.getLong("taxtypecount");
                    cal.set("avgcosttime", (Object)(avgCostTime + preAvgCost));
                    cal.set("taxtypecount", (Object)(preCount + (long)objects.size()));
                    resultList.add(cal);
                }
                continue;
            }
            DynamicObject calculate = this.getCalculateObject(appid, objects, avgCostTime);
            resultList.add(calculate);
        }
        if (EmptyCheckUtils.isNotEmpty(resultList)) {
            SaveServiceHelper.save((DynamicObject[])resultList.toArray(new DynamicObject[0]));
        }
    }

    private DynamicObject getCalculateObject(String appid, List<DynamicObject> objects, long avgCostTime) {
        DynamicObject calculate = BusinessDataServiceHelper.newDynamicObject((String)TCTB_TASK_CALCULATE);
        calculate.set("id", (Object)DBUtils.getLongId((String)"t_tctb_task_calculate"));
        calculate.set("appid", (Object)appid);
        calculate.set("number", (Object)DevprotalBizAppUtil.getTaxcAppById((String)appid));
        calculate.set("avgcosttime", (Object)avgCostTime);
        calculate.set("taxtypecount", (Object)objects.size());
        return calculate;
    }
}

