/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.business.task;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.taxc.common.util.BigDecimalUtil;
import kd.taxc.common.util.DateUtils;
import kd.taxc.common.util.EmptyCheckUtils;

public class SchduleMonistorTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(SchduleMonistorTask.class);
    private static final int LIMIT_SIZE = 500;
    private static final String STATUS = "status";
    private static final String TASK_MONITOR = "tctb_task_monitor";
    private static final String TASK_MONITOR_DETAIL = "tctb_task_monitor_detail";
    private static final String YES = "YES";
    private static final String ENDTIME = "endtime";
    private static final String[] TASK_MONITOR_STATUS = new String[]{"BEGIN", "SCHEDULED"};
    private static final String DEFAULT_TIME = "1970-01-01 08:00:00";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        DynamicObject[] monitorObjs = BusinessDataServiceHelper.load((String)TASK_MONITOR, (String)"id,taskid", (QFilter[])new QFilter[]{new QFilter(STATUS, "in", (Object)TASK_MONITOR_STATUS)}, (String)"createdate asc");
        if (EmptyCheckUtils.isEmpty((Object)monitorObjs)) {
            return;
        }
        List taskIds = Arrays.stream(monitorObjs).map(o -> o.getString("taskid")).collect(Collectors.toList());
        DynamicObject[] details = BusinessDataServiceHelper.load((String)TASK_MONITOR_DETAIL, (String)"taskid,parentid,status,progress,starttime,endtime", (QFilter[])new QFilter[]{new QFilter("parentid", "in", taskIds).and("dispatchflag", "=", (Object)YES)}, (String)"createdate asc");
        logger.info("SchduleMonistorTask get details size={}", (Object)details.length);
        if (EmptyCheckUtils.isEmpty((Object)details)) {
            return;
        }
        int count = details.length;
        if (count > 500) {
            int round = count / 500 + 1;
            for (int i = 0; i < round; ++i) {
                int start = 500 * i;
                int end = 500 * (i + 1);
                if (500 * (i + 1) >= count) {
                    end = count;
                }
                List<DynamicObject> subList = Arrays.asList(details).subList(start, end);
                this.branchHandleTask(subList);
            }
        } else {
            this.branchHandleTask(Arrays.asList(details));
        }
    }

    private void branchHandleTask(List<DynamicObject> details) {
        List<DynamicObject> detailUpdateList = this.handleSubTask(details);
        this.handleParentTask(detailUpdateList);
    }

    private List<DynamicObject> handleSubTask(List<DynamicObject> details) {
        List taskidList = details.stream().filter(o -> StringUtils.isNotBlank((String)o.getString("taskid"))).map(x -> x.getString("taskid")).collect(Collectors.toList());
        List subTaskInfoList = ScheduleServiceHelper.queryTask(taskidList);
        ArrayList<DynamicObject> detailUpdateList = new ArrayList<DynamicObject>(details.size());
        if (EmptyCheckUtils.isEmpty((Object)subTaskInfoList)) {
            return detailUpdateList;
        }
        Map<String, TaskInfo> taskMap = subTaskInfoList.stream().filter(o -> EmptyCheckUtils.isNotEmpty((Object)o)).collect(Collectors.toMap(task -> task.getId(), task -> task, (m, n) -> m));
        for (DynamicObject detail : details) {
            TaskInfo taskInfo = taskMap.get(detail.getString("taskid"));
            if (Objects.nonNull(taskInfo)) {
                detail.set("progress", (Object)taskInfo.getProgress());
                long runTime = taskInfo.getRunTime();
                long endTime = taskInfo.getEndTime();
                long timestamp = DateUtils.stringToTimestamp((String)DEFAULT_TIME).getTime();
                detail.set("starttime", (Object)(runTime == timestamp ? new Date() : Long.valueOf(runTime)));
                detail.set(ENDTIME, (Object)(endTime == timestamp ? new Date() : Long.valueOf(endTime)));
                String status = detail.getString(STATUS);
                if (!(Objects.equals("COMPLETED", status) || Objects.equals("FAILED", status) || Objects.equals("ABORTED", status))) {
                    detail.set(STATUS, (Object)taskInfo.getStatus());
                }
            } else {
                detail.set("progress", (Object)100);
                detail.set(STATUS, (Object)"FAILED");
            }
            detailUpdateList.add(detail);
        }
        if (EmptyCheckUtils.isNotEmpty(detailUpdateList)) {
            SaveServiceHelper.update((DynamicObject[])detailUpdateList.toArray(new DynamicObject[0]));
        }
        return detailUpdateList;
    }

    private void handleParentTask(List<DynamicObject> detailUpdateList) {
        List parentidList = detailUpdateList.stream().map(x -> x.getString("parentid")).distinct().collect(Collectors.toList());
        DynamicObject[] parentTasks = BusinessDataServiceHelper.load((String)TASK_MONITOR, (String)"taskdefine,taskid,status,progress,starttime,endtime,executedetail", (QFilter[])new QFilter[]{new QFilter("taskid", "in", parentidList)});
        DynamicObjectCollection subTaskList = QueryServiceHelper.query((String)TASK_MONITOR_DETAIL, (String)"parentid,status", (QFilter[])new QFilter[]{new QFilter("parentid", "in", parentidList)});
        Map<String, List<DynamicObject>> subTaskDbMap = subTaskList.stream().collect(Collectors.groupingBy(x -> x.getString("parentid")));
        for (Map.Entry<String, List<DynamicObject>> entry : subTaskDbMap.entrySet()) {
            String parentId = entry.getKey();
            List<DynamicObject> subTaskDbList = entry.getValue();
            long totalCount = subTaskDbList.size();
            List sucessList = subTaskDbList.stream().filter(x -> x.getString(STATUS).equals("COMPLETED")).collect(Collectors.toList());
            List runingList = subTaskDbList.stream().filter(x -> x.getString(STATUS).equals("SCHEDULED") || x.getString(STATUS).equals("BEGIN") || x.getString(STATUS).equals("RUNNING")).collect(Collectors.toList());
            List failedList = subTaskDbList.stream().filter(x -> x.getString(STATUS).equals("FAILED")).collect(Collectors.toList());
            String detailStr = ResManager.loadKDString((String)"\u672c\u6b21\u6267\u884c\u5171\u83b7\u53d6%1$s\u6761\u6570\u636e\uff0c\u6210\u529f%2$s\u6761\uff0c\u9519\u8bef%3$s\u6761\u3002", (String)"SchduleMonistorTask_0", (String)"taxc-tctb-business", (Object[])new Object[0]);
            for (DynamicObject parentTask : parentTasks) {
                Date endTime = DateUtils.stringToDate((String)DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"), (String)"yyyy-MM-dd HH:mm:ss");
                if (!Objects.equals(parentId, parentTask.getString("taskid"))) continue;
                if (totalCount == (long)sucessList.size()) {
                    parentTask.set(STATUS, (Object)"COMPLETED");
                    parentTask.set("progress", (Object)100);
                    parentTask.set(ENDTIME, (Object)endTime);
                    parentTask.set("executedetail", (Object)String.format(detailStr, totalCount, sucessList.size(), failedList.size()));
                    continue;
                }
                if (runingList.size() > 0 && failedList.size() == 0) {
                    parentTask.set(STATUS, (Object)"BEGIN");
                    parentTask.set("progress", (Object)BigDecimalUtil.divideObject((Object)(sucessList.size() + failedList.size()), (Object)totalCount, (int)2).multiply(new BigDecimal(100)).intValue());
                    parentTask.set("executedetail", (Object)String.format(detailStr, totalCount, sucessList.size(), failedList.size()));
                    continue;
                }
                if (failedList.size() <= 0) continue;
                if (totalCount == (long)(sucessList.size() + failedList.size())) {
                    parentTask.set(ENDTIME, (Object)endTime);
                }
                parentTask.set(STATUS, (Object)"FAILED");
                parentTask.set("progress", (Object)BigDecimalUtil.divideObject((Object)(sucessList.size() + failedList.size()), (Object)totalCount, (int)2).multiply(new BigDecimal(100)).intValue());
                parentTask.set("executedetail", (Object)String.format(detailStr, totalCount, sucessList.size(), failedList.size()));
            }
        }
        if (EmptyCheckUtils.isNotEmpty((Object)parentTasks)) {
            SaveServiceHelper.update((DynamicObject[])parentTasks);
        }
    }
}

