/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.business.task;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.common.util.BigDecimalUtil;
import kd.taxc.common.util.EmptyCheckUtils;
import kd.taxc.tctb.business.task.TaskMonitorBusiness;
import org.apache.commons.lang3.StringUtils;

public class SubtaskDispatchTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(SubtaskDispatchTask.class);
    private static final String TASK_MONITOR_DETAIL = "tctb_task_monitor_detail";
    private static final String NO = "NO";
    private static final String YES = "YES";
    private static final String BATCH_NUMBER = "batchnumber";
    private static final String TASK_BRANCH_NUMBER_KEY = "task_branch_number_key";
    private static final String DETAIL_SELECT_FEILDS = "id,taskid,taskdefine,parentid,status,appid,taskappid,taskname,taskclassname,businessparams,taxorg,skssqq,skssqz,progress,dispatchflag,createdate,modifydate,starttime,endtime,executedetail,batchnumber,operater";
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("SubtaskDispatchTask", new DistributeCacheHAPolicy(true, true));

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        QFilter dispatchFilter;
        DynamicObject[] detailObjects;
        QFilter filter;
        DynamicObjectCollection branchDetails;
        String cacheBranchNumber = (String)cache.get(TASK_BRANCH_NUMBER_KEY);
        if (StringUtils.isNotBlank((CharSequence)cacheBranchNumber) && EmptyCheckUtils.isNotEmpty((Object)(branchDetails = QueryServiceHelper.query((String)TASK_MONITOR_DETAIL, (String)"taskid,status", (QFilter[])new QFilter[]{filter = new QFilter(BATCH_NUMBER, "=", (Object)cacheBranchNumber)})))) {
            List endList = branchDetails.stream().filter(x -> Objects.equals(x.get("status"), "COMPLETED") || Objects.equals(x.get("status"), "FAILED")).collect(Collectors.toList());
            double calResult = BigDecimalUtil.divideObject((Object)endList.size(), (Object)branchDetails.size(), (int)2).doubleValue();
            long currentTime = System.currentTimeMillis();
            long cacheTime = Long.parseLong(cacheBranchNumber);
            if (calResult < 0.75 && currentTime - cacheTime <= 900000L) {
                logger.info("SubtaskDispatchTask execute cacheBranchNumber ={},calResult ={}", (Object)cacheBranchNumber, (Object)calResult);
                return;
            }
        }
        if (EmptyCheckUtils.isEmpty((Object)(detailObjects = BusinessDataServiceHelper.load((String)TASK_MONITOR_DETAIL, (String)DETAIL_SELECT_FEILDS, (QFilter[])new QFilter[]{dispatchFilter = new QFilter("dispatchflag", "=", (Object)NO)}, (String)"createdate asc", (int)100)))) {
            return;
        }
        logger.info("SubtaskDispatchTask get executeList size={}", (Object)detailObjects.length);
        String batchNumber = String.valueOf(System.currentTimeMillis());
        TaskMonitorBusiness.dispatchSubTask(detailObjects, batchNumber);
        cache.put(TASK_BRANCH_NUMBER_KEY, (Object)batchNumber);
    }

    private void calulateExecuteDetail(List<DynamicObject> executeList, String calResult) {
        try {
            Map typeMap = (Map)SerializationUtils.fromJsonString((String)calResult, Map.class);
            QFilter dispatchFilter = new QFilter("dispatchflag", "=", (Object)NO);
            DynamicObject[] details = BusinessDataServiceHelper.load((String)TASK_MONITOR_DETAIL, (String)DETAIL_SELECT_FEILDS, (QFilter[])new QFilter[]{dispatchFilter}, (String)"createdate asc", (int)200);
            Map<String, List<DynamicObject>> listMap = Arrays.stream(details).collect(Collectors.groupingBy(x -> x.getString("appid.id")));
            int totalTime = 120000;
            for (Map.Entry<String, List<DynamicObject>> detailEntry : listMap.entrySet()) {
                String detailAppid = detailEntry.getKey();
                List<DynamicObject> group = detailEntry.getValue();
                int costTime = Objects.isNull(typeMap.get(detailAppid)) ? 2000 : (Integer)typeMap.get(detailAppid);
                int count = BigDecimalUtil.divideObject((Object)totalTime, (Object)costTime, (int)2).intValue();
                double rate = BigDecimalUtil.divideObject((Object)group.size(), (Object)details.length, (int)2).doubleValue();
                int end = BigDecimalUtil.multiplyObject((Object)count, (Object)rate, (int)2).intValue();
                List<DynamicObject> subList = group.subList(0, end);
                executeList.addAll(subList);
            }
        }
        catch (Exception e) {
            logger.error("calulateExecuteDetail cause exception\uff1a", (Throwable)e);
        }
    }
}

