/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.business.task;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.TaskHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.taxc.bdtaxr.common.utils.metadata.MetadataUtil;
import kd.taxc.common.util.BigDecimalUtil;
import kd.taxc.common.util.DateUtils;
import kd.taxc.common.util.EmptyCheckUtils;
import org.apache.commons.lang3.StringUtils;

public class TaskMonitorBusiness {
    private static final String DEFAULT_TIME = "1970-01-01 08:00:00";

    public static List<String> dispatchSubTask(DynamicObject[] detailObjects, String batchNumber) {
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(detailObjects.length);
        ArrayList<String> taskIds = new ArrayList<String>(detailObjects.length);
        for (DynamicObject detail : detailObjects) {
            String appid = StringUtils.isBlank((CharSequence)detail.getString("taskappid")) ? "bdtaxr" : detail.getString("taskappid");
            String businessParamsStr = detail.getString("businessparams");
            HashMap<String, Object> businessParams = new HashMap();
            if (StringUtils.isNotBlank((CharSequence)businessParamsStr)) {
                businessParams = (Map)SerializationUtils.fromJsonString((String)businessParamsStr, Map.class);
            }
            String taskId = TaskMonitorBusiness.dispatch(appid, detail.getString("taskname"), detail.getString("taskclassname"), businessParams, detail.getLong("operater.id"), detail.getLong("id"));
            detail.set("taskid", (Object)taskId);
            taskIds.add(taskId);
            detail.set("dispatchflag", (Object)"YES");
            detail.set("batchnumber", (Object)batchNumber);
            updateList.add(detail);
        }
        if (EmptyCheckUtils.isNotEmpty(updateList)) {
            SaveServiceHelper.save((DynamicObject[])updateList.toArray(new DynamicObject[0]));
        }
        return taskIds;
    }

    public static List<String> dispatchSubTask(List<Long> Ids) {
        DynamicObject[] detailObjects = BusinessDataServiceHelper.load((Object[])Ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tctb_task_monitor_detail"));
        String batchNumber = String.valueOf(System.currentTimeMillis());
        return TaskMonitorBusiness.dispatchSubTask(detailObjects, batchNumber);
    }

    public static void updateTaskInfo(Map<String, Object> params) {
        String taskId = Objects.isNull(params.get("taskId")) ? null : (String)params.get("taskId");
        TaskMonitorBusiness.handlerTaskInfo(params, taskId);
    }

    private static void handlerTaskInfo(Map<String, Object> params, String taskId) {
        DynamicObject[] subTasks = BusinessDataServiceHelper.load((String)"tctb_task_monitor_detail", (String)MetadataUtil.getAllSubFieldString((String)"tctb_task_monitor_detail"), (QFilter[])new QFilter[]{new QFilter("parentid", "=", (Object)taskId)});
        boolean isStop = false;
        if (params.containsKey("isstop")) {
            isStop = (Boolean)params.get("isstop");
        }
        TaskMonitorBusiness.handleSubTask(subTasks, isStop);
        TaskMonitorBusiness.handleParentTask(taskId, isStop);
    }

    private static List<DynamicObject> handleSubTask(DynamicObject[] details, boolean isstop) {
        List taskidList = Arrays.stream(details).filter(o -> kd.bos.login.utils.StringUtils.isNotBlank((String)o.getString("taskid"))).map(x -> x.getString("taskid")).collect(Collectors.toList());
        List subTaskInfoList = ScheduleServiceHelper.queryTask(taskidList);
        ArrayList<DynamicObject> detailUpdateList = new ArrayList<DynamicObject>(details.length);
        if (EmptyCheckUtils.isEmpty((Object)subTaskInfoList)) {
            return detailUpdateList;
        }
        Map<String, TaskInfo> taskMap = subTaskInfoList.stream().filter(o -> EmptyCheckUtils.isNotEmpty((Object)o)).collect(Collectors.toMap(task -> task.getId(), task -> task, (m, n) -> m));
        for (DynamicObject detail : details) {
            TaskInfo taskInfo = taskMap.get(detail.getString("taskid"));
            if (Objects.nonNull(taskInfo)) {
                if (isstop && taskInfo.getProgress() == 0) {
                    detail.set("progress", (Object)0);
                } else {
                    detail.set("progress", (Object)taskInfo.getProgress());
                }
                long runTime = taskInfo.getRunTime();
                long endTime = taskInfo.getEndTime();
                long timestamp = DateUtils.stringToTimestamp((String)DEFAULT_TIME).getTime();
                detail.set("starttime", (Object)(runTime == timestamp ? new Date() : Long.valueOf(runTime)));
                detail.set("endtime", (Object)(endTime == timestamp ? new Date() : Long.valueOf(endTime)));
                String status = detail.getString("status");
                if (!(Objects.equals("COMPLETED", status) || Objects.equals("FAILED", status) || Objects.equals("ABORTED", status))) {
                    if (isstop) {
                        try {
                            TaskHelper.stop((String)detail.getString("taskid"));
                        }
                        catch (Exception e) {
                            detail.set("status", (Object)"ABORTED");
                        }
                    } else {
                        detail.set("status", (Object)taskInfo.getStatus());
                    }
                }
            } else {
                detail.set("progress", (Object)100);
                detail.set("status", (Object)"FAILED");
            }
            detailUpdateList.add(detail);
        }
        if (EmptyCheckUtils.isNotEmpty(detailUpdateList)) {
            SaveServiceHelper.update((DynamicObject[])detailUpdateList.toArray(new DynamicObject[0]));
        }
        return detailUpdateList;
    }

    private static void handleParentTask(String taskId, boolean isStop) {
        DynamicObject parentTask = BusinessDataServiceHelper.loadSingle((String)"tctb_task_monitor", (String)"id,dispatchtime,starttime,endtime,executetype,progress,status,operater,executedetail,taskdefine,taskid,createdate,modifydate", (QFilter[])new QFilter[]{new QFilter("taskid", "=", (Object)taskId)});
        if (parentTask != null) {
            DynamicObjectCollection subTaskDbList = QueryServiceHelper.query((String)"tctb_task_monitor_detail", (String)"id,taskdefine,starttime,endtime,progress,status,taskid,taxorg,skssqq,executedetail,parentid,taskname,taskclassname,businessparams,skssqz,appid,createdate,modifydate,taskappid,dispatchflag,batchnumber,operater", (QFilter[])new QFilter[]{new QFilter("parentid", "=", (Object)taskId)});
            long totalCount = subTaskDbList.size();
            List sucessList = subTaskDbList.stream().filter(x -> x.getString("status").equals("COMPLETED")).collect(Collectors.toList());
            List runingList = subTaskDbList.stream().filter(x -> x.getString("status").equals("SCHEDULED") || x.getString("status").equals("BEGIN") || x.getString("status").equals("RUNNING")).collect(Collectors.toList());
            List failedList = subTaskDbList.stream().filter(x -> x.getString("status").equals("FAILED")).collect(Collectors.toList());
            String detailStr = ResManager.loadKDString((String)"\u672c\u6b21\u6267\u884c\u5171\u83b7\u53d6%1$s\u6761\u6570\u636e\uff0c\u6210\u529f%2$s\u6761\uff0c\u9519\u8bef%3$s\u6761\u3002", (String)"TaskMonitorBusiness_0", (String)"taxc-tctb-business", (Object[])new Object[0]);
            Date endTime = DateUtils.stringToDate((String)DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"), (String)"yyyy-MM-dd HH:mm:ss");
            if (isStop) {
                parentTask.set("status", (Object)"ABORTED");
                parentTask.set("progress", (Object)BigDecimalUtil.divideObject((Object)(sucessList.size() + failedList.size()), (Object)totalCount, (int)2).multiply(new BigDecimal(100)).intValue());
                parentTask.set("executedetail", (Object)String.format(detailStr, totalCount, sucessList.size(), failedList.size()));
            } else if (totalCount == (long)sucessList.size()) {
                parentTask.set("status", (Object)"COMPLETED");
                parentTask.set("progress", (Object)100);
                parentTask.set("endtime", (Object)endTime);
                parentTask.set("executedetail", (Object)String.format(detailStr, totalCount, sucessList.size(), failedList.size()));
            } else if (runingList.size() > 0 && failedList.size() == 0) {
                parentTask.set("status", (Object)"BEGIN");
                parentTask.set("progress", (Object)BigDecimalUtil.divideObject((Object)(sucessList.size() + failedList.size()), (Object)totalCount, (int)2).multiply(new BigDecimal(100)).intValue());
                parentTask.set("executedetail", (Object)String.format(detailStr, totalCount, sucessList.size(), failedList.size()));
            } else if (failedList.size() > 0) {
                if (totalCount == (long)(sucessList.size() + failedList.size())) {
                    parentTask.set("endtime", (Object)endTime);
                }
                parentTask.set("progress", (Object)BigDecimalUtil.divideObject((Object)(sucessList.size() + failedList.size()), (Object)totalCount, (int)2).multiply(new BigDecimal(100)).intValue());
                parentTask.set("executedetail", (Object)String.format(detailStr, totalCount, sucessList.size(), failedList.size()));
            }
            if (EmptyCheckUtils.isNotEmpty((Object)parentTask)) {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{parentTask});
            }
        }
    }

    private static String dispatch(String appId, String taskName, String taskClassName, Map<String, Object> businessParams, Long operater, Long subTaskSerinoNumber) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId(appId);
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setName(taskName);
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname(taskClassName);
        businessParams.put("taskSerialNumber", subTaskSerinoNumber);
        jobInfo.setParams(businessParams);
        jobInfo.setRunByUserId(operater.longValue());
        return ScheduleServiceHelper.dispatch((JobInfo)jobInfo);
    }
}

