/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.business.task;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.taxc.common.util.EmptyCheckUtils;
import kd.taxc.tctb.common.util.DevprotalBizAppUtil;

public class TaskUpdateService {
    private static final String TASK_MONITOR = "tctb_task_monitor";
    private static final String TASK_MONITOR_DETAIL = "tctb_task_monitor_detail";
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";
    private static final String APPID = "appid";
    private static final String DEFAULT_NO = "NO";

    public void saveParentTask(Map<String, Object> params, String taskId, String executeType) {
        DynamicObject taskMonistor = BusinessDataServiceHelper.newDynamicObject((String)TASK_MONITOR);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
        taskMonistor.set("dispatchtime", (Object)taskInfo.getDispachTime());
        taskMonistor.set("starttime", (Object)taskInfo.getRunTime());
        taskMonistor.set("taskdefine", params.get("taskdefineId"));
        taskMonistor.set("executetype", (Object)executeType);
        taskMonistor.set("operater", params.get("operater"));
        taskMonistor.set("taskid", (Object)taskId);
        taskMonistor.set("status", (Object)"SCHEDULED");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskMonistor});
    }

    public DynamicObject saveSubTask(Map<String, Object> params, String parentId, long subTaskSerinoNumber) {
        String taskAppid;
        DynamicObject subTask = BusinessDataServiceHelper.newDynamicObject((String)TASK_MONITOR_DETAIL);
        subTask.set("id", (Object)subTaskSerinoNumber);
        subTask.set("taskdefine", params.get("taskdefineId"));
        subTask.set("parentid", (Object)parentId);
        subTask.set("status", (Object)"SCHEDULED");
        subTask.set("taxorg", params.get("taxorg"));
        if (EmptyCheckUtils.isNotEmpty((Object)params.get("dispatchflag"))) {
            subTask.set("dispatchflag", params.get("dispatchflag"));
        } else {
            subTask.set("dispatchflag", (Object)DEFAULT_NO);
        }
        subTask.set("operater", params.get("operater") == null ? Long.valueOf(0L) : params.get("operater"));
        subTask.set(SKSSQQ, params.get(SKSSQQ));
        subTask.set(SKSSQZ, params.get(SKSSQZ));
        String string = taskAppid = Objects.isNull(params.get(APPID)) ? null : (String)params.get(APPID);
        if (StringUtils.isNotBlank((CharSequence)taskAppid)) {
            subTask.set(APPID, (Object)DevprotalBizAppUtil.getTaxcAppByNumber((String)taskAppid));
        }
        subTask.set("taskappid", (Object)taskAppid);
        subTask.set("taskname", params.get("taskName"));
        subTask.set("taskclassname", params.get("taskClassName"));
        Object businessParams = params.get("businessParams");
        if (Objects.nonNull(businessParams)) {
            Map businessParamsMap = (Map)businessParams;
            if (Objects.nonNull(businessParamsMap.get(APPID))) {
                String appid = (String)businessParamsMap.get(APPID);
                subTask.set(APPID, (Object)DevprotalBizAppUtil.getTaxcAppByNumber((String)appid));
            }
            subTask.set("businessparams", (Object)JSONObject.toJSONString((Object)businessParamsMap));
        }
        return subTask;
    }

    public void handlerTaskDetailInfo(Map<String, Object> params, String taskId, Long taskSerialNumber) {
        Date skssqz;
        DynamicObject subTask = BusinessDataServiceHelper.loadSingle((Object)taskSerialNumber, (String)TASK_MONITOR_DETAIL);
        Date skssqq = Objects.isNull(params.get(SKSSQQ)) ? null : (Date)params.get(SKSSQQ);
        Date date = skssqz = Objects.isNull(params.get(SKSSQZ)) ? null : (Date)params.get(SKSSQZ);
        if (Objects.nonNull(subTask)) {
            subTask.set("taskid", (Object)taskId);
            if (Objects.nonNull(skssqq)) {
                subTask.set(SKSSQQ, (Object)skssqq);
            }
            if (Objects.nonNull(skssqz)) {
                subTask.set(SKSSQZ, (Object)skssqz);
            }
            if (Objects.equals("true", params.get("success"))) {
                subTask.set("status", (Object)"COMPLETED");
                subTask.set("progress", (Object)100);
                subTask.set("executedetail", params.get("executeDetail"));
            } else if (Objects.equals("false", params.get("success"))) {
                subTask.set("status", (Object)"FAILED");
                subTask.set("progress", (Object)100);
                subTask.set("executedetail", params.get("executeDetail"));
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{subTask});
    }
}

