/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.business.taxcalendarlist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.taxc.bdtaxr.common.utils.DyoToDtoUtils;
import kd.taxc.common.util.DateUtils;
import kd.taxc.enums.TaxCalendarEndDayEnum;
import kd.taxc.enums.TaxCycleEnum;
import kd.taxc.tctb.business.taxcalendarlist.TaxCalendarListDao;
import kd.taxc.tctb.business.taxcalendarlist.TaxCalendarRuleBusiness;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class TaxCalendarListBusiness {
    private static Log logger = LogFactory.getLog(TaxCalendarListBusiness.class);

    public static DynamicObject[] queryTaxCalendarListByIds(Collection ids) {
        return TaxCalendarListDao.queryTaxCalendarListByIds(ids);
    }

    public static DynamicObject[] queryTaxCalendarListByYearAndTaxYear(List<DynamicObject> taxyears, int yearstart, int yearend) {
        List<Long> taxyearIds = taxyears.stream().map(taxyear -> taxyear.getLong("id")).collect(Collectors.toList());
        return TaxCalendarListDao.queryTaxCalendarListByYearAndTaxYear(taxyearIds, yearstart, yearend);
    }

    public static List<Long> queryTaxCalendarListByDateAndTaxFields(Date skssqq, Date skssqz, List<Map<String, Object>> paramsListList) {
        DynamicObject[] taxCalendarArray = TaxCalendarListDao.queryTaxCalendarListByDateAndTaxFields("id,billno,billstatus,creator,modifier,auditor,auditdate,modifytime,createtime,taxyear,taxationsys,taxareagroup,taxcategory,taxcycle,skssqq,skssqz,sbjzrq,jkjzrq,periodyear,taxyear.orgentryentity.org", skssqq, skssqz, paramsListList);
        return DyoToDtoUtils.dyoToLong((DynamicObject[])taxCalendarArray);
    }

    public static Map<String, Object> generateTaxcalendarlistData(List<DynamicObject> taxyears, int yearstartInt, int yearendInt) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
        List<DynamicObject> rules = TaxCalendarRuleBusiness.queryRulesByTaxYears(taxyears);
        if (CollectionUtils.isEmpty(rules)) {
            TaxCalendarListBusiness.setResult(resultMap, false, ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u5bf9\u5e94\u7684\u7a0e\u52a1\u65e5\u5386\u89c4\u5219\u3002", (String)"TaxCalendarListBusiness_0", (String)"taxc-tctb-business", (Object[])new Object[0]));
            return resultMap;
        }
        Map<String, DynamicObject> taxyearMap = taxyears.stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getString("id"), dynamicObject -> dynamicObject, (a, b) -> a));
        ArrayList<DynamicObject> newTaxcalendarlistData = new ArrayList<DynamicObject>(10);
        try {
            for (DynamicObject rule : rules) {
                for (int year = yearstartInt; year <= yearendInt; ++year) {
                    List<DynamicObject> newDataPartList;
                    String taxyearIdStr = rule.getString("taxyearid");
                    DynamicObject taxyear = taxyearMap.get(taxyearIdStr);
                    if (taxyear == null || (newDataPartList = TaxCalendarListBusiness.getNewTaxcalendarlistData(taxyear, rule, year)) == null || newDataPartList.isEmpty()) continue;
                    newTaxcalendarlistData.addAll(newDataPartList);
                }
            }
            TaxCalendarListBusiness.saveNewDatas(newTaxcalendarlistData);
        }
        catch (Throwable e) {
            logger.error("\u751f\u6210\u7a0e\u52a1\u65e5\u5386\u6e05\u5355\u5931\u8d25\uff1a{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            TaxCalendarListBusiness.setResult(resultMap, false, ResManager.loadKDString((String)"\u751f\u6210\u7a0e\u52a1\u65e5\u5386\u6e05\u5355\u5931\u8d25\u3002", (String)"TaxCalendarListBusiness_1", (String)"taxc-tctb-business", (Object[])new Object[0]));
            return resultMap;
        }
        TaxCalendarListBusiness.setResult(resultMap, true, ResManager.loadKDString((String)"\u6210\u529f\u751f\u6210\u7a0e\u52a1\u65e5\u5386\u6e05\u5355%s\u6761\u3002", (String)"TaxCalendarListBusiness_2", (String)"taxc-tctb-business", (Object[])new Object[]{newTaxcalendarlistData.size()}));
        return resultMap;
    }

    protected static List<DynamicObject> getNewTaxcalendarlistData(DynamicObject taxyear, DynamicObject rule, int yearInt) {
        String[] taxYearValues;
        ArrayList<DynamicObject> resultList = new ArrayList<DynamicObject>(10);
        DynamicObjectCollection taxyearEntries = taxyear.getDynamicObjectCollection("entryentity");
        TaxCycleEnum taxCycleEnum = TaxCycleEnum.getTaxCycleEnumByCode((String)rule.getString("taxcycle"));
        Map<String, List<DynamicObject>> groupedTaxyearEntries = taxyearEntries.stream().collect(Collectors.groupingBy(obj -> {
            if ("year".equals(taxCycleEnum.getTaxYearField())) {
                return "1";
            }
            return obj.getString(taxCycleEnum.getTaxYearField());
        }));
        for (String taxYearValue : taxYearValues = taxCycleEnum.getTaxYearValues()) {
            DynamicObject newData = TaxCalendarListBusiness.buildData(taxyear, groupedTaxyearEntries.get(taxYearValue), rule, yearInt);
            if (newData == null) continue;
            resultList.add(newData);
        }
        return resultList;
    }

    protected static DynamicObject buildData(DynamicObject taxyear, List<DynamicObject> taxyearEntries, DynamicObject rule, int yearInt) {
        if (taxyearEntries == null || taxyearEntries.isEmpty()) {
            return null;
        }
        Date[] firstAndLastDate = TaxCalendarListBusiness.getFirstAndLastDate(taxyearEntries, yearInt);
        Date[] sbrqAndJKRQ = TaxCalendarListBusiness.getSBRQAndJKRQ(firstAndLastDate[1], rule);
        DynamicObject newTaxcalendarlistData = BusinessDataServiceHelper.newDynamicObject((String)"tctb_taxcalendar_list");
        newTaxcalendarlistData.set("billstatus", (Object)"C");
        newTaxcalendarlistData.set("taxyear", (Object)taxyear);
        newTaxcalendarlistData.set("taxationsys", (Object)rule.getDynamicObject("group"));
        newTaxcalendarlistData.set("taxcategory", (Object)rule.getDynamicObject("taxcategory"));
        newTaxcalendarlistData.set("taxcycle", (Object)rule.getString("taxcycle"));
        newTaxcalendarlistData.set("taxareagroup", (Object)rule.getDynamicObject("taxareagroup"));
        newTaxcalendarlistData.set("skssqq", (Object)firstAndLastDate[0]);
        newTaxcalendarlistData.set("skssqz", (Object)firstAndLastDate[1]);
        newTaxcalendarlistData.set("sbjzrq", (Object)sbrqAndJKRQ[0]);
        newTaxcalendarlistData.set("jkjzrq", (Object)sbrqAndJKRQ[1]);
        newTaxcalendarlistData.set("periodyear", (Object)yearInt);
        newTaxcalendarlistData.set("creator", (Object)UserServiceHelper.getCurrentUserId());
        return newTaxcalendarlistData;
    }

    protected static Date[] getFirstAndLastDate(List<DynamicObject> taxyearEntries, int yearInt) {
        Date[] result = new Date[2];
        String[] whichYear = new String[2];
        for (DynamicObject taxyearEntry : taxyearEntries) {
            Date startDate = taxyearEntry.getDate("startmonthandday");
            Date endDate = taxyearEntry.getDate("endmonthandday");
            if (result[0] == null) {
                result[0] = startDate;
                whichYear[0] = taxyearEntry.getString("startyear");
            }
            if (result[1] == null) {
                result[1] = endDate;
                whichYear[1] = taxyearEntry.getString("endyear");
            }
            if (startDate.before(result[0])) {
                result[0] = startDate;
                whichYear[0] = taxyearEntry.getString("startyear");
            }
            if (!endDate.after(result[1])) continue;
            result[1] = endDate;
            whichYear[1] = taxyearEntry.getString("endyear");
        }
        int year0 = yearInt + ("1".equals(whichYear[0]) ? 1 : 0);
        int year1 = yearInt + ("1".equals(whichYear[1]) ? 1 : 0);
        result[0] = DateUtils.setYear((Date)result[0], (int)year0);
        result[1] = DateUtils.setYear((Date)result[1], (int)year1);
        return result;
    }

    protected static Date[] getSBRQAndJKRQ(Date skssqz, DynamicObject rule) {
        String sbjzrnssdlx = rule.getString("sbjzrnssdlx");
        int sbMonth = rule.getInt("sbjzry");
        int sbDay = rule.getInt("sbjzrt");
        String jkjzrnssdlx = rule.getString("jkjzrnssdlx");
        int jkMonth = rule.getInt("jkjzry");
        int jkDay = rule.getInt("jkjzrt");
        Date[] sbAndjkDate = new Date[]{TaxCalendarListBusiness.getEnDate(skssqz, sbjzrnssdlx, sbMonth, sbDay), TaxCalendarListBusiness.getEnDate(skssqz, jkjzrnssdlx, jkMonth, jkDay)};
        return sbAndjkDate;
    }

    private static Date getEnDate(Date skssqz, String sdlx, int month, int day) {
        if (TaxCalendarEndDayEnum.ENDDAY.getCode().equals(sdlx)) {
            return skssqz;
        }
        if (TaxCalendarEndDayEnum.AFTERENDDAY.getCode().equals(sdlx)) {
            if (DateUtils.isMonthEndDay((Date)skssqz)) {
                skssqz = DateUtils.addMonth((Date)skssqz, (int)month);
                skssqz = DateUtils.getLastDateOfMonth((Date)skssqz);
            } else {
                skssqz = DateUtils.addMonth((Date)skssqz, (int)month);
            }
            skssqz = DateUtils.addDay((Date)skssqz, (int)day);
        } else if (TaxCalendarEndDayEnum.BEFOREENDDAY.getCode().equals(sdlx)) {
            month = -month;
            day = -day;
            if (DateUtils.isMonthEndDay((Date)skssqz)) {
                skssqz = DateUtils.addMonth((Date)skssqz, (int)month);
                skssqz = DateUtils.getLastDateOfMonth((Date)skssqz);
            } else {
                skssqz = DateUtils.addMonth((Date)skssqz, (int)month);
            }
            skssqz = DateUtils.addDay((Date)skssqz, (int)day);
        } else {
            return null;
        }
        return skssqz;
    }

    private static void saveNewDatas(List<DynamicObject> newDataList) {
        if (newDataList == null || newDataList.isEmpty()) {
            return;
        }
        String[] batchNumber = CodeRuleServiceHelper.getBatchNumber((String)"tctb_taxcalendar_list", (DynamicObject)newDataList.get(0), null, (int)newDataList.size());
        for (int i = 0; i < newDataList.size(); ++i) {
            newDataList.get(i).set("billno", (Object)batchNumber[i]);
        }
        SaveServiceHelper.save((DynamicObject[])newDataList.toArray(new DynamicObject[0]));
    }

    private static void setResult(Map resultMap, boolean isSuccess, String message) {
        resultMap.put("isSuccess", isSuccess);
        resultMap.put("message", message);
    }
}

