/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.business.taxcalendarlist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;

public class TaxCalendarListDao {
    public static DynamicObject[] queryTaxCalendarListByDateAndTaxFields(String selectField, Date skssqq, Date skssqz, List<Map<String, Object>> paramsListList) {
        if (paramsListList == null || paramsListList.isEmpty()) {
            return new DynamicObject[0];
        }
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
        List taxationsysids = paramsListList.stream().map(map -> (Long)map.get("taxationsys")).filter(Objects::nonNull).collect(Collectors.toList());
        List taxcategoryids = paramsListList.stream().map(map -> (Long)map.get("taxcategory")).filter(Objects::nonNull).collect(Collectors.toList());
        List taxareaids = paramsListList.stream().map(map -> (Long)map.get("taxareagroup")).filter(Objects::nonNull).collect(Collectors.toList());
        List taxyearids = paramsListList.stream().map(map -> (Long)map.get("taxyear")).filter(Objects::nonNull).collect(Collectors.toList());
        if (skssqq != null) {
            qFilterList.add(new QFilter("skssqq", ">=", (Object)skssqq));
        }
        if (skssqz != null) {
            qFilterList.add(new QFilter("skssqq", "<=", (Object)skssqz));
        }
        if (taxationsysids.isEmpty()) {
            return new DynamicObject[0];
        }
        qFilterList.add(new QFilter("taxationsys", "in", taxationsysids));
        if (taxcategoryids.isEmpty()) {
            return new DynamicObject[0];
        }
        qFilterList.add(new QFilter("taxcategory", "in", taxcategoryids));
        if (taxareaids.isEmpty()) {
            return new DynamicObject[0];
        }
        qFilterList.add(new QFilter("taxareagroup", "in", taxareaids));
        if (taxyearids.isEmpty()) {
            return new DynamicObject[0];
        }
        qFilterList.add(new QFilter("taxyear", "in", taxyearids));
        return TaxCalendarListDao.queryTaxCalendarListByQFilters(selectField, qFilterList.toArray(new QFilter[0]));
    }

    public static DynamicObject[] queryTaxCalendarListByYearAndTaxYear(List<Long> taxyearIds, int yearstart, int yearend) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
        if (taxyearIds != null && !taxyearIds.isEmpty()) {
            qFilterList.add(new QFilter("taxyear", "in", taxyearIds));
        }
        qFilterList.add(new QFilter("periodyear", ">=", (Object)yearstart));
        qFilterList.add(new QFilter("periodyear", "<=", (Object)yearend));
        return TaxCalendarListDao.queryTaxCalendarListByQFilters("id,billno,billstatus,creator,modifier,auditor,auditdate,modifytime,createtime,taxyear,taxationsys,taxareagroup,taxcategory,taxcycle,skssqq,skssqz,sbjzrq,jkjzrq,periodyear,taxyear.orgentryentity.org", qFilterList.toArray(new QFilter[0]));
    }

    public static DynamicObject[] queryTaxCalendarListByIds(Collection ids) {
        if (CollectionUtils.isNotEmpty((Collection)ids)) {
            QFilter idFilter = new QFilter("id", "in", (Object)ids);
            return TaxCalendarListDao.queryTaxCalendarListByQFilters(null, new QFilter[]{idFilter});
        }
        return null;
    }

    private static DynamicObject[] queryTaxCalendarListByQFilters(String selectFields, QFilter[] qfilters) {
        if (null == qfilters || qfilters.length == 0) {
            qfilters = new QFilter[]{new QFilter("1", "=", (Object)1)};
        }
        if (StringUtils.isEmpty((String)selectFields)) {
            selectFields = "id,billno,billstatus,creator,modifier,auditor,auditdate,modifytime,createtime,taxyear,taxationsys,taxareagroup,taxcategory,taxcycle,skssqq,skssqz,sbjzrq,jkjzrq,periodyear,taxyear.orgentryentity.org";
        }
        return BusinessDataServiceHelper.load((String)"tctb_taxcalendar_list", (String)selectFields, (QFilter[])qfilters);
    }
}

