/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.business.taxcalendarlist;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.taxc.tctb.business.taxcalendarlist.TaxCalendarRuleDao;

public class TaxCalendarRuleBusiness {
    public static List<DynamicObject> queryRulesByTaxYears(List<DynamicObject> taxyearsList) {
        HashSet<Long> taxationsysids = new HashSet<Long>(16);
        HashSet<Long> taxcategoryids = new HashSet<Long>(16);
        HashSet<String> taxyearKeys = new HashSet<String>(16);
        boolean hasTaxcategoryNullData = false;
        for (DynamicObject taxyear : taxyearsList) {
            long taxationsysid = taxyear.getDynamicObject("group").getLong("id");
            taxationsysids.add(taxationsysid);
            DynamicObject taxcategory = taxyear.getDynamicObject("taxcategory");
            if (taxcategory == null) {
                hasTaxcategoryNullData = true;
                taxyearKeys.add(String.format("%1$s_%2$s_%3$s", taxationsysid, "null", taxyear.getString("id")));
                continue;
            }
            taxcategoryids.add(taxcategory.getLong("id"));
            taxyearKeys.add(String.format("%1$s_%2$s_%3$s", taxationsysid, taxcategory.getLong("id"), taxyear.getString("id")));
        }
        DynamicObject[] queryRules = null;
        queryRules = hasTaxcategoryNullData ? TaxCalendarRuleDao.queryRulesByTaxationsysAndTaxcategory(taxationsysids, null) : TaxCalendarRuleDao.queryRulesByTaxationsysAndTaxcategory(taxationsysids, taxcategoryids);
        return TaxCalendarRuleBusiness.filterRules(taxyearKeys, queryRules);
    }

    public static List filterRules(Set<String> taxyearKeys, DynamicObject[] queryRules) {
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>();
        for (String taxyearKey : taxyearKeys) {
            String[] parts = taxyearKey.split("_");
            String taxationsysid = parts[0];
            String taxcategoryid = parts[1];
            String taxyearid = parts[2];
            for (DynamicObject queryRule : queryRules) {
                queryRule.set("taxyearid", (Object)taxyearid);
                if ("null".equals(taxcategoryid)) {
                    if (!taxationsysid.equals(queryRule.getString("group.id"))) continue;
                    result.add(queryRule);
                    continue;
                }
                if (!taxationsysid.equals(queryRule.getString("group.id")) || !taxcategoryid.equals(queryRule.getString("taxcategory.id"))) continue;
                result.add(queryRule);
            }
        }
        return result;
    }
}

