/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.business.taxclicense;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.TaxationsysMappingEnum;
import kd.taxc.bdtaxr.common.helper.bastax.taxcorg.TaxcOrgDataServiceHelper;
import kd.taxc.common.util.StringUtil;
import kd.taxc.license.LicenseGroupUtil;
import kd.taxc.tctb.business.taxclicense.TaxcLicenseApplyDao;
import kd.taxc.tctb.business.taxclicense.TaxcLicenseBusiness;
import kd.taxc.tctb.business.taxclicense.TaxcLicenseService;

public class TaxcLicenseApplyService {
    private static Log logger = LogFactory.getLog(TaxcLicenseApplyService.class);

    public static DynamicObject[] queryTaxLicenseApplyByIds(List<Long> ids) {
        return TaxcLicenseApplyDao.queryTaxLicenseApplyByIds(ids, "id,billno,billstatus,creator,modifier,auditor,auditdate,modifytime,createtime,entryentity,entryentity.seq,entryentity.org,entryentity.unifiedsocialcode,entryentity.group,entryentity.applystatus,entryentity.entrymodifier,entryentity.entrymodifydate,entryentity.licenseid", "billno desc");
    }

    public static DynamicObject[] queryOnTheWayLicenseApply(List<Long> licenseIds) {
        return TaxcLicenseApplyDao.queryOnTheWayLicenseApply(licenseIds, "id,billno,billstatus,creator,modifier,auditor,auditdate,modifytime,createtime,entryentity,entryentity.seq,entryentity.org,entryentity.unifiedsocialcode,entryentity.group,entryentity.applystatus,entryentity.entrymodifier,entryentity.entrymodifydate,entryentity.licenseid");
    }

    public static Map<Long, DynamicObject> getOrgMap(List<Long> orgIds) {
        Map<Long, DynamicObject> orgMap = new HashMap<Long, DynamicObject>(10);
        TaxResult taxResult = TaxcOrgDataServiceHelper.queryTaxcOrgByOrgIdsAndTaxationsysId(orgIds, (Long)TaxationsysMappingEnum.CHN.getId(), (boolean)true);
        if (taxResult != null && taxResult.isSuccess()) {
            List orgs = (List)taxResult.getData();
            orgMap = orgs.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        }
        return orgMap;
    }

    public static Map<Long, Optional<String>> checkUnifiedsocialcode(List<DynamicObject> colls) {
        List orgIds = colls.stream().flatMap(obj -> obj.getDynamicObjectCollection("entryentity").stream()).map(entry -> entry.getDynamicObject("org").getLong("id")).collect(Collectors.toList());
        TaxResult taxResult = TaxcOrgDataServiceHelper.queryTaxcOrgByOrgIdsAndTaxationsysId(orgIds, (Long)TaxationsysMappingEnum.CHN.getId(), (boolean)true);
        HashMap<Long, Optional<String>> result = new HashMap<Long, Optional<String>>(10);
        if (taxResult != null && taxResult.isSuccess()) {
            List orgs = (List)taxResult.getData();
            Map<Long, DynamicObject> validOrgMap = orgs.stream().filter(v -> StringUtil.isNotEmpty((CharSequence)v.getString("unifiedsocialcode"))).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
            DynamicObjectCollection entries = null;
            block0: for (DynamicObject obj2 : colls) {
                entries = obj2.getDynamicObjectCollection("entryentity");
                result.put(obj2.getLong("id"), Optional.empty());
                for (DynamicObject entry2 : entries) {
                    Long orgid = entry2.getDynamicObject("org").getLong("id");
                    if (validOrgMap.containsKey(orgid)) continue;
                    result.put(obj2.getLong("id"), Optional.of(ResManager.loadKDString((String)"\u6240\u9009\u62e9\u7684\u6570\u636e\u4e2d\uff0c\u201c\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002\u8bf7\u5148\u5728\u201c\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u201d\u4e2d\u8865\u5168\u4fe1\u606f\u3002", (String)"TaxcLicenseApplyBusiness_1", (String)"taxc-tctb-business", (Object[])new Object[0])));
                    continue block0;
                }
            }
        }
        if (taxResult == null || !taxResult.isSuccess() || taxResult.getData() == null) {
            for (DynamicObject obj3 : colls) {
                result.put(obj3.getLong("id"), Optional.of(ResManager.loadKDString((String)"\u6240\u9009\u62e9\u7684\u6570\u636e\u4e2d\uff0c\u201c\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002\u8bf7\u5148\u5728\u201c\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u201d\u4e2d\u8865\u5168\u4fe1\u606f\u3002", (String)"TaxcLicenseApplyBusiness_1", (String)"taxc-tctb-business", (Object[])new Object[0])));
            }
        }
        return result;
    }

    public static Map<Long, Optional<String>> checkOnTheWay(List<DynamicObject> colls) {
        Map<Long, DynamicObject> map = colls.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        List<Long> licenseIds = colls.stream().flatMap(obj -> obj.getDynamicObjectCollection("entryentity").stream()).map(entry -> entry.getLong("licenseid")).collect(Collectors.toList());
        DynamicObject[] dbColls = TaxcLicenseApplyService.queryOnTheWayLicenseApply(licenseIds);
        List uniqueDbColls = Stream.of(dbColls).filter(obj -> !map.containsKey(obj.getLong("id"))).collect(Collectors.toList());
        colls.addAll(uniqueDbColls);
        Map<Long, List<DynamicObject>> groupMap = colls.stream().flatMap(obj -> obj.getDynamicObjectCollection("entryentity").stream()).collect(Collectors.groupingBy(obj -> obj.getLong("licenseid")));
        HashMap<Long, Optional<String>> result = new HashMap<Long, Optional<String>>(10);
        DynamicObjectCollection entries = null;
        block0: for (DynamicObject obj2 : colls) {
            entries = obj2.getDynamicObjectCollection("entryentity");
            result.put(obj2.getLong("id"), Optional.empty());
            for (DynamicObject entry2 : entries) {
                List<DynamicObject> values = groupMap.get(entry2.getLong("licenseid"));
                if (values == null || values.size() <= 1) continue;
                result.put(obj2.getLong("id"), Optional.of(ResManager.loadKDString((String)"\u6240\u52fe\u9009\u7684\u6570\u636e\u4e2d\u5305\u542b\u4e86\u6b63\u5728\u7533\u8bf7\u4e2d\u7684\u6570\u636e\uff0c\u8bf7\u52ff\u91cd\u590d\u7533\u8bf7\u3002", (String)"TaxcLicenseApplyBusiness_2", (String)"taxc-tctb-business", (Object[])new Object[0])));
                continue block0;
            }
        }
        return result;
    }

    public static Optional<String> checkLicenseEnough(DynamicObject[] coll) {
        Stream<Map<Long, List<DynamicObject>>> entryStream = Stream.of(coll).flatMap(obj -> obj.getDynamicObjectCollection("entryentity").stream());
        Map<Long, List<DynamicObject>> groupMap = entryStream.collect(Collectors.groupingBy(obj -> obj.getDynamicObject("group").getLong("id")));
        ArrayList<Long> groupIds = new ArrayList<Long>(10);
        for (Map.Entry<Long, List<DynamicObject>> entry : groupMap.entrySet()) {
            groupIds.add(entry.getKey());
        }
        Map<Long, Integer> licenseUsedMap = TaxcLicenseService.getLicenseUsedCount(groupIds);
        Map<String, List<DynamicObject>> applyStatusMap = null;
        int applyCount = 0;
        int cancelCount = 0;
        Long groupId = null;
        int usedCount = 0;
        for (Map.Entry<Long, List<DynamicObject>> entry : groupMap.entrySet()) {
            groupId = entry.getKey();
            Optional<String> result = TaxcLicenseBusiness.checkLicenseEnough(groupId, applyCount = ((List)(applyStatusMap = entry.getValue().stream().collect(Collectors.groupingBy(obj -> obj.getString("applystatus")))).getOrDefault("A", new ArrayList(1))).size(), cancelCount = ((List)applyStatusMap.getOrDefault("B", new ArrayList(1))).size(), usedCount = licenseUsedMap.getOrDefault(groupId, 0).intValue());
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }

    public static void syncUpdateTaxLicense(DynamicObject[] objs) {
        if (ObjectUtils.isEmpty((Object[])objs)) {
            return;
        }
        ArrayList<Long> orgIds = new ArrayList<Long>(10);
        ArrayList<Long> licenseIds = new ArrayList<Long>(10);
        Stream.of(objs).flatMap(obj -> obj.getDynamicObjectCollection("entryentity").stream()).forEach(entry -> {
            orgIds.add(entry.getDynamicObject("org").getLong("id"));
            licenseIds.add(entry.getLong("licenseid"));
        });
        DynamicObject[] taxLicenses = TaxcLicenseService.queryTaxLicenseByIds(licenseIds);
        Map<Long, DynamicObject> taxLicenseMap = Stream.of(taxLicenses).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        Map<Long, DynamicObject> orgMap = TaxcLicenseApplyService.getOrgMap(orgIds);
        ArrayList saveList = new ArrayList(10);
        Stream.of(objs).flatMap(obj -> obj.getDynamicObjectCollection("entryentity").stream()).forEach(entry -> {
            DynamicObject taxLicense = (DynamicObject)taxLicenseMap.get(entry.getLong("licenseid"));
            DynamicObject org = (DynamicObject)orgMap.get(entry.getDynamicObject("org").getLong("id"));
            TaxcLicenseApplyService.updateLicense(taxLicense, entry, org);
            saveList.add(taxLicense);
        });
        if (saveList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[saveList.size()]));
        }
    }

    private static void updateLicense(DynamicObject taxLicense, DynamicObject entry, DynamicObject org) {
        if (taxLicense == null || entry == null || org == null) {
            return;
        }
        String applyStatus = entry.getString("applystatus");
        Long groupId = taxLicense.getDynamicObject("group").getLong("id");
        if ("A".equalsIgnoreCase(applyStatus)) {
            taxLicense.set("unifiedsocialcode", org.get("unifiedsocialcode"));
            taxLicense.set("licensestatus", (Object)"B");
            taxLicense.set("activeuserid", (Object)RequestContext.get().getCurrUserId());
            taxLicense.set("activedate", (Object)new Date());
            taxLicense.set("password", (Object)LicenseGroupUtil.password((DynamicObject)taxLicense, (String)String.valueOf(groupId)));
        } else {
            taxLicense.set("canceluserid", (Object)RequestContext.get().getCurrUserId());
            taxLicense.set("canceldate", (Object)new Date());
            taxLicense.set("licensestatus", (Object)"C");
            taxLicense.set("password", (Object)LicenseGroupUtil.password((DynamicObject)taxLicense, (String)String.valueOf(groupId)));
        }
    }

    public static void syncUpdateTaxOrg(DynamicObject[] objs) {
        if (ObjectUtils.isEmpty((Object[])objs)) {
            return;
        }
        Stream entryStream = Stream.of(objs).flatMap(obj -> obj.getDynamicObjectCollection("entryentity").stream());
        ArrayList<Long> applyOrgIds = new ArrayList<Long>(10);
        ArrayList<Long> cancelOrgIds = new ArrayList<Long>(10);
        entryStream.forEach(entry -> {
            if ("A".equalsIgnoreCase(entry.getString("applystatus"))) {
                applyOrgIds.add(entry.getDynamicObject("org").getLong("id"));
            } else {
                cancelOrgIds.add(entry.getDynamicObject("org").getLong("id"));
            }
        });
        if (applyOrgIds.size() > 0) {
            TaxcLicenseApplyService.updateLicenceStatus(applyOrgIds, "B");
        }
        if (cancelOrgIds.size() > 0) {
            TaxcLicenseApplyService.updateLicenceStatus(cancelOrgIds, "C");
        }
    }

    private static void updateLicenceStatus(List<Long> orgids, String status) {
        try {
            DispatchServiceHelper.invokeBizService((String)"bamp", (String)"bastax", (String)"TaxOrgUpdateService", (String)"updateLicenceStatus", (Object[])new Object[]{orgids, status});
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }
}

