/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.business.taxclicense;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.constant.TaxcLicenseConstant;
import kd.taxc.enums.MultiLangEnumBridge;
import kd.taxc.license.LicenseGroupUtil;
import kd.taxc.tctb.business.taxclicense.TaxcLicenseCheckService;
import kd.taxc.tctb.business.taxclicense.TaxcLicenseDao;
import kd.taxc.tctb.business.taxclicense.TaxcLicenseDataSynService;
import kd.taxc.tctb.business.taxclicense.TaxcLicenseDefineService;
import kd.taxc.tctb.business.taxclicense.TaxcLicensePurchaseService;
import kd.taxc.tctb.business.taxclicense.TaxcLicenseService;
import org.apache.commons.lang3.ObjectUtils;

public class TaxcLicenseBusiness {
    private static final Log logger = LogFactory.getLog(TaxcLicenseBusiness.class);

    public static void licenseReduce() {
        HashSet<String> vers = new HashSet<String>(2);
        String ver = TaxcLicensePurchaseService.getVersion();
        vers.add(ver);
        logger.info("sys license ver:" + ver);
        TaxcLicenseBusiness.licenseReduce(vers);
    }

    public static void licenseReduce(Set<String> vers) {
        DynamicObject[] objs = TaxcLicenseBusiness.loadTaxLicenseFormByStatus("B");
        int usedNumber = objs != null ? objs.length : 0;
        int totalNumber = LicenseGroupUtil.getTotalNumber((String)(TaxcLicenseConstant.GROUP_TAXB + ""));
        ArrayList<DynamicObject> needUpdate = new ArrayList<DynamicObject>(100);
        logger.info("license info: used-" + usedNumber + "  total-" + totalNumber);
        if (totalNumber > 0 && usedNumber > totalNumber) {
            for (DynamicObject o : objs) {
                if (!vers.contains(o.getString("ver"))) continue;
                o.set("licensestatus", (Object)"D");
                needUpdate.add(o);
            }
            if (needUpdate.size() > 0) {
                logger.info("license reduce num:" + needUpdate.size());
                SaveServiceHelper.update((DynamicObject[])needUpdate.toArray(new DynamicObject[0]));
            }
        }
    }

    public static DynamicObject[] loadTaxLicenseFormByStatus(String licensestatus) {
        return TaxcLicenseDao.loadTaxLicenseFormByStatus(licensestatus);
    }

    public static int getLicensePurchaseQuantity(String groupId) {
        return TaxcLicensePurchaseService.getTotalNumber(groupId);
    }

    public static int getLicenseEmpowerQuantity(String groupId) {
        return TaxcLicenseService.getLicenseUsedCount(Long.valueOf(groupId));
    }

    public static String getLicenseVersion() {
        return TaxcLicensePurchaseService.getVersion();
    }

    public static boolean isFeaturesPurchaseQuantityByNodeId(String nodeid) {
        String bm = TaxcLicenseDefineService.getTxLicenseBmByid(TaxcLicensePurchaseService.getVersion(), nodeid);
        return TaxcLicensePurchaseService.checkPurchaseGroup(bm).getHasLicense();
    }

    public static Map<String, String> getAppPurchaseQuantity() {
        return TaxcLicensePurchaseService.getGmLicense();
    }

    public static boolean isQuotationMode() {
        return TaxcLicensePurchaseService.isQuotationMode(TaxcLicensePurchaseService.getVersion());
    }

    public static void syncData(String nodeId) {
        TaxcLicenseDataSynService.syncData(TaxcLicensePurchaseService.getVersion(), nodeId);
    }

    public static void delDate() {
        TaxcLicenseDataSynService.delDate();
    }

    public static DynamicObject queryTaxLicenseGroupById(Long groupid) {
        return TaxcLicenseService.queryTaxLicenseGroupById(groupid);
    }

    public static DynamicObject[] queryTaxLicenseByIds(List<Long> ids) {
        return TaxcLicenseService.queryTaxLicenseByIds(ids);
    }

    public static Optional<String> checkUnifiedsocialcode(DynamicObject[] coll) {
        return TaxcLicenseService.checkUnifiedsocialcode(coll);
    }

    public static Optional<String> checkOnTheWay(List<Long> licenseIds) {
        return TaxcLicenseService.checkOnTheWay(licenseIds);
    }

    public static Optional<String> checkLicenseEnough(Long groupId, int applyCount, int cancelCount) {
        return TaxcLicenseService.checkLicenseEnough(groupId, applyCount, cancelCount);
    }

    public static Optional<String> checkLicenseEnough(Long groupId, int applyCount, int cancelCount, int usedCount) {
        return TaxcLicenseService.checkLicenseEnough(groupId, applyCount, cancelCount, usedCount);
    }

    public static LicenseCheckResult checkTxftPerformGroup(String appid) {
        String verion = TaxcLicensePurchaseService.getVersion();
        if (verion.equals("3.0")) {
            return TaxcLicensePurchaseService.checkTAXBPerformGroup(appid);
        }
        if (TaxcLicenseDefineService.isTxLicense(appid)) {
            String bm = TaxcLicenseDefineService.getTxLicenseBmByMk(verion, appid);
            if ("".equals(bm)) {
                if (TaxcLicenseDefineService.isLicenseByAppid(appid, verion)) {
                    return TaxcLicensePurchaseService.checkTAXBPerformGroup(appid);
                }
                MultiLangEnumBridge name = TaxcLicenseDefineService.getTxLicenseNameByMk(appid);
                String str = ResManager.loadKDString((String)"\u8bf7\u8d2d\u4e70%s\u7279\u6027\u8bb8\u53ef", (String)"TaxcLicenseBusiness_3", (String)"taxc-tctb-business", (Object[])new Object[0]);
                return new LicenseCheckResult(Boolean.FALSE, String.format(str, name != null ? name.getDescription() : ""));
            }
            return TaxcLicensePurchaseService.checkPurchaseGroup(bm);
        }
        return TaxcLicensePurchaseService.checkTAXBPerformGroup(appid);
    }

    public static Map<String, Object> getTaxcLicenseInfo() {
        HashMap<String, Integer> pro = new HashMap<String, Integer>(4);
        int total = TaxcLicensePurchaseService.getTotalNumber("38");
        int used = TaxcLicenseService.getLicenseUsedCount(Long.valueOf("38"));
        pro.put("total", total);
        pro.put("used", used);
        HashMap<String, Integer> advance = new HashMap<String, Integer>(8);
        int txft = TaxcLicensePurchaseService.checkPurchaseGroup(TaxcLicenseDefineService.txLicenseEnum.TXFT.bm).getHasLicense() != false ? 1 : 0;
        int txcd = TaxcLicensePurchaseService.checkPurchaseGroup(TaxcLicenseDefineService.txLicenseEnum.TXCD.bm).getHasLicense() != false ? 1 : 0;
        int qhzdsy = TaxcLicensePurchaseService.checkPurchaseGroup(TaxcLicenseDefineService.txLicenseEnum.QHZDSY.bm).getHasLicense() != false ? 1 : 0;
        int tctsa = TaxcLicensePurchaseService.checkPurchaseGroup(TaxcLicenseDefineService.txLicenseEnum.TCTSA.bm).getHasLicense() != false ? 1 : 0;
        int tam = TaxcLicensePurchaseService.checkPurchaseGroup(TaxcLicenseDefineService.txLicenseEnum.TAM.bm).getHasLicense() != false ? 1 : 0;
        advance.put("txft", txft);
        advance.put("txcd", txcd);
        advance.put("qhzdsy", qhzdsy);
        advance.put("tctsa", tctsa);
        advance.put("tam", tam);
        HashMap<String, Object> licenseInfo = new HashMap<String, Object>(4);
        licenseInfo.put("pro", pro);
        licenseInfo.put("advance", advance);
        return licenseInfo;
    }

    public static List<Long> getOrgByAppId(String appid, String licensestatus) {
        String ver = TaxcLicenseBusiness.getLicenseVersion();
        String group = TaxcLicenseDefineService.getLicenseByAppid(appid, ver);
        ArrayList<Long> orgids = new ArrayList<Long>();
        if (null != group && !"".equals(group)) {
            DynamicObject[] dynamicObjects;
            for (DynamicObject v : dynamicObjects = TaxcLicenseService.getLicenseOrgIdByGroupAndstatus(Long.valueOf(group), licensestatus)) {
                orgids.add(v.getDynamicObject("orgid").getLong("id"));
            }
        }
        return orgids;
    }

    public static Map<String, Object> check(Object orgid, String appid) {
        String ver = TaxcLicenseBusiness.getLicenseVersion();
        if (ver.equals("3.0")) {
            return TaxcLicenseCheckService.check3(orgid, appid, "3.0");
        }
        String group = TaxcLicenseDefineService.getLicenseByAppid(appid, ver);
        return TaxcLicenseCheckService.check(orgid, appid, ver, group);
    }

    public static Map<Long, Boolean> checkBatch(List<Long> orgids, String appid) {
        HashMap<Long, Boolean> map = new HashMap<Long, Boolean>();
        if (ObjectUtils.isEmpty(orgids)) {
            return map;
        }
        List partition = Lists.partition(orgids, (int)500);
        partition.forEach(org -> map.putAll(TaxcLicenseBusiness.checkLicenseBatch(org, appid)));
        return map;
    }

    private static Map<Long, Boolean> checkLicenseBatch(List<Long> orgids, String appid) {
        String ver = TaxcLicenseBusiness.getLicenseVersion();
        if (ver.equals("3.0")) {
            return TaxcLicenseCheckService.check3Batch(orgids, appid, "3.0");
        }
        String group = TaxcLicenseDefineService.getLicenseByAppid(appid, ver);
        return TaxcLicenseCheckService.checkBatch(orgids, appid, ver, group);
    }
}

