/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.business.taxclicense;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.common.constant.LicenseCheckConstant;
import kd.taxc.license.LicenseGroupUtil;
import kd.taxc.tctb.business.taxclicense.TaxcLicenseCheckService;
import org.apache.commons.lang3.ObjectUtils;

@Deprecated
public class TaxcLicenseCheckBusiness {
    public static LicenseCheckResult checkTxftPerformGroup(String appid) {
        LicenseCheckResult licenseCheckResult = null;
        licenseCheckResult = StringUtils.equalsIgnoreCase((CharSequence)appid, (CharSequence)LicenseCheckConstant.getTCDRSLicenseByMk()) ? ("4.0".equals(LicenseGroupUtil.getVersion()) || "5.0".equals(LicenseGroupUtil.getVersion()) || "6.0".equals(LicenseGroupUtil.getVersion()) ? LicenseGroupUtil.checkTxftPerformGroup() : new LicenseCheckResult(Boolean.FALSE, ResManager.loadKDString((String)"\u8bf7\u8d2d\u4e70\u8ba1\u7a0e\u5e95\u7a3f\u670d\u52a1\u7279\u6027\u8bb8\u53ef", (String)"TaxcLicenseCheckBusiness_0", (String)"taxc-tctb-business", (Object[])new Object[0]))) : (StringUtils.equalsIgnoreCase((CharSequence)appid, (CharSequence)LicenseCheckConstant.getTSDCSLicenseByMk()) ? ("5.0".equals(LicenseGroupUtil.getVersion()) || "6.0".equals(LicenseGroupUtil.getVersion()) ? LicenseGroupUtil.checkTxcdPerformGroup() : new LicenseCheckResult(Boolean.FALSE, ResManager.loadKDString((String)"\u8bf7\u8d2d\u4e70\u7a0e\u4f01\u76f4\u8fde\u7279\u6027\u8bb8\u53ef", (String)"TaxcLicenseCheckBusiness_1", (String)"taxc-tctb-business", (Object[])new Object[0]))) : (StringUtils.equalsIgnoreCase((CharSequence)appid, (CharSequence)LicenseCheckConstant.getQHZDSYLicenseByMk()) ? ("6.0".equals(LicenseGroupUtil.getVersion()) ? LicenseGroupUtil.checkQHZDSYPerformGroup() : new LicenseCheckResult(Boolean.FALSE, ResManager.loadKDString((String)"\u8bf7\u8d2d\u4e70\u5343\u6237\u53ca\u91cd\u70b9\u7a0e\u6e90\u7279\u6027\u8bb8\u53ef", (String)"TaxcLicenseCheckBusiness_2", (String)"taxc-tctb-business", (Object[])new Object[0]))) : (StringUtils.equalsIgnoreCase((CharSequence)appid, (CharSequence)LicenseCheckConstant.getTCTSALicenseByMk()) ? ("6.0".equals(LicenseGroupUtil.getVersion()) ? LicenseGroupUtil.checkTCTSAPerformGroup() : LicenseGroupUtil.checkTAXBPerformGroup((String)appid)) : (StringUtils.equalsIgnoreCase((CharSequence)appid, (CharSequence)LicenseCheckConstant.getTAMLicenseByMk()) ? ("6.0".equals(LicenseGroupUtil.getVersion()) ? LicenseGroupUtil.checkTamPerformGroup() : new LicenseCheckResult(Boolean.FALSE, ResManager.loadKDString((String)"\u8bf7\u8d2d\u4e70\u62a5\u7a0e\u5de5\u4f5c\u53f0\u7279\u6027\u8bb8\u53ef", (String)"TaxcLicenseCheckBusiness_3", (String)"taxc-tctb-business", (Object[])new Object[0]))) : LicenseGroupUtil.checkTAXBPerformGroup((String)appid)))));
        return licenseCheckResult;
    }

    public static List<Long> getOrgByAppId(String appid, String licensestatus) {
        QFilter qFilter = new QFilter("licensestatus", "=", (Object)licensestatus);
        QFilter groupQf = null;
        String group = "";
        if (LicenseGroupUtil.getVersion().startsWith("6.0")) {
            group = LicenseCheckConstant.getV6LicenseByAppid((String)appid);
        } else if (LicenseGroupUtil.getVersion().startsWith("5.0")) {
            group = LicenseCheckConstant.getV5LicenseByAppid((String)appid);
        } else if (LicenseGroupUtil.getVersion().startsWith("4.0")) {
            group = LicenseCheckConstant.getV4LicenseByAppid((String)appid);
        }
        if (LicenseGroupUtil.getVersion().startsWith("3.0")) {
            group = LicenseCheckConstant.getV3LicenseByAppid((String)appid);
        }
        if (!"".equals(group)) {
            groupQf = new QFilter("group", "=", (Object)Long.valueOf(group));
        }
        List<Long> orgids = new ArrayList<Long>();
        if (null != groupQf) {
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"tctb_license_from", (String)"orgid", (QFilter[])new QFilter[]{qFilter, groupQf});
            orgids = dynamicObjects.stream().map(v -> v.getLong("orgid")).collect(Collectors.toList());
        }
        return orgids;
    }

    public static Map<String, Object> check(Object orgid, String appid) {
        if (LicenseGroupUtil.getVersion().startsWith("6.0")) {
            String group = LicenseCheckConstant.getV6LicenseByAppid((String)appid);
            return TaxcLicenseCheckService.check(orgid, appid, LicenseGroupUtil.getVersion(), group);
        }
        if (LicenseGroupUtil.getVersion().startsWith("5.0")) {
            String group = LicenseCheckConstant.getV5LicenseByAppid((String)appid);
            return TaxcLicenseCheckService.check(orgid, appid, LicenseGroupUtil.getVersion(), group);
        }
        if (LicenseGroupUtil.getVersion().startsWith("4.0")) {
            String group = LicenseCheckConstant.getV4LicenseByAppid((String)appid);
            return TaxcLicenseCheckService.check(orgid, appid, LicenseGroupUtil.getVersion(), group);
        }
        return TaxcLicenseCheckService.check3(orgid, appid, "3.0");
    }

    public static Map<Long, Boolean> checkBatch(List<Long> orgids, String appid) {
        HashMap<Long, Boolean> map = new HashMap<Long, Boolean>();
        if (ObjectUtils.isEmpty(orgids)) {
            return map;
        }
        List partition = Lists.partition(orgids, (int)500);
        partition.forEach(org -> map.putAll(TaxcLicenseCheckBusiness.checkLicenseBatch(org, appid)));
        return map;
    }

    private static Map<Long, Boolean> checkLicenseBatch(List<Long> orgids, String appid) {
        if (LicenseGroupUtil.getVersion().startsWith("6.0")) {
            String group = LicenseCheckConstant.getV6LicenseByAppid((String)appid);
            return TaxcLicenseCheckService.checkBatch(orgids, appid, LicenseGroupUtil.getVersion(), group);
        }
        if (LicenseGroupUtil.getVersion().startsWith("5.0")) {
            String group = LicenseCheckConstant.getV5LicenseByAppid((String)appid);
            return TaxcLicenseCheckService.checkBatch(orgids, appid, LicenseGroupUtil.getVersion(), group);
        }
        if (LicenseGroupUtil.getVersion().startsWith("4.0")) {
            String group = LicenseCheckConstant.getV4LicenseByAppid((String)appid);
            return TaxcLicenseCheckService.checkBatch(orgids, appid, LicenseGroupUtil.getVersion(), group);
        }
        return TaxcLicenseCheckService.check3Batch(orgids, appid, "3.0");
    }

    public static Map<String, Object> getTaxcLicenseInfo() {
        HashMap<String, Integer> pro = new HashMap<String, Integer>(4);
        int total = LicenseGroupUtil.getTotalNumber((String)"38");
        DynamicObjectCollection assignedCount = QueryServiceHelper.query((String)"tctb_license_from", (String)"id,unifiedsocialcode", (QFilter[])new QFilter[]{new QFilter("group", "=", (Object)Integer.parseInt("38")), new QFilter("licensestatus", "=", (Object)"B"), new QFilter("ver", "=", (Object)LicenseGroupUtil.getVersion())});
        int used = assignedCount.size();
        pro.put("total", total);
        pro.put("used", used);
        HashMap<String, Integer> advance = new HashMap<String, Integer>(8);
        int txft = LicenseGroupUtil.checkTxftPerformGroup().getHasLicense() != false ? 1 : 0;
        int txcd = LicenseGroupUtil.checkTxcdPerformGroup().getHasLicense() != false ? 1 : 0;
        int qhzdsy = LicenseGroupUtil.checkQHZDSYPerformGroup().getHasLicense() != false ? 1 : 0;
        int tctsa = LicenseGroupUtil.checkTCTSAPerformGroup().getHasLicense() != false ? 1 : 0;
        int tam = LicenseGroupUtil.checkTamPerformGroup().getHasLicense() != false ? 1 : 0;
        advance.put("txft", txft);
        advance.put("txcd", txcd);
        advance.put("qhzdsy", qhzdsy);
        advance.put("tctsa", tctsa);
        advance.put("tam", tam);
        HashMap<String, Object> licenseInfo = new HashMap<String, Object>(4);
        licenseInfo.put("pro", pro);
        licenseInfo.put("advance", advance);
        return licenseInfo;
    }
}

