/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.business.taxclicense;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.errorcode.TaxcErrorCode;
import kd.taxc.common.util.EmptyCheckUtils;
import kd.taxc.common.util.TreeUtils;
import kd.taxc.tctb.business.taxclicense.TaxcLicenseDefineService;
import kd.taxc.tctb.business.taxclicense.TaxcLicensePurchaseService;

public class TaxcLicenseCheckService {
    public static Map<String, Object> result(String code, String failInfo, Boolean issuccess, Object data) {
        return TaxcLicenseCheckService.createReturnResultObject(issuccess, code, failInfo, data);
    }

    public static Map<String, Object> check3(Object orgid, String appid, String ver) {
        String group = TaxcLicenseDefineService.getV3LicenseByAppid(appid);
        if (!"".equals(group)) {
            LicenseCheckResult result = TaxcLicensePurchaseService.checkTAXBPerformGroup(appid);
            if (!result.getHasLicense().booleanValue()) {
                return TaxcLicenseCheckService.result(TaxcErrorCode.TAXC_SUCCESS_CODE.getCode(), result.getMsg(), Boolean.TRUE, Boolean.TRUE);
            }
            return TaxcLicenseCheckService.check(orgid, group, true, ver);
        }
        return TaxcLicenseCheckService.result(TaxcErrorCode.TAXC_SUCCESS_CODE.getCode(), "", Boolean.TRUE, Boolean.FALSE);
    }

    public static Map<String, Object> check(Object orgid, String appid, String ver, String group) {
        if (!"".equals(group)) {
            LicenseCheckResult result = TaxcLicensePurchaseService.checkTAXBPerformGroup(appid);
            if (!result.getHasLicense().booleanValue()) {
                return TaxcLicenseCheckService.result(TaxcErrorCode.TAXC_SUCCESS_CODE.getCode(), result.getMsg(), Boolean.TRUE, Boolean.TRUE);
            }
            return TaxcLicenseCheckService.check(orgid, group, true, ver);
        }
        return TaxcLicenseCheckService.result(TaxcErrorCode.TAXC_SUCCESS_CODE.getCode(), "", Boolean.TRUE, Boolean.FALSE);
    }

    public static Map<Long, Boolean> checkBatch(List<Long> orgids, String appid, String ver, String group) {
        HashMap<Long, Boolean> resultMap = new HashMap<Long, Boolean>();
        if (null == appid || "".equals(appid)) {
            orgids.forEach(v -> resultMap.put((Long)v, Boolean.FALSE));
            return resultMap;
        }
        if (!"".equals(group)) {
            LicenseCheckResult result = TaxcLicensePurchaseService.checkTAXBPerformGroup(appid);
            if (!result.getHasLicense().booleanValue()) {
                orgids.forEach(v -> resultMap.put((Long)v, Boolean.TRUE));
                return resultMap;
            }
            return TaxcLicenseCheckService.checkLicenseBatch(orgids, group, true, ver);
        }
        return resultMap;
    }

    public static Map<Long, Boolean> check3Batch(List<Long> orgids, String appid, String ver) {
        HashMap<Long, Boolean> resultMap = new HashMap<Long, Boolean>();
        if (null == appid || "".equals(appid)) {
            orgids.forEach(v -> resultMap.put((Long)v, Boolean.FALSE));
            return resultMap;
        }
        String group = TaxcLicenseDefineService.getV3LicenseByAppid(appid);
        if (!"".equals(group)) {
            LicenseCheckResult result = TaxcLicensePurchaseService.checkTAXBPerformGroup(appid);
            if (!result.getHasLicense().booleanValue()) {
                orgids.forEach(v -> resultMap.put((Long)v, Boolean.TRUE));
                return resultMap;
            }
            return TaxcLicenseCheckService.checkLicenseBatch(orgids, group, true, ver);
        }
        return resultMap;
    }

    private static Map<String, Object> check(Object orgid, String taxb, boolean isCheck, String ver) {
        if (isCheck) {
            DynamicObjectCollection doc = QueryServiceHelper.query((String)"tctb_license_from", (String)"id,orgid,orgid.name,licensestatus", (QFilter[])new QFilter[]{new QFilter("orgid", "=", (Object)Long.parseLong(orgid.toString())), new QFilter("group", "=", (Object)Long.parseLong(taxb)), new QFilter("ver", "=", (Object)ver)});
            if (doc.size() > 0) {
                String licensestatus = ((DynamicObject)doc.get(0)).getString("licensestatus");
                if ("A".equals(licensestatus) || "D".equals(licensestatus)) {
                    return TaxcLicenseCheckService.result(TaxcErrorCode.TAXC_SUCCESS_CODE.getCode(), String.format(TaxcLicenseCheckService.getMsgA(), ((DynamicObject)doc.get(0)).getString("orgid.name")), Boolean.TRUE, Boolean.TRUE);
                }
                if ("C".equals(licensestatus)) {
                    return TaxcLicenseCheckService.result(TaxcErrorCode.TAXC_SUCCESS_CODE.getCode(), String.format(TaxcLicenseCheckService.getMsgB(), ((DynamicObject)doc.get(0)).getString("orgid.name")), Boolean.TRUE, Boolean.TRUE);
                }
                if ("B".equals(licensestatus)) {
                    DynamicObjectCollection unifiedsocialcode = QueryServiceHelper.query((String)"bastax_taxorg", (String)"unifiedsocialcode", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)Long.parseLong(orgid.toString()))});
                    if (unifiedsocialcode.size() > 0) {
                        DynamicObjectCollection org = QueryServiceHelper.query((String)"tctb_license_from", (String)"id,unifiedsocialcode,orgid,licensestatus,group,password", (QFilter[])new QFilter[]{new QFilter("group", "=", (Object)Long.parseLong(taxb)), new QFilter("orgid", "=", (Object)Long.parseLong(orgid.toString())), new QFilter("unifiedsocialcode", "=", ((DynamicObject)unifiedsocialcode.get(0)).get("unifiedsocialcode")), new QFilter("ver", "=", (Object)ver)});
                        if (org.size() > 0) {
                            return TaxcLicenseCheckService.result(TaxcErrorCode.TAXC_SUCCESS_CODE.getCode(), "", Boolean.TRUE, Boolean.FALSE);
                        }
                        return TaxcLicenseCheckService.result(TaxcErrorCode.TAXC_SUCCESS_CODE.getCode(), String.format(TaxcLicenseCheckService.getMsgC(), ((DynamicObject)doc.get(0)).getString("orgid.name")), Boolean.TRUE, Boolean.TRUE);
                    }
                    return TaxcLicenseCheckService.result(TaxcErrorCode.TAXC_SUCCESS_CODE.getCode(), String.format(TaxcLicenseCheckService.getMsgA(), ((DynamicObject)doc.get(0)).getString("orgid.name")), Boolean.TRUE, Boolean.TRUE);
                }
                return TaxcLicenseCheckService.result(TaxcErrorCode.TAXC_SUCCESS_CODE.getCode(), String.format(TaxcLicenseCheckService.getMsgA(), ((DynamicObject)doc.get(0)).getString("orgid.name")), Boolean.TRUE, Boolean.TRUE);
            }
            DynamicObjectCollection dcs = TreeUtils.getOrgLists();
            DynamicObject orgId = null;
            for (DynamicObject temp : dcs) {
                if (temp.getLong("id") != Long.parseLong(orgid.toString())) continue;
                orgId = temp;
                break;
            }
            if (null != orgId) {
                return TaxcLicenseCheckService.result(TaxcErrorCode.TAXC_SUCCESS_CODE.getCode(), String.format(TaxcLicenseCheckService.getMsgA(), orgId.get("name")), Boolean.TRUE, Boolean.TRUE);
            }
            return TaxcLicenseCheckService.result(TaxcErrorCode.TAXC_SUCCESS_CODE.getCode(), TaxcLicenseCheckService.getMsgD(), Boolean.TRUE, Boolean.TRUE);
        }
        return TaxcLicenseCheckService.result(TaxcErrorCode.TAXC_SUCCESS_CODE.getCode(), "", Boolean.TRUE, Boolean.FALSE);
    }

    private static Map<Long, Boolean> checkLicenseBatch(List<Long> orgids, String taxb, boolean isCheck, String ver) {
        HashMap<Long, Boolean> resultMap = new HashMap<Long, Boolean>();
        if (isCheck) {
            DynamicObjectCollection doc = QueryServiceHelper.query((String)"tctb_license_from", (String)"id,orgid,orgid.name,licensestatus", (QFilter[])new QFilter[]{new QFilter("orgid", "in", orgids), new QFilter("group", "=", (Object)Long.parseLong(taxb)), new QFilter("ver", "=", (Object)ver)});
            if (doc.size() > 0) {
                Map<Long, String> collect = doc.stream().collect(Collectors.toMap(k -> k.getLong("orgid"), v -> v.getString("licensestatus"), (k1, k2) -> k1));
                DynamicObjectCollection unifiedsocialcode = QueryServiceHelper.query((String)"bastax_taxorg", (String)"id,unifiedsocialcode", (QFilter[])new QFilter[]{new QFilter("org", "in", orgids)});
                if (EmptyCheckUtils.isEmpty((Object)unifiedsocialcode)) {
                    orgids.forEach(v -> resultMap.put((Long)v, Boolean.TRUE));
                } else {
                    Map<Long, String> mappingOrgLicense = unifiedsocialcode.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v.getString("unifiedsocialcode"), (k1, k2) -> k1));
                    List list = unifiedsocialcode.stream().map(e -> e.getString("unifiedsocialcode")).collect(Collectors.toList());
                    if (EmptyCheckUtils.isEmpty(list)) {
                        orgids.forEach(v -> resultMap.put((Long)v, Boolean.TRUE));
                    } else {
                        DynamicObjectCollection license = QueryServiceHelper.query((String)"tctb_license_from", (String)"id,unifiedsocialcode,orgid,licensestatus,group,password", (QFilter[])new QFilter[]{new QFilter("group", "=", (Object)Long.parseLong(taxb)), new QFilter("orgid", "in", orgids), new QFilter("unifiedsocialcode", "in", list), new QFilter("ver", "=", (Object)ver)});
                        if (EmptyCheckUtils.isEmpty((Object)license)) {
                            orgids.forEach(v -> resultMap.put((Long)v, Boolean.TRUE));
                        } else {
                            Map<Long, String> mappingLicenseOrg = license.stream().collect(Collectors.toMap(k -> k.getLong("orgid"), v -> v.getString("unifiedsocialcode"), (k1, k2) -> k1));
                            collect.forEach((key, licenseStatus) -> {
                                if (StringUtils.equals((CharSequence)"A", (CharSequence)licenseStatus) || StringUtils.equals((CharSequence)"C", (CharSequence)licenseStatus) || StringUtils.equals((CharSequence)"D", (CharSequence)licenseStatus)) {
                                    resultMap.put((Long)key, Boolean.TRUE);
                                } else if (StringUtils.equals((CharSequence)"B", (CharSequence)licenseStatus)) {
                                    String licenseOrgTaxNo;
                                    String orgLicenseTaxNo = (String)mappingOrgLicense.get(key);
                                    if (!StringUtils.equals((CharSequence)orgLicenseTaxNo, (CharSequence)(licenseOrgTaxNo = (String)mappingLicenseOrg.get(key)))) {
                                        resultMap.put((Long)key, Boolean.TRUE);
                                    } else {
                                        resultMap.put((Long)key, Boolean.FALSE);
                                    }
                                } else {
                                    resultMap.put((Long)key, Boolean.TRUE);
                                }
                            });
                        }
                    }
                }
            } else {
                DynamicObjectCollection dcs = TreeUtils.getOrgLists();
                List<Long> orgList = dcs.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
                orgList.retainAll(orgids);
                orgList.forEach(v -> resultMap.put((Long)v, Boolean.TRUE));
            }
        } else {
            orgids.forEach(v -> resultMap.put((Long)v, Boolean.FALSE));
        }
        return resultMap;
    }

    private static String getMsgA() {
        return TaxcErrorCode.TAXC_LICENSE_CODE_NOT_ACTIVATE.getMessage();
    }

    private static String getMsgB() {
        return TaxcErrorCode.TAXC_LICENSE_CODE_CANCELED.getMessage();
    }

    private static String getMsgC() {
        return TaxcErrorCode.TAXC_LICENSE_CODE_NOT_SAME.getMessage();
    }

    private static String getMsgD() {
        return TaxcErrorCode.TAXC_LICENSE_CODE_NOT_TAXC_ORG.getMessage();
    }

    private static Map<String, Object> createReturnResultObject(Boolean success, String code, String message, Object data) {
        HashMap<String, Object> returnResult = new HashMap<String, Object>();
        returnResult.put("success", success);
        returnResult.put("code", code);
        returnResult.put("message", message);
        returnResult.put("data", data);
        return returnResult;
    }
}

