/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.business.taxclicense;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.common.util.TreeUtils;
import kd.taxc.tctb.business.taxclicense.TaxcLicensePurchaseService;

public class TaxcLicenseDataSynService {
    private static Log logger = LogFactory.getLog(TaxcLicenseDataSynService.class);
    private static String TCTB_LICENSE_FROM = "tctb_license_from";

    public static void delDate() {
        DeleteServiceHelper.delete((String)TCTB_LICENSE_FROM, (QFilter[])new QFilter[]{new QFilter("group", "=", (Object)0)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void syncData(String ver, String group) {
        DLock lock = null;
        try {
            lock = DLock.create((String)"taxc/license/syncData");
            boolean getLock = lock.tryLock();
            if (getLock) {
                TaxcLicenseDataSynService.deleteData();
                TaxcLicenseDataSynService.sysData(group);
            } else {
                logger.info("TaxcLicenseDataSynBusiness.syncData\u6ca1\u6709\u62ff\u5230\u9501\uff01");
            }
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    private static void deleteData() {
        StringBuilder existSql = new StringBuilder();
        existSql.append("select forgid from t_tctb_license_from group by forgid,fgroupid,fver having count(1)>1");
        HashSet<Long> orgIds = new HashSet<Long>(10);
        try (DataSet dataSet = DB.queryDataSet((String)TaxcLicenseDataSynService.class.getName(), (DBRoute)DBRoute.of((String)"taxc"), (String)existSql.toString());){
            if (dataSet == null || !dataSet.hasNext()) {
                return;
            }
            for (Row row : dataSet) {
                orgIds.add(row.getLong("forgid"));
            }
        }
        if (orgIds.size() == 0) {
            return;
        }
        SqlBuilder querySql = new SqlBuilder();
        querySql.append(" select fid ,forgid ,fgroupid ,fver FROM t_tctb_license_from  where ", new Object[0]);
        querySql.appendIn("forgid", orgIds.toArray()).append(" order by forgid,fgroupid,fver,flicensestatus desc", new Object[0]);
        ArrayList<Long> deleteIds = new ArrayList<Long>(100);
        HashMap<String, Long> retainIdMap = new HashMap<String, Long>(100);
        try (DataSet dataSet = DB.queryDataSet((String)TaxcLicenseDataSynService.class.getName(), (DBRoute)DBRoute.of((String)"taxc"), (SqlBuilder)querySql);){
            for (Row row : dataSet) {
                String groupKey = String.format("%s_%s_%s", row.getString("forgid"), row.getString("fgroupid"), row.getString("fver"));
                Object value = retainIdMap.get(groupKey);
                if (value == null) {
                    retainIdMap.put(groupKey, row.getLong("fid"));
                    continue;
                }
                deleteIds.add(row.getLong("fid"));
            }
        }
        if (!deleteIds.isEmpty()) {
            SqlBuilder deleteSql = new SqlBuilder();
            deleteSql.append(" delete from t_tctb_license_from where ", new Object[0]);
            deleteSql.appendIn("fid", deleteIds);
            DB.execute((DBRoute)DBRoute.of((String)"taxc"), (SqlBuilder)deleteSql);
            logger.info("TaxcLicenseDataSynBusiness.deleteData,deleteIds:{}", (Object)((Object)deleteIds).toString());
        }
    }

    private static void sysData(Object nodeId) {
        if (null != nodeId && "38".equals(nodeId.toString())) {
            String version = TaxcLicensePurchaseService.getVersion();
            if (version.startsWith("7")) {
                DynamicObjectCollection history_data = TaxcLicenseDataSynService.queryHistoryV7Data(nodeId);
                TaxcLicenseDataSynService.saveData(history_data, nodeId, version);
            } else if (version.startsWith("6")) {
                DynamicObjectCollection history_data = TaxcLicenseDataSynService.queryHistoryV6Data(nodeId);
                TaxcLicenseDataSynService.saveData(history_data, nodeId, version);
            } else if (version.startsWith("5")) {
                DynamicObjectCollection history_data = TaxcLicenseDataSynService.queryHistoryV5Data(nodeId);
                TaxcLicenseDataSynService.saveData(history_data, nodeId, version);
            } else if (version.startsWith("4")) {
                DynamicObjectCollection history_data = TaxcLicenseDataSynService.queryHistoryV4Data(nodeId);
                TaxcLicenseDataSynService.saveData(history_data, nodeId, version);
            } else {
                DynamicObjectCollection tctb = QueryServiceHelper.query((String)"tctb_license", (String)"orgfield,licensestatus,activeuserid,canceluserid,activedate,canceldate", (QFilter[])new QFilter[]{new QFilter("status", "!=", (Object)"1")});
                DynamicObjectCollection dos = TreeUtils.getOrgLists();
                DynamicObjectCollection doc1 = QueryServiceHelper.query((String)"bastax_taxorg", (String)"id,unifiedsocialcode", null);
                HashMap<String, DynamicObject> doc = new HashMap<String, DynamicObject>();
                for (DynamicObject d : doc1) {
                    doc.put(d.getString("id"), d);
                }
                TaxcLicenseDataSynService.sysData3(nodeId, doc, tctb, dos);
            }
        }
    }

    private static void sysData3(Object nodeId, Map<String, DynamicObject> doc, DynamicObjectCollection tctb, DynamicObjectCollection dos) {
        DynamicObject d;
        DynamicObject temp;
        if (null == nodeId) {
            return;
        }
        DynamicObjectCollection result = QueryServiceHelper.query((String)TCTB_LICENSE_FROM, (String)"orgid", (QFilter[])new QFilter[]{new QFilter("group", "=", (Object)Integer.parseInt((String)nodeId)), new QFilter("ver", "=", (Object)"3.0")});
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>();
        for (DynamicObject d2 : result) {
            map.put(d2.getString("orgid"), d2);
        }
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        for (DynamicObject r : tctb) {
            temp = (DynamicObject)map.get(r.getString("orgfield"));
            if (null != temp) continue;
            d = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)TCTB_LICENSE_FROM));
            d.set("orgid", (Object)r.getString("orgfield"));
            map.put(r.getString("orgfield"), d);
            d.set("group", nodeId);
            d.set("ver", (Object)"3.0");
            if (null != doc.get(r.getString("orgfield"))) {
                d.set("unifiedsocialcode", doc.get(r.getString("orgfield")).get("unifiedsocialcode"));
            }
            if ("34".equals(nodeId)) {
                d.set("licensestatus", r.get("licensestatus"));
                d.set("activeuserid", r.get("activeuserid"));
                d.set("canceluserid", r.get("canceluserid"));
                d.set("activedate", r.get("activedate"));
                d.set("canceldate", r.get("canceldate"));
            } else {
                d.set("licensestatus", (Object)"A");
            }
            d.set("password", (Object)"");
            list.add(d);
        }
        for (DynamicObject r : dos) {
            temp = (DynamicObject)map.get(r.getString("id"));
            if (null != temp || null == doc.get(r.getString("id"))) continue;
            d = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)TCTB_LICENSE_FROM));
            d.set("orgid", (Object)r.getString("id"));
            map.put(r.getString("id"), d);
            d.set("group", nodeId);
            d.set("unifiedsocialcode", doc.get(r.getString("id")).get("unifiedsocialcode"));
            d.set("licensestatus", (Object)"A");
            d.set("ver", (Object)"3.0");
            d.set("password", (Object)"");
            list.add(d);
        }
        if (list.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[1]));
        }
    }

    private static DynamicObjectCollection queryHistoryV7Data(Object nodeId) {
        DynamicObjectCollection doc_ver_6 = TaxcLicenseDataSynService.queryDataByVer(nodeId, "6.0");
        if (doc_ver_6.size() > 0) {
            return doc_ver_6;
        }
        return TaxcLicenseDataSynService.queryHistoryV6Data(nodeId);
    }

    private static DynamicObjectCollection queryHistoryV6Data(Object nodeId) {
        DynamicObjectCollection doc_ver_5 = TaxcLicenseDataSynService.queryDataByVer(nodeId, "5.0");
        if (doc_ver_5.size() > 0) {
            return doc_ver_5;
        }
        return TaxcLicenseDataSynService.queryHistoryV5Data(nodeId);
    }

    private static DynamicObjectCollection queryHistoryV5Data(Object nodeId) {
        DynamicObjectCollection doc_ver_4 = TaxcLicenseDataSynService.queryDataByVer(nodeId, "4.0");
        if (doc_ver_4.size() > 0) {
            return doc_ver_4;
        }
        return TaxcLicenseDataSynService.queryHistoryV4Data(nodeId);
    }

    private static DynamicObjectCollection queryHistoryV4Data(Object nodeId) {
        DynamicObjectCollection doc_ver_3 = TaxcLicenseDataSynService.queryDataByVer(nodeId, "3.0");
        if (doc_ver_3.size() > 0) {
            return doc_ver_3;
        }
        return new DynamicObjectCollection();
    }

    private static DynamicObjectCollection queryDataByVer(Object nodeId, String ver) {
        DynamicObjectCollection docs = QueryServiceHelper.query((String)TCTB_LICENSE_FROM, (String)"orgid,unifiedsocialcode,licensestatus,activeuserid,canceluserid,activedate,canceldate,ver", (QFilter[])new QFilter[]{new QFilter("group", "=", (Object)Integer.parseInt((String)nodeId)), new QFilter("ver", "in", (Object)new String[]{ver}), new QFilter("licensestatus", "in", (Object)new String[]{"B", "C"})});
        return docs;
    }

    private static void saveData(DynamicObjectCollection tctb, Object nodeId, String ver) {
        DynamicObject d;
        DynamicObject temp;
        DynamicObjectCollection doc1 = QueryServiceHelper.query((String)"bastax_taxorg", (String)"id,unifiedsocialcode", null);
        HashMap<String, DynamicObject> doc = new HashMap<String, DynamicObject>();
        for (DynamicObject d2 : doc1) {
            doc.put(d2.getString("id"), d2);
        }
        DynamicObjectCollection dos = TreeUtils.getOrgLists();
        DynamicObjectCollection result = QueryServiceHelper.query((String)TCTB_LICENSE_FROM, (String)"orgid", (QFilter[])new QFilter[]{new QFilter("group", "=", (Object)Integer.parseInt((String)nodeId)), new QFilter("ver", "=", (Object)ver)});
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>();
        for (DynamicObject d3 : result) {
            map.put(d3.getString("orgid"), d3);
        }
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        for (DynamicObject r : tctb) {
            temp = (DynamicObject)map.get(r.getString("orgid"));
            if (null != temp) continue;
            d = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)TCTB_LICENSE_FROM));
            d.set("orgid", (Object)r.getString("orgid"));
            map.put(r.getString("orgid"), d);
            d.set("group", nodeId);
            d.set("ver", (Object)ver);
            d.set("unifiedsocialcode", (Object)r.getString("unifiedsocialcode"));
            d.set("licensestatus", r.get("licensestatus"));
            d.set("activeuserid", r.get("activeuserid"));
            d.set("canceluserid", r.get("canceluserid"));
            d.set("activedate", r.get("activedate"));
            d.set("canceldate", r.get("canceldate"));
            d.set("password", (Object)"");
            list.add(d);
        }
        for (DynamicObject r : dos) {
            temp = (DynamicObject)map.get(r.getString("id"));
            if (null != temp || null == doc.get(r.getString("id"))) continue;
            d = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)TCTB_LICENSE_FROM));
            d.set("orgid", (Object)r.getString("id"));
            map.put(r.getString("id"), d);
            d.set("group", nodeId);
            d.set("unifiedsocialcode", ((DynamicObject)doc.get(r.getString("id"))).get("unifiedsocialcode"));
            d.set("licensestatus", (Object)"A");
            d.set("ver", (Object)ver);
            d.set("password", (Object)"");
            list.add(d);
        }
        if (list.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[1]));
        }
    }
}

