/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.business.taxclicense;

import kd.taxc.enums.MultiLangEnumBridge;

public class TaxcLicenseDefineService {
    public static final String LICENSE_LOCK_KEY = "taxc/license/syncData";
    public static final String PRO_TAXB = "34";
    public static final String PRO_TAXP = "35";
    public static final String PRO_TAXM = "37";
    public static final String TAXB = "38";
    public static final String v_7 = "7.0";
    public static final String v_6 = "6.0";
    public static final String v_5 = "5.0";
    public static final String v_4 = "4.0";
    public static final String v_3 = "3.0";

    public static String getTxLicenseBmByid(String version, String fid) {
        for (txLicenseVerEnum t : txLicenseVerEnum.values()) {
            txLicenseEnum[] values;
            if (!t.getVer().equals(version)) continue;
            for (txLicenseEnum v : values = t.getEnumver()) {
                if (!fid.equalsIgnoreCase(v.getId())) continue;
                return v.getBm();
            }
        }
        return "";
    }

    public static MultiLangEnumBridge getTxLicenseNameByMk(String mk) {
        txLicenseEnum[] values;
        for (txLicenseEnum v : values = txLicenseEnum.values()) {
            if (!mk.equalsIgnoreCase(v.getMk())) continue;
            return v.getName();
        }
        return null;
    }

    public static String getTxLicenseBmByMk(String version, String mk) {
        for (txLicenseVerEnum t : txLicenseVerEnum.values()) {
            txLicenseEnum[] values;
            if (!t.getVer().equals(version)) continue;
            for (txLicenseEnum v : values = t.getEnumver()) {
                if (!mk.equalsIgnoreCase(v.getMk())) continue;
                return v.getBm();
            }
        }
        return "";
    }

    public static boolean isTxLicense(String version, String appid) {
        for (txLicenseVerEnum t : txLicenseVerEnum.values()) {
            txLicenseEnum[] tx;
            if (!t.getVer().equals(version)) continue;
            for (txLicenseEnum tt : tx = t.getEnumver()) {
                if (!tt.getMk().equalsIgnoreCase(appid)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isTxLicense(String appid) {
        txLicenseEnum[] tx;
        for (txLicenseEnum tt : tx = txLicenseEnum.values()) {
            if (!tt.getMk().equalsIgnoreCase(appid)) continue;
            return true;
        }
        return false;
    }

    public static boolean isLicenseByAppid(String appid, String ver) {
        LicenseEnum[] vv;
        for (LicenseEnum v : vv = LicenseEnum.values()) {
            if (!v.getVersion().equals(ver)) continue;
            for (String app : v.getAppid()) {
                if (!app.equalsIgnoreCase(appid)) continue;
                return true;
            }
        }
        return false;
    }

    public static String getLicenseByAppid(String appid, String ver) {
        if (!ver.equals(v_3)) {
            return TaxcLicenseDefineService.getGroup(TaxcLicenseDefineService.getLicenseEnumByVer(ver), appid);
        }
        return TaxcLicenseDefineService.getV3LicenseByAppid(appid);
    }

    public static String getV3LicenseByAppid(String appid) {
        String group = TaxcLicenseDefineService.getGroup(LicenseEnum.v_3_PRO_TAXB, appid);
        if ("".equals(group) && "".equals(group = TaxcLicenseDefineService.getGroup(LicenseEnum.v_3_PRO_TAXM, appid))) {
            group = TaxcLicenseDefineService.getGroup(LicenseEnum.v_3_PRO_TAXP, appid);
        }
        return group;
    }

    private static LicenseEnum getLicenseEnumByVer(String ver) {
        for (LicenseEnum l : LicenseEnum.values()) {
            if (!l.getVersion().equalsIgnoreCase(ver)) continue;
            return l;
        }
        return null;
    }

    private static String getGroup(LicenseEnum licenseEnum, String appid) {
        String group = "";
        if (licenseEnum == null) {
            return group;
        }
        for (String id : licenseEnum.appid) {
            if (!id.equalsIgnoreCase(appid)) continue;
            group = licenseEnum.getGroup();
        }
        return group;
    }

    public static enum LicenseEnum {
        v_7("7.0", new String[]{"tcvat", "tccit", "tcret", "totf", "tcvvt", "rdesd", "tcetr", "tcnfep", "tctrc", "itp"}, "38"),
        v_6("6.0", new String[]{"tcvat", "tccit", "tcret", "totf", "tcvvt", "rdesd", "tcetr", "tcnfep", "tctrc"}, "38"),
        v_5("5.0", new String[]{"tcvat", "tccit", "tcret", "tctsa", "tctrc"}, "38"),
        v_4("4.0", new String[]{"tcvat", "tccit", "tcret", "tctsa", "tctrc"}, "38"),
        v_3_PRO_TAXB("3.0", new String[]{"tccit", "tcvat", "fjsf"}, "34"),
        v_3_PRO_TAXP("3.0", new String[]{"tcct", "tcsd", "tcret"}, "35"),
        v_3_PRO_TAXM("3.0", new String[]{"tctrc"}, "37");

        String version;
        String[] appid;
        String group;

        private LicenseEnum(String version, String[] appid, String group) {
            this.version = version;
            this.appid = appid;
            this.group = group;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String[] getAppid() {
            return this.appid;
        }

        public void setAppid(String[] appid) {
            this.appid = appid;
        }

        public String getGroup() {
            return this.group;
        }

        public void setGroup(String group) {
            this.group = group;
        }
    }

    static enum txLicenseEnum {
        TXFT("3901", "TXFT", "TCDRS", new MultiLangEnumBridge("\u8ba1\u7a0e\u5e95\u7a3f", "txLicenseEnum_0", "taxc-tctb-business")),
        TXCD("3902", "TXCD", "TSDCS", new MultiLangEnumBridge("\u7a0e\u4f01\u76f4\u8fde", "txLicenseEnum_1", "taxc-tctb-business")),
        QHZDSY("3903", "PRO_QHZDSY", "QHZDSY", new MultiLangEnumBridge("\u5343\u6237\u53ca\u91cd\u70b9\u7a0e\u6e90", "txLicenseEnum_2", "taxc-tctb-business")),
        TCTSA("3904", "PRO_TCTSA", "TCTSA", new MultiLangEnumBridge("\u7edf\u8ba1\u5206\u6790", "txLicenseEnum_3", "taxc-tctb-business")),
        TAM("3905", "PRO_TAM", "TAM", new MultiLangEnumBridge("\u62a5\u7a0e\u5de5\u4f5c\u53f0", "txLicenseEnum_4", "taxc-tctb-business"));

        String id;
        String bm;
        String mk;
        MultiLangEnumBridge name;

        private txLicenseEnum(String id, String bm, String mk, MultiLangEnumBridge name) {
            this.id = id;
            this.bm = bm;
            this.mk = mk;
            this.name = name;
        }

        public MultiLangEnumBridge getName() {
            return this.name;
        }

        public void setName(MultiLangEnumBridge name) {
            this.name = name;
        }

        public void setBm(String bm) {
            this.bm = bm;
        }

        public void setMk(String mk) {
            this.mk = mk;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getBm() {
            return this.bm;
        }

        public String getMk() {
            return this.mk;
        }
    }

    static enum txLicenseVerEnum {
        v_7("7.0", new txLicenseEnum[]{txLicenseEnum.TXCD, txLicenseEnum.QHZDSY, txLicenseEnum.TCTSA, txLicenseEnum.TAM}),
        v_6("6.0", new txLicenseEnum[]{txLicenseEnum.TXFT, txLicenseEnum.TXCD, txLicenseEnum.QHZDSY, txLicenseEnum.TCTSA, txLicenseEnum.TAM}),
        v_5("5.0", new txLicenseEnum[]{txLicenseEnum.TXFT, txLicenseEnum.TXCD}),
        v_4("4.0", new txLicenseEnum[]{txLicenseEnum.TXFT});

        private String ver;
        private txLicenseEnum[] enumver;

        private txLicenseVerEnum(String ver, txLicenseEnum[] enumver) {
            this.ver = ver;
            this.enumver = enumver;
        }

        public String getVer() {
            return this.ver;
        }

        public void setVer(String ver) {
            this.ver = ver;
        }

        public txLicenseEnum[] getEnumver() {
            return this.enumver;
        }

        public void setEnumver(txLicenseEnum[] enumver) {
            this.enumver = enumver;
        }
    }
}

