/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.business.taxclicense;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.taxc.tctb.business.taxclicense.TaxcLicenseDao;
import kd.taxc.tctb.business.taxclicense.TaxcLicenseDefineService;

public class TaxcLicensePurchaseService {
    private static final Log LOGGER = LogFactory.getLog(TaxcLicensePurchaseService.class);
    private static final String[] QUOTATIONMODE_ONE = new String[]{"3.0"};

    private static String getXhLicenseVerByxk(String xkVer) {
        xkLicenseVerEnum[] vs;
        for (xkLicenseVerEnum v : vs = xkLicenseVerEnum.values()) {
            if (!xkVer.equals(v.getXkVer())) continue;
            return v.getXhVer();
        }
        return "4.0";
    }

    public static String getVersion() {
        int modetype = 3;
        try {
            modetype = LicenseServiceHelper.getModeType();
        }
        catch (Exception e) {
            LOGGER.error(" LicenseServiceHelper.getModeType():" + e);
        }
        String ver = LicenseServiceHelper.getProductVersion();
        LOGGER.info("taxc-ProductVersion-:" + modetype + ";ver:" + ver);
        if (modetype == 4 || modetype == 2) {
            String finalVer = ver;
            ver = LicenseServiceHelper.getProductInfos().stream().peek(TaxcLicensePurchaseService.getMapConsumer()).filter(s -> ((String)s.get("softwarename")).contains(ResManager.loadKDString((String)"\u661f\u7a7a", (String)"LicenseGroupUtil_0", (String)"taxc-tctb-common", (Object[])new Object[0]))).map(s -> (String)s.get("productversion")).findFirst().orElseGet(() -> finalVer);
            return TaxcLicensePurchaseService.getXhLicenseVerByxk(ver);
        }
        if (modetype == 3) {
            String finalVer = ver;
            ver = LicenseServiceHelper.getProductInfos().stream().peek(TaxcLicensePurchaseService.getMapConsumer()).filter(s -> ((String)s.get("softwarename")).contains(ResManager.loadKDString((String)"\u661f\u701a", (String)"LicenseGroupUtil_1", (String)"taxc-tctb-common", (Object[])new Object[0]))).map(s -> (String)s.get("productversion")).findFirst().orElseGet(() -> finalVer);
            if (TaxcLicensePurchaseService.isQuotationMode(ver)) {
                return ver;
            }
            return "3.0";
        }
        return ver;
    }

    private static Consumer<Map<String, String>> getMapConsumer() {
        return s -> LOGGER.info("softwarename=" + (String)s.get("softwarename") + ",productversion=" + (String)s.get("productversion"));
    }

    public static boolean isQuotationMode(String ver) {
        for (String v : QUOTATIONMODE_ONE) {
            if (!ver.equals(v)) continue;
            return false;
        }
        return true;
    }

    private static String changeGruopid(String groupId) {
        if ("35".equals(groupId)) {
            return "87";
        }
        if ("37".equals(groupId)) {
            return "88";
        }
        if ("38".equals(groupId)) {
            return "406";
        }
        if ("39".equals(groupId)) {
            return "407";
        }
        return groupId;
    }

    public static int getTotalNumber(String groupId) {
        int sum = LicenseServiceHelper.getTotalNumber((Object)TaxcLicensePurchaseService.changeGruopid(groupId + ""));
        if ("1.0".equals(TaxcLicensePurchaseService.getVersion()) && sum == 0) {
            sum = 50;
        }
        return sum;
    }

    public static LicenseCheckResult checkPurchaseGroup(String bm) {
        return LicenseServiceHelper.checkPerformGroup((String)bm);
    }

    public static Map<String, String> getGmLicense() {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> groupName = new HashMap<String, String>();
        HashMap<String, String> bizlist = new HashMap<String, String>();
        Set set = LicenseServiceHelper.getLicenseModules();
        HashMap<String, String> setmap = new HashMap<String, String>();
        LOGGER.info("taxc-ProductVersion-set:" + set);
        if (null != set) {
            LOGGER.info("taxc-ProductVersion-set:" + set.size());
            for (Object s : set) {
                setmap.put(((String)s).toLowerCase(), ((String)s).toLowerCase());
                LOGGER.info("taxc-LicenseGroupUtil-s:" + ((String)s).toLowerCase());
            }
        }
        DynamicObject[] doc = TaxcLicenseDao.queryTaxLicenseGroup();
        for (DynamicObject d : doc) {
            if (!d.getString("id").toLowerCase().startsWith("38")) continue;
            LOGGER.info("taxc-LicenseGroupUtil-groupName:" + d.getString("number").toLowerCase() + ";" + d.getString("id").toLowerCase());
            groupName.put(d.getString("number").toLowerCase(), d.getString("id").toLowerCase());
        }
        if (groupName.size() > 0) {
            DynamicObjectCollection bizap = BizAppServiceHelp.getAllBizApps();
            for (DynamicObject biz : bizap) {
                LOGGER.info("taxc-LicenseGroupUtil-number:" + biz.getString("number").toLowerCase() + ";" + biz.getString("id").toLowerCase());
                if (null == groupName.get(biz.getString("number").toLowerCase())) continue;
                bizlist.put(biz.getString("id").toLowerCase(), biz.getString("number").toLowerCase());
            }
        }
        for (Map.Entry s : bizlist.entrySet()) {
            String value;
            LOGGER.info("taxc-LicenseGroupUtil:" + (String)s.getKey() + ";" + (String)s.getValue());
            if (null == setmap.get(s.getKey()) || null == (value = (String)groupName.get(s.getValue()))) continue;
            LOGGER.info("taxc-LicenseGroupUtil:" + value);
            map.put(value, value);
        }
        return map;
    }

    public static LicenseCheckResult checkTAXBPerformGroup(String code) {
        String ver = TaxcLicensePurchaseService.getVersion();
        if (TaxcLicensePurchaseService.isQuotationMode(ver)) {
            return TaxcLicensePurchaseService.getLicenseCheckResult(code);
        }
        if ("3.0".equals(TaxcLicensePurchaseService.getVersion())) {
            if (TaxcLicenseDefineService.getV3LicenseByAppid(code).equals("37")) {
                return LicenseServiceHelper.checkPerformGroup((String)"PRO_TAXM");
            }
            if (TaxcLicenseDefineService.getV3LicenseByAppid(code).equals("34")) {
                return LicenseServiceHelper.checkPerformGroup((String)"PRO_TAXB");
            }
            if (TaxcLicenseDefineService.getV3LicenseByAppid(code).equals("35")) {
                return LicenseServiceHelper.checkPerformGroup((String)"PRO_TAXP");
            }
            LicenseCheckResult s = new LicenseCheckResult();
            s.setHasLicense(Boolean.valueOf(false));
            AppMetadata app = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)code, (boolean)true);
            String erro = ResManager.loadKDString((String)"\u6ca1\u6709\u201c%s\u201d\u8bb8\u53ef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TaxcLicensePurchaseService_0", (String)"taxc-tctb-business", (Object[])new Object[0]);
            s.setMsg(String.format(erro, app.getName()));
            return s;
        }
        LicenseCheckResult s = new LicenseCheckResult();
        s.setHasLicense(Boolean.valueOf(true));
        return s;
    }

    private static LicenseCheckResult getLicenseCheckResult(String code) {
        LicenseCheckResult s = LicenseServiceHelper.checkPerformGroup((String)"TAXB");
        if (s.getHasLicense().booleanValue()) {
            LOGGER.info("taxc-ProductVersion-code:" + code);
            String appid = "";
            if (StringUtils.isNotBlank((CharSequence)code)) {
                appid = BizAppServiceHelp.getAppIdByAppNumber((String)code.toUpperCase());
                LOGGER.info("taxc-ProductVersion-code1:" + appid);
                if (null == appid || "".equals(appid)) {
                    appid = BizAppServiceHelp.getAppIdByAppNumber((String)code);
                }
                LOGGER.info("taxc-ProductVersion-code2:" + appid);
            }
            return LicenseServiceHelper.checkLicenseModules((String)appid);
        }
        return s;
    }

    static enum xkLicenseVerEnum {
        v_1("1.0", "4.0"),
        v_2("2.0", "5.0"),
        v_21("2.1", "6.0"),
        v_22("2.2", "6.0");

        private String xkVer;
        private String xhVer;

        private xkLicenseVerEnum(String xkVer, String xhVer) {
            this.xkVer = xkVer;
            this.xhVer = xhVer;
        }

        public String getXkVer() {
            return this.xkVer;
        }

        public void setXkVer(String xkVer) {
            this.xkVer = xkVer;
        }

        public String getXhVer() {
            return this.xhVer;
        }

        public void setXhVer(String xhVer) {
            this.xhVer = xhVer;
        }
    }
}

