/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.business.taxclicense;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.TaxationsysMappingEnum;
import kd.taxc.bdtaxr.common.helper.bastax.taxcorg.TaxcOrgDataServiceHelper;
import kd.taxc.common.util.StringUtil;
import kd.taxc.tctb.business.taxclicense.TaxcLicenseApplyDao;
import kd.taxc.tctb.business.taxclicense.TaxcLicenseDao;
import kd.taxc.tctb.business.taxclicense.TaxcLicensePurchaseService;

public class TaxcLicenseService {
    public static DynamicObject[] queryTaxcLicenseByOrgIds(List<Long> orgIds) {
        return BusinessDataServiceHelper.load((String)"tctb_license_from", (String)"id,unifiedsocialcode,activeuserid,canceluserid,activedate,canceldate,password,group,licensestatus,orgid,ver", (QFilter[])new QFilter[]{new QFilter("orgid", "in", orgIds)});
    }

    public static DynamicObject[] queryTaxLicenseByIds(List<Long> ids) {
        return TaxcLicenseDao.queryTaxLicenseByIds(ids, "id,unifiedsocialcode,activeuserid,canceluserid,activedate,canceldate,password,group,licensestatus,orgid,ver", null);
    }

    public static DynamicObject queryTaxLicenseGroupById(Long groupid) {
        return TaxcLicenseDao.queryTaxLicenseGroupById(groupid);
    }

    public static Optional<String> checkOnTheWay(List<Long> licenseIds) {
        if (TaxcLicenseApplyDao.checkOnTheWayLicenseApply(licenseIds)) {
            return Optional.of(ResManager.loadKDString((String)"\u6240\u52fe\u9009\u7684\u6570\u636e\u4e2d\u5305\u542b\u4e86\u6b63\u5728\u7533\u8bf7\u4e2d\u7684\u6570\u636e\uff0c\u8bf7\u52ff\u91cd\u590d\u7533\u8bf7\u3002", (String)"TaxcLicenseBusiness_0", (String)"taxc-tctb-business", (Object[])new Object[0]));
        }
        return Optional.empty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Optional<String> checkUnifiedsocialcode(DynamicObject[] coll) {
        ArrayList<Long> orgIds = new ArrayList<Long>(10);
        boolean involidOrg = false;
        for (DynamicObject obj : coll) {
            if (obj.getDynamicObject("orgid") == null) {
                involidOrg = true;
                break;
            }
            orgIds.add(obj.getDynamicObject("orgid").getLong("id"));
        }
        if (involidOrg) {
            return Optional.of(ResManager.loadKDString((String)"\u6240\u9009\u62e9\u7684\u6570\u636e\u4e2d\uff0c\u201c\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002\u8bf7\u5148\u5728\u201c\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u201d\u4e2d\u8865\u5168\u4fe1\u606f\u3002", (String)"TaxcLicenseBusiness_1", (String)"taxc-tctb-business", (Object[])new Object[0]));
        }
        TaxResult taxResult = TaxcOrgDataServiceHelper.queryTaxcOrgByOrgIdsAndTaxationsysId(orgIds, (Long)TaxationsysMappingEnum.CHN.getId(), (boolean)true);
        if (!taxResult.isSuccess()) return Optional.of(taxResult.getMessage());
        if (taxResult == null) return Optional.of(ResManager.loadKDString((String)"\u6240\u9009\u62e9\u7684\u6570\u636e\u4e2d\uff0c\u201c\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002\u8bf7\u5148\u5728\u201c\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u201d\u4e2d\u8865\u5168\u4fe1\u606f\u3002", (String)"TaxcLicenseBusiness_1", (String)"taxc-tctb-business", (Object[])new Object[0]));
        List orgs = (List)taxResult.getData();
        List invalidOrgs = orgs.stream().filter(v -> StringUtil.isEmpty((CharSequence)v.getString("unifiedsocialcode"))).collect(Collectors.toList());
        if (invalidOrgs.size() <= 0 && orgs.size() == orgIds.size()) return Optional.empty();
        return Optional.of(ResManager.loadKDString((String)"\u6240\u9009\u62e9\u7684\u6570\u636e\u4e2d\uff0c\u201c\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002\u8bf7\u5148\u5728\u201c\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u201d\u4e2d\u8865\u5168\u4fe1\u606f\u3002", (String)"TaxcLicenseBusiness_1", (String)"taxc-tctb-business", (Object[])new Object[0]));
    }

    public static Optional<String> checkLicenseEnough(Long groupId, int applyCount, int cancelCount) {
        if (applyCount <= cancelCount) {
            return Optional.empty();
        }
        int usedCount = TaxcLicenseService.getLicenseUsedCount(groupId);
        return TaxcLicenseService.checkLicenseEnough(groupId, applyCount, cancelCount, usedCount);
    }

    public static Optional<String> checkLicenseEnough(Long groupId, int applyCount, int cancelCount, int usedCount) {
        int totalCount = TaxcLicensePurchaseService.getTotalNumber(String.valueOf(groupId));
        if (applyCount - cancelCount + usedCount > totalCount) {
            return Optional.of(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u60a8\u5f53\u524d\u53ef\u7528\u7684\u8bb8\u53ef\u6570\u91cf\u4e0d\u8db3\u4ee5\u6388\u6743\u7533\u8bf7\u5355\u4e2d\u7684\u7ec4\u7ec7\u3002\r\n \u53ef\u7528\u8bb8\u53ef\u6570\u91cf%1$s\u4e2a,\u7533\u8bf7\u6388\u6743\u7684\u7ec4\u7ec7%2$s\u4e2a\uff0c\u7533\u8bf7\u6ce8\u9500\u7684\u7ec4\u7ec7%3$s\u4e2a\u3002", (String)"TaxcLicenseBusiness_2", (String)"taxc-tctb-business", (Object[])new Object[0]), totalCount - usedCount, applyCount, cancelCount));
        }
        return Optional.empty();
    }

    public static Map<Long, Integer> getLicenseUsedCount(List<Long> groupIds) {
        HashMap<Long, Integer> licenseUsedMap = new HashMap<Long, Integer>(10);
        DynamicObject[] coll = TaxcLicenseDao.queryTaxLicenseByGroupIds(groupIds);
        Map<Long, List<DynamicObject>> groupMap = Stream.of(coll).collect(Collectors.groupingBy(obj -> obj.getDynamicObject("group").getLong("id")));
        Long groupId = null;
        List<DynamicObject> licenses = null;
        for (Map.Entry<Long, List<DynamicObject>> entry : groupMap.entrySet()) {
            groupId = entry.getKey();
            licenses = entry.getValue();
            licenseUsedMap.put(groupId, licenses.size());
        }
        return licenseUsedMap;
    }

    public static int getLicenseUsedCount(Long groupid) {
        DynamicObject[] taxLicense = TaxcLicenseDao.queryTaxLicenseByGroupId(groupid);
        return taxLicense.length;
    }

    public static DynamicObject[] getLicenseOrgIdByGroupAndstatus(Long groupid, String licensestatus) {
        DynamicObject[] taxLicense = TaxcLicenseDao.getLicenseOrgIdByGroupAndstatus(groupid, licensestatus);
        return taxLicense;
    }
}

