/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.business.taxcmain;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.enums.TaxationsysMappingEnum;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tctb.business.taxcmain.TaxcMainBusiness;

public class TaxCreditratingBusiness {
    private static final String KEY_YEAR = "year";
    private static final String KEY_LEVEL = "creditlevel";
    private static final String KEY_SCORE = "ratingscore";
    private static final String KEY_REMARK = "remark";
    private static final String KEY_COMPARERESULT = "compareresult";
    private static final String KEY_COMPARERESULT_ERROCODE = "compareresult_errocode";
    private static final String KEY_COMPAREMSG = "comparemsg";
    private static final String KEY_COVERRESULT = "coverresult";
    private static final String KEY_COVERMSG = "covermsg";

    public static List<Map<String, Object>> compare(List<Map<String, Object>> list) {
        List<Long> orgIds = list.stream().map(item -> (Long)item.get("orgid")).collect(Collectors.toList());
        DynamicObject[] taxmainDyns = TaxcMainBusiness.loadTaxcMainByOrgIds(orgIds, TaxationsysMappingEnum.CHN.getId());
        Map<Long, DynamicObject> orgTaxmainDynMap = Arrays.stream(taxmainDyns).collect(Collectors.toMap(dyn -> dyn.getLong("taxorg.org.id"), dyn -> dyn));
        return TaxCreditratingBusiness.compare(list, orgTaxmainDynMap);
    }

    private static List<Map<String, Object>> compare(List<Map<String, Object>> list, Map<Long, DynamicObject> orgTaxmainDynMap) {
        for (Map<String, Object> map : list) {
            String info;
            Long orgId = (Long)map.getOrDefault("orgid", 0L);
            int year = (Integer)map.getOrDefault(KEY_YEAR, 0);
            String level = (String)map.getOrDefault(KEY_LEVEL, "");
            String score = (String)map.getOrDefault(KEY_SCORE, "");
            String remark = (String)map.getOrDefault(KEY_REMARK, "");
            DynamicObject taxmainDyn = orgTaxmainDynMap.get(orgId);
            if (taxmainDyn == null) {
                map.put(KEY_COMPARERESULT, CompareResult.ERRO.getCode());
                map.put(KEY_COMPARERESULT_ERROCODE, CompareResultErroCode.TAXMAIN_NOTEXIST.getCode());
                info = String.format(ResManager.loadKDString((String)"%s \u65e0\u5bf9\u5e94\u4e2d\u56fd\u5927\u9646\u7a0e\u5236\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u3002", (String)"TaxCreditratingBusiness_0", (String)"taxc-tctb-business", (Object[])new Object[0]), TaxCreditratingBusiness.getOrgName(orgId));
                map.put(KEY_COMPAREMSG, info);
                continue;
            }
            if (StringUtil.isEmpty((CharSequence)level) || StringUtil.isEmpty((CharSequence)score)) {
                map.put(KEY_COMPARERESULT, CompareResult.ERRO.getCode());
                map.put(KEY_COMPARERESULT_ERROCODE, CompareResultErroCode.SOURCEDATA_ERRO.getCode());
                info = String.format(ResManager.loadKDString((String)"%s \u4fe1\u7528\u7ea7\u522b\u6216\u8bc4\u4ef7\u5206\u6570\u65e0\u6570\u636e\uff0c\u6bd4\u5bf9\u5931\u8d25\u3002", (String)"TaxCreditratingBusiness_8", (String)"taxc-tctb-business", (Object[])new Object[0]), TaxCreditratingBusiness.getOrgName(orgId));
                map.put(KEY_COMPAREMSG, info);
                continue;
            }
            DynamicObjectCollection creditDyns = taxmainDyn.getDynamicObjectCollection("taxcreditrating");
            boolean exist = false;
            for (DynamicObject creditDyn : creditDyns) {
                int creditYear = TaxCreditratingBusiness.getYear(creditDyn);
                String creditLevel = creditDyn.getString(KEY_LEVEL);
                String creditSocre = creditDyn.getString(KEY_SCORE);
                String creditRemark = creditDyn.getString(KEY_REMARK);
                if (year != creditYear) continue;
                if (!level.equals(creditLevel) || !score.equals(creditSocre)) {
                    map.put(KEY_COMPARERESULT, CompareResult.DIFF.getCode());
                    map.put(KEY_COMPAREMSG, ResManager.loadKDString((String)"\u6709\u5dee\u5f02", (String)"TaxCreditratingBusiness_1", (String)"taxc-tctb-business", (Object[])new Object[0]));
                } else {
                    map.put(KEY_COMPARERESULT, CompareResult.NODIFF.getCode());
                    map.put(KEY_COMPAREMSG, ResManager.loadKDString((String)"\u65e0\u5dee\u5f02", (String)"TaxCreditratingBusiness_2", (String)"taxc-tctb-business", (Object[])new Object[0]));
                }
                exist = true;
                break;
            }
            if (exist) continue;
            map.put(KEY_COMPARERESULT, CompareResult.NOTEEXIST.getCode());
            map.put(KEY_COMPAREMSG, ResManager.loadKDString((String)"\u65e0\u8be5\u5e74\u4efd\u8bb0\u5f55", (String)"TaxCreditratingBusiness_3", (String)"taxc-tctb-business", (Object[])new Object[0]));
        }
        return list;
    }

    public static List<Map<String, Object>> cover(List<Map<String, Object>> list) {
        List<Long> orgIds = list.stream().map(item -> (Long)item.get("orgid")).collect(Collectors.toList());
        DynamicObject[] taxmainDyns = TaxcMainBusiness.loadTaxcMainByOrgIds(orgIds, TaxationsysMappingEnum.CHN.getId());
        Map<Long, DynamicObject> orgTaxmainDynMap = Arrays.stream(taxmainDyns).collect(Collectors.toMap(dyn -> dyn.getLong("taxorg.org.id"), dyn -> dyn));
        return TaxCreditratingBusiness.cover(list, orgTaxmainDynMap);
    }

    private static List<Map<String, Object>> cover(List<Map<String, Object>> list, Map<Long, DynamicObject> orgTaxmainDynMap) {
        List<Map<String, Object>> compareResult = TaxCreditratingBusiness.compare(list, orgTaxmainDynMap);
        HashSet<DynamicObject> tobeSave = new HashSet<DynamicObject>(8);
        for (Map<String, Object> map : compareResult) {
            Long orgId = (Long)map.getOrDefault("orgid", 0L);
            DynamicObject taxmainDyn = orgTaxmainDynMap.get(orgId);
            String compareRCode = (String)map.get(KEY_COMPARERESULT);
            CompareResult compareR = CompareResult.valueOfCode(compareRCode);
            if (compareR == null) {
                map.put(KEY_COVERRESULT, CoverResult.ERRO.getCode());
                map.put(KEY_COVERMSG, "compare result is null");
                continue;
            }
            switch (compareR) {
                case DIFF: {
                    TaxCreditratingBusiness.setUpdateInfo(map, taxmainDyn);
                    tobeSave.add(taxmainDyn);
                    map.put(KEY_COVERRESULT, CoverResult.SUCCESS.getCode());
                    map.put(KEY_COVERMSG, ResManager.loadKDString((String)"\u6709\u5dee\u5f02\u8986\u76d6\u6210\u529f", (String)"TaxCreditratingBusiness_5", (String)"taxc-tctb-business", (Object[])new Object[0]));
                    break;
                }
                case NODIFF: {
                    map.put(KEY_COVERRESULT, CoverResult.NONEED.getCode());
                    map.put(KEY_COVERMSG, ResManager.loadKDString((String)"\u76f8\u540c\u4e0d\u9700\u8981\u8986\u76d6", (String)"TaxCreditratingBusiness_6", (String)"taxc-tctb-business", (Object[])new Object[0]));
                    break;
                }
                case NOTEEXIST: {
                    TaxCreditratingBusiness.setAddInfo(map, taxmainDyn);
                    tobeSave.add(taxmainDyn);
                    map.put(KEY_COVERRESULT, CoverResult.SUCCESS.getCode());
                    map.put(KEY_COVERMSG, ResManager.loadKDString((String)"\u65b0\u589e\u6210\u529f", (String)"TaxCreditratingBusiness_7", (String)"taxc-tctb-business", (Object[])new Object[0]));
                    break;
                }
                case ERRO: {
                    map.put(KEY_COVERRESULT, CoverResult.ERRO.getCode());
                    map.put(KEY_COVERMSG, map.get(KEY_COMPAREMSG));
                    break;
                }
            }
        }
        SaveServiceHelper.save((DynamicObject[])tobeSave.toArray(new DynamicObject[0]));
        return compareResult;
    }

    private static void setUpdateInfo(Map<String, Object> map, DynamicObject taxmainDyn) {
        int year = (Integer)map.getOrDefault(KEY_YEAR, 0);
        String level = (String)map.getOrDefault(KEY_LEVEL, "");
        String score = (String)map.getOrDefault(KEY_SCORE, "");
        String remark = (String)map.getOrDefault(KEY_REMARK, "");
        DynamicObjectCollection creditDyns = taxmainDyn.getDynamicObjectCollection("taxcreditrating");
        for (DynamicObject creditDyn : creditDyns) {
            int creditYear = TaxCreditratingBusiness.getYear(creditDyn);
            if (year != creditYear) continue;
            creditDyn.set(KEY_LEVEL, (Object)level);
            creditDyn.set(KEY_SCORE, (Object)score);
            creditDyn.set(KEY_REMARK, (Object)remark);
        }
    }

    private static void setAddInfo(Map<String, Object> map, DynamicObject taxmainDyn) {
        int year = (Integer)map.getOrDefault(KEY_YEAR, 0);
        String level = (String)map.getOrDefault(KEY_LEVEL, "");
        String score = (String)map.getOrDefault(KEY_SCORE, "");
        String remark = (String)map.getOrDefault(KEY_REMARK, "");
        DynamicObjectCollection creditDyns = taxmainDyn.getDynamicObjectCollection("taxcreditrating");
        DynamicObject newCredit = creditDyns.addNew();
        newCredit.set(KEY_YEAR, (Object)TaxCreditratingBusiness.getDate(year));
        newCredit.set(KEY_LEVEL, (Object)level);
        newCredit.set(KEY_SCORE, (Object)score);
        newCredit.set(KEY_REMARK, (Object)remark);
    }

    private static Integer getYear(DynamicObject creditDyn) {
        Date dateY = creditDyn.getDate(KEY_YEAR);
        Calendar c = Calendar.getInstance();
        c.setTime(dateY);
        return c.get(1);
    }

    private static Date getDate(int year) {
        return DateUtils.stringToDate2((String)(year + ""), (String)"yyyy");
    }

    private static String getOrgName(Long orgId) {
        QFilter filter = new QFilter("id", "=", (Object)orgId);
        DynamicObject dyn = BusinessDataServiceHelper.loadSingle((String)"bastax_taxorg", (String)"org.name", (QFilter[])new QFilter[]{filter});
        return dyn == null ? null : dyn.getString("org.name");
    }

    static enum CoverResult {
        ERRO("erro"),
        SUCCESS("success"),
        NONEED("noneed");

        private String code;

        private CoverResult(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }
    }

    static enum CompareResultErroCode {
        TAXMAIN_NOTEXIST("1001"),
        SOURCEDATA_ERRO("2001");

        private String code;

        private CompareResultErroCode(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }
    }

    static enum CompareResult {
        ERRO("erro"),
        DIFF("diff"),
        NODIFF("nodiff"),
        NOTEEXIST("notexist");

        private String code;

        private CompareResult(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }

        public static CompareResult valueOfCode(String code) {
            Optional<CompareResult> op = Arrays.stream(CompareResult.values()).filter(item -> item.getCode().equals(code)).findFirst();
            return op.isPresent() ? op.get() : null;
        }
    }
}

