/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.business.taxcmain;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.mutex.impl.DataMutexImpl;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.executor.JobClient;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.taxc.bdtaxr.common.constant.tctb.TaxcMainConstant;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bos.perm.PermDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.bos.user.UserDataServiceHelper;
import kd.taxc.common.util.EmptyCheckUtils;
import kd.taxc.enums.TaxTypeComboEnum;
import kd.taxc.tctb.business.taxcmain.TaxInfoHomeDao;
import kd.taxc.tctb.common.vo.OpenTaxMainVo;

public class TaxInfoHomeBusiness {
    public static DynamicObject getTaxMainInfoById(Long pkid) {
        return BusinessDataServiceHelper.loadSingle((Object)pkid, (String)"tctb_tax_main");
    }

    public static DynamicObject queryTaxMainInfoById(Long pkid, String selectProperties) {
        QFilter qFilter = new QFilter("id", "=", (Object)pkid);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"tctb_tax_main", (String)selectProperties, (QFilter[])new QFilter[]{qFilter});
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            return dynamicObjects[0];
        }
        return null;
    }

    public static DynamicObject[] queryTaxMainInfoByOrgId(Long orgId, String selectProperties) {
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgId);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"tctb_tax_main", (String)selectProperties, (QFilter[])new QFilter[]{orgFilter});
        return dynamicObjects;
    }

    public static DynamicObject queryOrgById(Long id) {
        return TaxInfoHomeDao.queryOrgById(id);
    }

    public static DynamicObject queryTaxMainByIdAndOrgIdAndTaxationSys(Long id, Long orgId, Long taxationSys) {
        DynamicObject taxMain = null;
        if (id != null) {
            QFilter filter = new QFilter("id", "=", (Object)id);
            taxMain = QueryServiceHelper.queryOne((String)TaxcMainConstant.ENTITYNAME, (String)"id,orgid.id,orgid.name", (QFilter[])new QFilter[]{filter});
        } else if (taxationSys != null) {
            QFilter filter = new QFilter("orgid.id", "=", (Object)orgId);
            filter.and(new QFilter("taxationsys.id", "=", (Object)taxationSys));
            taxMain = QueryServiceHelper.queryOne((String)TaxcMainConstant.ENTITYNAME, (String)"id,orgid.id,orgid.name", (QFilter[])new QFilter[]{filter});
        } else {
            QFilter filter = new QFilter("orgid", "=", (Object)orgId);
            DynamicObject[] dobj = BusinessDataServiceHelper.load((String)TaxcMainConstant.ENTITYNAME, (String)"id,orgid.id,orgid.name", (QFilter[])new QFilter[]{filter}, (String)"taxationsys asc");
            if (EmptyCheckUtils.isNotEmpty((Object)dobj)) {
                taxMain = dobj[0];
            }
        }
        return taxMain;
    }

    public static boolean checkPermission(Long orgId, String permItemId, String entityNum) {
        String appId = EntityMetadataCache.getDataEntityType((String)entityNum).getAppId();
        TaxResult result = PermDataServiceHelper.checkPermission((Long)UserServiceHelper.getCurrentUserId(), (Long)orgId, (String)appId, (String)entityNum, (String)permItemId);
        return result.isSuccess() ? (Boolean)result.getData() : false;
    }

    public static String getBizappByNum(String num) {
        QFilter bizappidQfilter = new QFilter("number", "=", (Object)num);
        DynamicObjectCollection bizappObj = QueryServiceHelper.query((String)"bos_devportal_bizapp", (String)"id", (QFilter[])new QFilter[]{bizappidQfilter});
        if (bizappObj == null || bizappObj.size() == 0) {
            return null;
        }
        return ((DynamicObject)bizappObj.get(0)).getString("id");
    }

    public static Optional<String> checkSavePermission(Long orgId, String permItem) {
        if (orgId == null) {
            return Optional.empty();
        }
        boolean hasPermission = TaxInfoHomeBusiness.checkPermission(orgId, permItem, "tctb_tax_main");
        if (!hasPermission) {
            String orgName = null;
            DynamicObject org = TaxInfoHomeBusiness.queryOrgById(orgId);
            if (org != null) {
                orgName = org.getString("name");
            }
            String tipMessage = null;
            tipMessage = "4715a0df000000ac".equals(permItem) ? String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u7ec4\u7ec7\u201c%s\u201d\u7684\u7eb3\u7a0e\u4e3b\u4f53\u4fee\u6539\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TaxInfoHomeBusiness_1", (String)"taxc-tctb-business", (Object[])new Object[0]), orgName) : String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u7ec4\u7ec7\u201c%s\u201d\u7684\u7eb3\u7a0e\u4e3b\u4f53\u65b0\u589e\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TaxInfoHomeBusiness_2", (String)"taxc-tctb-business", (Object[])new Object[0]), orgName);
            return Optional.of(tipMessage);
        }
        return Optional.empty();
    }

    public static Optional<String> checkDataMutex(Long pkId, String entityNum) {
        if (pkId == null) {
            return Optional.empty();
        }
        DataMutexImpl dataMutex = new DataMutexImpl();
        Map lockInfo = dataMutex.getLockInfo(String.valueOf(pkId), "default_netctrl", entityNum);
        if (lockInfo != null && !((String)lockInfo.get("userid")).equals(String.valueOf(RequestContext.get().getCurrUserId()))) {
            String username = "";
            TaxResult result = UserDataServiceHelper.queryUserNameByIds((Long)Long.valueOf((String)lockInfo.get("userid")));
            if (result != null && result.isSuccess()) {
                username = (String)result.getData();
            }
            String tipMessage = String.format(ResManager.loadKDString((String)"%s\u6b63\u5728\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"TaxInfoHomeBusiness_0", (String)"taxc-tctb-business", (Object[])new Object[0]), username);
            return Optional.of(tipMessage);
        }
        return Optional.empty();
    }

    public static OpenTaxMainVo checkOpenTaxMain(Long pkId, Long orgId) {
        boolean hasViewPermission;
        DynamicObject org;
        OpenTaxMainVo openTaxMainVo = new OpenTaxMainVo();
        openTaxMainVo.setPkId(pkId);
        openTaxMainVo.setOrgId(orgId);
        openTaxMainVo.setOpen(true);
        OperationStatus operationStatus = null;
        if (pkId != null) {
            DynamicObject main = TaxInfoHomeBusiness.queryTaxMainInfoById(pkId, "orgid.id,billstatus");
            if (main == null) {
                String msg = ResManager.loadKDString((String)"\u8df3\u8f6c\u5931\u8d25\uff1a\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u64cd\u4f5c\u3002", (String)"TaxInfoHomeBusiness_3", (String)"taxc-tctb-business", (Object[])new Object[0]);
                openTaxMainVo.setOpen(false);
                openTaxMainVo.setTipClassify("exist");
                openTaxMainVo.setTipMessage(msg);
                return openTaxMainVo;
            }
            String billStatus = main.getString("billstatus");
            operationStatus = "A".equals(billStatus) ? OperationStatus.EDIT : OperationStatus.VIEW;
            orgId = main.getLong("orgid.id");
            openTaxMainVo.setOrgId(orgId);
        } else {
            operationStatus = OperationStatus.ADDNEW;
        }
        openTaxMainVo.setViewStatus(operationStatus);
        String orgName = null;
        if (orgId != null && (org = TaxInfoHomeBusiness.queryOrgById(orgId)) != null) {
            orgName = org.getString("name");
        }
        if (!(hasViewPermission = TaxInfoHomeBusiness.checkPermission(orgId, "47150e89000000ac", "tctb_tax_main"))) {
            String msg = String.format(ResManager.loadKDString((String)"\u8df3\u8f6c\u5931\u8d25\uff1a\u5f53\u524d\u7528\u6237\u6ca1\u6709\u7ec4\u7ec7\u201c%s\u201d\u7684\u7eb3\u7a0e\u4e3b\u4f53\u67e5\u8be2\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TaxInfoHomeBusiness_4", (String)"taxc-tctb-business", (Object[])new Object[0]), orgName);
            openTaxMainVo.setOpen(false);
            openTaxMainVo.setTipClassify("view");
            openTaxMainVo.setTipMessage(msg);
            return openTaxMainVo;
        }
        if (OperationStatus.ADDNEW.equals((Object)operationStatus)) {
            boolean hasAddNewPermission = TaxInfoHomeBusiness.checkPermission(orgId, "47156aff000000ac", "tctb_tax_main");
            if (!hasAddNewPermission) {
                String msg = String.format(ResManager.loadKDString((String)"\u8df3\u8f6c\u5931\u8d25\uff1a\u5f53\u524d\u7528\u6237\u6ca1\u6709\u7ec4\u7ec7\u201c%s\u201d\u7684\u7eb3\u7a0e\u4e3b\u4f53\u65b0\u589e\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TaxInfoHomeBusiness_5", (String)"taxc-tctb-business", (Object[])new Object[0]), orgName);
                openTaxMainVo.setOpen(false);
                openTaxMainVo.setTipClassify("addnew");
                openTaxMainVo.setTipMessage(msg);
            }
        } else if (OperationStatus.EDIT.equals((Object)operationStatus)) {
            boolean hasEditPermission = TaxInfoHomeBusiness.checkPermission(orgId, "4715a0df000000ac", "tctb_tax_main");
            if (!hasEditPermission) {
                String msg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u7ec4\u7ec7\u201c%s\u201d\u7684\u7eb3\u7a0e\u4e3b\u4f53\u4fee\u6539\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TaxInfoHomeBusiness_7", (String)"taxc-tctb-business", (Object[])new Object[0]), orgName);
                openTaxMainVo.setTipMessage(msg);
                openTaxMainVo.setTipClassify("edit");
                openTaxMainVo.setViewStatus(OperationStatus.VIEW);
            } else {
                Optional<String> checkResult = TaxInfoHomeBusiness.checkDataMutex(pkId, "tctb_tax_main");
                if (checkResult.isPresent()) {
                    openTaxMainVo.setTipMessage(checkResult.get());
                    openTaxMainVo.setTipClassify("mutex");
                    openTaxMainVo.setViewStatus(OperationStatus.VIEW);
                }
            }
        }
        return openTaxMainVo;
    }

    public static void doAuditJob(List<Long> ids) {
        HashMap<String, List<Long>> jobParams = new HashMap<String, List<Long>>();
        jobParams.put("ids", ids);
        JobInfo job = new JobInfo();
        job.setJobType(JobType.REALTIME);
        job.setName("kd.taxc.tctb.business.task.TaxInfoMainAuditTask");
        job.setTaskClassname("TaxInfoMainAuditTask");
        job.setRunByUserId(RequestContext.get().getCurrUserId());
        job.setId(UUID.randomUUID().toString());
        job.setParams(jobParams);
        JobClient.dispatch((JobInfo)job);
    }

    public static Long getMaxVer(TaxTypeComboEnum taxTypeComboEnum, Long orgid) {
        QFilter orgQfilter = new QFilter("org.id", "=", (Object)orgid);
        QFilter taxTypeQfilter = new QFilter("taxtype", "=", (Object)taxTypeComboEnum.getCode());
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)taxTypeComboEnum.getFormId(), (String)"ver", (QFilter[])new QFilter[]{orgQfilter, taxTypeQfilter}, (String)"ver desc");
        return EmptyCheckUtils.isEmpty((Object)dynamicObjects) ? 0L : dynamicObjects[0].getLong("ver");
    }

    public static Map<Long, Optional<DynamicObject>> getMaxVerMap(TaxTypeComboEnum taxTypeComboEnum, List<Long> orgIds) {
        if (orgIds.size() == 1) {
            QFilter orgQfilter = new QFilter("org.id", "=", (Object)orgIds.get(0));
            QFilter taxTypeQfilter = new QFilter("taxtype", "=", (Object)taxTypeComboEnum.getCode());
            DynamicObject[] verList = BusinessDataServiceHelper.load((String)taxTypeComboEnum.getFormId(), (String)(taxTypeComboEnum.getFields() + ",ver,org.id"), (QFilter[])new QFilter[]{orgQfilter, taxTypeQfilter}, (String)"ver desc", (int)1);
            if (verList == null || verList.length == 0) {
                return Collections.emptyMap();
            }
            return Arrays.stream(verList).collect(Collectors.toMap(k -> k.getLong("org.id"), v -> Optional.of(v)));
        }
        QFilter orgQfilter = new QFilter("org.id", "in", orgIds);
        QFilter taxTypeQfilter = new QFilter("taxtype", "=", (Object)taxTypeComboEnum.getCode());
        DynamicObject[] verList = BusinessDataServiceHelper.load((String)taxTypeComboEnum.getFormId(), (String)(taxTypeComboEnum.getFields() + ",ver,org.id"), (QFilter[])new QFilter[]{orgQfilter, taxTypeQfilter}, null);
        Map<Long, Optional<DynamicObject>> maxVerMap = Arrays.stream(verList).collect(Collectors.groupingBy(k -> k.getLong("org.id"), Collectors.maxBy(Comparator.comparingLong(v -> v.getLong("ver")))));
        return maxVerMap;
    }

    public static Map<String, Optional<DynamicObject>> getLastChangeRecordMap(List<Long> mainTableIds) {
        if (mainTableIds.size() == 1) {
            QFilter taxTypeQfilter;
            QFilter orgQfilter = new QFilter("maintableid", "=", (Object)String.valueOf(mainTableIds.get(0)));
            DynamicObject[] taxChangeRecordList = BusinessDataServiceHelper.load((String)"tctb_tax_change_record", (String)"maintableid,taxstartdate,createdate", (QFilter[])new QFilter[]{orgQfilter, taxTypeQfilter = new QFilter("taxtype", "=", (Object)TaxTypeComboEnum.ZZS.getCode())}, (String)"createdate desc", (int)1);
            if (taxChangeRecordList == null || taxChangeRecordList.length == 0) {
                return Collections.emptyMap();
            }
            return Arrays.stream(taxChangeRecordList).collect(Collectors.toMap(k -> k.getString("maintableid"), v -> Optional.of(v)));
        }
        QFilter orgQfilter = new QFilter("maintableid", "in", mainTableIds.stream().map(v -> String.valueOf(v)).collect(Collectors.toList()));
        QFilter taxTypeQfilter = new QFilter("taxtype", "=", (Object)TaxTypeComboEnum.ZZS.getCode());
        DynamicObject[] taxChangeRecordList = BusinessDataServiceHelper.load((String)"tctb_tax_change_record", (String)"maintableid,taxstartdate,createdate", (QFilter[])new QFilter[]{orgQfilter, taxTypeQfilter}, null);
        Map<String, Optional<DynamicObject>> LastChangeRecordMap = Arrays.stream(taxChangeRecordList).collect(Collectors.groupingBy(k -> k.getString("maintableid"), Collectors.maxBy(Comparator.comparing(v -> v.getDate("createdate")))));
        return LastChangeRecordMap;
    }

    public static DynamicObject getTaxMainInfo(Long pkid) {
        return BusinessDataServiceHelper.loadSingle((Object)pkid, (String)"tctb_tax_main");
    }
}

