/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.business.taxcmain;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.taxc.bdtaxr.common.constant.tctb.TaxcMainConstant;
import kd.taxc.bdtaxr.common.utils.DyoToDtoUtils;
import kd.taxc.common.util.DateUtils;
import kd.taxc.common.util.EmptyCheckUtils;
import kd.taxc.common.util.StringUtil;
import kd.taxc.tctb.business.taxcmain.TaxcMainDao;
import kd.taxc.tctb.business.taxcmain.TaxcMainService;

public class TaxcMainBusiness {
    private static Log logger = LogFactory.getLog(TaxcMainBusiness.class);

    public static Boolean isTaxcMainByOrgId(Long orgId, Long taxationsysId) {
        DynamicObject obj = TaxcMainDao.loadTaxcMainFormDBByOrgId(TaxcMainConstant.BASE_FILEDS, orgId, taxationsysId);
        return TaxcMainService.orgViewEnbale(obj) != false && TaxcMainService.isBillStatusAndStatus(obj, taxationsysId) != false;
    }

    public static Boolean isTaxcMainByOrgIdAndIsTaxpayer(Long orgId, Long taxationsysId) {
        DynamicObject obj = TaxcMainDao.loadTaxcMainFormDBByOrgId(TaxcMainConstant.BASE_FILEDS, orgId, taxationsysId);
        return TaxcMainService.orgViewEnbale(obj) != false && TaxcMainService.isBillStatusAndStatusAndIsTaxPayer(obj, taxationsysId) != false;
    }

    public static Boolean isTaxcMainByOrgNum(String orgNum, Long taxationsysId) {
        DynamicObject obj = TaxcMainDao.loadTaxcMainFormDBByOrgNum(TaxcMainConstant.BASE_FILEDS, orgNum, taxationsysId);
        return TaxcMainService.orgViewEnbale(obj) != false && TaxcMainService.isBillStatusAndStatus(obj, taxationsysId) != false;
    }

    public static Boolean isTaxcMainByUnifiedsocialcode(String unifiedsocialcode, Long taxationsysId) {
        DynamicObject obj = TaxcMainDao.loadTaxcMainFormDBByUnifiedsocialCode(TaxcMainConstant.BASE_FILEDS, unifiedsocialcode, taxationsysId);
        return TaxcMainService.orgViewEnbale(obj) != false && TaxcMainService.isBillStatusAndStatus(obj, taxationsysId) != false;
    }

    public static DynamicObject loadTaxcMainByOrgId(Long orgId, Long taxationsysId) {
        DynamicObject dyo = TaxcMainDao.loadTaxcMainFormDBByOrgId(TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, orgId, taxationsysId);
        if (TaxcMainService.orgViewEnbale(dyo).booleanValue() && TaxcMainService.isBillStatusAndStatus(dyo, taxationsysId).booleanValue()) {
            return dyo;
        }
        return null;
    }

    public static DynamicObject loadTaxcMainByTaxpayer(String taxpayer, Long taxationsysId) {
        DynamicObject dyo = TaxcMainDao.loadTaxcMainFormDBByTaxpayer(TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, taxpayer, taxationsysId);
        if (TaxcMainService.orgViewEnbale(dyo).booleanValue() && TaxcMainService.isBillStatusAndStatus(dyo, taxationsysId).booleanValue()) {
            return dyo;
        }
        return null;
    }

    public static DynamicObject loadTaxcMainByOrgName(String orgName, Long taxationsysId) {
        DynamicObject dyo = TaxcMainDao.loadTaxcMainFormDBByOrgName(TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, orgName, taxationsysId);
        if (TaxcMainService.orgViewEnbale(dyo).booleanValue() && TaxcMainService.isBillStatusAndStatus(dyo, taxationsysId).booleanValue()) {
            return dyo;
        }
        return null;
    }

    public static DynamicObject[] loadTaxcMainByOrgIds(List<Long> orgIds, Long taxationsysId) {
        DynamicObject[] docs = TaxcMainDao.loadTaxcMainFormDBByOrgIds(TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, orgIds, taxationsysId);
        docs = TaxcMainService.filterOrgViewEnbale(docs);
        return TaxcMainService.filterBillStatusAndStatus(docs, taxationsysId);
    }

    public static DynamicObject[] loadTaxcMainByOrgIds(List<Long> orgIds, Long taxationsysId, boolean isIncludeTaxationsys) {
        DynamicObject[] docs = TaxcMainDao.loadTaxcMainFormDBByOrgIds(TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, orgIds, taxationsysId, isIncludeTaxationsys);
        docs = TaxcMainService.filterOrgViewEnbale(docs);
        return TaxcMainService.filterBillStatusAndStatus(docs, taxationsysId, isIncludeTaxationsys);
    }

    public static DynamicObject[] loadTaxcMainByOrgIdsAndIsTaxpayer(List<Long> orgIds, Long taxationsysId, boolean isIncludeTaxationsys) {
        DynamicObject[] docs = TaxcMainDao.loadTaxcMainFormDBByOrgIds(TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, orgIds, taxationsysId, isIncludeTaxationsys);
        docs = TaxcMainService.filterOrgViewEnbale(docs);
        return TaxcMainService.filterBillStatusAndStatusAndIsTaxPayer(docs, taxationsysId, isIncludeTaxationsys);
    }

    public static DynamicObject loadTaxcMainByOrgIdAndIsTaxpayer(Long orgId, Long taxationsysId) {
        DynamicObject dyo = TaxcMainDao.loadTaxcMainFormDBByOrgId(TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, orgId, taxationsysId);
        if (TaxcMainService.orgViewEnbale(dyo).booleanValue() && TaxcMainService.isBillStatusAndStatus(dyo, taxationsysId).booleanValue() && TaxcMainService.isTaxPayer(dyo, taxationsysId).booleanValue()) {
            return dyo;
        }
        return null;
    }

    public static DynamicObject[] loadTaxcMainByOrgIdsAndIsTaxpayer(List<Long> orgIds, Long taxationsysId) {
        DynamicObject[] docs = TaxcMainDao.loadTaxcMainFormDBByOrgIds(TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, orgIds, taxationsysId);
        docs = TaxcMainService.filterOrgViewEnbale(docs);
        return TaxcMainService.filterBillStatusAndStatusAndIsTaxPayer(docs, taxationsysId);
    }

    public static DynamicObject[] loadTaxcMainByTaxOfficeId(Long taxofficeId, Long taxationsysId) {
        DynamicObject[] docs = TaxcMainDao.loadTaxcMainFormDBByTaxOfficeId(TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, taxofficeId, taxationsysId);
        docs = TaxcMainService.filterOrgViewEnbale(docs);
        return TaxcMainService.filterBillStatusAndStatus(docs, taxationsysId);
    }

    public static DynamicObject[] loadTaxcMainByTaxOfficeIds(List<Long> taxofficeIds, Long taxationsysId) {
        DynamicObject[] docs = TaxcMainDao.loadTaxcMainFormDBByTaxOfficeIds(TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, taxofficeIds, taxationsysId);
        docs = TaxcMainService.filterOrgViewEnbale(docs);
        return TaxcMainService.filterBillStatusAndStatus(docs, taxationsysId);
    }

    public static DynamicObject loadTaxcMainByOrgNum(String orgNum, Long taxationsysId) {
        DynamicObject doc = TaxcMainDao.loadTaxcMainFormDBByOrgNum(TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, orgNum, taxationsysId);
        if (TaxcMainService.isBillStatusAndStatus(doc, taxationsysId).booleanValue()) {
            return doc;
        }
        return null;
    }

    public static DynamicObject[] loadTaxcMainByOrgNums(List<String> orgNums, Long taxationsysId) {
        DynamicObject[] docs = TaxcMainDao.loadTaxcMainFormDBByOrgNums(TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, orgNums, taxationsysId);
        docs = TaxcMainService.filterOrgViewEnbale(docs);
        return TaxcMainService.filterBillStatusAndStatus(docs, taxationsysId);
    }

    public static DynamicObject loadTaxcMainByUnifiedsocialCode(String unifiedsocialcode, Long taxationsysId) {
        DynamicObject doc = TaxcMainDao.loadTaxcMainFormDBByUnifiedsocialCode(TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, unifiedsocialcode, taxationsysId);
        if (TaxcMainService.orgViewEnbale(doc).booleanValue() && TaxcMainService.isBillStatusAndStatus(doc, taxationsysId).booleanValue()) {
            return doc;
        }
        return null;
    }

    public static DynamicObject[] loadTaxcMainByUnifiedsocialCodes(List<String> unifiedsocialcodes, Long taxationsysId) {
        DynamicObject[] docs = TaxcMainDao.loadTaxcMainFormDBByUnifiedsocialCodes(TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, unifiedsocialcodes, taxationsysId);
        docs = TaxcMainService.filterOrgViewEnbale(docs);
        return TaxcMainService.filterBillStatusAndStatus(docs, taxationsysId);
    }

    public static DynamicObject loadTaxcMainByUnifiedsocialCodeAndTrasAndIsTaxpayer(String unifiedsocialcode, Long taxationsysId) {
        DynamicObject doc = TaxcMainDao.loadTaxcMainFormDBByUnifiedsocialCode(TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, unifiedsocialcode, taxationsysId);
        if (TaxcMainService.orgViewEnbale(doc).booleanValue() && TaxcMainService.isBillStatusAndStatus(doc, taxationsysId).booleanValue() && TaxcMainService.isTras(doc).booleanValue()) {
            return doc;
        }
        return null;
    }

    public static DynamicObject[] loadTaxcMainByUnifiedsocialCodesAndTrasAndIsTaxpayer(List<String> unifiedsocialcodes, Long taxationsysId) {
        DynamicObject[] docs = TaxcMainDao.loadTaxcMainFormDBByUnifiedsocialCodes(TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, unifiedsocialcodes, taxationsysId);
        docs = TaxcMainService.filterOrgViewEnbale(docs);
        return TaxcMainService.filterBillStatusAndStatusAndIsTras(docs, taxationsysId);
    }

    public static DynamicObject[] loadTaxcMainByIsTaxpayer(Long taxationsysId) {
        DynamicObject[] docs = TaxcMainDao.loadTaxcMainFormDB(TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, taxationsysId);
        docs = TaxcMainService.filterOrgViewEnbale(docs);
        return TaxcMainService.filterBillStatusAndStatusAndIsTaxPayer(docs, taxationsysId);
    }

    public static DynamicObject[] loadTaxcMainByOrgIdsAndTaxpayer(List<Long> orgIds, Long taxationsysId) {
        DynamicObject[] docs = TaxcMainDao.loadTaxcMainFormDBByOrgIds(TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, orgIds, taxationsysId);
        docs = TaxcMainService.filterOrgViewEnbale(docs);
        return TaxcMainService.filterTaxPayer(docs, taxationsysId);
    }

    public static DynamicObject[] loadTaxcMain(Long taxationsysId) {
        DynamicObject[] docs = TaxcMainDao.loadTaxcMainFormDB(TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, taxationsysId);
        docs = TaxcMainService.filterOrgViewEnbale(docs);
        return TaxcMainService.filterBillStatusAndStatus(docs, taxationsysId);
    }

    public static DynamicObject[] loadTaxcMainByOrgIdsWithNoStatus(List<Long> orgIds, Long taxationsysId) {
        return TaxcMainDao.loadTaxcMainFormDBByOrgIds(TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, orgIds, taxationsysId);
    }

    public static DynamicObject[] loadTaxcMainByOrgNumbersWithNoStatus(List<String> orgNums, Long taxationsysId) {
        return TaxcMainDao.loadTaxcMainFormDBByOrgNums(TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, orgNums, taxationsysId);
    }

    public static List<Long> loadTaxOfficeIdByOrgId(List<Long> orgIds, Long taxationsysId) {
        DynamicObject[] docs = TaxcMainDao.loadTaxcMainFormDBByOrgIds(TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, orgIds, taxationsysId);
        docs = TaxcMainService.filterOrgViewEnbale(docs);
        return DyoToDtoUtils.dyoToLong((DynamicObject[])TaxcMainService.filterBillStatusAndStatus(docs, taxationsysId), (String)"taxoffice");
    }

    public static List<Long> loadTaxcMainOrgIdByOrgAttrIds(List<Long> orgAttrIds, Long taxationsysId) {
        DynamicObject[] docs = TaxcMainDao.loadTaxcMainFormDBByOrgAttrIds(TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, orgAttrIds, taxationsysId);
        docs = TaxcMainService.filterOrgViewEnbale(docs);
        return DyoToDtoUtils.dyoToLong((DynamicObject[])TaxcMainService.filterBillStatusAndStatus(docs, taxationsysId), (String)"taxorg");
    }

    public static List<Long> loadTaxcMainOrgIdByOrgIdsAndOrgAttrIds(List<Long> orgIds, List<Long> orgAttrIds, Long taxationsysId) {
        DynamicObject[] docs = TaxcMainDao.loadTaxcMainFormDBByOrgAttrIds(TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, orgIds, orgAttrIds, taxationsysId);
        return DyoToDtoUtils.dyoToLong((DynamicObject[])docs, (String)"taxorg");
    }

    public static List<Long> loadTaxcMainIdByOrgIds(List<Long> orgIds, Long taxationsysId) {
        DynamicObject[] docs = TaxcMainDao.loadTaxcMainFormDBByOrgIds(TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, orgIds, taxationsysId);
        docs = TaxcMainService.filterOrgViewEnbale(docs);
        return DyoToDtoUtils.dyoToLong((DynamicObject[])TaxcMainService.filterBillStatusAndStatus(docs, taxationsysId));
    }

    public static List<Long> loadTaxOfficeIdByOrgNums(List<String> orgNums, Long taxationsysId) {
        DynamicObject[] docs = TaxcMainDao.loadTaxcMainFormDBByOrgNums(TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, orgNums, taxationsysId);
        docs = TaxcMainService.filterOrgViewEnbale(docs);
        return DyoToDtoUtils.dyoToLong((DynamicObject[])TaxcMainService.filterBillStatusAndStatus(docs, taxationsysId), (String)"taxoffice");
    }

    public static List<Long> queryTaxcMainOrgIdsByUnifiedsocialCodes(List<String> unifiedsocialcodes, Long taxationsysId) {
        DynamicObject[] docs = TaxcMainDao.loadTaxcMainFormDBByUnifiedsocialCodes(TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, unifiedsocialcodes, taxationsysId);
        docs = TaxcMainService.filterOrgViewEnbale(docs);
        return DyoToDtoUtils.dyoToLong((DynamicObject[])TaxcMainService.filterBillStatusAndStatus(docs, taxationsysId), (String)"taxorg");
    }

    public static List<Long> loadTaxcMainOrgIdsByFinancialStatementAndIsTaxpayer(Long taxationsysId) {
        DynamicObject[] docs = TaxcMainDao.loadTaxcMainFormDB(TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, taxationsysId);
        docs = TaxcMainService.filterOrgViewEnbale(docs);
        return DyoToDtoUtils.dyoToLong((DynamicObject[])TaxcMainService.filterBillStatusAndStatusAndIsTaxPayerAndFinancialstatement(docs, taxationsysId), (String)"taxorg");
    }

    public static List<Long> loadTaxcMainOrgIdByOrgIdAndIsTaxpayer(List<Long> orgIds, Long taxationsysId) {
        DynamicObject[] dyos = TaxcMainDao.loadTaxcMainFormDBByOrgIds(TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, orgIds, taxationsysId);
        dyos = TaxcMainService.filterOrgViewEnbale(dyos);
        return DyoToDtoUtils.dyoToLong((DynamicObject[])TaxcMainService.filterBillStatusAndStatusAndIsTaxPayer(dyos, taxationsysId), (String)"taxorg");
    }

    public static List<Long> loadTaxcMainOrgIdByIsTaxpayer(Long taxationsysId) {
        DynamicObject[] dyos = TaxcMainDao.loadTaxcMainFormDB(TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, taxationsysId);
        dyos = TaxcMainService.filterOrgViewEnbale(dyos);
        return DyoToDtoUtils.dyoToLong((DynamicObject[])TaxcMainService.filterBillStatusAndStatusAndIsTaxPayer(dyos, taxationsysId), (String)"taxorg");
    }

    public static List<Long> loadTaxcMainOrgIdByIsTaxpayer(Long taxationsysId, boolean isIncludeTaxationsys) {
        DynamicObject[] dyos = TaxcMainDao.loadTaxcMainFormDB(TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, taxationsysId, isIncludeTaxationsys);
        dyos = TaxcMainService.filterOrgViewEnbale(dyos);
        return DyoToDtoUtils.dyoToLong((DynamicObject[])TaxcMainService.filterBillStatusAndStatusAndIsTaxPayer(dyos, taxationsysId, isIncludeTaxationsys), (String)"taxorg");
    }

    public static List<Long> loadTaxcMainOrgIdsByTaxpayer(Long taxationsysId) {
        DynamicObject[] dyos = TaxcMainDao.loadTaxcMainFormDB(TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, taxationsysId);
        dyos = TaxcMainService.filterOrgViewEnbale(dyos);
        return DyoToDtoUtils.dyoToLong((DynamicObject[])TaxcMainService.filterTaxPayer(dyos, taxationsysId), (String)"taxorg");
    }

    public static List<Long> loadTaxcMainOrgIds(Long taxationsysId) {
        DynamicObject[] dyos = TaxcMainDao.loadTaxcMainFormDB(TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, taxationsysId);
        dyos = TaxcMainService.filterOrgViewEnbale(dyos);
        return DyoToDtoUtils.dyoToLong((DynamicObject[])TaxcMainService.filterBillStatusAndStatus(dyos, taxationsysId), (String)"taxorg");
    }

    public static List<Long> loadTaxcMainOrgIdByOrgIds(List<Long> orgIds, Long taxationsysId) {
        DynamicObject[] dyos = TaxcMainDao.loadTaxcMainFormDBByOrgIds(TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, orgIds, taxationsysId);
        dyos = TaxcMainService.filterOrgViewEnbale(dyos);
        return DyoToDtoUtils.dyoToLong((DynamicObject[])TaxcMainService.filterBillStatusAndStatus(dyos, taxationsysId), (String)"taxorg");
    }

    public static List<Long> loadTaxcMainOrgIdsByIsTaxpayerForHws(Long taxationsysId, Long categoryId, boolean istaxpayer) {
        DynamicObject[] dyos = TaxcMainDao.loadTaxcMainFormDB(TaxcMainConstant.TAXC_MAIN_CARD_FILED_HWS, taxationsysId, categoryId);
        dyos = TaxcMainService.filterOrgViewEnbale(dyos);
        return DyoToDtoUtils.dyoToLong((DynamicObject[])TaxcMainService.filterBillStatusAndStatusForHws(dyos, taxationsysId, categoryId, istaxpayer), (String)"taxorg");
    }

    public static DynamicObject[] loadTaxcMainZzsByOrgId(List<Long> orgids, Long taxationsysId) {
        DynamicObject[] cardObjs = TaxcMainDao.loadTaxcMainFormDBByOrgIds(TaxcMainConstant.TAXC_MAIN_CARD_FILED, orgids, taxationsysId);
        cardObjs = TaxcMainService.filterOrgViewEnbale(cardObjs);
        return TaxcMainService.filterBillStatusAndStatusWithTaxtype(cardObjs, taxationsysId, TaxcMainConstant.TAXTYPE_ZZS, false);
    }

    public static DynamicObject[] loadTaxcMainQysdsByOrgIds(List<Long> orgids, Long taxationsysId) {
        DynamicObject[] cardObjs = TaxcMainDao.loadTaxcMainFormDBByOrgIds(TaxcMainConstant.TAXC_MAIN_CARD_FILED, orgids, taxationsysId);
        cardObjs = TaxcMainService.filterOrgViewEnbale(cardObjs);
        return TaxcMainService.filterBillStatusAndStatusWithTaxtype(cardObjs, taxationsysId, TaxcMainConstant.TAXTYPE_QYSDS, false);
    }

    public static DynamicObject[] loadTaxcMainQysdsByOrgNums(List<String> orgNums, Long taxationsysId) {
        DynamicObject[] cardObjs = TaxcMainDao.loadTaxcMainFormDBByOrgNums(TaxcMainConstant.TAXC_MAIN_CARD_FILED, orgNums, taxationsysId);
        cardObjs = TaxcMainService.filterOrgViewEnbale(cardObjs);
        return TaxcMainService.filterBillStatusAndStatusWithTaxtype(cardObjs, taxationsysId, TaxcMainConstant.TAXTYPE_QYSDS, false);
    }

    public static DynamicObject[] loadTaxcMainSzysByOrgId(List<Long> orgids, Long taxationsysId) {
        DynamicObject[] cardObjs = TaxcMainDao.loadTaxcMainFormDBByOrgIds(TaxcMainConstant.TAXC_MAIN_CARD_FILED, orgids, taxationsysId);
        cardObjs = TaxcMainService.filterOrgViewEnbale(cardObjs);
        return TaxcMainService.filterBillStatusAndStatusWithTaxtype(cardObjs, taxationsysId, TaxcMainConstant.TAXTYPE_SZYS, false);
    }

    public static DynamicObject[] loadTaxcMainCategoryByOrgId(List<Long> orgIds, Long taxationsysId, Long categoryId, boolean istaxpayer) {
        DynamicObject[] cardObjs = TaxcMainDao.loadTaxcMainFormDBByOrgIds(TaxcMainConstant.TAXC_MAIN_CARD_FILED_HWS, orgIds, taxationsysId);
        cardObjs = TaxcMainService.filterOrgViewEnbale(cardObjs);
        return TaxcMainService.filterBillStatusAndStatusForHws(cardObjs, taxationsysId, categoryId, istaxpayer);
    }

    public static DynamicObject[] loadTaxcMainYhsByOrgId(List<Long> orgIds, Long taxationsysId) {
        DynamicObject[] cardObjs = TaxcMainDao.loadTaxcMainFormDBByOrgIds(TaxcMainConstant.TAXC_MAIN_CARD_FILED_YHS, orgIds, taxationsysId);
        cardObjs = TaxcMainService.filterOrgViewEnbale(cardObjs);
        return TaxcMainService.filterBillStatusAndStatusWithTaxtype(cardObjs, taxationsysId, TaxcMainConstant.TAXTYPE_YHS, false);
    }

    public static DynamicObject[] loadTaxcMainXfsByOrgId(List<Long> orgIds, Long taxationsysId) {
        DynamicObject[] cardObjs = TaxcMainDao.loadTaxcMainFormDBByOrgIds(TaxcMainConstant.TAXC_MAIN_CARD_FILED_XFS, orgIds, taxationsysId);
        cardObjs = TaxcMainService.filterOrgViewEnbale(cardObjs);
        return TaxcMainService.filterBillStatusAndStatusWithTaxtype(cardObjs, taxationsysId, TaxcMainConstant.TAXTYPE_XFS, false);
    }

    public static DynamicObject[] loadTaxcMainHjbhsByOrgId(List<Long> orgIds, Long taxationsysId) {
        DynamicObject[] cardObjs = TaxcMainDao.loadTaxcMainFormDBByOrgIds(TaxcMainConstant.TAXC_MAIN_CARD_FILED_HJBHS, orgIds, taxationsysId);
        cardObjs = TaxcMainService.filterOrgViewEnbale(cardObjs);
        return TaxcMainService.filterBillStatusAndStatusWithTaxtype(cardObjs, taxationsysId, TaxcMainConstant.TAXTYPE_HJBHS, false);
    }

    public static DynamicObject[] loadTaxcMainQtsfByOrgId(List<Long> orgIds, Long taxationsysId) {
        DynamicObject[] cardObjs = TaxcMainDao.loadTaxcMainFormDBByOrgIds(TaxcMainConstant.TAXC_MAIN_CARD_FILED_QTSF, orgIds, taxationsysId);
        cardObjs = TaxcMainService.filterOrgViewEnbale(cardObjs);
        return TaxcMainService.filterBillStatusAndStatusWithTaxtype(cardObjs, taxationsysId, TaxcMainConstant.TAXTYPE_QTSF, false);
    }

    public static DynamicObject[] queryTaxcMainCategoryByOrgIdsAndTaxtype(List<Long> orgIds, String taxtype, Long taxationsysId) {
        DynamicObject[] cardObjs = TaxcMainDao.loadTaxcMainFormDBByOrgIds(TaxcMainConstant.TAXC_MAIN_CARD_FILED, orgIds, taxationsysId);
        cardObjs = TaxcMainService.filterOrgViewEnbale(cardObjs);
        return TaxcMainService.filterIsTaxpayerWithTaxtype(cardObjs, taxationsysId, taxtype, false, true);
    }

    public static DynamicObject[] queryBatchTaxcMainByOrgIds(List<Long> orgIds, List<Long> taxationsysIds, List<Long> categoryIds) {
        DynamicObject[] cardObjs = TaxcMainDao.loadTaxcMainFormDBByOrgIds(TaxcMainConstant.TAXC_MAIN_CARD_FILED, orgIds, taxationsysIds, categoryIds);
        cardObjs = TaxcMainService.filterOrgViewEnbale(cardObjs);
        return TaxcMainService.filterBillStatusAndStatusForHws(cardObjs, taxationsysIds, true);
    }

    public static DynamicObject[] loadTaxcMainFjsfByOrgIds(List<Long> orgIds, Long taxationsysId) {
        DynamicObject[] cardObjs = TaxcMainDao.loadTaxcMainFormDBByOrgIds(TaxcMainConstant.TAXC_MAIN_CARD_FILED, orgIds, taxationsysId);
        cardObjs = TaxcMainService.filterOrgViewEnbale(cardObjs);
        return TaxcMainService.filterBillStatusAndStatusWithTaxtype(cardObjs, taxationsysId, TaxcMainConstant.TAXTYPE_FJSF, false);
    }

    public static DynamicObject[] loadTaxcMainCategoryByIsTaxpayerForHws(List<Long> orgIds, Long taxationsysId, Long categoryId, boolean istaxpayer) {
        DynamicObject[] cardObjs = TaxcMainDao.loadTaxcMainFormDBByOrgIds(TaxcMainConstant.TAXC_MAIN_CARD_FILED_HWS, orgIds, taxationsysId, categoryId);
        cardObjs = TaxcMainService.filterOrgViewEnbale(cardObjs);
        return TaxcMainService.filterBillStatusAndStatusForHws(cardObjs, taxationsysId, categoryId, istaxpayer);
    }

    public static Boolean isTaxcMainZzsEnableByOrgId(long orgid, Long taxationsysId) {
        DynamicObject cardObj = TaxcMainDao.loadTaxcMainFormDBByOrgId(TaxcMainConstant.TAXC_MAIN_CARD_FILED, orgid, taxationsysId);
        return TaxcMainService.taxTypeIsEnbale(cardObj, TaxcMainConstant.TAXTYPE_ZZS, taxationsysId);
    }

    public static Boolean loadTaxcMainZzsTaxpayerTypeByOrgId(Long orgid, Long taxationsysId) {
        DynamicObject cardObj = TaxcMainDao.loadTaxcMainFormDBByOrgId(TaxcMainConstant.TAXC_MAIN_CARD_FILED, orgid, taxationsysId);
        return TaxcMainService.isBillStatusAndStatusAndIsTaxPayerAndYbnsr(cardObj, TaxcMainConstant.TAXTYPE_ZZS, taxationsysId);
    }

    public static Boolean isTaxcMainQysdsEnableByOrgId(Long orgId, Long taxationsysId) {
        DynamicObject cardObj = TaxcMainDao.loadTaxcMainFormDBByOrgId(TaxcMainConstant.TAXC_MAIN_CARD_FILED, orgId, taxationsysId);
        return TaxcMainService.taxTypeIsEnbale(cardObj, TaxcMainConstant.TAXTYPE_QYSDS, taxationsysId);
    }

    public static Boolean isTaxcMainSzysEnableByOrgId(long orgid, Long taxationsysId) {
        DynamicObject cardObj = TaxcMainDao.loadTaxcMainFormDBByOrgId(TaxcMainConstant.TAXC_MAIN_CARD_FILED, orgid, taxationsysId);
        return TaxcMainService.taxTypeIsEnbale(cardObj, TaxcMainConstant.TAXTYPE_SZYS, taxationsysId);
    }

    public static Boolean isTaxcMainXfsEnableByOrgId(long orgid, Long taxationsysId) {
        DynamicObject cardObj = TaxcMainDao.loadTaxcMainFormDBByOrgId(TaxcMainConstant.TAXC_MAIN_CARD_FILED, orgid, taxationsysId);
        return TaxcMainService.taxTypeIsEnbale(cardObj, TaxcMainConstant.TAXTYPE_XFS, taxationsysId);
    }

    public static Boolean isTaxcMainHjbhsEnableByOrgId(long orgid, Long taxationsysId) {
        DynamicObject cardObj = TaxcMainDao.loadTaxcMainFormDBByOrgId(TaxcMainConstant.TAXC_MAIN_CARD_FILED, orgid, taxationsysId);
        return TaxcMainService.taxTypeIsEnbale(cardObj, TaxcMainConstant.TAXTYPE_HJBHS, taxationsysId);
    }

    public static Boolean isTaxcMainYhsEnableByOrgId(long orgid, Long taxationsysId) {
        DynamicObject cardObj = TaxcMainDao.loadTaxcMainFormDBByOrgId(TaxcMainConstant.TAXC_MAIN_CARD_FILED, orgid, taxationsysId);
        return TaxcMainService.taxTypeIsEnbale(cardObj, TaxcMainConstant.TAXTYPE_YHS, taxationsysId);
    }

    public static Boolean isTaxcMainFcsEnableByOrgId(long orgid, Long taxationsysId) {
        DynamicObject cardObj = TaxcMainDao.loadTaxcMainFormDBByOrgId(TaxcMainConstant.TAXC_MAIN_CARD_FILED, orgid, taxationsysId);
        return TaxcMainService.taxTypeIsEnbale(cardObj, TaxcMainConstant.TAXTYPE_FCSCZTDSYS, taxationsysId);
    }

    public static Boolean isTaxcMainFjsfEnableByOrgId(long orgid, Long taxationsysId) {
        DynamicObject cardObj = TaxcMainDao.loadTaxcMainFormDBByOrgId(TaxcMainConstant.TAXC_MAIN_CARD_FILED, orgid, taxationsysId);
        return TaxcMainService.taxTypeIsEnbale(cardObj, TaxcMainConstant.TAXTYPE_FJSF, taxationsysId);
    }

    public static Boolean isTaxcMainQtsfEnableByOrgId(long orgid, Long taxationsysId) {
        DynamicObject cardObj = TaxcMainDao.loadTaxcMainFormDBByOrgId(TaxcMainConstant.TAXC_MAIN_CARD_FILED, orgid, taxationsysId);
        return TaxcMainService.taxTypeIsEnbale(cardObj, TaxcMainConstant.TAXTYPE_QTSF, taxationsysId);
    }

    public static Boolean isTaxcMainTdzzsEnableByOrgId(long orgid, Long taxationsysId) {
        DynamicObject cardObj = TaxcMainDao.loadTaxcMainFormDBByOrgId(TaxcMainConstant.TAXC_MAIN_CARD_FILED, orgid, taxationsysId);
        return TaxcMainService.taxTypeIsEnbale(cardObj, TaxcMainConstant.TAXTYPE_TDZZS, taxationsysId);
    }

    public static Map<Long, Map<String, Boolean>> isTaxcMainCategoryEnableByOrgId(List<Long> orgIds, Long taxationsysId) {
        DynamicObject[] cardObjs = TaxcMainDao.loadTaxcMainFormDBByOrgIds(TaxcMainConstant.TAXC_MAIN_CARD_FILED, orgIds, taxationsysId);
        return TaxcMainService.filterTaxTypeIsEnbale(cardObjs, taxationsysId);
    }

    public static DynamicObject[] getTaxMainInfoByIds(List<Long> ids) {
        Object[] pks = new Object[ids.size()];
        int size = ids.size();
        for (int i = 0; i < size; ++i) {
            pks[i] = ids.get(i);
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"tctb_tax_main");
        return BusinessDataServiceHelper.load((Object[])pks, (DynamicObjectType)type);
    }

    public static DynamicObject[] getTaxMainInfoByOrgIds(List<Long> orgids) {
        QFilter orgFilter = new QFilter("orgid", "in", orgids);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"tctb_tax_main", (String)"id,orgid,number,billstatus,taxationsys,registerplace,taxjurisdiction", (QFilter[])new QFilter[]{orgFilter});
        if (EmptyCheckUtils.isEmpty((Object)dynamicObjects)) {
            return null;
        }
        return dynamicObjects;
    }

    public static Map<String, String> checkTaxPayersMustInput(List<Long> orgIds, Long taxationsysId) {
        DynamicObject[] objs = TaxcMainDao.loadTaxcMainFormDBByOrgIds(TaxcMainConstant.TAXC_MAIN_TAXPAYER_MUST_INPUT, orgIds, taxationsysId);
        DynamicObject obj2 = null;
        String result = null;
        HashMap<String, String> resultMap = new HashMap<String, String>(10);
        for (DynamicObject obj2 : objs) {
            if (obj2.getDynamicObject("taxorg") == null || obj2.getDynamicObject("taxationsys") == null || !StringUtil.isNotEmpty((CharSequence)(result = TaxcMainService.checkTaxPayerMustInput(obj2)))) continue;
            resultMap.put(TaxcMainService.getTaxcMainDimKey(obj2), result);
        }
        return resultMap;
    }

    public static DynamicObject getTaxVer(Long orgId, String tax, Date time) {
        DynamicObject[] dyns = TaxcMainDao.loadTaxVer(orgId, tax);
        return TaxcMainBusiness.filterTaxRecordVerByTime(dyns, orgId, tax, time);
    }

    public static Map<String, Object> getZzsTaxVer(Long orgId, Date time) {
        logger.info("getZzsTaxVer" + orgId + time);
        String tax = "zzs";
        DynamicObject[] dyns = TaxcMainDao.loadTaxVer(orgId, tax);
        DynamicObject dyn = TaxcMainBusiness.filterTaxRecordVerByTime(dyns, orgId, tax, time);
        Map<String, Object> map = TaxcMainBusiness.translatZzs(dyn, true);
        Date startDate = (Date)map.remove("taxenddate");
        map.put("taxstartdate", startDate);
        if (startDate != null) {
            DynamicObject dynBefor = TaxcMainBusiness.filterTaxRecordVerByBeforeModifyDate(dyns, orgId, tax, startDate);
            Map<String, Object> mapBefore = TaxcMainBusiness.translatZzs(dynBefor, true);
            Date endDate = (Date)mapBefore.get("taxenddate");
            if (endDate == null) {
                endDate = startDate;
            }
            if (endDate.after(startDate)) {
                map.put("taxenddate", endDate);
            }
        }
        return map;
    }

    private static DynamicObject filterTaxRecordVerByTime(DynamicObject[] dynsOrderByModifyDateDesc, Long orgId, String tax, Date time) {
        for (DynamicObject dyn : dynsOrderByModifyDateDesc) {
            for (DynamicObject entity : dyn.getDynamicObjectCollection("entryentity")) {
                Date date2;
                String key = entity.getString("modifycontexttitleysjbs");
                if (!"taxenddate".equals(key)) continue;
                String date2Str = entity.getString("modifycontexafter");
                if (StringUtil.isEmpty((CharSequence)date2Str)) {
                    logger.error("modifycontexafter is null" + entity.get("id"));
                    continue;
                }
                try {
                    date2 = DateUtils.stringToDate((String)date2Str);
                }
                catch (Exception e) {
                    logger.error("modifycontexafter is erro" + entity.get("id") + " " + date2Str);
                    logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                    continue;
                }
                if (time.compareTo(date2) < 0) continue;
                return dyn;
            }
        }
        return null;
    }

    private static DynamicObject filterTaxRecordVerByBeforeModifyDate(DynamicObject[] dynsOrderByModifyDateDesc, Long orgId, String tax, Date beforModifyDate) {
        DynamicObject[] dyns = TaxcMainDao.loadTaxVer(orgId, "zzs");
        DynamicObject target = null;
        for (DynamicObject dyn : dyns) {
            for (DynamicObject entity : dyn.getDynamicObjectCollection("entryentity")) {
                String key = entity.getString("modifycontexttitleysjbs");
                if (!"taxenddate".equals(key)) continue;
                Date date1 = entity.getDate("modifycontexbefore");
                if (!DateUtils.format((Date)beforModifyDate).equals(DateUtils.format((Date)date1))) continue;
                target = dyn;
                break;
            }
            if (target != null) break;
        }
        return target;
    }

    private static Map<String, Object> translatZzs(DynamicObject dyn, boolean afterValueFlag) {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        if (dyn == null) {
            return map;
        }
        DynamicObjectCollection dyns = dyn.getDynamicObjectCollection("entryentity");
        for (DynamicObject item : dyns) {
            String key = item.getString("modifycontexttitleysjbs");
            Object value = null;
            if ("taxenddate".equals(key)) {
                String dataStr = afterValueFlag ? item.getString("modifycontexafter") : item.getString("modifycontexbefor");
                value = DateUtils.stringToDate((String)dataStr);
            } else {
                value = afterValueFlag ? item.getString("modifycontexaftercode") : item.getString("modifycontexbeforecode");
            }
            map.put(key, value);
        }
        return map;
    }

    public static DynamicObject[] filterIsRegistedAddress(List<Long> orgIds) {
        DynamicObject[] dyns = TaxcMainDao.loadTaxcMainByOrgIds(orgIds);
        List list = kd.taxc.bdtaxr.business.taxcmain.TaxcMainBusiness.filterCommonBatch(Arrays.asList(dyns), (Boolean)true, (Boolean)true, (Boolean)true, null);
        list = kd.taxc.bdtaxr.business.taxcmain.TaxcMainBusiness.filterIsRegisterPlaceBatch((List)list, (Boolean)true);
        return list.toArray(new DynamicObject[0]);
    }

    public static DynamicObject[] filterAllIsRegistedAddress() {
        return TaxcMainBusiness.filterIsRegistedAddress(null);
    }
}

