/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.business.taxcmain;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.taxc.bdtaxr.common.constant.tctb.TaxcMainConstant;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.TaxationsysMappingEnum;
import kd.taxc.bdtaxr.common.helper.bos.param.SystemParamDataServiceHelper;
import org.apache.commons.collections.CollectionUtils;

public class TaxcMainDao {
    public static DynamicObject loadTaxcMainFormDBByOrgId(String selectFiled, Long orgId, Long taxationsysId) {
        return TaxcMainDao.loadOneTaxcMainByQfilter(selectFiled, TaxcMainConstant.taxOrgQFilter((Long)orgId), taxationsysId);
    }

    public static DynamicObject loadTaxcMainFormDBByTaxpayer(String selectFiled, String taxpayer, Long taxationsysId) {
        return TaxcMainDao.loadOneTaxcMainByQfilter(selectFiled, TaxcMainConstant.taxpayerQFilter((String)taxpayer), taxationsysId);
    }

    public static DynamicObject loadTaxcMainFormDBByOrgName(String selectFiled, String orgName, Long taxationsysId) {
        return TaxcMainDao.loadOneTaxcMainByQfilter(selectFiled, TaxcMainConstant.orgNameQfillter((String)orgName), taxationsysId);
    }

    public static DynamicObject loadTaxcMainFormDBByOrgNum(String selectFiled, String orgNum, Long taxationsysId) {
        return TaxcMainDao.loadOneTaxcMainByQfilter(selectFiled, TaxcMainConstant.orgNumQFilter((String)orgNum), taxationsysId);
    }

    public static DynamicObject[] loadTaxcMainFormDBByOrgAttrId(String selectFiled, Long orgAttrId, Long taxationsysId) {
        return TaxcMainDao.loadTaxcMainByQfilter(selectFiled, TaxcMainConstant.orgattrQFilter((Long)orgAttrId), taxationsysId);
    }

    public static DynamicObject loadTaxcMainFormDBByUnifiedsocialCode(String selectFiled, String unifiedsocialcode, Long taxationsysId) {
        return TaxcMainDao.loadOneTaxcMainByQfilter(selectFiled, TaxcMainConstant.unifiedsocialcodeQFilter((String)unifiedsocialcode), taxationsysId);
    }

    public static DynamicObject[] loadTaxcMainFormDBByTaxOfficeId(String selectFiled, Long taxofficeId, Long taxationsysId) {
        return TaxcMainDao.loadTaxcMainByQfilter(selectFiled, TaxcMainConstant.taxOfficeQFilter((Long)taxofficeId), taxationsysId);
    }

    public static DynamicObject[] loadTaxcMainFormDBByOrgIds(String selectFiled, List<Long> orgIds, Long taxationsysId) {
        return TaxcMainDao.loadTaxcMainByQfilter(selectFiled, TaxcMainConstant.taxOrgQFilter(orgIds), taxationsysId);
    }

    public static DynamicObject[] loadTaxcMainFormDBByOrgIds(String selectFiled, List<Long> orgIds, Long taxationsysId, Long categoryId) {
        return TaxcMainDao.loadTaxcMainByQfilter(selectFiled, TaxcMainConstant.taxOrgQFilter(orgIds).and(TaxcMainDao.buildCategoryQfilter(categoryId)), taxationsysId);
    }

    public static DynamicObject[] loadTaxcMainFormDBByOrgIds(String selectFiled, List<Long> orgIds, List<Long> taxationsysIds, List<Long> categoryIds) {
        return TaxcMainDao.loadTaxcMainByQfilter(selectFiled, TaxcMainConstant.taxOrgQFilter(orgIds).and(TaxcMainDao.buildCategoryQfilter(categoryIds)), taxationsysIds);
    }

    public static DynamicObject[] loadTaxcMainFormDBByOrgIds(String selectFiled, List<Long> orgIds, Long taxationsysId, boolean isIncludeTaxationsys) {
        return TaxcMainDao.loadTaxcMainByQfilter(selectFiled, TaxcMainConstant.taxOrgQFilter(orgIds), taxationsysId, isIncludeTaxationsys);
    }

    public static DynamicObject[] loadTaxcMainFormDBByOrgNums(String selectFiled, List<String> orgNums, Long taxationsysId) {
        return TaxcMainDao.loadTaxcMainByQfilter(selectFiled, TaxcMainConstant.orgNumQFilter(orgNums), taxationsysId);
    }

    public static DynamicObject[] loadTaxcMainFormDBByOrgAttrIds(String selectFiled, List<Long> orgAttrIds, Long taxationsysId) {
        return TaxcMainDao.loadTaxcMainByQfilter(selectFiled, TaxcMainConstant.orgattrQFilter(orgAttrIds), taxationsysId);
    }

    public static DynamicObject[] loadTaxcMainFormDBByOrgAttrIds(String selectFiled, List<Long> orgIds, List<Long> orgAttrIds, Long taxationsysId) {
        if (CollectionUtils.isNotEmpty(orgIds)) {
            return TaxcMainDao.loadTaxcMainByQfilter(selectFiled, TaxcMainConstant.taxOrgQFilter(orgIds).and(TaxcMainConstant.orgattrQFilter(orgAttrIds)), taxationsysId);
        }
        return TaxcMainDao.loadTaxcMainByQfilter(selectFiled, TaxcMainConstant.orgattrQFilter(orgAttrIds), taxationsysId);
    }

    public static DynamicObject[] loadTaxcMainFormDBByUnifiedsocialCodes(String selectFiled, List<String> unifiedsocialcodes, Long taxationsysId) {
        return TaxcMainDao.loadTaxcMainByQfilter(selectFiled, TaxcMainConstant.unifiedsocialcodeQFilter(unifiedsocialcodes), taxationsysId);
    }

    public static DynamicObject[] loadTaxcMainFormDBByTaxOfficeIds(String selectFiled, List<Long> taxofficeIds, Long taxationsysId) {
        return TaxcMainDao.loadTaxcMainByQfilter(selectFiled, TaxcMainConstant.taxOfficeQFilter(taxofficeIds), taxationsysId);
    }

    public static DynamicObject[] loadTaxcMainFormDB(String selectFiled, Long taxationsysId) {
        return TaxcMainDao.loadTaxcMainByQfilter(selectFiled, null, taxationsysId);
    }

    public static DynamicObject[] loadTaxcMainFormDB(String selectFiled, Long taxationsysId, Long categoryId) {
        return TaxcMainDao.loadTaxcMainByQfilter(selectFiled, TaxcMainDao.buildCategoryQfilter(categoryId), taxationsysId);
    }

    public static DynamicObject[] loadTaxcMainFormDB(String selectFiled, Long taxationsysId, boolean isIncludeTaxationsys) {
        return TaxcMainDao.loadTaxcMainByQfilter(selectFiled, null, taxationsysId, isIncludeTaxationsys);
    }

    private static DynamicObject[] loadTaxcMainByQfilter(String selectFields, QFilter qfilter, Long taxationsysId) {
        if (null == qfilter) {
            qfilter = new QFilter("1", "=", (Object)1);
        }
        if (TaxcMainDao.isOverseasTaxOrg()) {
            if (taxationsysId != null) {
                qfilter = qfilter.and(new QFilter("taxationsys", "=", (Object)taxationsysId));
            }
        } else {
            qfilter = qfilter.and(new QFilter("taxationsys", "=", (Object)TaxationsysMappingEnum.CHN.getId()));
        }
        return BusinessDataServiceHelper.load((String)TaxcMainConstant.ENTITYNAME, (String)selectFields, (QFilter[])new QFilter[]{qfilter});
    }

    private static DynamicObject[] loadTaxcMainByQfilter(String selectFields, QFilter qfilter, List<Long> taxationsysIds) {
        if (null == qfilter) {
            qfilter = new QFilter("1", "=", (Object)1);
        }
        if (TaxcMainDao.isOverseasTaxOrg()) {
            if (CollectionUtils.isNotEmpty(taxationsysIds)) {
                qfilter = qfilter.and(new QFilter("taxationsys", "in", taxationsysIds));
            }
        } else {
            qfilter = qfilter.and(new QFilter("taxationsys", "=", (Object)TaxationsysMappingEnum.CHN.getId()));
        }
        return BusinessDataServiceHelper.load((String)TaxcMainConstant.ENTITYNAME, (String)selectFields, (QFilter[])new QFilter[]{qfilter});
    }

    private static QFilter buildCategoryQfilter(Long categoryId) {
        if (categoryId != null && categoryId != 0L) {
            return new QFilter("hwsentryentity.hwstaxtype", "=", (Object)categoryId).and("hwsentryentity.hwsenable", "=", (Object)"1");
        }
        return null;
    }

    private static QFilter buildCategoryQfilter(List<Long> categoryIds) {
        if (CollectionUtils.isNotEmpty(categoryIds)) {
            return new QFilter("hwsentryentity.hwstaxtype", "in", categoryIds).and("hwsentryentity.hwsenable", "=", (Object)"1");
        }
        return null;
    }

    private static DynamicObject[] loadTaxcMainByQfilter(String selectFields, QFilter qfilter, Long taxationsysId, boolean isIncludeTaxationsys) {
        if (null == qfilter) {
            qfilter = new QFilter("1", "=", (Object)1);
        }
        if (TaxcMainDao.isOverseasTaxOrg()) {
            if (taxationsysId != null) {
                qfilter = isIncludeTaxationsys ? qfilter.and(new QFilter("taxationsys", "=", (Object)taxationsysId)) : qfilter.and(new QFilter("taxationsys", "!=", (Object)taxationsysId));
            }
        } else {
            qfilter = isIncludeTaxationsys ? qfilter.and(new QFilter("taxationsys", "=", (Object)TaxationsysMappingEnum.CHN.getId())) : qfilter.and(new QFilter("taxationsys", "!=", (Object)TaxationsysMappingEnum.CHN.getId()));
        }
        return BusinessDataServiceHelper.load((String)TaxcMainConstant.ENTITYNAME, (String)selectFields, (QFilter[])new QFilter[]{qfilter});
    }

    private static DynamicObject loadOneTaxcMainByQfilter(String selectFields, QFilter qfilter, Long taxationsysId) {
        if (null == qfilter) {
            qfilter = new QFilter("1", "=", (Object)1);
        }
        if (TaxcMainDao.isOverseasTaxOrg()) {
            if (taxationsysId != null) {
                qfilter = qfilter.and(new QFilter("taxationsys", "=", (Object)taxationsysId));
            }
        } else {
            qfilter = qfilter.and(new QFilter("taxationsys", "=", (Object)TaxationsysMappingEnum.CHN.getId()));
        }
        return BusinessDataServiceHelper.loadSingle((String)TaxcMainConstant.ENTITYNAME, (String)selectFields, (QFilter[])new QFilter[]{qfilter});
    }

    public static boolean isOverseasTaxOrg() {
        boolean isEnable = false;
        TaxResult appParameter = SystemParamDataServiceHelper.getAppParameter((String)"tctb", (String)"enableoverseastax", (Long)OrgUnitServiceHelper.getRootOrgId());
        if (appParameter != null && appParameter.getData() != null) {
            isEnable = (Boolean)appParameter.getData();
        }
        return isEnable;
    }

    public static DynamicObject[] loadTaxVer(Long orgId, String tax) {
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and("taxtype", "=", (Object)tax);
        DynamicObject[] dyns = BusinessDataServiceHelper.load((String)"tctb_tax_ver_normal", (String)"id,modifydate,modifier,org,taxtype,ver,entryentity,entryentity.seq,entryentity.modifycontexbeforecode,entryentity.modifycontexaftercode,entryentity.modifycontexttitleysjbs,entryentity.modifycontexafter,entryentity.modifycontexbefore,entryentity.modifycontexttitle", (QFilter[])new QFilter[]{filter}, (String)"modifydate desc");
        return TaxcMainDao.sortByModifyerDesc(dyns);
    }

    public static DynamicObject[] sortByModifyerDesc(DynamicObject[] taxverNormalDyns) {
        Comparator<DynamicObject> comparetor = new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                Date d1 = o1.getDate("modifydate");
                Date d2 = o2.getDate("modifydate");
                if (d1 == null && d2 == null) {
                    return 0;
                }
                if (d1 == null) {
                    return -1;
                }
                if (d2 == null) {
                    return 1;
                }
                return d1.compareTo(d2);
            }
        };
        List<DynamicObject> list = Arrays.asList(taxverNormalDyns);
        Collections.sort(list, comparetor);
        Collections.reverse(list);
        return list.toArray(new DynamicObject[0]);
    }

    public static DynamicObject[] loadTaxcMainByOrgIds(List<Long> orgIds) {
        QFilter filter = new QFilter("1", "=", (Object)1);
        if (orgIds != null && orgIds.size() > 0) {
            filter.and("taxorg.org.id", "in", orgIds);
        }
        return BusinessDataServiceHelper.load((String)TaxcMainConstant.ENTITYNAME, (String)TaxcMainConstant.TAXC_MAIN_BASE_INFO_FILED, (QFilter[])new QFilter[]{filter});
    }
}

