/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.business.taxcmain;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.taxc.bdtaxr.common.constant.tctb.BillStatusConstant;
import kd.taxc.bdtaxr.common.constant.tctb.TaxcMainConstant;
import kd.taxc.bdtaxr.common.enums.TaxationsysMappingEnum;
import kd.taxc.bdtaxr.common.errorcode.TaxcErrorCode;
import kd.taxc.bdtaxr.common.errorcode.TctbErrorCode;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class TaxcMainService {
    public static Boolean isBillStatusAndStatusAndIsTaxPayer(DynamicObject doc, Long taxationsysId) {
        return TaxcMainService.isBillStatusAndStatus(doc, taxationsysId) != false && TaxcMainService.isTaxPayer(doc, taxationsysId) != false;
    }

    public static DynamicObject[] filterBillStatusAndStatusAndIsTaxPayer(DynamicObject[] docs, Long taxationsysId) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        if (docs != null && docs.length > 0) {
            for (DynamicObject doc : docs) {
                if (!TaxcMainService.filterBillStatusAndStatus(doc, taxationsysId).booleanValue() || !TaxcMainService.filterTaxPayer(doc, taxationsysId).booleanValue()) continue;
                list.add(doc);
            }
        }
        return list.toArray(new DynamicObject[0]);
    }

    public static DynamicObject[] filterTaxPayer(DynamicObject[] docs, Long taxationsysId) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        if (docs != null && docs.length > 0) {
            for (DynamicObject doc : docs) {
                if (!TaxcMainService.filterTaxPayer(doc, taxationsysId).booleanValue()) continue;
                list.add(doc);
            }
        }
        return list.toArray(new DynamicObject[0]);
    }

    public static DynamicObject[] filterBillStatusAndStatusAndIsTaxPayer(DynamicObject[] docs, Long taxationsysId, boolean isIncludeTaxationsys) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        if (docs != null && docs.length > 0) {
            for (DynamicObject doc : docs) {
                if (!TaxcMainService.filterBillStatusAndStatus(doc, taxationsysId, isIncludeTaxationsys).booleanValue() || !TaxcMainService.filterTaxPayer(doc, taxationsysId, isIncludeTaxationsys).booleanValue()) continue;
                list.add(doc);
            }
        }
        return list.toArray(new DynamicObject[0]);
    }

    public static DynamicObject[] filterBillStatusAndStatusWithTaxtype(DynamicObject[] docs, Long taxationsysId, String taxtype, boolean istaxpayer) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        if (docs != null && docs.length > 0) {
            for (DynamicObject doc : docs) {
                if (!TaxcMainService.filterBillStatusAndStatus(doc, taxationsysId).booleanValue()) continue;
                TaxcMainService.filterTaxtype(doc, taxtype);
                if (istaxpayer) {
                    if (!TaxcMainService.filterTaxPayer(doc, taxationsysId).booleanValue()) continue;
                    list.add(doc);
                    continue;
                }
                list.add(doc);
            }
        }
        return list.toArray(new DynamicObject[0]);
    }

    public static DynamicObject[] filterIsTaxpayerWithTaxtype(DynamicObject[] docs, Long taxationsysId, String taxtype, boolean istaxpayer, boolean cardEnable) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        if (docs != null && docs.length > 0) {
            for (DynamicObject doc : docs) {
                TaxcMainService.filterTaxtype(doc, taxtype, cardEnable);
                if (istaxpayer) {
                    if (!TaxcMainService.filterTaxPayer(doc, taxationsysId).booleanValue()) continue;
                    list.add(doc);
                    continue;
                }
                list.add(doc);
            }
        }
        return list.toArray(new DynamicObject[0]);
    }

    public static DynamicObject[] filterBillStatusAndStatusForHws(DynamicObject[] docs, Long taxationsysId, Long categoryId, boolean istaxpayer) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        if (docs != null && docs.length > 0) {
            for (DynamicObject doc : docs) {
                if (!TaxcMainService.filterBillStatusAndStatus(doc, taxationsysId).booleanValue()) continue;
                if (istaxpayer) {
                    if (!TaxcMainService.filterTaxPayer(doc, taxationsysId).booleanValue()) continue;
                    list.add(doc);
                    continue;
                }
                list.add(doc);
            }
        }
        return list.toArray(new DynamicObject[0]);
    }

    public static DynamicObject[] filterBillStatusAndStatusForHws(DynamicObject[] docs, List<Long> taxationsysIds, boolean istaxpayer) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        if (docs != null && docs.length > 0) {
            for (DynamicObject doc : docs) {
                if (!TaxcMainService.filterBillStatusAndStatus(doc, taxationsysIds).booleanValue()) continue;
                if (istaxpayer) {
                    if (!TaxcMainService.filterTaxPayer(doc, taxationsysIds).booleanValue()) continue;
                    list.add(doc);
                    continue;
                }
                list.add(doc);
            }
        }
        return list.toArray(new DynamicObject[0]);
    }

    public static DynamicObject[] filterBillStatusAndStatus(DynamicObject[] docs, Long taxationsysId) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        if (docs != null && docs.length > 0) {
            for (DynamicObject doc : docs) {
                if (!TaxcMainService.filterBillStatusAndStatus(doc, taxationsysId).booleanValue()) continue;
                list.add(doc);
            }
        }
        return list.toArray(new DynamicObject[0]);
    }

    public static DynamicObject[] filterBillStatusAndStatus(DynamicObject[] docs, List<Long> taxationsysIds) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        if (docs != null && docs.length > 0) {
            for (DynamicObject doc : docs) {
                if (!TaxcMainService.filterBillStatusAndStatus(doc, taxationsysIds).booleanValue()) continue;
                list.add(doc);
            }
        }
        return list.toArray(new DynamicObject[0]);
    }

    public static DynamicObject[] filterBillStatusAndStatus(DynamicObject[] docs, Long taxationsysId, boolean isIncludeTaxationsys) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        if (docs != null && docs.length > 0) {
            for (DynamicObject doc : docs) {
                if (!TaxcMainService.filterBillStatusAndStatus(doc, taxationsysId, isIncludeTaxationsys).booleanValue()) continue;
                list.add(doc);
            }
        }
        return list.toArray(new DynamicObject[0]);
    }

    public static DynamicObject[] filterBillStatusAndStatusAndIsTras(DynamicObject[] docs, Long taxationsysId) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        if (docs != null && docs.length > 0) {
            for (DynamicObject doc : docs) {
                if (!TaxcMainService.filterBillStatusAndStatus(doc, taxationsysId).booleanValue() || !TaxcMainService.filterTras(doc).booleanValue()) continue;
                list.add(doc);
            }
        }
        return list.toArray(new DynamicObject[0]);
    }

    public static DynamicObject[] filterBillStatusAndStatusAndIsTaxPayerAndFinancialstatement(DynamicObject[] docs, Long taxationsysId) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        if (docs != null && docs.length > 0) {
            for (DynamicObject doc : docs) {
                if (!TaxcMainService.filterBillStatusAndStatus(doc, taxationsysId).booleanValue() || !TaxcMainService.filterTaxPayer(doc, taxationsysId).booleanValue() || !TaxcMainService.filterFinancialstatement(doc).booleanValue()) continue;
                list.add(doc);
            }
        }
        return list.toArray(new DynamicObject[0]);
    }

    public static Boolean filterBillStatusAndStatus(DynamicObject doc, Long taxationsysId) {
        if (null != doc && BillStatusConstant.isBillStatus((DynamicObject)doc) && doc.getDynamicObject("taxorg") != null) {
            DynamicObjectCollection entryentity = doc.getDynamicObject("taxorg").getDynamicObjectCollection("entryentity");
            Optional<DynamicObject> entryObj = taxationsysId != null ? entryentity.stream().filter(o -> o != null && "1".equals(o.getString("entry_status")) && taxationsysId != null && o.getLong("entry_taxationsys.id") == taxationsysId.longValue()).findFirst() : entryentity.stream().filter(o -> o != null && "1".equals(o.getString("entry_status"))).findFirst();
            return entryObj.isPresent();
        }
        return Boolean.FALSE;
    }

    public static Boolean filterBillStatusAndStatus(DynamicObject doc, List<Long> taxationsysIds) {
        if (null != doc && BillStatusConstant.isBillStatus((DynamicObject)doc) && doc.getDynamicObject("taxorg") != null) {
            DynamicObjectCollection entryentity = doc.getDynamicObject("taxorg").getDynamicObjectCollection("entryentity");
            Optional<DynamicObject> entryObj = CollectionUtils.isNotEmpty(taxationsysIds) ? entryentity.stream().filter(o -> o != null && "1".equals(o.getString("entry_status")) && taxationsysIds.contains(o.getLong("entry_taxationsys.id"))).findFirst() : entryentity.stream().filter(o -> o != null && "1".equals(o.getString("entry_status"))).findFirst();
            return entryObj.isPresent();
        }
        return Boolean.FALSE;
    }

    public static Boolean filterBillStatusAndStatus(DynamicObject doc, Long taxationsysId, boolean isIncludeTaxationsy) {
        if (null != doc && BillStatusConstant.isBillStatus((DynamicObject)doc) && doc.getDynamicObject("taxorg") != null) {
            DynamicObjectCollection entryentity = doc.getDynamicObject("taxorg").getDynamicObjectCollection("entryentity");
            Optional<DynamicObject> entryObj = taxationsysId != null ? (isIncludeTaxationsy ? entryentity.stream().filter(o -> o != null && "1".equals(o.getString("entry_status")) && o.getLong("entry_taxationsys.id") == taxationsysId.longValue()).findFirst() : entryentity.stream().filter(o -> o != null && "1".equals(o.getString("entry_status")) && o.getLong("entry_taxationsys.id") != taxationsysId.longValue()).findFirst()) : entryentity.stream().filter(o -> o != null && "1".equals(o.getString("entry_status"))).findFirst();
            return entryObj.isPresent();
        }
        return Boolean.FALSE;
    }

    public static Boolean filterTaxPayer(DynamicObject doc, Long taxationsysId) {
        if (null != doc && doc.getDynamicObject("taxorg") != null) {
            DynamicObjectCollection entryentity = doc.getDynamicObject("taxorg").getDynamicObjectCollection("entryentity");
            Optional<DynamicObject> entryObj = taxationsysId != null ? entryentity.stream().filter(o -> o.getBoolean("entry_istaxpayer") && o.getLong("entry_taxationsys.id") == taxationsysId.longValue()).findFirst() : entryentity.stream().filter(o -> o.getBoolean("entry_istaxpayer")).findFirst();
            return entryObj.isPresent();
        }
        return Boolean.FALSE;
    }

    public static Boolean filterTaxPayer(DynamicObject doc, List<Long> taxationsysIds) {
        if (null != doc && doc.getDynamicObject("taxorg") != null) {
            DynamicObjectCollection entryentity = doc.getDynamicObject("taxorg").getDynamicObjectCollection("entryentity");
            Optional<DynamicObject> entryObj = CollectionUtils.isNotEmpty(taxationsysIds) ? entryentity.stream().filter(o -> o.getBoolean("entry_istaxpayer") && taxationsysIds.contains(o.getLong("entry_taxationsys.id"))).findFirst() : entryentity.stream().filter(o -> o.getBoolean("entry_istaxpayer")).findFirst();
            return entryObj.isPresent();
        }
        return Boolean.FALSE;
    }

    public static Boolean filterTaxPayer(DynamicObject doc, Long taxationsysId, boolean isIncludeTaxationsy) {
        if (null != doc && doc.getDynamicObject("taxorg") != null) {
            DynamicObjectCollection entryentity = doc.getDynamicObject("taxorg").getDynamicObjectCollection("entryentity");
            Optional<DynamicObject> entryObj = taxationsysId != null ? (isIncludeTaxationsy ? entryentity.stream().filter(o -> o.getBoolean("entry_istaxpayer") && o.getLong("entry_taxationsys.id") == taxationsysId.longValue()).findFirst() : entryentity.stream().filter(o -> o.getBoolean("entry_istaxpayer") && o.getLong("entry_taxationsys.id") != taxationsysId.longValue()).findFirst()) : entryentity.stream().filter(o -> o.getBoolean("entry_istaxpayer")).findFirst();
            return entryObj.isPresent();
        }
        return Boolean.FALSE;
    }

    public static Boolean filterTras(DynamicObject doc) {
        if (null != doc && doc.getBoolean("tras")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean filterQhclique(DynamicObject doc) {
        if (null != doc && doc.getBoolean("qhclique")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean filterFinancialstatement(DynamicObject doc) {
        if (null != doc && doc.getBoolean("financialstatement")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean isBillStatusAndStatus(DynamicObject doc, Long taxationsysId) {
        if (null != doc) {
            if (BillStatusConstant.isBillStatus((DynamicObject)doc)) {
                if (doc.getDynamicObject("taxorg") != null) {
                    DynamicObjectCollection entryentity = doc.getDynamicObject("taxorg").getDynamicObjectCollection("entryentity");
                    Optional<DynamicObject> entryObj = taxationsysId != null ? entryentity.stream().filter(o -> "1".equals(o.getString("entry_status")) && o.getLong("entry_taxationsys.id") == taxationsysId.longValue()).findFirst() : entryentity.stream().filter(o -> "1".equals(o.getString("entry_status"))).findFirst();
                    if (entryObj.isPresent()) {
                        return Boolean.TRUE;
                    }
                    throw new KDBizException(new ErrorCode(TaxcErrorCode.TAXC_STATUS_CODE.getCode(), String.format(TaxcErrorCode.TAXC_STATUS_CODE.getMessage(), doc.getString("taxorg.org.name"))), new Object[0]);
                }
                throw new KDBizException(new ErrorCode(TaxcErrorCode.TAXC_STATUS_CODE.getCode(), String.format(TaxcErrorCode.TAXC_STATUS_CODE.getMessage(), doc.getString("taxorg.org.name"))), new Object[0]);
            }
            throw new KDBizException(new ErrorCode(TaxcErrorCode.TAXC_BILLSTATUS_CODE.getCode(), String.format(TaxcErrorCode.TAXC_BILLSTATUS_CODE.getMessage(), doc.getString("taxorg.org.name"))), new Object[0]);
        }
        return Boolean.FALSE;
    }

    public static DynamicObject[] filterOrgViewEnbale(DynamicObject[] docs) {
        if (null != docs && docs.length > 0) {
            List orgIds = OrgUnitServiceHelper.getAllOrgByViewNumber((String)"40", (boolean)false);
            List<DynamicObject> collect = Arrays.stream(docs).filter(o -> orgIds.contains(o.getLong("taxorg.org.id"))).collect(Collectors.toList());
            return collect.toArray(new DynamicObject[0]);
        }
        return null;
    }

    public static Boolean orgViewEnbale(DynamicObject doc) {
        if (null != doc) {
            List orgIds = OrgUnitServiceHelper.getAllOrgByViewNumber((String)"40", (boolean)false);
            return orgIds.contains(doc.getLong("taxorg.org.id"));
        }
        return Boolean.FALSE;
    }

    public static Boolean isTaxPayer(DynamicObject doc, Long taxationsysId) {
        if (null != doc) {
            if (doc.getDynamicObject("taxorg") != null) {
                DynamicObjectCollection entryentity = doc.getDynamicObject("taxorg").getDynamicObjectCollection("entryentity");
                Optional<DynamicObject> entryObj = taxationsysId != null ? entryentity.stream().filter(o -> o.getBoolean("entry_istaxpayer") && o.getLong("entry_taxationsys.id") == taxationsysId.longValue()).findFirst() : entryentity.stream().filter(o -> o.getBoolean("entry_istaxpayer")).findFirst();
                if (entryObj.isPresent()) {
                    return Boolean.TRUE;
                }
                throw new KDBizException(new ErrorCode(TctbErrorCode.TCTB_ISTAXPAYER_CODE.getCode(), TctbErrorCode.TCTB_ISTAXPAYER_CODE.getMessage()), new Object[0]);
            }
            throw new KDBizException(new ErrorCode(TctbErrorCode.TCTB_ISTAXPAYER_CODE.getCode(), TctbErrorCode.TCTB_ISTAXPAYER_CODE.getMessage()), new Object[0]);
        }
        throw new KDBizException(new ErrorCode(TctbErrorCode.TCTB_ISTAXPAYER_CODE.getCode(), TctbErrorCode.TCTB_ISTAXPAYER_CODE.getMessage()), new Object[0]);
    }

    public static Boolean isTras(DynamicObject doc) {
        if (null != doc) {
            if (doc.getBoolean("tras")) {
                return Boolean.TRUE;
            }
            throw new KDBizException(new ErrorCode(TctbErrorCode.TCTB_IS_TRAS_CODE.getCode(), TctbErrorCode.TCTB_IS_TRAS_CODE.getMessage()), new Object[0]);
        }
        throw new KDBizException(new ErrorCode(TctbErrorCode.TCTB_IS_TRAS_CODE.getCode(), TctbErrorCode.TCTB_IS_TRAS_CODE.getMessage()), new Object[0]);
    }

    public static Boolean isQhclique(DynamicObject doc) {
        if (null != doc) {
            if (doc.getBoolean("qhclique")) {
                return Boolean.TRUE;
            }
            throw new KDBizException(new ErrorCode(TctbErrorCode.TCTB_QHCLIQUE_CODE.getCode(), TctbErrorCode.TCTB_QHCLIQUE_CODE.getMessage()), new Object[0]);
        }
        throw new KDBizException(new ErrorCode(TctbErrorCode.TCTB_ORG_NULL_CODE.getCode(), TctbErrorCode.TCTB_ORG_NULL_CODE.getMessage()), new Object[0]);
    }

    public static Boolean isFinancialstatement(DynamicObject doc) {
        if (null != doc) {
            if (doc.getBoolean("financialstatement")) {
                return Boolean.TRUE;
            }
            throw new KDBizException(new ErrorCode(TctbErrorCode.TCTB_IS_FINANCIALSTATEMENT_CODE.getCode(), TctbErrorCode.TCTB_IS_FINANCIALSTATEMENT_CODE.getMessage()), new Object[0]);
        }
        throw new KDBizException(new ErrorCode(TctbErrorCode.TCTB_ORG_NULL_CODE.getCode(), TctbErrorCode.TCTB_ORG_NULL_CODE.getMessage()), new Object[0]);
    }

    public static Boolean isYbnsr(DynamicObject doc) {
        if (null != doc && doc.getString("taxpayertype").equals("ybnsr")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean isBillStatusAndStatusAndIsTaxPayerAndYbnsr(DynamicObject doc, String type, Long taxationsysId) {
        if (null != doc) {
            Boolean isBillStatusAndStatusAndTaxPayer = TaxcMainService.filterBillStatusAndStatus(doc, taxationsysId) != false && TaxcMainService.filterTaxPayer(doc, taxationsysId) != false;
            if (isBillStatusAndStatusAndTaxPayer.booleanValue()) {
                DynamicObjectCollection categoryentryentity = doc.getDynamicObjectCollection("categoryentryentity");
                if (CollectionUtils.isNotEmpty((Collection)categoryentryentity)) {
                    Optional<DynamicObject> first = categoryentryentity.stream().filter(s -> type.equals(s.getString("taxtype"))).findFirst();
                    if (first.isPresent() && first.get().getString("enable").equals("1") && TaxcMainService.isYbnsr(first.get()).booleanValue()) {
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }
                return Boolean.FALSE;
            }
            return Boolean.FALSE;
        }
        return Boolean.FALSE;
    }

    public static Boolean taxTypeIsEnbale(DynamicObject doc, String type, Long taxationsysId) {
        if (null != doc) {
            Boolean isBillStatusAndStatusAndTaxPayer = TaxcMainService.filterBillStatusAndStatus(doc, taxationsysId);
            if (isBillStatusAndStatusAndTaxPayer.booleanValue()) {
                DynamicObjectCollection categoryentryentity = doc.getDynamicObjectCollection("categoryentryentity");
                if (CollectionUtils.isNotEmpty((Collection)categoryentryentity)) {
                    Optional<DynamicObject> first = categoryentryentity.stream().filter(s -> type.equals(s.getString("taxtype"))).findFirst();
                    if (first.isPresent() && first.get().getString("enable").equals("1")) {
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }
                return Boolean.FALSE;
            }
            return Boolean.FALSE;
        }
        return Boolean.FALSE;
    }

    public static Map<Long, Map<String, Boolean>> filterTaxTypeIsEnbale(DynamicObject[] docs, Long taxationsysId) {
        HashMap<Long, Map<String, Boolean>> result = new HashMap<Long, Map<String, Boolean>>();
        if (null != docs && docs.length > 0) {
            for (DynamicObject obj : docs) {
                Boolean isBillStatusAndStatusAndTaxPayer = TaxcMainService.filterBillStatusAndStatus(obj, taxationsysId);
                if (!isBillStatusAndStatusAndTaxPayer.booleanValue()) continue;
                DynamicObjectCollection categoryentryentity = obj.getDynamicObjectCollection("categoryentryentity");
                if (!result.containsKey(obj.getLong("taxorg.org.id"))) {
                    result.put(obj.getLong("taxorg.org.id"), new HashMap());
                }
                if (!CollectionUtils.isNotEmpty((Collection)categoryentryentity)) continue;
                for (DynamicObject entryObj : categoryentryentity) {
                    ((Map)result.get(obj.getLong("taxorg.org.id"))).put(entryObj.getString("taxtype"), entryObj.getBoolean("enable"));
                    if (StringUtils.equals((CharSequence)TaxcMainConstant.TAXTYPE_FCSCZTDSYS, (CharSequence)entryObj.getString("taxtype"))) {
                        boolean fcsIsEnable = StringUtils.equals((CharSequence)entryObj.getString("fcsenable"), (CharSequence)"2");
                        boolean czdtsysIsEnable = StringUtils.equals((CharSequence)entryObj.getString("cztdsysenable"), (CharSequence)"3");
                        ((Map)result.get(obj.getLong("taxorg.org.id"))).put(TaxcMainConstant.TAXTYPE_FCS, fcsIsEnable);
                        ((Map)result.get(obj.getLong("taxorg.org.id"))).put(TaxcMainConstant.TAXTYPE_CZTDSYS, czdtsysIsEnable);
                        continue;
                    }
                    if (!StringUtils.equals((CharSequence)TaxcMainConstant.TAXTYPE_FJSF, (CharSequence)entryObj.getString("taxtype"))) continue;
                    boolean addcswhjssenableIsEnable = StringUtils.equals((CharSequence)entryObj.getString("cswhjssenable"), (CharSequence)"1");
                    boolean addjyffjIsEnable = StringUtils.equals((CharSequence)entryObj.getString("jyffjenable"), (CharSequence)"2");
                    boolean adddfjyffjIsEnable = StringUtils.equals((CharSequence)entryObj.getString("dfjyffjenable"), (CharSequence)"3");
                    ((Map)result.get(obj.getLong("taxorg.org.id"))).put(TaxcMainConstant.TAXTYPE_ADDCSWHJSS, addcswhjssenableIsEnable);
                    ((Map)result.get(obj.getLong("taxorg.org.id"))).put(TaxcMainConstant.TAXTYPE_ADDJYFFJ, addjyffjIsEnable);
                    ((Map)result.get(obj.getLong("taxorg.org.id"))).put(TaxcMainConstant.TAXTYPE_ADDDFJYFFJ, adddfjyffjIsEnable);
                }
            }
        }
        return result;
    }

    public static void filterTaxtype(DynamicObject doc, String type, boolean isEnable) {
        if (doc != null && CollectionUtils.isNotEmpty((Collection)doc.getDynamicObjectCollection("categoryentryentity"))) {
            DynamicObjectCollection entryentity = doc.getDynamicObjectCollection("categoryentryentity");
            DynamicObjectCollection entryObjs = null;
            entryObjs = isEnable ? entryentity.stream().filter(o -> StringUtils.equals((CharSequence)o.getString("taxtype"), (CharSequence)type) && o.getBoolean("enable")).collect(Collectors.toCollection(DynamicObjectCollection::new)) : entryentity.stream().filter(o -> StringUtils.equals((CharSequence)o.getString("taxtype"), (CharSequence)type)).collect(Collectors.toCollection(DynamicObjectCollection::new));
            doc.set("categoryentryentity", (Object)entryObjs);
        }
    }

    private static void filterTaxtype(DynamicObject doc, String type) {
        if (doc != null && CollectionUtils.isNotEmpty((Collection)doc.getDynamicObjectCollection("categoryentryentity"))) {
            DynamicObjectCollection entryentity = doc.getDynamicObjectCollection("categoryentryentity");
            DynamicObjectCollection entryObjs = entryentity.stream().filter(o -> StringUtils.equals((CharSequence)o.getString("taxtype"), (CharSequence)type)).collect(Collectors.toCollection(DynamicObjectCollection::new));
            doc.set("categoryentryentity", (Object)entryObjs);
        }
    }

    private static void filterCategory(DynamicObject doc, Long categoryId) {
        if (doc != null && CollectionUtils.isNotEmpty((Collection)doc.getDynamicObjectCollection("hwsentryentity"))) {
            DynamicObjectCollection entryentity = doc.getDynamicObjectCollection("hwsentryentity");
            DynamicObjectCollection entryObjs = entryentity.stream().filter(o -> o.getDynamicObject("hwstaxtype") != null && o.getDynamicObject("hwstaxtype").getLong("id") == categoryId.longValue() && o.getBoolean("hwsenable")).collect(Collectors.toCollection(DynamicObjectCollection::new));
            doc.set("hwsentryentity", (Object)entryObjs);
        }
    }

    public static String checkTaxPayerMustInput(DynamicObject info) {
        if (info == null) {
            return null;
        }
        StringBuilder errors = new StringBuilder();
        String start = ResManager.loadKDString((String)"\u8bf7\u586b\u5199", (String)"TaxcMainService_0", (String)"taxc-tctb-business", (Object[])new Object[0]);
        Long taxationsys = Objects.isNull(info.getDynamicObject("taxationsys")) ? null : Long.valueOf(info.getLong("taxationsys.id"));
        Map isEntityRelateFields = new TaxcMainConstant().getIsEntityRelateFields();
        for (Map.Entry entry : isEntityRelateFields.entrySet()) {
            if (!ObjectUtils.isEmpty((Object)info.get((String)entry.getKey()))) continue;
            if (Objects.nonNull(taxationsys) && !TaxationsysMappingEnum.CHN.getId().equals(taxationsys)) {
                ArrayList list = Lists.newArrayList((Object[])new String[]{"taxoffice", "accountingstandards", "registertype", "codeandname"});
                if (!info.getBoolean("registerplace")) {
                    list.add("registertime");
                    list.add("registeraddress");
                    list.add("actualaddress");
                }
                if (list.contains(entry.getKey())) continue;
            }
            if (!errors.toString().contains(start)) {
                errors.append(start);
            }
            errors.append((String)entry.getValue()).append('\uff0c');
        }
        if (Objects.nonNull(taxationsys) && !TaxationsysMappingEnum.CHN.getId().equals(taxationsys)) {
            DynamicObjectCollection hwsEntity = info.getDynamicObjectCollection("hwsentryentity");
            int hwsEntityCount = hwsEntity.size();
            Map hwsEntityFields = new TaxcMainConstant().getHwsEntityFields();
            for (int i = 0; i < hwsEntityCount; ++i) {
                for (Map.Entry entry : hwsEntityFields.entrySet()) {
                    if (!ObjectUtils.isEmpty((Object)((DynamicObject)hwsEntity.get(i)).get((String)entry.getKey()))) continue;
                    if (!errors.toString().contains(start)) {
                        errors.append(start);
                    }
                    errors.append(String.format(ResManager.loadKDString((String)"\u7a0e\u79cd\u4fe1\u606f\u5355\u636e\u4f53\u7b2c%d\u884c\uff1a\"%s\"", (String)"TaxcMainService_1", (String)"taxc-tctb-business", (Object[])new Object[0]), i + 1, entry.getValue())).append('\uff0c');
                }
            }
        }
        DynamicObjectCollection bankInfoEntity = info.getDynamicObjectCollection("entryentity");
        int bankInfosCount = bankInfoEntity.size();
        int count = 0;
        Map bankInfoFields = new TaxcMainConstant().getBankInfoFields();
        for (int i = 0; i < bankInfosCount; ++i) {
            boolean taxacct = ((DynamicObject)bankInfoEntity.get(i)).getBoolean("taxacct");
            if (taxacct) {
                ++count;
            }
            for (Map.Entry entry : bankInfoFields.entrySet()) {
                if (!ObjectUtils.isEmpty((Object)((DynamicObject)bankInfoEntity.get(i)).get((String)entry.getKey())) || !taxacct && "tripleaggrement".equals(entry.getKey()) || !ObjectUtils.isEmpty((Object)((DynamicObject)bankInfoEntity.get(i)).get((String)entry.getKey()))) continue;
                if (!errors.toString().contains(start)) {
                    errors.append(start);
                }
                errors.append(String.format(ResManager.loadKDString((String)"\u94f6\u884c\u4fe1\u606f\u7b2c%d\u884c\uff1a\"%s\"", (String)"TaxcMainService_2", (String)"taxc-tctb-business", (Object[])new Object[0]), i + 1, entry.getValue())).append('\uff0c');
            }
        }
        if (count > 1) {
            errors.append(ResManager.loadKDString((String)"\u6bcf\u4e2a\u7eb3\u7a0e\u4e3b\u4f53\u53ea\u80fd\u6709\u4e00\u4e2a\u94f6\u884c\u4fe1\u606f\u7684\u201c\u7f34\u7a0e\u8d26\u6237\u201d\u586b\u5199\u4e3a\u201c\u662f\u201d\u3002", (String)"TaxcMainService_3", (String)"taxc-tctb-business", (Object[])new Object[0]));
        }
        Map shareHolderFields = new TaxcMainConstant().getShareHolderFields();
        DynamicObjectCollection shareHoldersEntity = info.getDynamicObjectCollection("entryentity1");
        int shareHoldersCount = shareHoldersEntity.size();
        for (int i = 0; i < shareHoldersCount; ++i) {
            for (Map.Entry entry : shareHolderFields.entrySet()) {
                if (!ObjectUtils.isEmpty((Object)((DynamicObject)shareHoldersEntity.get(i)).get((String)entry.getKey()))) continue;
                if (!errors.toString().contains(start)) {
                    errors.append(start);
                }
                errors.append(String.format(ResManager.loadKDString((String)"\u80a1\u4e1c\u4fe1\u606f\u7b2c%d\u884c\uff1a\"%s\"", (String)"TaxcMainService_4", (String)"taxc-tctb-business", (Object[])new Object[0]), i + 1, entry.getValue())).append('\uff0c');
            }
        }
        if (StringUtils.isBlank((CharSequence)errors.toString())) {
            return null;
        }
        errors.deleteCharAt(errors.length() - 1);
        errors.append("\u3002");
        return errors.toString();
    }

    public static String getTaxcMainDimKey(DynamicObject obj) {
        if (obj.getDynamicObject("taxorg") == null || obj.getDynamicObject("taxationsys") == null) {
            return null;
        }
        String keyFormat = "%1$1s_%2$s";
        return String.format(keyFormat, obj.getDynamicObject("taxorg").getLong(TaxcMainConstant.ID), obj.getDynamicObject("taxationsys").getLong(TaxcMainConstant.ID));
    }
}

