/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.business.taxcyear;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.taxc.tctb.business.taxcyear.TaxcYearDao;

public class TaxcYearBusiness {
    public static DynamicObject[] loadTaxcYearByIds(List<Long> taxyearIds) {
        return TaxcYearDao.loadTaxcYearByIds(taxyearIds);
    }

    public static DynamicObject[] loadTaxcYearBytaxationsysId(Long taxationsysId) {
        return TaxcYearDao.loadByTaxationsysId(taxationsysId);
    }

    public static DynamicObject[] loadTaxcYearBytaxationsysId(Long taxationsysId, Long taxcategoryId) {
        return TaxcYearDao.loadByTaxationsysId(taxationsysId, taxcategoryId);
    }

    public static DynamicObject[] loadTaxcYearBytaxationsysId(Long taxationsysId, Long taxcategoryId, String applicationscope) {
        return TaxcYearDao.loadByTaxationsysId(taxationsysId, taxcategoryId, applicationscope);
    }

    public static DynamicObject[] loadTaxcYearByTaxationsysIdAndOrgId(List<Long> orgIds, Long taxationsysId) {
        return TaxcYearDao.loadByTaxationsysIdAndOrgIds(orgIds, taxationsysId);
    }

    public static DynamicObject[] loadTaxcYearByTaxationsysIdAndOrgId(List<Long> orgIds, List<Long> taxationsysIds) {
        return TaxcYearDao.loadByTaxationsysIdAndOrgIds(orgIds, taxationsysIds);
    }

    public static DynamicObject[] loadTaxcYearByTaxationsysIdAndOrgId(List<Long> orgIds, List<Long> taxationsysIds, List<Long> taxcategoryIds, String applicationscope) {
        return TaxcYearDao.loadByTaxationsysIdAndOrgIds(orgIds, taxationsysIds, taxcategoryIds, applicationscope);
    }

    public static List<Map<String, Object>> loadTaxcYearByPriority(List<Map<String, Object>> paramsList) {
        DynamicObject[] taxyearDyns = TaxcYearDao.loadAll();
        for (Map<String, Object> map : paramsList) {
            Long orgId = (Long)map.get("key_orgId");
            Long taxationsysId = (Long)map.get("key_taxationsysId");
            Long taxcategoryId = (Long)map.get("key_taxcategoryId");
            DynamicObject targetTaxYear = TaxcYearBusiness.filterByPriority(Arrays.asList(taxyearDyns), orgId, taxationsysId, taxcategoryId);
            map.put("key_taxyear", targetTaxYear);
        }
        return paramsList;
    }

    private static DynamicObject filterByPriority(List<DynamicObject> taxYearList, Long orgId, Long taxationsysId, Long taxcategoryId) {
        DynamicObject dyn = null;
        dyn = TaxcYearBusiness.findInOriginData(taxYearList, orgId, taxationsysId, taxcategoryId, "2");
        if (dyn != null) {
            return dyn;
        }
        dyn = TaxcYearBusiness.findInOriginData(taxYearList, null, taxationsysId, taxcategoryId, "1");
        if (dyn != null) {
            return dyn;
        }
        dyn = TaxcYearBusiness.findInOriginData(taxYearList, orgId, taxationsysId, null, "2");
        if (dyn != null) {
            return dyn;
        }
        dyn = TaxcYearBusiness.findInOriginData(taxYearList, null, taxationsysId, null, "1");
        return dyn;
    }

    private static DynamicObject findInOriginData(List<DynamicObject> taxYearList, Long orgId, Long taxationsysId, Long taxcategoryId, String applicationscope) {
        for (DynamicObject dyn : taxYearList) {
            String itemApplicationscop;
            Long itemTaxationsysId = dyn.getLong("group.id");
            if (taxationsysId.compareTo(itemTaxationsysId) != 0) continue;
            Long itemTaxcategoryId = dyn.getLong("taxcategory.id");
            if (itemTaxcategoryId == null) {
                itemTaxcategoryId = 0L;
            }
            if (taxcategoryId == null) {
                taxcategoryId = 0L;
            }
            if (itemTaxcategoryId.compareTo(taxcategoryId) != 0 || !(itemApplicationscop = dyn.getString("applicationscope")).equals(applicationscope)) continue;
            if ("1".equals(itemApplicationscop)) {
                return dyn;
            }
            DynamicObjectCollection orgs = dyn.getDynamicObjectCollection("orgentryentity");
            for (DynamicObject itemOrg : orgs) {
                Long itemOrgId = itemOrg.getLong("org.id");
                if (itemOrgId == null) {
                    itemOrgId = 0L;
                }
                if (orgId == null) {
                    orgId = 0L;
                }
                if (itemOrgId.compareTo(orgId) != 0) continue;
                return dyn;
            }
        }
        return null;
    }
}

