/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.business.taxcyear;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class TaxcYearDao {
    public static DynamicObject loadSingleById(Long Id) {
        QFilter qFilter = TaxcYearDao.buildQfilter();
        if (Id != null) {
            qFilter = qFilter.and("id", "=", (Object)Id);
        }
        return BusinessDataServiceHelper.loadSingle((String)"tctb_taxyear", (String)"id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,group,taxcategory,startdate,entryentity,ispreset,orgentryentity,applicationscope,entryentity.seq,entryentity.startyear,entryentity.startmonthandday,entryentity.starttoend,entryentity.endyear,entryentity.endmonthandday,entryentity.monthly,entryentity.quarter,entryentity.halfyear,orgentryentity.seq,orgentryentity.org", (QFilter[])new QFilter[]{qFilter});
    }

    public static List<DynamicObject> loadByIds(List<Long> ids) {
        QFilter qFilter = TaxcYearDao.buildQfilter();
        if (CollectionUtils.isNotEmpty(ids)) {
            qFilter = qFilter.and("id", "in", ids);
        }
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"tctb_taxyear", (String)"id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,group,taxcategory,startdate,entryentity,ispreset,orgentryentity,applicationscope,entryentity.seq,entryentity.startyear,entryentity.startmonthandday,entryentity.starttoend,entryentity.endyear,entryentity.endmonthandday,entryentity.monthly,entryentity.quarter,entryentity.halfyear,orgentryentity.seq,orgentryentity.org", (QFilter[])new QFilter[]{qFilter});
        return new ArrayList<DynamicObject>(Arrays.asList(load));
    }

    public static List<DynamicObject> loadByNumbers(List<String> numbers) {
        QFilter qFilter = TaxcYearDao.buildQfilter();
        if (CollectionUtils.isNotEmpty(numbers)) {
            qFilter = qFilter.and("number", "in", numbers);
        }
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"tctb_taxyear", (String)"id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,group,taxcategory,startdate,entryentity,ispreset,orgentryentity,applicationscope,entryentity.seq,entryentity.startyear,entryentity.startmonthandday,entryentity.starttoend,entryentity.endyear,entryentity.endmonthandday,entryentity.monthly,entryentity.quarter,entryentity.halfyear,orgentryentity.seq,orgentryentity.org", (QFilter[])new QFilter[]{qFilter});
        return new ArrayList<DynamicObject>(Arrays.asList(load));
    }

    public static DynamicObject loadSingleByNumber(String numbers) {
        QFilter qFilter = TaxcYearDao.buildQfilter();
        if (StringUtils.isNotEmpty((CharSequence)numbers)) {
            qFilter = qFilter.and("number", "=", (Object)numbers);
        }
        return BusinessDataServiceHelper.loadSingle((String)"tctb_taxyear", (String)"id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,group,taxcategory,startdate,entryentity,ispreset,orgentryentity,applicationscope,entryentity.seq,entryentity.startyear,entryentity.startmonthandday,entryentity.starttoend,entryentity.endyear,entryentity.endmonthandday,entryentity.monthly,entryentity.quarter,entryentity.halfyear,orgentryentity.seq,orgentryentity.org", (QFilter[])new QFilter[]{qFilter});
    }

    public static DynamicObject[] loadByTaxationsysId(Long taxationsysId) {
        return TaxcYearDao.loadByTaxationsysId(taxationsysId, null);
    }

    public static DynamicObject[] loadByTaxationsysId(Long taxationsysId, Long taxcategoryId) {
        return TaxcYearDao.loadByTaxationsysId(taxationsysId, taxcategoryId, null);
    }

    public static DynamicObject[] loadByTaxationsysId(Long taxationsysId, Long taxcategoryId, String applicationscope) {
        QFilter qFilter = TaxcYearDao.buildQfilter();
        if (taxationsysId != null) {
            qFilter = qFilter.and("group", "=", (Object)taxationsysId);
        }
        if (taxcategoryId != null) {
            if (0L == taxcategoryId) {
                QFilter emptyFilter = new QFilter("taxcategory", "=", (Object)0L);
                emptyFilter.or("taxcategory", "is null", (Object)0L);
                qFilter.and(emptyFilter);
            } else {
                qFilter = qFilter.and("taxcategory", "=", (Object)taxcategoryId);
            }
        }
        if (applicationscope != null) {
            qFilter = qFilter.and("applicationscope", "=", (Object)applicationscope);
        }
        return BusinessDataServiceHelper.load((String)"tctb_taxyear", (String)"id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,group,taxcategory,startdate,entryentity,ispreset,orgentryentity,applicationscope,entryentity.seq,entryentity.startyear,entryentity.startmonthandday,entryentity.starttoend,entryentity.endyear,entryentity.endmonthandday,entryentity.monthly,entryentity.quarter,entryentity.halfyear,orgentryentity.seq,orgentryentity.org", (QFilter[])new QFilter[]{qFilter});
    }

    public static DynamicObject[] loadByTaxationsysIdAndOrgIds(List<Long> orgIds, Long taxationsysId) {
        QFilter qFilter = TaxcYearDao.buildQfilter().and("applicationscope", "=", (Object)"2");
        if (taxationsysId != null) {
            qFilter = qFilter.and("group", "=", (Object)taxationsysId);
        }
        if (CollectionUtils.isNotEmpty(orgIds)) {
            qFilter = qFilter.and("orgentryentity.org", "in", orgIds);
        }
        return BusinessDataServiceHelper.load((String)"tctb_taxyear", (String)"id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,group,taxcategory,startdate,entryentity,ispreset,orgentryentity,applicationscope,entryentity.seq,entryentity.startyear,entryentity.startmonthandday,entryentity.starttoend,entryentity.endyear,entryentity.endmonthandday,entryentity.monthly,entryentity.quarter,entryentity.halfyear,orgentryentity.seq,orgentryentity.org", (QFilter[])new QFilter[]{qFilter});
    }

    public static DynamicObject[] loadByTaxationsysIdAndOrgIds(List<Long> orgIds, List<Long> taxationsysId) {
        return TaxcYearDao.loadByTaxationsysIdAndOrgIds(orgIds, taxationsysId, null, null);
    }

    public static DynamicObject[] loadByTaxationsysIdAndOrgIds(List<Long> orgIds, List<Long> taxationsysId, List<Long> taxcategoryIds, String applicationscope) {
        QFilter qFilter = TaxcYearDao.buildQfilter();
        if (CollectionUtils.isNotEmpty(taxationsysId)) {
            qFilter = qFilter.and("group", "in", taxationsysId);
        }
        if (CollectionUtils.isNotEmpty(orgIds)) {
            qFilter = qFilter.and("orgentryentity.org", "in", orgIds);
        }
        if (taxcategoryIds != null && taxcategoryIds.size() > 0) {
            QFilter taxcategoryFilter = new QFilter("taxcategory", "in", taxcategoryIds);
            Optional<Long> op = taxcategoryIds.stream().filter(item -> item == 0L).findFirst();
            if (op.isPresent()) {
                taxcategoryFilter.or("taxcategory", "is null", (Object)0L);
            }
            qFilter = qFilter.and(taxcategoryFilter);
        }
        if (applicationscope != null) {
            qFilter = qFilter.and("applicationscope", "=", (Object)applicationscope);
        }
        return BusinessDataServiceHelper.load((String)"tctb_taxyear", (String)MetadataUtil.getAllSubFieldString((String)"tctb_taxyear"), (QFilter[])new QFilter[]{qFilter});
    }

    public static DynamicObject[] loadTaxcYearByIds(List<Long> taxyearIds) {
        QFilter qFilter = new QFilter("id", "in", taxyearIds);
        return BusinessDataServiceHelper.load((String)"tctb_taxyear", (String)"id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,group,taxcategory,startdate,entryentity,ispreset,orgentryentity,applicationscope,entryentity.seq,entryentity.startyear,entryentity.startmonthandday,entryentity.starttoend,entryentity.endyear,entryentity.endmonthandday,entryentity.monthly,entryentity.quarter,entryentity.halfyear,orgentryentity.seq,orgentryentity.org", (QFilter[])new QFilter[]{qFilter});
    }

    public static DynamicObject[] loadAll() {
        QFilter qFilter = TaxcYearDao.buildQfilter();
        return BusinessDataServiceHelper.load((String)"tctb_taxyear", (String)"id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,group,taxcategory,startdate,entryentity,ispreset,orgentryentity,applicationscope,entryentity.seq,entryentity.startyear,entryentity.startmonthandday,entryentity.starttoend,entryentity.endyear,entryentity.endmonthandday,entryentity.monthly,entryentity.quarter,entryentity.halfyear,orgentryentity.seq,orgentryentity.org", (QFilter[])new QFilter[]{qFilter});
    }

    private static QFilter buildQfilter() {
        return new QFilter("enable", "=", (Object)"1");
    }
}

