/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.business.taxmain.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.common.util.BeanCopyUtils;
import kd.taxc.common.util.DateUtils;
import kd.taxc.common.util.DynamicObjectUtils;
import kd.taxc.common.util.EmptyCheckUtils;
import kd.taxc.common.util.StringUtil;
import kd.taxc.enums.TaxTypeComboEnum;
import kd.taxc.enums.TaxVerInfoBean;
import kd.taxc.enums.TaxVerInfoFormat;
import kd.taxc.tctb.business.taxcmain.TaxInfoHomeBusiness;

public class TaxVersionUtil {
    private static final Log logger = LogFactory.getLog(TaxVersionUtil.class);

    public static boolean needGetLastVerData(TaxTypeComboEnum taxTypeComboEnum) {
        if (null == taxTypeComboEnum) {
            throw new KDBizException(ResManager.loadKDString((String)"\u975e\u6cd5\u53c2\u6570", (String)"TaxVersionUtil_0", (String)"taxc-tctb-business", (Object[])new Object[0]));
        }
        return taxTypeComboEnum.getDisplayControl().equalsIgnoreCase(TaxTypeComboEnum.ZZS.getDisplayControl());
    }

    public static String saveTsateTaxLastVersion(String taxTypeChangStr, Long pkid) {
        String effectiveDate = null;
        DynamicObject taxMain = TaxInfoHomeBusiness.getTaxMainInfo(pkid);
        Long orgId = taxMain.getLong("orgid.id");
        Map<String, Optional<DynamicObject>> taxChangeRecordMap = TaxInfoHomeBusiness.getLastChangeRecordMap(Collections.singletonList(pkid));
        for (TaxTypeComboEnum taxTypeComboEnum : TaxTypeComboEnum.values()) {
            Map<Long, Optional<DynamicObject>> maxVerMap = TaxInfoHomeBusiness.getMaxVerMap(taxTypeComboEnum, Collections.singletonList(orgId));
            ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(10);
            DynamicObject lastVer = null;
            if (maxVerMap.get(orgId) != null && maxVerMap.get(orgId).isPresent()) {
                lastVer = maxVerMap.get(orgId).get();
            }
            DynamicObject lastChange = null;
            if (taxChangeRecordMap.get(String.valueOf(pkid)) != null && taxChangeRecordMap.get(String.valueOf(pkid)).isPresent()) {
                lastChange = taxChangeRecordMap.get(String.valueOf(pkid)).get();
            }
            if (TaxVersionUtil.needGetLastVerData(taxTypeComboEnum)) {
                if (taxTypeComboEnum.getCode().equalsIgnoreCase("zzs")) {
                    effectiveDate = TaxVersionUtil.doAddNormalHistory(taxMain, taxTypeComboEnum, lastVer, lastChange, updateList);
                } else {
                    TaxVersionUtil.doAddNormalHistory(taxMain, taxTypeComboEnum, lastVer, lastChange, updateList);
                }
            } else {
                TaxVersionUtil.doAddNonNormalHistory(taxMain, taxTypeComboEnum, lastVer, updateList, false);
            }
            if (updateList.size() <= 0) continue;
            SaveServiceHelper.save((DynamicObject[])updateList.toArray(new DynamicObject[updateList.size()]));
        }
        return effectiveDate;
    }

    public static Map<Long, String> saveTaxLastVersion(List<DynamicObject> taxMains) {
        if (EmptyCheckUtils.isEmpty(taxMains)) {
            return Collections.emptyMap();
        }
        HashMap<Long, String> result = new HashMap<Long, String>(10);
        List<Long> ids = taxMains.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
        List<Long> orgids = taxMains.stream().map(v -> v.getLong("orgid.id")).collect(Collectors.toList());
        Map<String, Optional<DynamicObject>> taxChangeRecordMap = TaxInfoHomeBusiness.getLastChangeRecordMap(ids);
        for (TaxTypeComboEnum taxTypeComboEnum : TaxTypeComboEnum.values()) {
            Map<Long, Optional<DynamicObject>> maxVerMap = TaxInfoHomeBusiness.getMaxVerMap(taxTypeComboEnum, orgids);
            ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(10);
            for (DynamicObject taxMain : taxMains) {
                Long pkid = taxMain.getLong("id");
                Long orgId = taxMain.getLong("orgid.id");
                DynamicObject lastVer = null;
                if (maxVerMap.get(orgId) != null && maxVerMap.get(orgId).isPresent()) {
                    lastVer = maxVerMap.get(orgId).get();
                }
                DynamicObject lastChange = null;
                if (taxChangeRecordMap.get(String.valueOf(pkid)) != null && taxChangeRecordMap.get(String.valueOf(pkid)).isPresent()) {
                    lastChange = taxChangeRecordMap.get(String.valueOf(pkid)).get();
                }
                if (TaxVersionUtil.needGetLastVerData(taxTypeComboEnum)) {
                    if (taxTypeComboEnum.getCode().equalsIgnoreCase("zzs")) {
                        String effectiveDate = TaxVersionUtil.doAddNormalHistory(taxMain, taxTypeComboEnum, lastVer, lastChange, updateList);
                        result.put(pkid, effectiveDate);
                        continue;
                    }
                    TaxVersionUtil.doAddNormalHistory(taxMain, taxTypeComboEnum, lastVer, lastChange, updateList);
                    continue;
                }
                TaxVersionUtil.doAddNonNormalHistory(taxMain, taxTypeComboEnum, lastVer, updateList, false);
            }
            if (updateList.size() <= 0) continue;
            SaveServiceHelper.save((DynamicObject[])updateList.toArray(new DynamicObject[updateList.size()]));
        }
        return result;
    }

    private static String doAddNormalHistory(DynamicObject taxMain, TaxTypeComboEnum taxTypeComboEnum, DynamicObject lastVer, DynamicObject lastChange, List<DynamicObject> updateList) {
        List taxVerInfoBeans = taxTypeComboEnum.getFieldInfo();
        if (EmptyCheckUtils.isEmpty((Object)taxVerInfoBeans)) {
            return null;
        }
        List fitTaxTypes = taxMain.getDynamicObjectCollection("categoryentryentity").stream().filter(v -> taxTypeComboEnum.getCode().equalsIgnoreCase(v.getString("taxtype"))).collect(Collectors.toList());
        if (EmptyCheckUtils.isEmpty(fitTaxTypes)) {
            return null;
        }
        String effectiveDate = null;
        Long curMaxVer = lastVer != null ? lastVer.getLong("ver") : 0L;
        Long ver = curMaxVer = Long.valueOf(curMaxVer + 1L);
        Long orgid = taxMain.getLong("orgid.id");
        DynamicObject newVer = TaxVersionUtil.createNewVer(taxMain, taxTypeComboEnum, ver);
        DynamicObjectCollection newVerEntryentity = newVer.getDynamicObjectCollection("entryentity");
        boolean needSave = false;
        if (EmptyCheckUtils.isNotEmpty((Object)lastVer)) {
            DynamicObject entity;
            logger.info("normal\u8868\u5b58\u5728\u5386\u53f2\u53d8\u66f4\u8bb0\u5f55:" + orgid + "-" + curMaxVer);
            DynamicObjectCollection lastVerDataInfoList = lastVer.getDynamicObjectCollection("entryentity");
            HashSet<String> lastVerCodes = new HashSet<String>();
            for (DynamicObject last : lastVerDataInfoList) {
                entity = newVerEntryentity.addNew();
                String ysjbs = last.getString("modifycontexttitleysjbs");
                entity.set("modifycontexttitle", last.get("modifycontexttitle"));
                entity.set("modifycontexttitleysjbs", last.get("modifycontexttitleysjbs"));
                lastVerCodes.add(last.getString("modifycontexttitleysjbs"));
                entity.set("modifycontexbefore", last.get("modifycontexafter"));
                entity.set("modifycontexbeforecode", last.get("modifycontexaftercode"));
                TaxVersionUtil.code2Name(TaxVerInfoBean.getEnumByCode((String)ysjbs, (List)taxVerInfoBeans), entity, (DynamicObject)fitTaxTypes.get(0));
                if ("taxenddate".equalsIgnoreCase(ysjbs)) {
                    logger.info("\u7279\u6b8a\u5904\u7406\u589e\u503c\u7a0e\u8bbe\u7f6e\u65f6\u95f4\uff1a" + orgid);
                    effectiveDate = TaxVersionUtil.setZzsDateField(taxMain, entity, lastChange);
                }
                if (StringUtil.equalsIgnoreCase((CharSequence)entity.getString("modifycontexafter"), (CharSequence)entity.getString("modifycontexbefore"))) continue;
                needSave = true;
            }
            for (TaxVerInfoBean taxVerInfoBean : taxVerInfoBeans) {
                if (lastVerCodes.contains(taxVerInfoBean.getCode())) continue;
                entity = newVerEntryentity.addNew();
                entity.set("modifycontexttitle", (Object)taxVerInfoBean.getName());
                entity.set("modifycontexttitleysjbs", (Object)taxVerInfoBean.getCode());
                entity.set("modifycontexbefore", null);
                entity.set("modifycontexbeforecode", null);
                TaxVersionUtil.code2Name(taxVerInfoBean, entity, (DynamicObject)fitTaxTypes.get(0));
                if ("taxenddate".equalsIgnoreCase(taxVerInfoBean.getCode())) {
                    logger.info("\u7279\u6b8a\u5904\u7406\u8865\u5145\u589e\u503c\u7a0e\u8bbe\u7f6e\u65f6\u95f4(\u539f\u8bb0\u5f55\u7f3a\u5931\u8be5\u5b57\u6bb5)-" + orgid);
                    effectiveDate = TaxVersionUtil.setZzsDateField(taxMain, entity, lastChange);
                }
                if (StringUtil.equalsIgnoreCase((CharSequence)entity.getString("modifycontexafter"), (CharSequence)entity.getString("modifycontexbefore"))) continue;
                needSave = true;
            }
        } else {
            logger.info("normal\u8868\u4e0d\u5b58\u5728\u5386\u53f2\u53d8\u66f4\u8bb0\u5f55:" + orgid + "-" + curMaxVer);
            needSave = true;
            for (TaxVerInfoBean taxVerInfoBean : taxVerInfoBeans) {
                DynamicObject entity = newVerEntryentity.addNew();
                entity.set("modifycontexttitle", (Object)taxVerInfoBean.getName());
                entity.set("modifycontexttitleysjbs", (Object)taxVerInfoBean.getCode());
                entity.set("modifycontexbefore", null);
                entity.set("modifycontexbeforecode", null);
                TaxVersionUtil.code2Name(taxVerInfoBean, entity, (DynamicObject)fitTaxTypes.get(0));
                if (!"taxenddate".equalsIgnoreCase(taxVerInfoBean.getCode())) continue;
                logger.info("\u6784\u5efa\u751f\u6548\u65f6\u95f4\u5b57\u6bb5-" + orgid);
                effectiveDate = TaxVersionUtil.setZzsDateField(taxMain, entity, lastChange);
            }
        }
        if (needSave) {
            updateList.add(newVer);
        }
        return effectiveDate;
    }

    private static void doAddNonNormalHistory(DynamicObject taxMain, TaxTypeComboEnum taxTypeComboEnum, DynamicObject lastVerData, List<DynamicObject> updateList, boolean isValueChange) {
        DynamicObjectCollection taxTypes = taxMain.getDynamicObjectCollection("categoryentryentity");
        List fitTaxTypes = taxTypes.stream().filter(v -> taxTypeComboEnum.getCode().equalsIgnoreCase(v.getString("taxtype"))).collect(Collectors.toList());
        if (EmptyCheckUtils.isEmpty(fitTaxTypes)) {
            return;
        }
        Long curMaxVer = lastVerData != null ? lastVerData.getLong("ver") : 0L;
        Long ver = curMaxVer = Long.valueOf(curMaxVer + 1L);
        DynamicObject newVer = TaxVersionUtil.createNewVer(taxMain, taxTypeComboEnum, ver);
        newVer.set("enable", ((DynamicObject)fitTaxTypes.get(0)).get("enable"));
        DynamicObjectCollection otherTaxTypes = taxMain.getDynamicObjectCollection(taxTypeComboEnum.getDisplayControl());
        if (EmptyCheckUtils.isEmpty((Object)otherTaxTypes)) {
            if (EmptyCheckUtils.isEmpty((Object)lastVerData)) {
                return;
            }
            DynamicObjectCollection entitys = lastVerData.getDynamicObjectCollection("entryentity");
            if (EmptyCheckUtils.isNotEmpty((Object)entitys)) {
                updateList.add(newVer);
            }
            return;
        }
        DynamicObjectCollection newVerEntryentity = newVer.getDynamicObjectCollection("entryentity");
        if (taxTypeComboEnum.compareTo((Enum)TaxTypeComboEnum.HJBHS) == 0) {
            newVer.set("hjbhs_acsb", ((DynamicObject)otherTaxTypes.get(0)).get("hjbhs_acsb"));
            newVer.set("hjbhs_cshygc", ((DynamicObject)otherTaxTypes.get(0)).get("hjbhs_cshygc"));
            newVer.set("hjbhs_cxwsjzclcs", ((DynamicObject)otherTaxTypes.get(0)).get("hjbhs_cxwsjzclcs"));
            newVer.set("hjbhs_shljjzclcs", ((DynamicObject)otherTaxTypes.get(0)).get("hjbhs_shljjzclcs"));
            newVer.set("hjbhs_pollutanttype", ((DynamicObject)otherTaxTypes.get(0)).get("hjbhs_pollutanttype"));
        }
        for (DynamicObject temp : otherTaxTypes) {
            DynamicObject entity = newVerEntryentity.addNew();
            if (taxTypeComboEnum.compareTo((Enum)TaxTypeComboEnum.HJBHS) != 0) {
                BeanCopyUtils.copyDynamicObjectWithoutEntityid((DynamicObject)temp, (DynamicObject)entity);
            } else if (taxTypeComboEnum.compareTo((Enum)TaxTypeComboEnum.HJBHS) == 0) {
                entity.set("hjbhs_number", temp.get("hjbhs_number"));
                entity.set("hjbhs_startdate", temp.get("hjbhs_startdate"));
                entity.set("hjbhs_enddate", temp.get("hjbhs_enddate"));
                entity.set("hjbhs_remark", temp.get("hjbhs_remark"));
            }
            if (taxTypeComboEnum.compareTo((Enum)TaxTypeComboEnum.XFS) != 0) continue;
            entity.set("xfsperiod", ((DynamicObject)fitTaxTypes.get(0)).get("deadline"));
        }
        if (isValueChange || TaxVersionUtil.isValueChange(lastVerData, newVer)) {
            updateList.add(newVer);
        }
    }

    private static boolean isValueChange(DynamicObject oldVer, DynamicObject newVer) {
        try {
            if (oldVer == null) {
                return true;
            }
            return DynamicObjectUtils.isValueChange((DynamicObject)oldVer, (DynamicObject)newVer, Arrays.asList("pkid", "id", "ver", "modifydate", "modifier_id", "modifier", "org", "org_id"));
        }
        catch (Throwable e) {
            logger.error("\u5224\u65ad\u7248\u672c\u662f\u5426\u6539\u53d8\u51fa\u73b0\u5f02\u5e38", e);
            return false;
        }
    }

    private static void code2Name(TaxVerInfoBean taxVerInfoBean, DynamicObject entity, DynamicObject newData) {
        Object newVal = newData.get(taxVerInfoBean.getCode());
        Supplier supplier = taxVerInfoBean.getFieldCode2NameMapSupplier();
        Object supplierObj = null == supplier ? null : supplier.get();
        Map code2NameMap = null;
        TaxVerInfoFormat format = null;
        if (supplierObj instanceof Map) {
            code2NameMap = supplierObj;
        } else if (supplierObj instanceof TaxVerInfoFormat) {
            format = supplierObj;
        }
        if (null != code2NameMap && 0 != code2NameMap.size()) {
            entity.set("modifycontexafter", code2NameMap.get(newVal));
            entity.set("modifycontexaftercode", newVal);
        } else if (format != null) {
            entity.set("modifycontexafter", (Object)format.format(newData, newVal));
            entity.set("modifycontexaftercode", newVal);
        } else {
            entity.set("modifycontexafter", newVal);
        }
    }

    private static String setZzsDateField(DynamicObject taxMain, DynamicObject verEntity, DynamicObject lastChange) {
        String effectiveDate = null;
        if (EmptyCheckUtils.isEmpty((Object)lastChange)) {
            logger.info("changerecord \u8bb0\u5f55\u4e0d\u5b58\u5728!!!\uff1a" + taxMain.getLong("id"));
            String dateStr = "2018-01-01";
            verEntity.set("modifycontexafter", (Object)dateStr);
            return dateStr;
        }
        if (EmptyCheckUtils.isNotEmpty((Object)lastChange.get("taxstartdate"))) {
            verEntity.set("modifycontexafter", (Object)DateUtils.format((Date)lastChange.getDate("taxstartdate")));
            effectiveDate = DateUtils.format((Date)lastChange.getDate("taxstartdate"));
        }
        return effectiveDate;
    }

    private static DynamicObject createNewVer(DynamicObject taxMain, TaxTypeComboEnum taxTypeComboEnum, Long ver) {
        Long orgid = taxMain.getLong("orgid.id");
        DynamicObject newVer = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)taxTypeComboEnum.getFormId()));
        newVer.set("modifydate", (Object)new Date());
        newVer.set("modifier", (Object)RequestContext.get().getUserId());
        newVer.set("org", (Object)orgid);
        newVer.set("taxtype", (Object)taxTypeComboEnum.getCode());
        newVer.set("ver", (Object)ver);
        return newVer;
    }
}

