/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.business.taxplan;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.taxc.common.util.DateUtils;
import kd.taxc.tctb.business.taxplan.TaxcPlanDao;

public class TaxcPlanBusiness {
    private static final String TAX_DIMENSION_ORG = "1";
    private static final String TAX_DIMENSION_BUSINESS = "2";

    public static DynamicObject[] loadAllAvaliable() {
        return TaxcPlanDao.loadAllAvaliable();
    }

    public static DynamicObject[] loadByIds(List<Long> ids) {
        return TaxcPlanDao.loadByIds(ids);
    }

    public static DynamicObject loadById(Long id) {
        return TaxcPlanDao.loadById(id);
    }

    public static String getDimKey(DynamicObject plan) {
        String keyFormat = "%1$1s";
        return String.format(keyFormat, plan.getLong("taxtype.id"));
    }

    public static boolean hasDateDuplicate(List<DynamicObject> objs, boolean filterDisable) {
        List<Object> colls = objs;
        if (filterDisable) {
            colls = objs.stream().filter(v -> TAX_DIMENSION_ORG.equals(v.getString("enable"))).collect(Collectors.toList());
        }
        for (DynamicObject obj : colls) {
            if (!TaxcPlanBusiness.hasDateDuplicate(obj, colls, filterDisable)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasDateDuplicate(DynamicObject currobj, List<DynamicObject> objs, boolean filterDisable) {
        List colls = null;
        colls = filterDisable ? objs.stream().filter(v -> v.getLong("id") != currobj.getLong("id") && TAX_DIMENSION_ORG.equals(v.getString("enable"))).collect(Collectors.toList()) : objs.stream().filter(v -> v.getLong("id") != currobj.getLong("id")).collect(Collectors.toList());
        for (DynamicObject obj : colls) {
            if (!TaxcPlanBusiness.hasDateDuplicate(currobj, obj)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasDateDuplicate(DynamicObject o1, DynamicObject o2) {
        Date endDate;
        Date startDate;
        Date endTime;
        Date beginTime = o1.getDate("startdate");
        Date[] date = DateUtils.getIntersectionDate((Date)beginTime, (Date)(endTime = o1.getDate("enddate")), (Date)(startDate = o2.getDate("startdate")), (Date)(endDate = o2.getDate("enddate")));
        return date != null && date.length > 0;
    }

    public static boolean ifOrgHasOrgDimensionTaxPlan(Long orgId, Long taxCategoryId) {
        return TaxcPlanBusiness.queryTaxPlanIsOrgDimension(orgId, taxCategoryId).size() > 0;
    }

    public static List<DynamicObject> queryTaxPlanIsOrgDimension(Long orgId, Long taxCategoryId) {
        List<DynamicObject> taxPlans = TaxcPlanBusiness.queryTaxPlanByOrgIdAndTaxcategory(orgId, taxCategoryId);
        return TaxcPlanBusiness.filterByTaxdimensionIsOrg(taxPlans);
    }

    public static List<DynamicObject> queryTaxPlanByOrgIdAndTaxcategory(Long orgId, Long taxCategoryId) {
        return TaxcPlanBusiness.queryTaxPlanByOrgIdAndTaxcategorys(orgId, Collections.singletonList(taxCategoryId));
    }

    public static List<DynamicObject> queryTaxPlanByOrgIdAndTaxcategorys(Long orgId, List<Long> taxCategoryIds) {
        DynamicObject[] taxPlanDyns = TaxcPlanDao.loadTaxPlanByOrgIds(Collections.singletonList(orgId));
        List<DynamicObject> tempTaxPlans = Arrays.asList(taxPlanDyns);
        List<DynamicObject> target = TaxcPlanBusiness.filterByEnable(tempTaxPlans);
        if (taxCategoryIds != null) {
            target = TaxcPlanBusiness.filterByTaxCategory(target, taxCategoryIds);
        }
        return target;
    }

    public static List<DynamicObject> queryTaxPlanByOrgIdsAndTaxcategory(List<Long> orgIds, Long taxCategoryId) {
        DynamicObject[] taxPlanDyns = TaxcPlanDao.loadTaxPlanByOrgIds(orgIds);
        List<DynamicObject> tempTaxPlans = Arrays.asList(taxPlanDyns);
        List<DynamicObject> target = TaxcPlanBusiness.filterByEnable(tempTaxPlans);
        if (taxCategoryId != null) {
            target = TaxcPlanBusiness.filterByTaxCategory(target, taxCategoryId);
        }
        return target;
    }

    private static List<DynamicObject> filterByEnable(Collection<DynamicObject> taxplanDyns) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(10);
        for (DynamicObject taxplanDyn : taxplanDyns) {
            boolean enable = taxplanDyn.getBoolean("enable");
            if (!enable) continue;
            list.add(taxplanDyn);
        }
        return list;
    }

    private static List<DynamicObject> filterByTaxCategory(Collection<DynamicObject> taxplanDyns, Long taxCategoryId) {
        return TaxcPlanBusiness.filterByTaxCategory(taxplanDyns, Collections.singletonList(taxCategoryId));
    }

    private static List<DynamicObject> filterByTaxCategory(Collection<DynamicObject> taxplanDyns, List<Long> taxCategoryIds) {
        HashSet<Long> taxCategorySet = new HashSet<Long>(8);
        taxCategorySet.addAll(taxCategoryIds);
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(10);
        for (DynamicObject taxplanDyn : taxplanDyns) {
            Long taxId = taxplanDyn.getLong("taxtype.id");
            if (!taxCategorySet.contains(taxId)) continue;
            list.add(taxplanDyn);
        }
        return list;
    }

    private static List<DynamicObject> filterByTaxdimensionIsOrg(Collection<DynamicObject> taxplanDyns) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(10);
        for (DynamicObject taxplanDyn : taxplanDyns) {
            String dimension = taxplanDyn.getString("taxdimension");
            if (!TaxcPlanBusiness.containsTaxDimensionOrg(dimension)) continue;
            list.add(taxplanDyn);
        }
        return list;
    }

    private static boolean containsTaxDimensionOrg(String taxDimension) {
        return taxDimension.contains(TAX_DIMENSION_ORG);
    }

    private static boolean containsTaxDimensionBusiness(String taxDimension) {
        return taxDimension.contains(TAX_DIMENSION_BUSINESS);
    }
}

