/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.business.taxplan;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class TaxcPlanDao {
    public static DynamicObject[] loadAllAvaliable() {
        QFilter filter = TaxcPlanDao.baseFilter();
        return BusinessDataServiceHelper.load((String)"tctb_tax_plan", (String)"id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,taxtype,taxdimension,startdate,enddate,businessdimesion", (QFilter[])new QFilter[]{filter});
    }

    public static DynamicObject[] loadByIds(List<Long> ids) {
        QFilter filter = new QFilter("id", "in", ids);
        return BusinessDataServiceHelper.load((String)"tctb_tax_plan", (String)"id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,taxtype,taxdimension,startdate,enddate,businessdimesion", (QFilter[])new QFilter[]{filter});
    }

    public static DynamicObject loadById(Long id) {
        QFilter filter = new QFilter("id", "=", (Object)id);
        return BusinessDataServiceHelper.loadSingle((String)"tctb_tax_plan", (String)"id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,taxtype,taxdimension,startdate,enddate,businessdimesion", (QFilter[])new QFilter[]{filter});
    }

    private static QFilter baseFilter() {
        return new QFilter("enable", "=", (Object)"1");
    }

    public static DynamicObject[] loadSharePlanByOrgId(Long orgId) {
        QFilter filter = new QFilter("orgentity.org.id", "=", (Object)orgId);
        DynamicObject[] sharePlanDyns = BusinessDataServiceHelper.load((String)"tctb_jsfa_shareplan", (String)"id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,ruleentity,orgentity,ruleentity.seq,ruleentity.rule,orgentity.seq,orgentity.org,ruleentity.taxtype,ruleentity.taxdimension,ruleentity.businessdimesion,ruleentity.startdate,ruleentity.enddate,ruleentity.enable,ruleentity.rule.businessdimension.fbasedataid.id", (QFilter[])new QFilter[]{filter});
        return sharePlanDyns;
    }

    public static DynamicObject[] loadSharePlanByOrgIds(List<Long> orgIds) {
        QFilter filter = new QFilter("orgentity.org.id", "in", orgIds);
        DynamicObject[] sharePlanDyns = BusinessDataServiceHelper.load((String)"tctb_jsfa_shareplan", (String)"id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,ruleentity,orgentity,ruleentity.seq,ruleentity.rule,orgentity.seq,orgentity.org,ruleentity.taxtype,ruleentity.taxdimension,ruleentity.businessdimesion,ruleentity.startdate,ruleentity.enddate,ruleentity.enable,ruleentity.rule.businessdimension.fbasedataid.id", (QFilter[])new QFilter[]{filter});
        return sharePlanDyns;
    }

    public static DynamicObject[] loadTaxPlanByOrgIds(List<Long> orgIds) {
        DynamicObject[] sharePlanDyns = TaxcPlanDao.loadSharePlanByOrgIds(orgIds);
        ArrayList<Long> taxPlanIds = new ArrayList<Long>(10);
        for (DynamicObject sharePlanDyn : sharePlanDyns) {
            DynamicObjectCollection taxplanDyns = sharePlanDyn.getDynamicObjectCollection("ruleentity");
            List planIds = taxplanDyns.stream().map(dyn -> dyn.getLong("rule.id")).collect(Collectors.toList());
            taxPlanIds.addAll(planIds);
        }
        return TaxcPlanDao.loadByIds(taxPlanIds);
    }
}

