/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.business.util;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.OrgViewServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bastax.taxcorg.TaxcOrgDataServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.admindivision.AdminDivisionUtils;
import kd.taxc.common.util.StringUtil;
import kd.taxc.tctb.business.taxcmain.TaxcMainBusiness;
import kd.taxc.util.SystemParamUtil;
import org.apache.commons.lang3.ObjectUtils;

public class TaxInfoUtil {
    public static Map<String, String> getInfoByOrgIdFromErp(String orgId, String ... selectFields) {
        QFilter id = new QFilter("id", "=", (Object)Long.parseLong(orgId));
        StringBuilder selectStrBuilder = new StringBuilder();
        int len = selectFields.length;
        for (int i = 0; i < len; ++i) {
            selectStrBuilder.append(selectFields[i]);
            selectStrBuilder.append(',');
        }
        String temp = selectStrBuilder.toString();
        String selectStr = temp.substring(0, temp.length() - 1);
        DataSet ds = QueryServiceHelper.queryDataSet((String)OrgViewServiceHelper.class.getName(), (String)"bos_org", (String)selectStr, (QFilter[])new QFilter[]{id}, (String)"id");
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator iter = ds.iterator();
        if (iter.hasNext()) {
            Row row = (Row)iter.next();
            for (int key = 0; key < selectFields.length; ++key) {
                map.put(selectFields[key], row.getString(selectFields[key]));
            }
        }
        return map;
    }

    public static String validateBillstatus(String operateKey, String billstatus) {
        String errorMsg = "";
        if (!"A".equals(billstatus) && "delete".equals(operateKey)) {
            errorMsg = ResManager.loadKDString((String)"\u53ea\u6709\u6682\u5b58\u72b6\u6001\u7684\u6570\u636e\u624d\u5141\u8bb8\u5220\u9664\u3002", (String)"TaxInfoUtil_0", (String)"taxc-tctb-business", (Object[])new Object[0]);
        } else if (!"A".equals(billstatus) && "submit".equals(operateKey)) {
            errorMsg = ResManager.loadKDString((String)"\u53ea\u6709\u6682\u5b58\u72b6\u6001\u7684\u6570\u636e\u624d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"TaxInfoUtil_1", (String)"taxc-tctb-business", (Object[])new Object[0]);
        } else if (!"B".equals(billstatus) && "unsubmit".equals(operateKey)) {
            errorMsg = ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u5fc5\u987b\u662f\u5df2\u63d0\u4ea4\u624d\u80fd\u64a4\u9500\u3002", (String)"TaxInfoUtil_2", (String)"taxc-tctb-business", (Object[])new Object[0]);
        } else if (!"B".equals(billstatus) && "audit".equals(operateKey)) {
            errorMsg = ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u63d0\u4ea4\u624d\u80fd\u5ba1\u6838\u3002", (String)"TaxInfoUtil_3", (String)"taxc-tctb-business", (Object[])new Object[0]);
        } else if (!"C".equals(billstatus) && "unaudit".equals(operateKey)) {
            errorMsg = ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u662f\u5df2\u5ba1\u6838\u7684\u6570\u636e\u624d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"TaxInfoUtil_4", (String)"taxc-tctb-business", (Object[])new Object[0]);
        }
        return errorMsg;
    }

    public static boolean validateHwsIsopen() {
        return SystemParamUtil.isOverseasTaxOrg((Long)OrgUnitServiceHelper.getRootOrgId());
    }

    public static Optional<String> checkTaxOrgVolid(DynamicObject obj) {
        List basTaxList;
        DynamicObject org = obj.getDynamicObject("orgid");
        Long taxAtionId = obj.getLong("taxationsys.id");
        Long orgId = org.getLong("id");
        List<Long> orgIds = Collections.singletonList(orgId);
        TaxResult result = TaxcOrgDataServiceHelper.queryTaxcOrgByOrgIdsAndTaxationsysId(orgIds, (Long)taxAtionId, (boolean)true);
        if (result != null && result.isSuccess() && (basTaxList = (List)result.getData()) != null && basTaxList.size() > 0) {
            DynamicObject basTax = (DynamicObject)basTaxList.get(0);
            DynamicObjectCollection entries = basTax.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entries) {
                if (!taxAtionId.equals(entry.getLong("entry_taxationsys.id"))) continue;
                if ("0".equals(entry.getString("entry_status"))) {
                    return Optional.of(String.format(ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\u5df2\u7981\u7528\uff0c\u8bf7\u524d\u5f80\u201c\u57fa\u7840\u8bbe\u7f6e>\u7a0e\u52a1\u7ec4\u7ec7\u7ba1\u7406>\u7a0e\u52a1\u7ec4\u7ec7\u4fe1\u606f\u201d\uff0c\u7ef4\u62a4\u7a0e\u52a1\u7ec4\u7ec7\u72b6\u6001\u4e3a\u53ef\u7528\u3002", (String)"TaxInfoUtil_16", (String)"taxc-tctb-business", (Object[])new Object[0]), new Object[0]));
                }
                if (ObjectUtils.isEmpty((Object)entry.getString("entry_taxpayer"))) {
                    return Optional.of(String.format(ResManager.loadKDString((String)"\u8bf7\u524d\u5f80\u201c\u57fa\u7840\u8bbe\u7f6e>\u7a0e\u52a1\u7ec4\u7ec7\u7ba1\u7406>\u7a0e\u52a1\u7ec4\u7ec7\u4fe1\u606f\u201d\u70b9\u51fb\u201c\u7f16\u7801\u201d\uff0c\u5728\u7a0e\u52a1\u7ec4\u7ec7\u4fe1\u606f\u5f39\u7a97\u4e2d\u7ef4\u62a4\u7eb3\u7a0e\u4eba\u540d\u79f0\u3002", (String)"TaxInfoUtil_5", (String)"taxc-tctb-business", (Object[])new Object[0]), new Object[0]));
                }
                if (!ObjectUtils.isEmpty((Object)entry.getString("entry_unifiedsocialcode"))) continue;
                return Optional.of(String.format(ResManager.loadKDString((String)"\u8bf7\u524d\u5f80\u201c\u57fa\u7840\u8bbe\u7f6e>\u7a0e\u52a1\u7ec4\u7ec7\u7ba1\u7406>\u7a0e\u52a1\u7ec4\u7ec7\u4fe1\u606f\u201d\u70b9\u51fb\u201c\u7f16\u7801\u201d\uff0c\u5728\u7a0e\u52a1\u7ec4\u7ec7\u4fe1\u606f\u5f39\u7a97\u4e2d\u7ef4\u62a4\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u3002", (String)"TaxInfoUtil_6", (String)"taxc-tctb-business", (Object[])new Object[0]), new Object[0]));
            }
        }
        return Optional.empty();
    }

    public static Optional<String> validateFinancetaxperiodMustInput(DynamicObject obj) {
        DynamicObject entry;
        DynamicObjectCollection coll = obj.getDynamicObjectCollection("categoryentryentity");
        List entries = coll.stream().filter(v -> "cwbb".equals(v.getString("taxtype"))).collect(Collectors.toList());
        Long taxationsysId = obj.getDynamicObject("taxationsys").getLong("id");
        if (taxationsysId == 1L && entries.size() > 0 && "1".equals((entry = (DynamicObject)entries.get(0)).getString("enable")) && EmptyCheckUtils.isEmpty((Object)entry.getString("declareperiod"))) {
            return Optional.of(ResManager.loadKDString((String)"\u8d22\u52a1\u62a5\u8868\u201c\u542f\u7528\u201d\u65f6\uff0c\u7533\u62a5\u671f\u9650\u4e0d\u4e3a\u7a7a\u3002", (String)"TaxInfoUtil_8", (String)"taxc-tctb-business", (Object[])new Object[0]));
        }
        return Optional.empty();
    }

    public static Optional<String> validateRegisterAdressForzzs(DynamicObject obj) {
        DynamicObject registeraddressObj;
        String registeraddress;
        long taxationsysId = obj.getDynamicObject("taxationsys").getLong("id");
        DynamicObjectCollection categoryentryentity = obj.getDynamicObjectCollection("categoryentryentity");
        boolean isNeedValidate = false;
        if (!CollectionUtils.isEmpty((Collection)categoryentryentity)) {
            Optional<DynamicObject> taxtype = categoryentryentity.stream().filter(a -> StringUtil.equals((CharSequence)"zzs", (CharSequence)a.getString("taxtype")) && StringUtil.equals((CharSequence)"1", (CharSequence)a.getString("enable"))).findFirst();
            isNeedValidate = taxtype.isPresent();
        }
        if (taxationsysId == 1L && isNeedValidate && StringUtils.isNotBlank((CharSequence)(registeraddress = obj.getString("registeraddress"))) && (registeraddressObj = AdminDivisionUtils.getObject((String)registeraddress)) != null) {
            String level = registeraddressObj.getString("level");
            boolean isCity = registeraddressObj.getBoolean("iscity");
            boolean isleaf = registeraddressObj.getBoolean("isleaf");
            if (StringUtils.equals((CharSequence)level, (CharSequence)"1") && !isCity && !isleaf) {
                return Optional.of(ResManager.loadKDString((String)"\u589e\u503c\u7a0e\u7a0e\u79cd\u5361\u7247\u5df2\u542f\u7528\uff0c\u201c\u6ce8\u518c\u767b\u8bb0\u533a\u57df\u201d\u5e94\u5177\u4f53\u5230\u5e02\u3002", (String)"TaxInfoUtil_7", (String)"taxc-tctb-business", (Object[])new Object[0]));
            }
        }
        return Optional.empty();
    }

    public static Map<String, Object> batchFetchValidateData(List<DynamicObject> objs) {
        List<Long> orgIds = objs.stream().map(v -> v.getLong("orgid.id")).filter(v -> v != 0L).collect(Collectors.toList());
        DynamicObject[] taxMains = TaxcMainBusiness.getTaxMainInfoByOrgIds(orgIds);
        Map<Object, Object> taxMainOrgMap = new HashMap(10);
        Map<Object, Object> taxMainMap = new HashMap(10);
        if (taxMains != null && taxMains.length > 0) {
            taxMainOrgMap = Stream.of(taxMains).collect(Collectors.groupingBy(k -> k.getLong("orgid.id")));
            taxMainMap = Stream.of(taxMains).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        }
        HashMap<String, Object> cacheData = new HashMap<String, Object>(10);
        cacheData.put("taxMainOrgMap", taxMainOrgMap);
        cacheData.put("taxMainMap", taxMainMap);
        return cacheData;
    }

    public static Optional<String> validateRegisterAddressCountry(DynamicObject obj, Map<String, Object> cacheData) {
        boolean registerplace = obj.getBoolean("registerplace");
        if (registerplace) {
            String registeraddress = obj.getString("registeraddress");
            long taxsystemId = obj.getLong("taxationsys.id");
            if (StringUtils.isNotBlank((CharSequence)registeraddress) && taxsystemId != 0L) {
                long taxSystemCountry;
                long registerCountry;
                DynamicObject registeraddressObj = AdminDivisionUtils.getObject((String)registeraddress);
                DynamicObject taxSystemObj = obj.getDynamicObject("taxationsys");
                if (registeraddressObj != null && taxSystemObj != null && (registerCountry = registeraddressObj.getLong("country.id")) != (taxSystemCountry = taxSystemObj.getLong("countryid.id"))) {
                    return Optional.of(ResManager.loadKDString((String)"\u6ce8\u518c\u767b\u8bb0\u533a\u57df\u4e0e\u6ce8\u518c\u5730\u7a0e\u6536\u5236\u5ea6\u7684\u56fd\u5bb6/\u5730\u533a\u4e0d\u4e00\u81f4\u3002", (String)"TaxInfoUtil_9", (String)"taxc-tctb-business", (Object[])new Object[0]));
                }
            }
        }
        return Optional.empty();
    }

    public static Optional<String> volidateBankInfoTaxAcctUnique(DynamicObject obj, Map<String, Object> cacheData) {
        if (obj.containsProperty("entryentity")) {
            DynamicObjectCollection bankInfoEntity = obj.getDynamicObjectCollection("entryentity");
            int bankInfosCount = bankInfoEntity.size();
            int count = 0;
            for (int i = 0; i < bankInfosCount; ++i) {
                boolean taxacct = ((DynamicObject)bankInfoEntity.get(i)).getBoolean("taxacct");
                if (!taxacct) continue;
                ++count;
            }
            if (count > 1) {
                return Optional.of(ResManager.loadKDString((String)"\u6bcf\u4e2a\u7eb3\u7a0e\u4e3b\u4f53\u53ea\u80fd\u6709\u4e00\u4e2a\u94f6\u884c\u4fe1\u606f\u7684\u201c\u7f34\u7a0e\u8d26\u6237\u201d\u586b\u5199\u4e3a\u201c\u662f\u201d\u3002", (String)"TaxcMainService_3", (String)"taxc-tctb-business", (Object[])new Object[0]));
            }
        }
        return Optional.empty();
    }

    public static Optional<String> validateRegisterPlaceUnique(DynamicObject obj, Map<String, Object> cacheData) {
        Map taxMainOrgMap = (Map)cacheData.get("taxMainOrgMap");
        if (taxMainOrgMap != null) {
            List taxMains = (List)taxMainOrgMap.get(obj.getLong("orgid.id"));
            boolean registerplace = obj.getBoolean("registerplace");
            if (taxMains != null && registerplace) {
                for (DynamicObject info : taxMains) {
                    if (info.getLong("id") == obj.getLong("id") || !info.getBoolean("registerplace")) continue;
                    String taxSystemName = info.getDynamicObject("taxationsys").getString("name");
                    return Optional.of(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5df2\u88ab\u8bbe\u7f6e\u4e3a\u6ce8\u518c\u5730\uff0c\u6ce8\u518c\u5730\u6807\u8bc6\u4e0d\u53ef\u91cd\u590d\u3002", (String)"TaxInfoUtil_10", (String)"taxc-tctb-business", (Object[])new Object[0]), taxSystemName));
                }
            }
        }
        return Optional.empty();
    }

    public static Optional<String> validateTaxJurisdictionUnique(DynamicObject obj, Map<String, Object> cacheData) {
        Map taxMainOrgMap = (Map)cacheData.get("taxMainOrgMap");
        if (taxMainOrgMap != null) {
            List taxMains = (List)taxMainOrgMap.get(obj.getLong("orgid.id"));
            boolean taxjurisdiction = obj.getBoolean("taxjurisdiction");
            if (taxMains != null && taxjurisdiction) {
                for (DynamicObject info : taxMains) {
                    if (info.getLong("id") == obj.getLong("id") || !info.getBoolean("taxjurisdiction")) continue;
                    String taxSystemName = info.getDynamicObject("taxationsys").getString("name");
                    return Optional.of(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5df2\u88ab\u8bbe\u7f6e\u4e3a\u7a0e\u6536\u7ba1\u8f96\u5730\uff0c\u7a0e\u6536\u7ba1\u8f96\u5730\u6807\u8bc6\u4e0d\u53ef\u91cd\u590d\u3002", (String)"TaxInfoUtil_11", (String)"taxc-tctb-business", (Object[])new Object[]{taxSystemName}), new Object[0]));
                }
            }
        }
        return Optional.empty();
    }

    public static Optional<String> validateRegisteredCurrencyMustInput(DynamicObject obj) {
        boolean isOverseasTax;
        boolean registerplace = obj.getBoolean("registerplace");
        boolean bl = isOverseasTax = obj.getLong("taxationsys.id") != 1L;
        if (isOverseasTax && !registerplace) {
            return Optional.empty();
        }
        BigDecimal registeredcapital = obj.getBigDecimal("registeredcapital");
        if ((registeredcapital == null || BigDecimal.ZERO.compareTo(registeredcapital) != 0) && obj.get("registeredcurrency") == null) {
            return Optional.of(ResManager.loadKDString((String)"\u60a8\u5df2\u7ef4\u62a4\u6ce8\u518c\u8d44\u91d1\u4fe1\u606f\uff0c\u8bf7\u586b\u5199\u6ce8\u518c\u8d44\u91d1\u5e01\u79cd\u3002", (String)"TaxInfoUtil_12", (String)"taxc-tctb-business", (Object[])new Object[0]));
        }
        return Optional.empty();
    }

    public static void updateTaxMainTaxOrgEntryFields(DynamicObject[] taxMains) {
        TaxResult result;
        if (taxMains == null || taxMains.length == 0) {
            return;
        }
        List orgIds = Arrays.stream(taxMains).filter(v -> v.getDynamicObject("orgid") != null).map(v -> v.getLong("orgid.id")).collect(Collectors.toList());
        if (orgIds.size() > 0 && (result = TaxcOrgDataServiceHelper.queryAllTaxcOrgByOrgIds(orgIds)) != null && result.getData() != null) {
            DynamicObject[] taxOrgs = (DynamicObject[])result.getData();
            HashMap<String, DynamicObject> groupMap = new HashMap<String, DynamicObject>(10);
            for (DynamicObject taxOrg : taxOrgs) {
                DynamicObjectCollection entries = taxOrg.getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : entries) {
                    if (taxOrg.getDynamicObject("org") == null || entry.getDynamicObject("entry_taxationsys") == null) continue;
                    String key = taxOrg.getLong("org.id") + "_" + entry.getLong("entry_taxationsys.id");
                    groupMap.put(key, entry);
                }
            }
            Arrays.stream(taxMains).forEach(v -> {
                if (v.getDynamicObject("taxorg") == null || v.getDynamicObject("taxationsys") == null) {
                    return;
                }
                String key = v.getLong("taxorg.id") + "_" + v.getLong("taxationsys.id");
                DynamicObject entry = (DynamicObject)groupMap.get(key);
                if (entry != null) {
                    v.set("taxorgentry", (Object)entry);
                }
            });
        }
    }

    public static void updateResidenttypeFields(DynamicObject[] taxMains) {
        if (taxMains == null || taxMains.length == 0) {
            return;
        }
        Arrays.stream(taxMains).forEach(obj -> {
            String residenttype;
            DynamicObject entry;
            DynamicObjectCollection coll = obj.getDynamicObjectCollection("categoryentryentity");
            List entries = coll.stream().filter(v -> "qysds".equals(v.getString("taxtype"))).collect(Collectors.toList());
            if (entries != null && entries.size() > 0 && (entry = (DynamicObject)entries.get(0)).containsProperty("residenttype") && StringUtil.isEmpty((CharSequence)(residenttype = entry.getString("residenttype")))) {
                entry.set("residenttype", (Object)"jmqy");
            }
        });
    }
}

