/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.business.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.common.util.DBUtils;
import kd.taxc.common.util.DateUtils;
import kd.taxc.common.util.EmptyCheckUtils;
import kd.taxc.common.util.StringUtil;
import kd.taxc.tctb.business.taxmain.util.TaxVersionUtil;

public class UpgradeUtil {
    private static final Log logger = LogFactory.getLog(TaxVersionUtil.class);
    private static final String CATEGORYENTRYENTITY = "categoryentryentity";
    private static final String DEFAULT_START_DATE = "2018-01-01";
    private static final String INSERT_BASE_SQL = "INSERT INTO T_TCTB_TAX_CHANGE_RECORD (FID, FLEVYTYPE, FDEADLINE, FTAXPAYERTYPE, FENABLE, FSTARTDATE, FTYPE, FCREATER, FMODIFIER, FMODIFYDATE, FCREATEDATE, FMAINTABLEID, FTAXTYPE, FSEQ) VALUES ";
    private static final String SELECT_BASE_SQL = "SELECT FID,FTAXTYPE,FMAINTABLEID FROM  T_TCTB_TAX_CHANGE_RECORD ";
    private static final String SELECT_ORIGIN_BASE_SQL = "SELECT B.FID, B.FENTRYID, B.FSEQ, B.FTAXTYPE, B.FLEVYTYPE, B.FDEADLINE, B.FTAXPAYERTYPE, B.FENABLE FROM T_TCTB_TAX_MAIN A LEFT JOIN T_TCTB_CATEGORYINFO B ON A.FID=B.FID ";
    private static final String MAIN_TBALE = "T_TCTB_DECLARE_MAIN";
    private static final String EXT_TBALE = "T_TCTB_DECLARE_EXT";
    private static final String SELECT_ORI_BASE_SQL = "SELECT FID, FCREATORID, FCREATETIME, FNSRSBH, FNSRMC, FNSRTYPE, FSKSSQQ, FSKSSQZ, FTEMPLATEID, FORGID, FDECLARESTATUS, FMODIFIERID, FMODIFYTIME, FEWBLXH, FSSHYMC, FFDDBRXM, FZCDZ, FSCJYDZ, FYHZH, FKHYH, FREGISTERTYPE, FPHONENUM, FBQYBTSE, FYSSR, FAUDITDATE, FBILLNO, FBILLSTATUS, FAUDITORID, FDATATYPE, '1' AS FSBLX,FSBRQ,FTAXLIMIT, FAPANAGE, FTCRETTYPE, FGROUPID,'0' AS FSERIALNO FROM T_TCVAT_NSRXX";
    private static final String FIELDS = "FID, FCREATORID, FCREATETIME, FNSRSBH, FNSRMC, FNSRTYPE, FSKSSQQ, FSKSSQZ, FTEMPLATEID, FORGID, FDECLARESTATUS, FMODIFIERID, FMODIFYTIME, FEWBLXH, FSSHYMC, FFDDBRXM, FZCDZ, FSCJYDZ, FYHZH, FKHYH, FREGISTERTYPE, FPHONENUM, FBQYBTSE, FYSSR, FAUDITDATE, FBILLNO, FBILLSTATUS, FAUDITORID, FDATATYPE, FSBLX,FSBRQ,FTAXLIMIT, FAPANAGE, FTCRETTYPE, FGROUPID,FSERIALNO";
    private static final String INSERT_BASE_SQL_PARAM = "INSERT INTO T_TCTB_DECLARE_MAIN(FID, FCREATORID, FCREATETIME, FNSRSBH, FNSRMC, FNSRTYPE, FSKSSQQ, FSKSSQZ, FTEMPLATEID, FORGID, FDECLARESTATUS, FMODIFIERID, FMODIFYTIME, FEWBLXH, FSSHYMC, FFDDBRXM, FZCDZ, FSCJYDZ, FYHZH, FKHYH, FREGISTERTYPE, FPHONENUM, FBQYBTSE, FYSSR, FAUDITDATE, FBILLNO, FBILLSTATUS, FAUDITORID, FDATATYPE, FSBLX,FSBRQ,FTAXLIMIT, FAPANAGE, FTCRETTYPE, FGROUPID,FSERIALNO) VALUES";
    private static final String SELECT_EXT_ORI_BASE_SQL = "SELECT FID, FKJZG, FDLSB, FDLSBZJJG, FJBR, FBLRYSFZJLX, FSLR, FZGSWJG, FFDDBRQZRQ, FTBRQ, FBLR, FDLSBRQ, FJBRZYZJHM, FBLRYSFZJHM, FSLRQ, FKSZJGXZQH, FEWBLXH FROM T_TCVAT_NSRXX";
    private static final String EXT_FIELDS = "FSBBID,FKJZG, FDLSB, FDLSBZJJG, FJBR, FBLRYSFZJLX, FSLR, FZGSWJG, FFDDBRQZRQ, FTBRQ, FBLR, FDLSBRQ, FJBRZYZJHM, FBLRYSFZJHM, FSLRQ, FKSZJGXZQH, FEWBLXH,FID";
    private static final String INSERT_EXT_BASE_SQL_PARAM = "INSERT INTO T_TCTB_DECLARE_EXT(FSBBID,FKJZG, FDLSB, FDLSBZJJG, FJBR, FBLRYSFZJLX, FSLR, FZGSWJG, FFDDBRQZRQ, FTBRQ, FBLR, FDLSBRQ, FJBRZYZJHM, FBLRYSFZJHM, FSLRQ, FKSZJGXZQH, FEWBLXH,FID) VALUES";
    private static final int MAX_PAGE_SIZE = 5000;
    private static volatile UpgradeUtil instance;

    private UpgradeUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UpgradeUtil getInstance() {
        if (instance != null) return instance;
        Class<UpgradeUtil> clazz = UpgradeUtil.class;
        synchronized (UpgradeUtil.class) {
            if (instance != null) return instance;
            instance = new UpgradeUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static void executeInitSyncTask() {
        List<Map<String, Object>> dynamicObjectList = UpgradeUtil.getAllExecuteDataByDBOperate();
        Set collect = (dynamicObjectList = dynamicObjectList.stream().filter(v -> StringUtils.isNotBlank(v.get("FID")) && StringUtils.isNotBlank(v.get("FTAXTYPE"))).collect(Collectors.toList())).stream().map(v -> v.get("FID")).collect(Collectors.toSet());
        if (EmptyCheckUtils.isEmpty(collect)) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(SELECT_BASE_SQL).append("WHERE FMAINTABLEID IN (").append(collect.stream().map(s -> "'" + s + "'").collect(Collectors.joining(","))).append(')');
        List mapList = DBUtils.query((String)builder.toString());
        HashMap flatMap = new HashMap(mapList.size());
        mapList.forEach(itemMap -> {
            StringBuilder key = new StringBuilder();
            key.append(itemMap.get("FMAINTABLEID")).append(itemMap.get("FTAXTYPE"));
            flatMap.put(key.toString(), itemMap.get("FID"));
        });
        ArrayList parmList = new ArrayList(dynamicObjectList.size());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(INSERT_BASE_SQL).append("(?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        dynamicObjectList.stream().forEach(dynamic -> {
            String mainTableId = dynamic.get("FID").toString();
            String taxType = dynamic.get("FTAXTYPE").toString();
            if (!flatMap.containsKey(mainTableId + taxType)) {
                parmList.add(UpgradeUtil.getObjectArray(dynamic));
            }
        });
        if (EmptyCheckUtils.isNotEmpty(parmList)) {
            DBUtils.executeBatch((String)stringBuilder.toString(), parmList);
        }
    }

    private static Object[] getObjectArray(Map<String, Object> dynamic) {
        return new Object[]{DBUtils.getLongId((String)"tctb_tax_main"), dynamic.get("FLEVYTYPE"), dynamic.get("FDEADLINE"), dynamic.get("FTAXPAYERTYPE"), dynamic.get("FENABLE"), "zzs".equals(dynamic.get("FTAXTYPE").toString()) ? DateUtils.stringToDate((String)DEFAULT_START_DATE) : null, dynamic.get("FTAXTYPE").toString() + (null != dynamic.get("FTAXPAYERTYPE") ? dynamic.get("FTAXPAYERTYPE") : ""), RequestContext.get().getCurrUserId(), RequestContext.get().getCurrUserId(), new Date(), new Date(), dynamic.get("FID"), dynamic.get("FTAXTYPE"), dynamic.get("FSEQ")};
    }

    public static void executeInitSyncTask(DynamicObjectCollection collection) {
        ArrayList<DynamicObject> initData = new ArrayList<DynamicObject>(collection.size());
        ArrayList<DynamicObject> updateData = new ArrayList<DynamicObject>(collection.size());
        for (DynamicObject dynamicObject : collection) {
            ArrayList<QFilter> list = new ArrayList<QFilter>(3);
            QFilter typeFilter = new QFilter("taxtype", "=", dynamicObject.get("taxtype"));
            QFilter idFilter = new QFilter("maintableid", "=", (Object)((DynamicObject)dynamicObject.getParent()).getPkValue().toString());
            list.add(typeFilter);
            list.add(idFilter);
            DynamicObject[] objects = BusinessDataServiceHelper.load((String)"tctb_tax_change_record", (String)"id,taxstartdate", (QFilter[])list.toArray(new QFilter[list.size()]), (String)"taxstartdate desc", (int)1);
            if (null != objects && objects.length > 0 && !"zzs".equals(dynamicObject.get("taxtype"))) {
                logger.info("\u975e\u589e\u503c\u7a0e\u4e14\u5b58\u5728\u5bf9\u5e94\u7684changerecord\u8bb0\u5f55 \u4e0d\u8bb0\u5f55changerecord");
                list.clear();
                continue;
            }
            if (null != objects && objects.length > 0 && "zzs".equals(dynamicObject.get("taxtype"))) {
                logger.info("\u589e\u503c\u7a0e\u4e14\u5b58\u5728\u5bf9\u5e94\u7684changerecord\u8bb0\u5f55");
                if (dynamicObject.get("qsyfdate") == null) {
                    logger.info("\u7a0e\u79cd\u5361\u7247\u8d77\u59cb\u6708\u4efd\u65f6\u95f4\u4e3a\u7a7a");
                    list.clear();
                    continue;
                }
                logger.info("\u7a0e\u79cd\u5361\u7247\u8d77\u59cb\u6708\u4efd\u65f6\u95f4\u4e0d\u4e3a\u7a7a");
                if (dynamicObject.getDate("qsyfdate").before(objects[0].getDate("taxstartdate"))) {
                    logger.info("\u7a0e\u79cd\u5361\u7247\u8d77\u59cb\u6708\u4efd\u906d\u9047changerecord\u4e2d\u7684\u8d77\u59cb\u65f6\u95f4\uff0c\u5f53\u505a\u65e0\u6548\uff0c\u4e0d\u8bb0\u5f55record");
                    list.clear();
                    continue;
                }
                logger.info("\u8bb0\u5f55record");
                initData.add(UpgradeUtil.assembleChangeRecordDynamicObject(dynamicObject, "tctb_tax_change_record", updateData));
                continue;
            }
            initData.add(UpgradeUtil.assembleChangeRecordDynamicObject(dynamicObject, "tctb_tax_change_record", updateData));
        }
        SaveServiceHelper.save((DynamicObject[])updateData.toArray(new DynamicObject[updateData.size()]));
        SaveServiceHelper.save((DynamicObject[])initData.toArray(new DynamicObject[initData.size()]));
    }

    public static List<DynamicObject> executeSingleSyncTask(String type, String mainTableId) {
        List<DynamicObject> dynamicObjectList = UpgradeUtil.getExecuteData(type, mainTableId, false);
        ArrayList<DynamicObject> initData = new ArrayList<DynamicObject>(dynamicObjectList.size());
        ArrayList<DynamicObject> updateData = new ArrayList<DynamicObject>(dynamicObjectList.size());
        for (DynamicObject dynamicObject : dynamicObjectList) {
            initData.add(UpgradeUtil.assembleChangeRecordDynamicObject(dynamicObject, "tctb_tax_change_record", updateData));
        }
        SaveServiceHelper.save((DynamicObject[])initData.toArray(new DynamicObject[initData.size()]));
        return initData;
    }

    private static List<Map<String, Object>> getAllExecuteDataByDBOperate() {
        return DBUtils.query((String)SELECT_ORIGIN_BASE_SQL);
    }

    private static List<DynamicObject> getExecuteData(String type, String id, boolean isQueryAll) {
        ArrayList<QFilter> list = new ArrayList<QFilter>(2);
        if (StringUtils.isNotBlank((CharSequence)type)) {
            QFilter typeFilter = new QFilter("categoryentryentity.taxtype", "=", (Object)type);
            list.add(typeFilter);
        }
        if (StringUtils.isNotBlank((CharSequence)id) && !isQueryAll) {
            QFilter idFilter = new QFilter("categoryentryentity.primarykey", "=", (Object)Long.parseLong(id));
            list.add(idFilter);
        }
        return UpgradeUtil.getConditionCollection(type, BusinessDataServiceHelper.load((String)"tctb_tax_main", (String)UpgradeUtil.getCommonStringBuilder().toString(), (QFilter[])list.toArray(new QFilter[list.size()])));
    }

    public static List<DynamicObject> getExecuteOriginalData(String type, String id) {
        ArrayList<QFilter> list = new ArrayList<QFilter>(2);
        QFilter typeFilter = new QFilter("categoryentryentity.taxtype", "=", (Object)type);
        list.add(typeFilter);
        QFilter idFilter = new QFilter("id", "=", (Object)Long.parseLong(id));
        list.add(idFilter);
        return UpgradeUtil.getConditionCollection(type, BusinessDataServiceHelper.load((String)"tctb_tax_main", (String)UpgradeUtil.getCommonStringBuilder().toString(), (QFilter[])list.toArray(new QFilter[list.size()])));
    }

    private static StringBuilder getCommonStringBuilder() {
        StringBuilder builder = new StringBuilder();
        builder.append(CATEGORYENTRYENTITY).append(".").append("taxtype").append(",").append(CATEGORYENTRYENTITY).append(".").append("levytype").append(",").append(CATEGORYENTRYENTITY).append(".").append("deadline").append(",").append(CATEGORYENTRYENTITY).append(".").append("taxpayertype").append(",").append(CATEGORYENTRYENTITY).append(".").append("enable").append(",").append(CATEGORYENTRYENTITY).append(".").append("seq").append(",").append(CATEGORYENTRYENTITY).append(".").append("farmdeducttype").append(",").append(CATEGORYENTRYENTITY).append(".").append("qsyfdate");
        return builder;
    }

    private static boolean check(DynamicObject object, String type) {
        return StringUtils.isNotBlank((CharSequence)type) && type.equals(object.getString("taxtype"));
    }

    public static DynamicObject assembleChangeRecordDynamicObject(DynamicObject dynamic, String metadataNumber, List<DynamicObject> updateData) {
        DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)metadataNumber));
        Object pkValue = ((DynamicObject)dynamic.getParent()).getPkValue();
        logger.info("assembleChangeRecordDynamicObject \u7ec4\u88c5\u6570\u636e\uff1a" + pkValue);
        dynamicObject.set("maintableid", pkValue);
        if ("zzs".equals(dynamic.get("taxtype").toString())) {
            if (dynamic.get("qsyfdate") == null) {
                dynamicObject.set("taxstartdate", (Object)DateUtils.stringToDate((String)DEFAULT_START_DATE));
                dynamicObject.set("index", dynamic.get("seq"));
            } else {
                Date qsyf = dynamic.getDate("qsyfdate");
                logger.info("\u8d77\u59cb\u6708\u4efd\u65f6\u95f4\uff1a" + qsyf.toString());
                dynamicObject.set("taxstartdate", (Object)qsyf);
                HashMap<String, Object> customs = new HashMap<String, Object>(8);
                customs.put("mainId", pkValue);
                Map<String, Object> sortedMap = UpgradeUtil.getSortedDynamicObject(customs);
                DynamicObject category = (DynamicObject)sortedMap.get("sorted");
                category.set("taxenddate", dynamic.get("taxenddate"));
                category.set("modifydate", (Object)new Date());
                category.set("modifier", (Object)RequestContext.get().getUserId());
                updateData.add(category);
                dynamicObject.set("index", (Object)(Long.parseLong(sortedMap.get("allSize").toString()) + 1L));
            }
        } else {
            dynamicObject.set("index", dynamic.get("seq"));
        }
        dynamicObject.set("levytype", dynamic.get("levytype"));
        dynamicObject.set("deadline", dynamic.get("deadline"));
        dynamicObject.set("taxpayertype", dynamic.get("taxpayertype"));
        dynamicObject.set("enable", dynamic.get("enable"));
        dynamicObject.set("taxtype", dynamic.get("taxtype"));
        dynamicObject.set("type", (Object)(dynamic.get("taxtype").toString() + (null != dynamic.get("taxpayertype") ? dynamic.get("taxpayertype") : "")));
        dynamicObject.set("createdate", (Object)new Date());
        dynamicObject.set("modifydate", (Object)new Date());
        dynamicObject.set("creater", (Object)RequestContext.get().getUserId());
        dynamicObject.set("modifier", (Object)RequestContext.get().getUserId());
        if (StringUtil.equalsIgnoreCase((CharSequence)"zzs", (CharSequence)dynamic.getString("taxtype"))) {
            dynamicObject.set("farmdeducttype", dynamic.get("farmdeducttype"));
        }
        return dynamicObject;
    }

    private static List<DynamicObject> getConditionCollection(String type, DynamicObject[] main) {
        DynamicObjectCollection collection = new DynamicObjectCollection();
        for (DynamicObject object : main) {
            if (StringUtils.isNotBlank((CharSequence)type)) {
                collection.addAll((Collection)object.getDynamicObjectCollection(CATEGORYENTRYENTITY).stream().filter(v -> UpgradeUtil.check(v, type)).collect(Collectors.toCollection(DynamicObjectCollection::new)));
                continue;
            }
            collection.addAll((Collection)object.getDynamicObjectCollection(CATEGORYENTRYENTITY));
        }
        return collection;
    }

    public static void executeDataMergeTask() {
        List query = DBUtils.query((String)SELECT_ORI_BASE_SQL);
        if (EmptyCheckUtils.isEmpty((Object)query)) {
            return;
        }
        String tableName = MAIN_TBALE;
        if (query.size() > 5000) {
            int executeTime = query.size() / 5000 + 1;
            UpgradeUtil.partitionSaveTask(query, query.size() / executeTime, tableName);
        } else {
            UpgradeUtil.batchInsert(query, tableName);
        }
        List queryExt = DBUtils.query((String)SELECT_EXT_ORI_BASE_SQL);
        if (EmptyCheckUtils.isEmpty((Object)queryExt)) {
            return;
        }
        tableName = EXT_TBALE;
        if (queryExt.size() > 5000) {
            int executeTime = queryExt.size() / 5000 + 1;
            UpgradeUtil.partitionSaveTask(queryExt, queryExt.size() / executeTime, tableName);
        } else {
            UpgradeUtil.batchInsert(queryExt, EXT_TBALE);
        }
    }

    private static void partitionSaveTask(List<Map<String, Object>> query, int count, String tableName) {
        int begin = 0;
        int end = begin + count;
        while (begin <= query.size() - 1) {
            List<Map<String, Object>> partQueryList = query.subList(begin, end <= query.size() ? end : query.size());
            UpgradeUtil.batchInsert(partQueryList, tableName);
            begin = end;
            end = begin + count;
        }
    }

    private static void batchInsert(List<Map<String, Object>> partQueryList, String tableName) {
        ArrayList prepareParamList;
        String[] fieldArray;
        StringBuilder stringBuilder;
        ArrayList parmList;
        HashMap flatMap;
        List mapList;
        StringBuilder builder;
        Set collect = partQueryList.stream().map(v -> v.get("FID").toString()).collect(Collectors.toSet());
        if (tableName.equals(MAIN_TBALE)) {
            builder = new StringBuilder();
            builder.append("SELECT FID FROM ").append(MAIN_TBALE).append(" WHERE FID IN (").append(collect.stream().collect(Collectors.joining(","))).append(')');
            mapList = DBUtils.query((String)builder.toString());
            flatMap = new HashMap(mapList.size());
            mapList.forEach(itemMap -> flatMap.put(itemMap.get("FID").toString(), itemMap));
            parmList = new ArrayList(partQueryList.size());
            stringBuilder = new StringBuilder();
            fieldArray = FIELDS.split(",");
            prepareParamList = new ArrayList(fieldArray.length);
            Arrays.stream(fieldArray).forEach(v -> prepareParamList.add("?"));
            stringBuilder.append(INSERT_BASE_SQL_PARAM).append('(').append(prepareParamList.stream().collect(Collectors.joining(","))).append(')');
            partQueryList.stream().forEach(dynamic -> {
                String mainTableId = dynamic.get("FID").toString();
                if (!flatMap.containsKey(mainTableId)) {
                    parmList.add(UpgradeUtil.convertSqlParams(dynamic, tableName));
                }
            });
            if (EmptyCheckUtils.isNotEmpty(parmList)) {
                DBUtils.executeBatch((String)stringBuilder.toString(), parmList);
            }
        }
        if (tableName.equals(EXT_TBALE)) {
            builder = new StringBuilder();
            builder.append("SELECT FSBBID FROM ").append(EXT_TBALE).append(" WHERE FSBBID IN (").append(collect.stream().map(s -> "'" + s + "'").collect(Collectors.joining(","))).append(')');
            mapList = DBUtils.query((String)builder.toString());
            flatMap = new HashMap(mapList.size());
            mapList.forEach(itemMap -> flatMap.put(itemMap.get("FSBBID").toString(), itemMap));
            parmList = new ArrayList(partQueryList.size());
            stringBuilder = new StringBuilder();
            fieldArray = EXT_FIELDS.split(",");
            prepareParamList = new ArrayList(fieldArray.length);
            Arrays.stream(fieldArray).forEach(v -> prepareParamList.add("?"));
            stringBuilder.append(INSERT_EXT_BASE_SQL_PARAM).append('(').append(prepareParamList.stream().collect(Collectors.joining(","))).append(')');
            partQueryList.stream().forEach(dynamic -> {
                String mainTableId = dynamic.get("FID").toString();
                if (!flatMap.containsKey(mainTableId)) {
                    parmList.add(UpgradeUtil.convertSqlParams(dynamic, tableName));
                }
            });
            if (EmptyCheckUtils.isNotEmpty(parmList)) {
                DBUtils.executeBatch((String)stringBuilder.toString(), parmList);
            }
        }
    }

    private static Object[] convertSqlParams(Map<String, Object> dynamic, String tableName) {
        if (tableName.equals(MAIN_TBALE)) {
            return new Object[]{dynamic.get("FID"), dynamic.get("FCREATORID"), dynamic.get("FCREATETIME"), dynamic.get("FNSRSBH"), dynamic.get("FNSRMC"), dynamic.get("FNSRTYPE"), dynamic.get("FSKSSQQ"), dynamic.get("FSKSSQZ"), dynamic.get("FTEMPLATEID"), dynamic.get("FORGID"), dynamic.get("FDECLARESTATUS"), dynamic.get("FMODIFIERID"), dynamic.get("FMODIFYTIME"), dynamic.get("FEWBLXH"), dynamic.get("FSSHYMC"), dynamic.get("FFDDBRXM"), dynamic.get("FZCDZ"), dynamic.get("FSCJYDZ"), dynamic.get("FYHZH"), dynamic.get("FKHYH"), dynamic.get("FREGISTERTYPE"), dynamic.get("FPHONENUM"), dynamic.get("FBQYBTSE"), dynamic.get("FYSSR"), dynamic.get("FAUDITDATE"), dynamic.get("FBILLNO"), dynamic.get("FBILLSTATUS"), dynamic.get("FAUDITORID"), dynamic.get("FDATATYPE"), dynamic.get("FSBLX"), dynamic.get("FSBRQ"), dynamic.get("FTAXLIMIT"), dynamic.get("FAPANAGE"), dynamic.get("FTCRETTYPE"), dynamic.get("FGROUPID"), dynamic.get("FSERIALNO")};
        }
        if (tableName.equals(EXT_TBALE)) {
            return new Object[]{String.valueOf(dynamic.get("FID")), dynamic.get("FKJZG"), dynamic.get("FDLSB"), dynamic.get("FDLSBZJJG"), dynamic.get("FJBR"), dynamic.get("FBLRYSFZJLX"), dynamic.get("FSLR"), dynamic.get("FZGSWJG"), dynamic.get("FFDDBRQZRQ"), dynamic.get("FTBRQ"), dynamic.get("FBLR"), dynamic.get("FDLSBRQ"), dynamic.get("FJBRZYZJHM"), dynamic.get("FBLRYSFZJHM"), dynamic.get("FSLRQ"), dynamic.get("FKSZJGXZQH"), dynamic.get("FEWBLXH"), DBUtils.getLongId((String)tableName)};
        }
        return null;
    }

    public static Map<String, Object> getSortedDynamicObject(Map<String, Object> customs) {
        StringBuilder builder = new StringBuilder();
        builder.append("id").append(",").append("taxenddate").append(",").append("taxstartdate").append(",").append("taxtype").append(",").append("modifydate").append(",").append("modifier");
        DynamicObject[] changeRecord = BusinessDataServiceHelper.load((String)"tctb_tax_change_record", (String)builder.toString(), (QFilter[])new QFilter[]{new QFilter("maintableid", "=", (Object)customs.get("mainId").toString())});
        if (null == changeRecord || changeRecord.length == 0) {
            List<DynamicObject> list = UpgradeUtil.executeSingleSyncTask(null, customs.get("mainId").toString());
            changeRecord = list.toArray(new DynamicObject[list.size()]);
        }
        DynamicObjectCollection sortedSub = Arrays.stream(changeRecord).filter(v -> UpgradeUtil.check(v)).sorted((o1, o2) -> UpgradeUtil.sortedTime(o1, o2)).collect(Collectors.toCollection(DynamicObjectCollection::new));
        HashMap<String, Object> sorted = new HashMap<String, Object>(sortedSub.size());
        sorted.put("sortedTime", sortedSub.stream().map(v -> v.getDate("taxstartdate")).collect(Collectors.toList()));
        if (sortedSub.size() >= 1) {
            sorted.put("sorted", sortedSub.get(0));
        }
        sorted.put("allSize", changeRecord.length);
        return sorted;
    }

    private static int sortedTime(DynamicObject o1, DynamicObject o2) {
        int compare = o2.getDate("taxstartdate").compareTo(o1.getDate("taxstartdate"));
        return compare;
    }

    private static boolean check(DynamicObject v) {
        return null == v.get("taxenddate") && "zzs".equals(v.getString("taxtype"));
    }
}

