/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctf.common.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.OrgFuncEnum;
import kd.taxc.bdtaxr.common.helper.TaxcCombineDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.bastax.taxcorg.TaxcOrgDataServiceHelper;
import kd.taxc.tctf.common.helper.AbstractServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class OrgServiceHelper
extends AbstractServiceHelper {
    private static Log logger = LogFactory.getLog(OrgServiceHelper.class);
    public static final String allFlagOne = "1";

    public static TaxResult<Boolean> isOrg(Long orgId) {
        return TaxcOrgDataServiceHelper.isTaxcOrgExistByOrgId((Long)orgId);
    }

    public static List<Long> getOrgLists() {
        TaxResult result = TaxcCombineDataServiceHelper.queryOrgIdByViewWithPerm((Long)RequestContext.get().getCurrUserId(), (String)OrgFuncEnum.TAX.getNumber());
        if (!result.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)result.getData()))) {
            return new ArrayList<Long>();
        }
        return (List)result.getData();
    }

    public static List<Long> getOrgTaxpayerLists() {
        TaxResult result = TaxcCombineDataServiceHelper.queryOrgIdByViewWithPerm((Long)RequestContext.get().getCurrUserId(), (String)OrgFuncEnum.TAX.getNumber());
        TaxResult nszt = TaxcCombineDataServiceHelper.queryTaxcMainOrgIdByIsTaxpayerWithPerm((Long)RequestContext.get().getCurrUserId());
        if (!result.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)result.getData())) || !nszt.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)nszt.getData()))) {
            return new ArrayList<Long>();
        }
        ((List)result.getData()).retainAll((Collection)nszt.getData());
        return (List)result.getData();
    }

    public static List<Long> getOrgTaxpayerAllLists() {
        TaxResult result = TaxcCombineDataServiceHelper.queryTaxcMainOrgIdsByTaxpayerWithPerm((Long)RequestContext.get().getCurrUserId());
        if (!result.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)result.getData()))) {
            return new ArrayList<Long>();
        }
        return (List)result.getData();
    }

    public static TaxResult<List<Long>> getAllOrg() {
        return TaxcCombineDataServiceHelper.queryOrgIdByViewWithPerm((Long)RequestContext.get().getCurrUserId(), (String)OrgFuncEnum.TAX.getNumber(), (boolean)true);
    }

    public static final List<Long> getOrgListHasPermissionAll() {
        TaxResult<List<Long>> listTaxResult = OrgServiceHelper.getAllOrg();
        if (listTaxResult != null && listTaxResult.isSuccess() && !kd.bos.orm.util.CollectionUtils.isEmpty((Collection)((Collection)listTaxResult.getData()))) {
            return (List)listTaxResult.getData();
        }
        return new ArrayList<Long>();
    }

    public static List<Long> queryMainOrgListByCondition() {
        TaxResult result = TaxcCombineDataServiceHelper.queryTaxcMainOrgIdByIsTaxpayerWithPerm((Long)RequestContext.get().getCurrUserId());
        if (!result.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)result.getData()))) {
            return new ArrayList<Long>();
        }
        return (List)result.getData();
    }

    public static List<Long> queryOrgListByCondition() {
        TaxResult result = TaxcCombineDataServiceHelper.queryTaxcOrgIdsWithPerm((Long)RequestContext.get().getCurrUserId());
        if (!result.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)result.getData()))) {
            return new ArrayList<Long>();
        }
        return (List)result.getData();
    }

    public static String getOrgNameById(String orgid) {
        try {
            TaxResult object = TaxcOrgDataServiceHelper.queryTaxcOrgByOrgIdIsTaxpayer((Long)Long.parseLong(orgid));
            if (object.isSuccess() && object.getData() != null) {
                return ((DynamicObject)object.getData()).getString("org.name");
            }
            return "";
        }
        catch (NumberFormatException e) {
            logger.error("OrgServiceHelper.getOrgNameById\u51fa\u9519", (Throwable)e);
            return "";
        }
    }

    public static List<Long> mergeOrgIds(List<Long> idList) {
        List<Long> list = OrgServiceHelper.queryMainOrgListByCondition();
        if (CollectionUtils.isEmpty(idList) || CollectionUtils.isEmpty(list)) {
            return new ArrayList<Long>();
        }
        idList.retainAll(list);
        return idList;
    }

    public static List<DynamicObject> queryEnableOrgs() {
        TaxResult result = TaxcCombineDataServiceHelper.queryTaxcOrgByIsTaxpayerWithPerm((Long)RequestContext.get().getCurrUserId(), (Long)1L);
        if (!result.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)result.getData()))) {
            return new ArrayList<DynamicObject>();
        }
        return (List)result.getData();
    }

    public static Set<String> orgNumber() {
        List<DynamicObject> list = OrgServiceHelper.queryEnableOrgs();
        return list.stream().map(v -> v.getString("org.number")).collect(Collectors.toSet());
    }

    public static void initMainOrg(IFormView view, Boolean allTrue) {
        Object object = view.getModel().getValue("org");
        if (object == null) {
            List<Long> col = allTrue != false ? OrgServiceHelper.getOrgTaxpayerAllLists() : OrgServiceHelper.getOrgTaxpayerLists();
            if (CollectionUtils.isEmpty(col)) {
                return;
            }
            if (col.contains(RequestContext.get().getOrgId())) {
                view.getModel().setValue("org", (Object)RequestContext.get().getOrgId());
            } else {
                view.getModel().setValue("org", (Object)col.get(0));
            }
        }
    }

    public static void fseven(BeforeF7SelectEvent event, Boolean multiSelect, String allFlag) {
        ListShowParameter formShowParameter = (ListShowParameter)event.getFormShowParameter();
        formShowParameter.setCustomParam("orgViewSchemeNumber", (Object)"40");
        formShowParameter.getCustomParams().put("orgFuncId", "40");
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7", (String)"OrgServiceHelper_0", (String)"taxc-tctf", (Object[])new Object[0]));
        List<Long> orgIds = StringUtils.equals((CharSequence)allFlag, (CharSequence)allFlagOne) ? OrgServiceHelper.getOrgTaxpayerAllLists() : OrgServiceHelper.getOrgTaxpayerLists();
        if (CollectionUtils.isEmpty(orgIds)) {
            return;
        }
        QFilter orgIdsFilter = new QFilter("id", "in", orgIds);
        formShowParameter.getListFilterParameter().getQFilters().add(orgIdsFilter);
        if (multiSelect != null) {
            formShowParameter.setMultiSelect(multiSelect.booleanValue());
        }
    }
}

