/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctf.formplugin.apphome;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.form.ClientViewProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tctf.common.enums.TagsEnum;
import org.apache.commons.lang3.StringUtils;

public class DetailTagsPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
HyperLinkClickListener {
    public void registerListener(EventObject e) {
        BasedataEdit orgs = (BasedataEdit)this.getView().getControl("basedatafield");
        orgs.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        this.addClickListeners(new String[]{"basedatafield"});
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        if ("basedatafield".equalsIgnoreCase(name)) {
            int currentRow = this.getModel().getEntryCurrentRowIndex("entryentity");
            Long labelaptitleid = Long.parseLong(this.getModel().getValue("labelaptitleid", currentRow).toString());
            DynamicObjectCollection labelcol = QueryServiceHelper.query((String)((Object)((Object)this)).getClass().getName(), (String)"tctb_label_group", (String)"id", (QFilter[])new QFilter[]{new QFilter("group", "=", (Object)labelaptitleid), new QFilter("enable", "=", (Object)"1")}, (String)"number  ");
            List<Long> labelIdList = labelcol.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
            labelIdList = this.filterList(currentRow, labelIdList);
            QFilter qFilter = new QFilter("id", "in", labelIdList);
            evt.addCustomQFilter(qFilter);
        }
    }

    private List<Long> filterList(int currentRow, List<Long> labelIdList) {
        for (int i = 1; i < 4; ++i) {
            String key = "hyperlinktable" + i;
            if (!StringUtils.isNotEmpty((CharSequence)this.getModel().getValue(key, currentRow).toString())) continue;
            labelIdList = labelIdList.stream().filter(v -> Long.parseLong(this.getModel().getValue(key, currentRow).toString()) != v).collect(Collectors.toList());
        }
        return labelIdList;
    }

    public void afterCreateNewData(EventObject e) {
        this.createEntry();
    }

    private void createEntry() {
        this.getModel().deleteEntryData("entryentity");
        DynamicObjectCollection labelTypecol = QueryServiceHelper.query((String)((Object)((Object)this)).getClass().getName(), (String)"tctb_label_type", (String)"id,number,name,parent", (QFilter[])new QFilter[]{new QFilter("parent.number", "=", (Object)"taxfile"), new QFilter("enable", "=", (Object)"1")}, null);
        DynamicObjectCollection labelcol = QueryServiceHelper.query((String)((Object)((Object)this)).getClass().getName(), (String)"tctb_label_group", (String)"id,name,group", (QFilter[])new QFilter[]{new QFilter("group", "in", labelTypecol.stream().map(v -> v.getLong("id")).collect(Collectors.toList())), new QFilter("enable", "=", (Object)"1")}, (String)"number  ");
        Map<Long, List<DynamicObject>> labelmap = labelcol.stream().collect(Collectors.groupingBy(v -> v.getLong("group")));
        this.getModel().beginInit();
        for (DynamicObject datarow : labelTypecol) {
            int row = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("labelaptitle", (Object)(datarow.get("name") + ":"), row);
            this.getModel().setValue("labelaptitleid", datarow.get("id"), row);
            List<DynamicObject> labelList = labelmap.get(datarow.get("id"));
            if (!CollectionUtils.isEmpty(labelList)) {
                for (int i = 0; i < labelList.size(); ++i) {
                    if (i >= 3) continue;
                    int j = i + 1;
                    String tablekey = "table" + j;
                    String hyperlinktablekey = "hyperlinktable" + j;
                    this.getModel().setValue(tablekey, labelList.get(i).get("name"), row);
                    this.getModel().setValue(hyperlinktablekey, labelList.get(i).get("id"), row);
                }
            }
            HashMap pmap = new HashMap(16);
            HashMap<String, String> propertiesMap = new HashMap<String, String>(16);
            propertiesMap.put("fontClass", TagsEnum.getFongClass(datarow.getString("number")));
            pmap.put("vectorap1", propertiesMap);
            ClientViewProxy client = (ClientViewProxy)this.getView().getService(IClientViewProxy.class);
            client.invokeControlMethod("entryentity", "setCustomProperties", new Object[]{row++, pmap});
        }
        this.getModel().endInit();
        this.getView().updateView();
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        int index = hyperLinkClickEvent.getRowIndex();
        DynamicObject entryentity = (DynamicObject)this.getModel().getEntryEntity("entryentity").get(index);
        String label = "";
        if ("table1".equals(hyperLinkClickEvent.getFieldName())) {
            label = entryentity.getString("hyperlinktable1");
        }
        if ("table2".equals(hyperLinkClickEvent.getFieldName())) {
            label = entryentity.getString("hyperlinktable2");
        }
        if ("table3".equals(hyperLinkClickEvent.getFieldName())) {
            label = entryentity.getString("hyperlinktable3");
        }
        if (StringUtils.isNotEmpty((CharSequence)label)) {
            ListShowParameter param = new ListShowParameter();
            param.setBillFormId("tctf_group_knowledge");
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            HashMap<String, String> customParams = new HashMap<String, String>(1);
            customParams.put("billstatus", "C");
            customParams.put("mulknowledgetags", label);
            param.setCustomParams(customParams);
            this.getView().showForm((FormShowParameter)param);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("basedatafield".equalsIgnoreCase(name)) {
            DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            ListShowParameter param = new ListShowParameter();
            param.setBillFormId("tctf_group_knowledge");
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            HashMap<String, Object> customParams = new HashMap<String, Object>(1);
            customParams.put("billstatus", "C");
            customParams.put("knowledgetags", newValue.get("id"));
            param.setCustomParams(customParams);
            this.getView().showForm((FormShowParameter)param);
        }
    }
}

