/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctf.formplugin.filemanagement;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.TaxationsysMappingEnum;
import kd.taxc.bdtaxr.common.errorcode.TaxcErrorCode;
import kd.taxc.bdtaxr.common.helper.TaxcCombineDataServiceHelper;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import org.apache.commons.lang3.ObjectUtils;

public class FileManagementFormPlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        Long orgId;
        List<DynamicObject> orgs = FileManagementFormPlugin.queryValidTaxOrg(TaxationsysMappingEnum.CHN.getId());
        List ids = orgs.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
        if (ids.contains(orgId = Long.valueOf(RequestContext.get().getOrgId()))) {
            this.getModel().setValue("org", (Object)orgId);
        } else if (!ObjectUtils.isEmpty(ids)) {
            this.getModel().setValue("org", ids.get(0));
        }
    }

    public static List<DynamicObject> queryValidTaxOrg(Long taxationSysId) {
        ArrayList<DynamicObject> resultList = new ArrayList<DynamicObject>();
        TaxResult taxResult = TaxcCombineDataServiceHelper.queryTaxcOrgByIsTaxpayerWithPerm((Long)RequestContext.get().getCurrUserId(), (Long)taxationSysId);
        if (StringUtil.equalsIgnoreCase((CharSequence)TaxcErrorCode.TAXC_SUCCESS_CODE.getCode(), (CharSequence)taxResult.getCode())) {
            List taxResultData = (List)taxResult.getData();
            return taxResultData;
        }
        return resultList;
    }
}

