/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctf.formplugin.regulatorylibrary;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.taxc.tctf.business.groupknowledge.GroupKnowledgeBusinessImpl;
import kd.taxc.tctf.common.utils.GroupKnowledgeDownloadUtils;
import org.apache.commons.lang3.ObjectUtils;

public class GroupKnowledgeList
extends AbstractListPlugin {
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("pdfdownload".equalsIgnoreCase(operateKey) || "worddownload".equalsIgnoreCase(operateKey)) {
            BillList billlist = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection list = billlist.getSelectedRows();
            if (list == null || list.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e", (String)"GroupKnowledgeList_0", (String)"taxc-tctf", (Object[])new Object[0]));
                return;
            }
            List<Long> pkIds = Arrays.stream(list.getPrimaryKeyValues()).mapToLong(Long.class::cast).boxed().collect(Collectors.toList());
            GroupKnowledgeDownloadUtils.groupKnowledgeDownload(operateKey, pkIds);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String billstatus = (String)customParams.get("billstatus");
        Object mulknowledgetags = customParams.get("mulknowledgetags");
        if (StringUtils.isNotBlank((CharSequence)billstatus) || StringUtils.isNotBlank(mulknowledgetags)) {
            List commonFilters = args.getFilterContainerInitEvent().getCommonFilterColumns();
            for (FilterColumn filterColumn : commonFilters) {
                String fieldName = filterColumn.getFieldName();
                if (fieldName.contains("billstatus") && StringUtils.isNotEmpty((CharSequence)billstatus)) {
                    filterColumn.setDefaultValue(billstatus);
                }
                if (!fieldName.contains("mulknowledgetags.fbasedataid.name") || mulknowledgetags == null) continue;
                filterColumn.setDefaultValue(mulknowledgetags.toString());
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if (StringUtils.equals((CharSequence)"texttitle", (CharSequence)args.getHyperLinkClickEvent().getFieldName())) {
            int rowIndex = args.getRowIndex();
            BillList bl = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection currentListAllRowCollection = bl.getCurrentListAllRowCollection();
            ListSelectedRow listSelectedRow = currentListAllRowCollection.get(rowIndex);
            Object primaryKeyValue = listSelectedRow.getPrimaryKeyValue();
            DynamicObject nsrxx = GroupKnowledgeBusinessImpl.queryGroupKnowledgeByPkId(Long.parseLong(primaryKeyValue.toString()));
            if (ObjectUtils.isEmpty((Object)nsrxx)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u96c6\u56e2\u77e5\u8bc6\u6570\u636e\u5df2\u53d8\u5316\uff0c\u8bf7\u5237\u65b0\u3002", (String)"GroupKnowledgeList_1", (String)"taxc-tctf", (Object[])new Object[0]));
                return;
            }
            String billstatus = nsrxx.getString("billstatus");
            if (StringUtils.equalsIgnoreCase((CharSequence)"C", (CharSequence)billstatus)) {
                args.setCancel(true);
                BillShowParameter showParameter = new BillShowParameter();
                showParameter.setPkId(primaryKeyValue);
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setFormId("tctf_group_knowledge_look");
                this.getView().showForm((FormShowParameter)showParameter);
            }
        }
    }
}

